/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.instructions.models.regular.InstructionHkwolunBaseModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionHkwolunAlgoModel {
    public InstructionHkwolunBaseModel baseModel;
    @Inject
    private AlgoModel param;
    @Inject
    private MObjFactory of;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private AlgoTradeModel tradeModel;
    @Inject
    private MEventService es;
    private LongProperty countAlgo = new SimpleLongProperty();
    private static final Logger logger = LogManager.getLogger(InstructionHkwolunAlgoModel.class);
    @Inject
    private MessagePromptMng mpMng;
    private double price;
    private static int PAR_VALUE = 100;

    public void initAlgo() {
        this.countAlgo.addListener(ob -> this.onCountAlgoChange());
        this.baseModel.getMI().nowPriceProperty().addListener((ob, old, now) -> Platform.runLater(() -> {
            if (!this.baseModel.isNormal()) {
                this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
                if (this.baseModel.getMI().getNowPrice() == 0.0) {
                    this.baseModel.getAccDisModel().clearCanBuy(this.baseModel.getAccDisModel().getRoot());
                    return;
                }
                this.baseModel.filterAcc();
            }
        }));
        this.baseModel.normal.addListener(ob -> this.onNormalChange());
    }

    private void onNormalChange() {
        if (this.baseModel.isNormal()) {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getPrice());
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.baseModel.getCount());
        } else {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
        }
        this.baseModel.filterAcc();
        this.baseModel.calCountDistribution();
    }

    private void onCountAlgoChange() {
        if (!this.baseModel.isNormal()) {
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
            if (this.getCountAlgo() == 0L) {
                this.baseModel.getAccDisModel().clearCount(this.baseModel.getAccDisModel().getRoot());
                return;
            }
            this.baseModel.calCountDistribution();
            if (!this.baseModel.getAccDisModel().isActive() && this.baseModel.getAccDisModel().getInstructType().equals("4")) {
                this.baseModel.getAccDisModel().allocateCount();
            }
        }
    }

    public synchronized RespResult submitAdvice() throws MException {
        RespResult respResult = new RespResult();
        for (AlgoParam oa : this.getOrderAdvice()) {
            try {
                InstructionSubmitResult submitResult = oa.submit();
                respResult.incrementSuccessed();
                this.mpMng.algoInst(oa, this.baseModel.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
            }
            catch (MException e) {
                respResult.incrementFailed(e.getMessage());
                this.mpMng.algoInst(oa, this.baseModel.getAccDisModel().getInstructType(), (Object)e, "");
            }
        }
        return respResult;
    }

    public RespResult submitApprove(Instruction instruction) throws MException {
        RespResult respResult = new RespResult();
        try {
            this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
            respResult.incrementSuccessed();
        }
        catch (MException e) {
            respResult.incrementFailed(e.getMessage());
        }
        return respResult;
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public synchronized RespResult submitOrder(String instructionId, String resourceId) {
        ObservableList list = FxUtils.newList();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AlgoParam param = (AlgoParam)this.of.create(AlgoParam.class);
                param.update((Object)this.param);
                param.setFundAccId(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId());
                param.setSecAccId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                param.setCount((int)((CcsAccountDistribution)secAcc.getValue()).getCount());
                param.setReference(instructionId);
                param.setResourceId(resourceId);
                list.add((Object)param);
            }
        }
        RespResult result = new RespResult();
        if (this.param.getAlgorithm().getType() != 18) {
            for (AlgoParam param : list) {
                try {
                    int type = param.getAlgorithm().getType();
                    switch (type) {
                        case 15: 
                        case 16: 
                        case 19: 
                        case 20: {
                            this.tradeModel.submitMise(param);
                            break;
                        }
                        default: {
                            this.tradeModel.submit(param);
                        }
                    }
                    result.incrementSuccessed();
                }
                catch (MException e) {
                    logger.error((Object)e, (Throwable)e);
                    result.incrementFailed(e.getMessage());
                }
            }
        }
        this.es.sendEvent(AlgoQueryPart.class.getName(), null);
        return result;
    }

    public List<CcsSingleEntrust> getEntrustList() throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                CcsSingleEntrust en = this.baseModel.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                if (this.baseModel.isReverseRepo()) {
                    en.setSide(this.param.isBuy() ? 71 : 70);
                } else {
                    en.setSide(this.param.isBuy() ? 49 : 50);
                }
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setSec(this.param.getCode());
                en.setSecName(this.param.getName());
                en.setMarket(this.param.getMarket());
                en.setSecType(this.param.getType());
                en.setPrice(this.baseModel.getMI().getNowPrice());
                this.price = en.getPrice();
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                en.setOrderType(50);
                en.setAppID(this.baseModel.isReverseRepo() ? "110" : "010");
                enList.add(en);
            }
        }
        return enList;
    }

    public List<AlgoParam> getOrderAdvice() throws MException {
        LinkedList<AlgoParam> adviceList = new LinkedList<AlgoParam>();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            AlgoParam orderAdvice = (AlgoParam)this.of.create(AlgoParam.class);
            orderAdvice.update((Object)this.param);
            orderAdvice.setInstructionPanelType(this.baseModel.getAccDisModel().getInstructType());
            orderAdvice.setAccntLevel(0);
            orderAdvice.setInsExpiredDate(this.baseModel.getInsExpiredMap().get(((CcsAccountDistribution)acc.getValue()).getAcc()));
            orderAdvice.setProductId(this.baseModel.accountService.getAccountFromCache(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getProductId());
            List stepList = this.baseModel.instrAccModel.getWorkflow(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getSteps();
            if (stepList != null && !stepList.isEmpty()) {
                for (AccntStepAttribute step : stepList) {
                    if (1 != step.getStepId()) continue;
                    orderAdvice.setFlowAttriId(step.getFlowAttriId());
                    orderAdvice.setStepAttrId(step.getStepAttriId());
                    break;
                }
            }
            orderAdvice.setInstructionType(8);
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSec = new AccntSecInfo();
                accntSec.setAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId());
                accntSec.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                accntSec.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                accntSec.setMarket(this.baseModel.mktItem.getRefItem().getMarket());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount();
                accntSec.setParentId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                accntSecList.add(accntSec);
            }
            orderAdvice.setAccSecInfoList(accntSecList);
            orderAdvice.setCount((int)orderQty);
            orderAdvice.setPrice(this.price);
            orderAdvice.setAmount(this.getMoney(orderAdvice));
            if (accntSecList.isEmpty()) continue;
            adviceList.add(orderAdvice);
        }
        return adviceList;
    }

    private int getParValue(AlgoParam item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(AlgoParam item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getCount() * this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getType())) {
            return (double)item.getCount() * item.getPrice() * 10.0;
        }
        return (double)item.getCount() * item.getPrice();
    }

    public void setParam(AlgoParam param) {
        this.param.getMI().setRefItem(this.baseModel.getMI().getRefItem());
        this.param.update((Object)param);
    }

    public AlgoParam getParam() {
        return this.param;
    }

    public IntegerProperty minuteProperty() {
        return this.param.minuteProperty();
    }

    public final LongProperty countAlgoProperty() {
        return this.countAlgo;
    }

    public final long getCountAlgo() {
        return this.countAlgoProperty().get();
    }

    public final void setCountAlgo(long countAlgo) {
        this.countAlgoProperty().set(countAlgo);
    }
}

