/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.risk.IRiskCheckApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.datatype.proto.unify_risk.PRiskConstants;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.define.MxDict;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateReq;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateResp;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowBusinessType;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.NewOrdersSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.ExecTask;
import cms.tmx.http.instruction.dto.ExecuteTaskReq;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.instruction.dto.TaskArgument;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.instructions.models.regular.HKCcsAccountDistributionModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.neeq.view.NeeqSelectWorkflowDialog;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.entrust.SingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cms.tmx.utils.MarketUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionHkBaseModel
implements ITradeModel {
    public BooleanProperty normal = new SimpleBooleanProperty(true);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public IntegerProperty buy = new SimpleIntegerProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> sideNode = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private ObjectProperty<ObSimpleInstruction> instruction = new SimpleObjectProperty((Object)new ObSimpleInstruction());
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeMktStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeAfterHours = new SimpleObjectProperty();
    private ObjectProperty<MxNode> offerWay = new SimpleObjectProperty();
    private ObjectProperty<MxNode> tif = new SimpleObjectProperty();
    private ObjectProperty<MxNode> market = new SimpleObjectProperty();
    private StringProperty marketStr = new SimpleStringProperty("");
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private String postil = "";
    private final int INIT_UNIT = 100;
    private static final Logger logger = LogManager.getLogger(InstructionHkBaseModel.class);
    @Inject
    private MObjFactory of;
    @Inject
    private TradeServiceNewApi api;
    protected MarketItem mktItem;
    @Inject
    protected INewRefMng refMng;
    @Inject
    private MarketDataModel mdModel;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    protected HKCcsAccountDistributionModel accTreeModel;
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    protected ResourceModel resModel;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private HttpBaseApi baseHttpApi;
    @Inject
    private IRiskCheckApi riskApi;
    @Inject
    private InstructionServiceApi insApi;
    @Inject
    private WorkflowTemplateApi workflowApi;
    private Map<String, WorkflowTemplate> workFlowAccountMap = new HashMap<String, WorkflowTemplate>();
    protected Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    protected Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    @Inject
    private WorkflowTemplateApi workflowTemplateApi;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;

    @PostConstruct
    public void init() {
        MxNode nodeMarket = MxNodeFactory.create((String)"hk_market_code", (String)"XHKG");
        this.market.set((Object)nodeMarket.getNode("XHKG"));
        MxNode nodeSide = MxNodeFactory.create((String)"side", (String)"\u4e70");
        this.sideNode.set((Object)nodeSide.getNode("\u4e70"));
        this.getAccDisModel().setHkwolun(true);
        this.getAccDisModel().setHk(true);
        this.getAccDisModel().securityProperty().bind((ObservableValue)this.security);
        this.getAccDisModel().marketProperty().bind((ObservableValue)this.marketStr);
        this.mktItem = this.mdModel.createItem(10);
        this.getAccDisModel().normalProperty().bind((ObservableValue)this.normal);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = MxNodeFactory.createNew((String)"hkwolun_offer_way", (String)"0");
        this.initOfferWay(node, true);
        this.setOfferWay(node);
        MxNode tif = MxNodeFactory.createNew((String)"tif_undefined_str", (String)"48");
        this.setTif(tif);
        node = ((MxNode)this.of.create(MxNode.class)).load("trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = MxNodeFactory.createNew((String)"cstr_price_type", (String)"50");
        this.setPriceStg(node);
        this.changePriceStg();
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
        this.setPriceTypeLimitedStg(node);
        this.limitStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
        this.initPriceGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
        this.initMarketType(node);
        this.setPriceTypeMktStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_after_hours", "1");
        this.initAfterHoursType(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_count_filter", "1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    @PreDestroy
    private void preDestroy() {
    }

    private void initAfterHoursType(MxNode node) {
        this.setPriceTypeAfterHours(node);
    }

    public void onSecChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        if (this.getValidRef() != null) {
            RefItem validRef = this.getValidRef();
            this.mdModel.dye(this.mktItem);
            String mKey = String.valueOf(validRef.getMarket()) + validRef.getCode();
            MarketItem item = (MarketItem)((Map)this.mdModel.getMapInfo().get(validRef)).get(mKey);
            this.mktItem.setRefItem(validRef);
            this.mktItem.update((Object)item);
            this.updateHandicapInfoList(this.mktItem);
            this.setName(validRef.getName());
        } else {
            this.setName("");
        }
        this.filterAcc();
        this.changePriceStg();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
        this.setMktPrice();
        this.setBidAskPrice();
        this.setAfterHoursPrice();
    }

    public void updateHandicapInfoList(MarketItem mkt) {
        this.initHKInfoList(mkt);
        this.updateSellInfoList(mkt);
        this.updateBuyInfoList(mkt);
    }

    private void updateSellInfoList(MarketItem mkt) {
        ObservableList sellInfos = mkt.getListSellHandicap();
        for (HandicapInfo info : mkt.getListHKSellHandicap()) {
            for (HandicapInfo sell : sellInfos) {
                double sellPrice;
                double infoPrice = (double)Math.round(info.getPrice() * 1000.0) / 1000.0;
                if (infoPrice != (sellPrice = (double)Math.round(sell.getPrice() * 1000.0) / 1000.0)) continue;
                info.update((Object)sell);
                break;
            }
            info.update((Object)info);
            System.out.println();
        }
    }

    private void updateBuyInfoList(MarketItem mkt) {
        ObservableList buyInfos = mkt.getListBuyHandicap();
        for (HandicapInfo info : mkt.getListHKBuyHandicap()) {
            for (HandicapInfo buy : buyInfos) {
                double buyPrice;
                double infoPrice = (double)Math.round(info.getPrice() * 1000.0) / 1000.0;
                if (infoPrice != (buyPrice = (double)Math.round(buy.getPrice() * 1000.0) / 1000.0)) continue;
                info.update((Object)buy);
                break;
            }
            info.update((Object)info);
        }
    }

    private void initHKInfoList(MarketItem mkt) {
        ObservableList sellInfo = mkt.getListSellHandicap();
        ObservableList buyInfo = mkt.getListBuyHandicap();
        mkt.getListHKSellHandicap().clear();
        mkt.getListHKBuyHandicap().clear();
        double sellPrice = ((HandicapInfo)sellInfo.get(0)).getPrice();
        double sellTik = this.priceUnit(String.valueOf(sellPrice));
        double buyPrice = ((HandicapInfo)buyInfo.get(0)).getPrice();
        double buyTik = this.priceUnit(String.valueOf(buyPrice));
        int i = 0;
        while ((double)i <= this.getTik((ObservableList<HandicapInfo>)mkt.getListSellHandicap())) {
            HandicapInfo infoSell = new HandicapInfo();
            infoSell.setIndex(i + 1);
            infoSell.setPrice(sellPrice + sellTik * (double)i);
            infoSell.setPriceStr(String.valueOf(sellPrice + sellTik * (double)i));
            infoSell.setCount(0);
            mkt.getListHKSellHandicap().add((Object)infoSell);
            ++i;
        }
        i = 0;
        while ((double)i <= this.getTik((ObservableList<HandicapInfo>)mkt.getListBuyHandicap())) {
            HandicapInfo infoBuy = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoBuy.setPrice(buyPrice - buyTik * (double)i);
            infoBuy.setPriceStr(String.valueOf(buyPrice - buyTik * (double)i));
            infoBuy.setCount(0);
            mkt.getListHKBuyHandicap().add((Object)infoBuy);
            ++i;
        }
    }

    private double getTik(ObservableList<HandicapInfo> sellInfos) {
        HandicapInfo handicapInfo = (HandicapInfo)sellInfos.get(0);
        double tik = this.priceUnit(String.valueOf(handicapInfo.getPrice()));
        double abs = Math.abs((double)Math.round((handicapInfo.getPrice() - ((HandicapInfo)sellInfos.get(sellInfos.size() - 1)).getPrice()) * 1000.0) / 1000.0);
        return abs / tik;
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            if (this.isStar() && this.isMktPrice()) {
                this.setCount(this.getPriceProtected() != 0.0 ? (long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            } else {
                this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            }
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.isNormal()) {
            ((CcsAccountDistribution)this.getAccDisModel().getRoot().getValue()).setCount(this.getCount());
            if (this.getCount() == 0L) {
                this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                return;
            }
            this.calCountDistribution();
            if (!this.getAccDisModel().isActive() && this.getAccDisModel().getInstructType().equals("3")) {
                this.getAccDisModel().allocateCount();
            }
        }
    }

    private void setAfterHoursPrice() {
        if (!this.isAfterHoursPrice()) {
            return;
        }
        double price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        this.setPrice(price);
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    public void setMktPrice() {
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(49 == this.getBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
    }

    private void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        } else if (this.isBidAskPrice()) {
            this.setBidAskPrice();
        } else if (this.isAfterHoursPrice()) {
            this.setAfterHoursPrice();
        } else {
            this.setPrice(0.0);
        }
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            if (this.isNormal()) {
                if (this.isStar() && this.isMktPrice()) {
                    this.getAccDisModel().setPrice(this.getPriceProtected());
                } else {
                    this.getAccDisModel().setPrice(this.getPrice());
                }
                this.filterAcc();
                if (this.isCountOrSell()) {
                    this.getAccDisModel().calCanBuy();
                    return;
                }
                boolean clear = false;
                if (this.isStar() && this.isMktPrice()) {
                    clear = this.getPriceProtected() == 0.0;
                } else {
                    boolean bl = clear = this.getPrice() == 0.0 && !this.isUnlimited();
                }
                if (clear) {
                    this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                    this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
                    return;
                }
                if (this.getCountStg().getRaw().equals("5")) {
                    this.setCount((long)(this.getMoney() / this.getAccDisModel().getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
                    return;
                }
                this.calCountDistribution();
            }
        });
    }

    private void onMoneyChange() {
        if (this.isStar() && this.isMktPrice()) {
            if (this.getPriceProtected() != 0.0) {
                this.setCount((long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            }
        } else if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            logger.error("\u6e2f\u80a1\u53d6\u4e0d\u5230\u9759\u6001\u884c\u60c5");
            return;
        }
        long total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    public void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanBuy();
        this.getAccDisModel().calAccountCanSell();
        this.getAccDisModel().filterAcc();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public IntegerProperty buyProperty() {
        return this.buy;
    }

    public int getBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(int buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized Result submit(TreeItem<CcsAccountDistribution> root) {
        Result result = new Result();
        for (NewCcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                if (this.instruction.get() == null) continue;
                this.hkOrder(en);
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u6e2f\u80a1\u59d4\u6258\u63d0\u4ea4\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized Result submit(ObSimpleInstruction ins) {
        Result result = new Result();
        for (NewCcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                ExecuteTaskReq req = new ExecuteTaskReq();
                req.setInstructionId(ins.getId());
                ExecTask execTask = new ExecTask();
                req.setInstructionId(ins.getId());
                execTask.setInstructionId(ins.getId());
                RefItem refItem = this.refMng.getItem(String.valueOf(((ObSimpleInstruction)this.instruction.get()).getSecType()) + ((ObSimpleInstruction)this.instruction.get()).getSecMarket(), ((ObSimpleInstruction)this.instruction.get()).getSecMarket(), ((ObSimpleInstruction)this.instruction.get()).getSecurityCode());
                TaskArgument taskArg = new TaskArgument();
                taskArg.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
                taskArg.setType("type.googleapis.com/proto.instruction.TaskArgument");
                AccountId accountId = new AccountId();
                accountId.setCashAccntId(en.getAcc());
                accountId.setSecAccntId(en.getSecAcc());
                taskArg.setAccountId(accountId);
                Instrument instrument = ins.getOrderDetail().getInstrument();
                instrument.setApplId("910");
                instrument.setMarketIndicator("COMMON_STOCK");
                instrument.setSecurityGroup(refItem.getLevelInfo());
                instrument.setSecuritySubType(refItem.getSubSecurityType());
                taskArg.setInstrument(instrument);
                taskArg.setMatchType(MatchType.getMatchTypeByRefKey((String)refItem.getTransferMethodCode()).getValue());
                taskArg.setOrderQty((double)en.getQuantity());
                taskArg.setPrice(en.getPrice());
                ArrayList<TaskArgument> args = new ArrayList<TaskArgument>(4);
                args.add(taskArg);
                execTask.setArgument(args);
                taskArg.setSide(Side.get((String)((ObSimpleInstruction)this.instruction.get()).getSide()));
                req.getTask().add(execTask);
                this.insApi.execInstructionTask(req);
                result.operate(true);
                TaskLog log = new TaskLog();
                log.setWorkflowId(((ObSimpleInstruction)this.instruction.get()).getEntryId());
                log.setOpUser(this.baseHttpApi.getBaseApi().getUserId());
                log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId);
                List workflowTasks = ((ObSimpleInstruction)this.instruction.get()).getWorkflowTasks();
                for (WorkflowTask workflowTask : workflowTasks) {
                    Node node = workflowTask.getNode();
                    if (!node.getNodeName().contains("\u6267\u884c") || !node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) continue;
                    log.setNodeId(node.getNodeId());
                    log.setNodeName(node.getNodeName());
                    break;
                }
                this.workflowApi.recordTaskLog(log);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u6267\u884c\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u6e2f\u80a1\u6307\u4ee4\u6267\u884c\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void hkOrder(NewCcsSingleEntrust en) throws MException {
        NewOrdersSingle order = new NewOrdersSingle();
        order.setOpUser(this.baseHttpApi.getHttpOpUser());
        Instrument inst = new Instrument();
        if (this.getValidRef() != null) {
            inst.setSecurityId(en.getSec());
            inst.setMarket(this.getValidRef().getMarket());
            inst.setMarketGroup(MarketUtils.getMarketGroup((String)this.getValidRef().getMarket()));
            inst.setSecurityType(en.getSecType());
            inst.setSymbol(this.getValidRef().getName());
        }
        order.setExtCashAccntId(en.getAcc());
        order.setExtSecAccntId(en.getSecAcc());
        order.setInvestorId(en.getInvestorId());
        order.setAccount(en.getFundAccount().getParentId());
        order.setInstrument(inst);
        order.setSide((Object)this.getBuy());
        order.setOrderQty((double)en.getQuantity());
        order.setOrdType(String.valueOf(en.getOrderType()));
        order.setPrice(en.getPrice());
        order.setTif(Integer.valueOf(this.getTif().getRaw()).intValue());
        order.setTradePlatformId(en.getFundAccount().getCounterId());
        this.api.newOrdersSingle(order);
    }

    public synchronized ObservableList<Boolean> newSubmit(TreeItem<CcsAccountDistribution> root) {
        ObservableList returnList = FxUtils.newList();
        return returnList;
    }

    private void hkNewOrder(CcsSingleEntrust en) throws MException {
        NewOrdersSingle order = new NewOrdersSingle();
        this.api.newOrdersSingle(order);
    }

    public synchronized Result submitAdvice() throws MException {
        Result result = new Result();
        for (NewInstructionReq req : this.getOrderAdvices()) {
            try {
                OpStatus status = this.insApi.newInstruction(req);
                InstructionSubmitResult submitResult = new InstructionSubmitResult();
                submitResult.setInstructionId(status.getData());
                submitResult.setReason(status.getReason());
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
            }
        }
        return result;
    }

    public List<NewInstructionReq> getOrderAdvices() throws MException {
        LinkedList<NewInstructionReq> adviceList = new LinkedList<NewInstructionReq>();
        for (TreeItem acc : this.accTreeModel.getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            WorkflowTemplate workflowTemplate = this.workFlowAccountMap.get(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
            if (workflowTemplate == null) continue;
            NewInstructionReq req = new NewInstructionReq();
            cms.tmx.http.instruction.dto.Instruction ins = new cms.tmx.http.instruction.dto.Instruction();
            Instrument instrument = new Instrument();
            SimpleDetail detail = new SimpleDetail();
            ins.setName(this.mktItem.getRefItem().getName());
            ins.setType("SimpleDetail");
            ins.setFlowAttrId(workflowTemplate.getInstanceId());
            ins.setProductId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
            if ("1".equals(workflowTemplate.getNode().getFrozenCapital())) {
                ins.setDoFreezeCash();
            }
            if ("1".equals(workflowTemplate.getNode().getFrozenVouchers())) {
                ins.setDoFreezeSec();
            }
            if ("1".equals(workflowTemplate.getNode().getFastApprove())) {
                ins.setDoAutoApprove();
            }
            ins.setDoRiskCheck();
            detail.setType("type.googleapis.com/proto.instruction.SimpleDetail");
            detail.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
            detail.setTif(TimeInForce.getValue((int)Integer.valueOf(this.getTif().getRaw())));
            instrument.setSecurityId(this.mktItem.getRefItem().getCode());
            instrument.setSymbol(this.mktItem.getRefItem().getName());
            instrument.setMarketGroup(MarketUtils.findMarketGrp((String)this.mktItem.getRefItem().getMarket()));
            instrument.setMarket(this.mktItem.getRefItem().getMarket());
            instrument.setApplId("910");
            instrument.setSecurityType(this.mktItem.getRefItem().getType());
            instrument.setCurrencyId("HKD");
            instrument.setSecurityGroup(this.mktItem.getRefItem().getLevelInfo());
            instrument.setSecuritySubType(this.mktItem.getRefItem().getSubSecurityType());
            detail.setInstrument(instrument);
            if (this.buy.get() == 49) {
                detail.setSide(Side.SIDE_BUY);
            } else if (this.buy.get() == 50) {
                detail.setSide(Side.SIDE_SELL);
            } else if (this.buy.get() == 53) {
                detail.setSide(Side.SIDE_SELL_SHORT);
            }
            if ("50".equals(this.getPriceStg().getRaw())) {
                detail.setOrdType(OrdType.ORD_TYPE_LIMIT);
                detail.setPriceRestriction(Integer.valueOf(this.getPriceTypeLimitedStg().getRaw()).intValue());
                detail.setPrice(this.getPrice());
                if ("3".equals(this.getPriceTypeLimitedStg().getRaw())) {
                    detail.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
                }
            } else if ("49".equals(this.getPriceStg().getRaw())) {
                detail.setOrdType(OrdType.ORD_TYPE_MARKET);
                detail.setPrice(this.mktItem.getNowPrice());
            }
            ArrayList<AccntSecInfo> list = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSecInfo = new AccntSecInfo();
                AccountId accountID = new AccountId();
                accountID.setCashAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId());
                accountID.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSecInfo.setAccountId(accountID);
                accntSecInfo.setOrderQty((double)(orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount()));
                accntSecInfo.setOrderAmount((double)orderQty * detail.getPrice());
                list.add(accntSecInfo);
            }
            detail.setAccntSecInfo(list);
            ins.setDetail((Object)detail);
            req.setInstruction(ins);
            adviceList.add(req);
        }
        return adviceList;
    }

    private boolean isBuy() {
        return this.buy.get() == 49;
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return ((MxNode)this.sideNode.get()).getNode(String.valueOf(this.getBuy())).getRaw();
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is(Integer.toString(50));
    }

    protected void changeMarketPriceType() {
        MxNode node = this.getPriceTypeMktStg();
        if (node == null) {
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initMarketType(node);
        }
    }

    private void changePriceStg() {
        MxNode node = this.getPriceStg();
        if (node == null) {
            return;
        }
        node.getNodes().clear();
        node.addNode("49");
        node.addNode("50");
        this.setPriceStg(node);
    }

    public boolean isStar() {
        return this.mktItem.isValidRef();
    }

    protected void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            node.removeOthers("1");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    protected int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    protected void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        MxNode nodeDistStg = this.getDistStg();
        if (49 == this.getBuy()) {
            this.countStgBuy(nodeCountStg);
            this.limitStgBuy(this.getPriceTypeLimitedStg());
            this.distStgBuy(nodeDistStg);
        } else {
            this.countStgSell(nodeCountStg);
            this.limitStgSell(this.getPriceTypeLimitedStg());
            this.distStgSell(nodeDistStg);
        }
        this.initOfferWay(this.getOfferWay(), 49 == this.getBuy());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(49 == this.getBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        if (this.getAccDisModel().isActive()) {
            this.filterAcc();
        }
    }

    public NewCcsSingleEntrust createNewCcsSingle(String acc, String secAcc) {
        return this.ef.createNewCcsSingle(acc, secAcc);
    }

    public HKCcsAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().clearSelect();
        this.getAccDisModel().selectSecAcc(secAcc, mkt);
    }

    public void setPresetPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().selectSecAcc(secAcc, mkt);
    }

    protected void setAccDistModel(HKCcsAccountDistributionModel accDistModel) {
        this.accTreeModel = accDistModel;
    }

    public List<NewCcsSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<NewCcsSingleEntrust> enList = new LinkedList<NewCcsSingleEntrust>();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                NewCcsSingleEntrust en = this.createNewCcsSingle(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setLevelInfo(this.mktItem.getRefItem().getLevelInfo());
                en.setMatchType(this.mktItem.getRefItem().getTransferMethodCode());
                en.setSecSubType(this.mktItem.getRefItem().getSubSecurityType());
                if (((CcsAccountDistribution)acc.getValue()).getAcc() == null) {
                    en.setInvestorId("");
                    en.getFundAccount().setParentId("");
                }
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.getFundAccount().setParentId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                en.setAcc(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId());
                en.setMarketIndicate("COMMON_STOCK");
                en.setApplId("800");
                en.setSide(String.valueOf(this.buy.get()));
                long count = ((CcsAccountDistribution)secAcc.getValue()).getCount();
                en.setQuantity(count);
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                if ("".equals(this.mktItem.getRefItem().getMarket())) {
                    en.setMarket(this.getMarket().getRaw());
                } else {
                    en.setMarket(this.mktItem.getRefItem().getMarket());
                }
                en.setSecType(this.mktItem.getRefItem().getType());
                en.setOrderType(50);
                if ("50".equals(this.getPriceStg().getRaw())) {
                    en.setOrderType(50);
                    en.setPrice(this.getPrice());
                } else {
                    en.setOrderType(49);
                }
                if ("".equals(this.mktItem.getRefItem().getCode())) {
                    en.setSec(this.getSecurity());
                } else {
                    en.setSec(this.mktItem.getRefItem().getCode());
                }
                en.setSecName(this.mktItem.getRefItem().getName());
                enList.add(en);
            }
        }
        return enList;
    }

    public Boolean setWorkFlow() {
        NeeqSelectWorkflowDialog workflowObj = null;
        boolean hasWorkflow = false;
        if ("1".equals(this.getAccDisModel().getInstructType()) || "0".equals(this.getAccDisModel().getInstructType())) {
            HashMap<String, WorkflowTemplate> orderMap;
            for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                GetWorkflowTemplateReq getWorkflowReq = new GetWorkflowTemplateReq();
                getWorkflowReq.setOrg(this.baseApi.getPartyId());
                getWorkflowReq.setUserId(this.baseApi.getUserId());
                getWorkflowReq.setPostId(this.baseApi.getPostId());
                getWorkflowReq.setObjType("2");
                getWorkflowReq.setObjId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
                getWorkflowReq.setAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                getWorkflowReq.setAssetClass("1");
                getWorkflowReq.setMarket(this.mktItem.getRefItem().getMarket());
                getWorkflowReq.setSecurityId(this.mktItem.getRefItem().getCode());
                getWorkflowReq.setSecurityType(this.mktItem.getRefItem().getType());
                getWorkflowReq.setBusinessType(this.buy.get() == 49 ? WorkflowBusinessType.TYPE_BUY.getCode() : WorkflowBusinessType.TYPE_SELL.getCode());
                try {
                    List pick;
                    GetWorkflowTemplateResp getWorkflowResp = this.workflowTemplateApi.getWorkflowTemplate(getWorkflowReq);
                    if (getWorkflowResp.getList() == null || getWorkflowResp.getList().size() == 0 || (pick = getWorkflowResp.getList().stream().filter(item -> this.getAccDisModel().getInstructType().equals(item.getNode().getOrderType())).collect(Collectors.toList())).size() == 0) continue;
                    if (workflowObj == null) {
                        hasWorkflow = true;
                        workflowObj = (NeeqSelectWorkflowDialog)this.of.create(NeeqSelectWorkflowDialog.class);
                    }
                    workflowObj.getMap().put(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId(), getWorkflowResp.getList());
                }
                catch (MException e1) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2 \u6307\u4ee4\u6d41\u6a21\u677f\u5931\u8d25" + e1.getMessage());
                    return false;
                }
            }
            if (!hasWorkflow) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u60a8\u91cd\u65b0\u8bbe\u7f6e\u6307\u4ee4\u6d41,\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u6307\u4ee4\u6d41");
                return false;
            }
            if (workflowObj.getMap().size() != 1) {
                MxDialog workflowDialog = this.df.create(workflowObj, "\u5df2\u5339\u914d\u6307\u4ee4\u6d41\u9009\u62e9");
                workflowObj.init(this.getAccDisModel().getInstructType());
                if (workflowDialog.launch() == ButtonType.OK) {
                    orderMap = workflowObj.getOrderMap();
                    this.setWorkFlowAccountMap(orderMap);
                    return true;
                }
                return false;
            }
            try {
                String key = (String)String.class.cast(workflowObj.getMap().keySet().toArray()[0]);
                orderMap = new HashMap<String, WorkflowTemplate>();
                orderMap.put(key, (WorkflowTemplate)((List)workflowObj.getMap().get(key)).get(0));
                this.setWorkFlowAccountMap(orderMap);
                return true;
            }
            catch (Exception exception) {
                this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u6d41\u8bbe\u7f6e\u9519\u8bef");
                return false;
            }
        }
        return true;
    }

    public WorkFlowDescriptor getWorkFlowByFundAccount(FundAccount fundAcc) {
        return this.instrAccModel.getWorkflow(fundAcc.getParentId());
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public void create(String instructType) {
        this.getAccDisModel().setInstructPanelType(instructType);
        try {
            this.getAccDisModel().create();
        }
        catch (MException | Exception e) {
            logger.error("\u521b\u5efa\u8d26\u53f7\u6811\u51fa\u9519", e);
        }
    }

    public ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public ObjectProperty<MxNode> priceTypeMktStgProperty() {
        return this.priceTypeMktStg;
    }

    public MxNode getPriceTypeMktStg() {
        return (MxNode)this.priceTypeMktStgProperty().get();
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStgProperty().set((Object)priceTypeMktStg);
    }

    public ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    public boolean isSpecify() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("2");
    }

    public boolean isAfterHours() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public boolean isUpLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("1");
    }

    public boolean isDownLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("4");
    }

    private void limitStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("1");
        node.setRaw(oldNodeRaw.equals("4") ? "1" : oldNodeRaw);
        node.setRaw("2");
        this.setPriceTypeLimitedStg(node);
    }

    private void limitStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("4");
        node.setRaw(oldNodeRaw.equals("1") ? "4" : oldNodeRaw);
        node.setRaw("2");
        this.setPriceTypeLimitedStg(node);
    }

    private void initPriceGear(MxNode node) {
        node.removeOthers("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    private void initOfferWay(MxNode node, boolean isBuy) {
        if (isBuy) {
            node.removeNode("2");
        } else {
            node.addNode("2");
        }
    }

    private MxNode initMarketType(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.setRaw("0");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode shMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SH1");
        node.addNode("SH2");
        if (this.isStar()) {
            node.addNode("SH3");
            node.addNode("SH4");
        }
        node.removeNode("0");
        node.setRaw("SH1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode szMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        node.removeNode("0");
        node.setRaw("SZ1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    public boolean isMktPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("49");
    }

    public boolean isBidAskPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("0");
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public ObservableList<Boolean> submitApprove(Instruction instruction) throws MException {
        ObservableList returnList = FxUtils.newList();
        return returnList;
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public Result riskRangeCheck() {
        Result res = new Result();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            try {
                PUnifyRiskService.InstructionRiskCheckReq.Builder insB = PUnifyRiskService.InstructionRiskCheckReq.newBuilder();
                PUnifyRiskService.InstructionRiskCheckInfo.Builder infoB = PUnifyRiskService.InstructionRiskCheckInfo.newBuilder();
                infoB.setPartyId(this.baseApi.getPartyId());
                infoB.setProductId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
                infoB.setExtAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                infoB.setSecurityType(this.mktItem.getRefItem().getType());
                infoB.setMarket(this.mktItem.getRefItem().getMarket());
                infoB.setSecurityId(this.mktItem.getRefItem().getCode());
                int side = this.buy.get();
                infoB.setSideValue(side);
                insB.setOpUser(this.baseApi.getOpUser());
                insB.addInstrInfo(infoB.build());
                PUnifyRiskService.InstructionRiskCheckResp resp = this.riskApi.riskRangeCheck(insB.build());
                if (PRiskConstants.Risk_Action.RISK_ACTION_UNDEFINED.equals((Object)resp.getRiskAction())) {
                    res.operate(true);
                    continue;
                }
                res.operate(false);
                res.getReason().append(String.valueOf(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId()) + "\u98ce\u63a7\u6821\u9a8c\u5931\u8d25");
                for (PUnifyRiskService.InstructionRiskCheckResult checkRes : resp.getCheckResultList()) {
                    for (PUnifyRiskService.RiskCheckResult check : checkRes.getRiskcheckresultList()) {
                        res.getReason().append(check.getRemark()).append("\n");
                    }
                }
            }
            catch (MException | Exception e) {
                res.operate(false);
                res.getReason().append(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId()).append("\u8c03\u7528\u98ce\u63a7\u6821\u9a8c\u51fa\u9519").append(e.getMessage()).append("\n");
            }
        }
        return res;
    }

    public double priceUnit(String newV) {
        if ("".equals(newV)) {
            return 0.001;
        }
        Double p = Double.valueOf(newV);
        if (p <= 0.25) {
            return 0.001;
        }
        if (p > 0.25 && p <= 0.5) {
            return 0.005;
        }
        if (p > 0.5 && p <= 10.0) {
            return 0.01;
        }
        if (p > 10.0 && p <= 20.0) {
            return 0.02;
        }
        if (p > 20.0 && p <= 100.0) {
            return 0.05;
        }
        if (p > 100.0 && p <= 200.0) {
            return 0.1;
        }
        if (p > 200.0 && p <= 500.0) {
            return 0.2;
        }
        if (p > 500.0 && p <= 1000.0) {
            return 0.5;
        }
        if (p > 1000.0 && p <= 2000.0) {
            return 1.0;
        }
        if (p > 2000.0 && p <= 5000.0) {
            return 2.0;
        }
        if (p > 5000.0) {
            return 5.0;
        }
        return 0.0;
    }

    public ObjectProperty<ObSimpleInstruction> instructionProperty() {
        return this.instruction;
    }

    public ObSimpleInstruction getInstruction() {
        return (ObSimpleInstruction)this.instructionProperty().get();
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instructionProperty().set((Object)instruction);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public InstructionAccountModel getInstrAccModel() {
        return this.instrAccModel;
    }

    public void setInstrAccModel(InstructionAccountModel instrAccModel) {
        this.instrAccModel = instrAccModel;
    }

    public InstructionModel getInstructionModel() {
        return this.instructionModel;
    }

    public ObjectProperty<MxNode> priceTypeAfterHoursProperty() {
        return this.priceTypeAfterHours;
    }

    public MxNode getPriceTypeAfterHours() {
        return (MxNode)this.priceTypeAfterHoursProperty().get();
    }

    public void setPriceTypeAfterHours(MxNode priceTypeAfterHours) {
        this.priceTypeAfterHoursProperty().set((Object)priceTypeAfterHours);
    }

    public DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public final ObjectProperty<MxNode> offerWayProperty() {
        return this.offerWay;
    }

    public final MxNode getOfferWay() {
        return (MxNode)this.offerWayProperty().get();
    }

    public final void setOfferWay(MxNode offerWay) {
        this.offerWayProperty().set((Object)offerWay);
    }

    public final ObjectProperty<MxNode> tifProperty() {
        return this.tif;
    }

    public final MxNode getTif() {
        return (MxNode)this.tifProperty().get();
    }

    public final void setTif(MxNode tif) {
        this.tifProperty().set((Object)tif);
    }

    public final ObjectProperty<MxNode> marketProperty() {
        return this.market;
    }

    public final MxNode getMarket() {
        return (MxNode)this.marketProperty().get();
    }

    public final void setMarket(MxNode market) {
        this.marketProperty().set((Object)market);
    }

    public final StringProperty marketStrProperty() {
        return this.marketStr;
    }

    public final String getMarketStr() {
        return (String)this.marketStrProperty().get();
    }

    public final void setMarketStr(String marketStr) {
        this.marketStrProperty().set((Object)marketStr);
    }

    public Map<String, WorkflowTemplate> getWorkFlowAccountMap() {
        return this.workFlowAccountMap;
    }

    public void setWorkFlowAccountMap(Map<String, WorkflowTemplate> workFlowAccountMap) {
        this.workFlowAccountMap = workFlowAccountMap;
    }

    public SingleEntrust createEntrust(String acc, String secAcc) {
        return null;
    }
}

