/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.NewCcsSingleEntrust;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.OpStatus;
import cms.tmx.http.api.strategy.api.TradeServiceNewApi;
import cms.tmx.http.api.strategy.dto.Attachment;
import cms.tmx.http.api.strategy.dto.MatchType;
import cms.tmx.http.api.strategy.dto.NewExecMode;
import cms.tmx.http.api.strategy.dto.NewOrdersSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.ExecTask;
import cms.tmx.http.instruction.dto.ExecuteTaskReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.instruction.dto.TaskArgument;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.instructions.models.regular.InstructionHkBaseModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import com.google.gson.Gson;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionHkAlgoModel {
    public InstructionHkBaseModel baseModel;
    @Inject
    private AlgoModel param;
    @Inject
    private InstructionServiceApi insApi;
    @Inject
    protected INewRefMng refMng;
    @Inject
    private TradeServiceNewApi api;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private WorkflowTemplateApi workflowApi;
    private LongProperty countAlgo = new SimpleLongProperty();
    private static final Logger logger = LogManager.getLogger(InstructionHkAlgoModel.class);
    private double price;
    @Inject
    protected CcsEntrustFactory ef;
    private static int PAR_VALUE = 100;

    public void initAlgo() {
        this.countAlgo.addListener(ob -> this.onCountAlgoChange());
        this.baseModel.getMI().nowPriceProperty().addListener((ob, old, now) -> Platform.runLater(() -> {
            if (!this.baseModel.isNormal()) {
                this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
                if (this.baseModel.getMI().getNowPrice() == 0.0) {
                    this.baseModel.getAccDisModel().clearCanBuy(this.baseModel.getAccDisModel().getRoot());
                    return;
                }
                this.baseModel.filterAcc();
            }
        }));
        this.baseModel.normal.addListener(ob -> this.onNormalChange());
    }

    private void onNormalChange() {
        if (this.baseModel.isNormal()) {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getPrice());
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.baseModel.getCount());
        } else {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
        }
        this.baseModel.filterAcc();
        this.baseModel.calCountDistribution();
    }

    private void onCountAlgoChange() {
        if (!this.baseModel.isNormal()) {
            ((CcsAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
            if (this.getCountAlgo() == 0L) {
                this.baseModel.getAccDisModel().clearCount(this.baseModel.getAccDisModel().getRoot());
                return;
            }
            this.baseModel.calCountDistribution();
            if (!this.baseModel.getAccDisModel().isActive() && this.baseModel.getAccDisModel().getInstructType().equals("4")) {
                this.baseModel.getAccDisModel().allocateCount();
            }
        }
    }

    public synchronized RespResult submitAdvice() throws MException {
        RespResult respResult = new RespResult();
        for (NewInstructionReq req : this.getOrderAdvices()) {
            try {
                OpStatus status = this.insApi.newInstruction(req);
                InstructionSubmitResult submitResult = new InstructionSubmitResult();
                submitResult.setInstructionId(status.getData());
                submitResult.setReason(status.getReason());
                respResult.incrementSuccessed();
            }
            catch (MException e) {
                respResult.incrementFailed(e.getMessage());
            }
        }
        return respResult;
    }

    public RespResult submitApprove(ObSimpleInstruction instruction) throws MException {
        RespResult respResult = new RespResult();
        return respResult;
    }

    public RespResult execute(ObSimpleInstruction ins) {
        RespResult result = new RespResult();
        for (NewCcsSingleEntrust en : this.getEntrustList()) {
            try {
                ExecuteTaskReq req = new ExecuteTaskReq();
                req.setInstructionId(ins.getId());
                ExecTask execTask = new ExecTask();
                req.setInstructionId(ins.getId());
                execTask.setInstructionId(ins.getId());
                RefItem refItem = this.refMng.getItem(String.valueOf(ins.getSecType()) + ins.getSecMarket(), ins.getSecMarket(), ins.getSecurityCode());
                TaskArgument taskArg = new TaskArgument();
                taskArg.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
                taskArg.setType("type.googleapis.com/proto.instruction.TaskArgument");
                AccountId accountId = new AccountId();
                accountId.setCashAccntId(en.getAcc());
                accountId.setSecAccntId(en.getSecAcc());
                taskArg.setAccountId(accountId);
                Instrument instrument = ins.getOrderDetail().getInstrument();
                instrument.setApplId("910");
                instrument.setMarketIndicator("COMMON_STOCK");
                instrument.setSecurityGroup(refItem.getLevelInfo());
                instrument.setSecuritySubType(refItem.getSubSecurityType());
                taskArg.setInstrument(instrument);
                taskArg.setMatchType(MatchType.getMatchTypeByRefKey((String)refItem.getTransferMethodCode()).getValue());
                taskArg.setOrderQty((double)en.getQuantity());
                taskArg.setPrice(en.getPrice());
                ArrayList<TaskArgument> args = new ArrayList<TaskArgument>(4);
                args.add(taskArg);
                execTask.setArgument(args);
                taskArg.setSide(Side.get((String)ins.getSide()));
                req.getTask().add(execTask);
                this.insApi.execInstructionTask(req);
                result.incrementSuccessed();
                TaskLog log = new TaskLog();
                log.setWorkflowId(ins.getEntryId());
                log.setOpUser(this.baseApi.getBaseApi().getUserId());
                log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId);
                List workflowTasks = ins.getWorkflowTasks();
                for (WorkflowTask workflowTask : workflowTasks) {
                    Node node = workflowTask.getNode();
                    if (!node.getNodeName().contains("\u6267\u884c") || !node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) continue;
                    log.setNodeId(node.getNodeId());
                    log.setNodeName(node.getNodeName());
                    break;
                }
                this.workflowApi.recordTaskLog(log);
            }
            catch (MException e) {
                result.incrementFailed("\u6267\u884c\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getMessage());
                logger.error("\u6e2f\u80a1\u6307\u4ee4\u6267\u884c\u51fa\u9519" + e.getCode() + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized RespResult submitOrder() {
        RespResult result = new RespResult();
        for (NewCcsSingleEntrust en : this.getEntrustList()) {
            try {
                this.hkOrder(en);
                result.incrementSuccessed();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                result.incrementFailed(e.getMessage());
            }
        }
        return result;
    }

    private void hkOrder(NewCcsSingleEntrust en) throws MException {
        NewOrdersSingle order = new NewOrdersSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument inst = new Instrument();
        inst.setSecurityId(en.getSec());
        inst.setMarket(en.getMarket());
        inst.setMarketGroup(MarketUtils.getMarketGroup((String)en.getMarket()));
        inst.setSecurityType(en.getSecType());
        inst.setSymbol(en.getSecName());
        order.setInstrument(inst);
        order.setExtCashAccntId(en.getAcc());
        order.setExtSecAccntId(en.getSecAcc());
        order.setInvestorId(en.getInvestorId());
        order.setAccount(en.getFundAccount().getParentId());
        order.setSide((Object)en.getSide());
        order.setOrderQty((double)en.getQuantity());
        order.setPrice(en.getPrice());
        order.setTif(48);
        order.setTradePlatformId(en.getFundAccount().getCounterId());
        order.setOrdType(String.valueOf(en.getOrderType()));
        order.setExecMode(this.getExecMode());
        order.setAttachment(new Gson().toJson((Object)this.getAttachment(order.getExecMode())));
        this.api.newOrdersSingle(order);
    }

    private NewExecMode getExecMode() {
        String ordType = this.param.getAlgoTypeNode().getRaw().split("#")[1];
        return new NewExecMode("3", ordType);
    }

    private Attachment getAttachment(NewExecMode mode) {
        Attachment attachment = new Attachment();
        attachment.setAlgorithmName(mode.getEmName());
        if (mode.getEmName().contains("POV")) {
            attachment.setParticipationRate(Integer.valueOf((int)this.param.getMarketPercent()));
        }
        String startTime = this.packDateTime(this.param.getStartHour(), this.param.getStartMinute());
        attachment.setStartTime(startTime);
        String endTime = this.packDateTime(this.param.getEndHour(), this.param.getEndMinute());
        attachment.setEndTime(endTime);
        return attachment;
    }

    public String packDateTime(int hour, int minute) {
        StringBuffer dateTime = new StringBuffer();
        dateTime.append(LocalDate.now().toString().replace("-", ""));
        dateTime.append(" ");
        dateTime.append(this.complement(hour));
        dateTime.append(":");
        dateTime.append(this.complement(minute));
        dateTime.append(":00");
        return dateTime.toString();
    }

    public String complement(Object obj) {
        String str = obj.toString();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)str)) {
            str = "0" + str;
        }
        return str;
    }

    public List<NewCcsSingleEntrust> getEntrustList() {
        LinkedList<NewCcsSingleEntrust> enList = new LinkedList<NewCcsSingleEntrust>();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                NewCcsSingleEntrust en = this.ef.createNewCcsSingle(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                en.setLevelInfo(this.baseModel.getMI().getRefItem().getLevelInfo());
                en.setMatchType(this.baseModel.getMI().getRefItem().getTransferMethodCode());
                en.setSecSubType(this.baseModel.getMI().getRefItem().getSubSecurityType());
                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.getFundAccount().setParentId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                en.setAcc(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId());
                en.setMarketIndicate("COMMON_STOCK");
                en.setApplId("800");
                en.setSide(String.valueOf(this.param.getSide()));
                long count = ((CcsAccountDistribution)secAcc.getValue()).getCount();
                en.setQuantity(count);
                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                String ordType = this.param.getAlgoTypeNode().getRaw().split("#")[0];
                en.setOrderType(Integer.parseInt(ordType));
                en.setPrice(this.param.getPrice());
                en.setSec(this.param.getCode());
                en.setSecName(this.param.getName());
                en.setMarket(this.param.getMarket());
                en.setSecType(this.param.getType());
                enList.add(en);
            }
        }
        return enList;
    }

    public List<NewInstructionReq> getOrderAdvices() throws MException {
        LinkedList<NewInstructionReq> adviceList = new LinkedList<NewInstructionReq>();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            WorkflowTemplate workflowTemplate = this.baseModel.getWorkFlowAccountMap().get(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
            if (workflowTemplate == null) continue;
            NewInstructionReq req = new NewInstructionReq();
            Instruction ins = new Instruction();
            ins.setName(this.param.getName());
            ins.setType("SimpleAlgoDetail");
            ins.setFlowAttrId(workflowTemplate.getInstanceId());
            ins.setProductId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
            if ("1".equals(workflowTemplate.getNode().getFrozenCapital())) {
                ins.setDoFreezeCash();
            }
            if ("1".equals(workflowTemplate.getNode().getFrozenVouchers())) {
                ins.setDoFreezeSec();
            }
            if ("1".equals(workflowTemplate.getNode().getFastApprove())) {
                ins.setDoAutoApprove();
            }
            ins.setDoRiskCheck();
            SimpleDetail detail = new SimpleDetail();
            detail.setType("type.googleapis.com/proto.instruction.SimpleDetail");
            detail.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT);
            detail.setTif(TimeInForce.getValue((int)48));
            Instrument instrument = new Instrument();
            instrument.setSecurityType(this.param.getType());
            instrument.setSecurityId(this.param.getCode());
            instrument.setSymbol(this.param.getName());
            instrument.setMarket(this.param.getMarket());
            instrument.setMarketGroup(MarketUtils.findMarketGrp((String)this.param.getMarket()));
            instrument.setSecurityGroup(this.baseModel.getMI().getRefItem().getLevelInfo());
            instrument.setSecuritySubType(this.baseModel.getMI().getRefItem().getSubSecurityType());
            instrument.setCurrencyId("HKD");
            instrument.setApplId("910");
            detail.setInstrument(instrument);
            NewExecMode execMode = this.getExecMode();
            ins.setText(new Gson().toJson((Object)execMode));
            detail.setAttachment(new Gson().toJson((Object)this.getAttachment(execMode)));
            detail.setSide(Side.get((String)String.valueOf(this.param.getSide())));
            String ordType = this.param.getAlgoTypeNode().getRaw().split("#")[0];
            detail.setOrdType(OrdType.get((String)ordType));
            if (OrdType.ORD_TYPE_LIMIT.getValue().equals(ordType)) {
                detail.setPrice(this.param.getPrice());
            } else {
                detail.setPrice(this.baseModel.getMI().getNowPrice());
            }
            ArrayList<AccntSecInfo> list = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSecInfo = new AccntSecInfo();
                AccountId accountID = new AccountId();
                accountID.setCashAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId());
                accountID.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSecInfo.setAccountId(accountID);
                accntSecInfo.setOrderQty((double)(orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount()));
                accntSecInfo.setOrderAmount((double)orderQty * detail.getPrice());
                list.add(accntSecInfo);
            }
            detail.setAccntSecInfo(list);
            ins.setDetail((Object)detail);
            req.setInstruction(ins);
            adviceList.add(req);
        }
        return adviceList;
    }

    private int getParValue(AlgoParam item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(AlgoParam item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getCount() * this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getType())) {
            return (double)item.getCount() * item.getPrice() * 10.0;
        }
        return (double)item.getCount() * item.getPrice();
    }

    public void setParam(AlgoParam param) {
        this.param.getMI().setRefItem(this.baseModel.getMI().getRefItem());
        this.param.update((Object)param);
    }

    public AlgoParam getParam() {
        return this.param;
    }

    public IntegerProperty minuteProperty() {
        return this.param.minuteProperty();
    }

    public final LongProperty countAlgoProperty() {
        return this.countAlgo;
    }

    public final long getCountAlgo() {
        return this.countAlgoProperty().get();
    }

    public final void setCountAlgo(long countAlgo) {
        this.countAlgoProperty().set(countAlgo);
    }
}

