/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.risk.IRiskCheckApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.unify_risk.PRiskConstants;
import cms.tmx.datatype.proto.unify_risk.PUnifyRiskService;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.RiskCheckResult;
import cms.tmx.entity.User;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.instructions.models.regular.InstrCcsAccountDistributionModel;
import cms.tmx.instructions.models.regular.UserPreCtrl;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.models.PostMngServiceImpl;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.entrust.CcsEntrustFactory;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cmx.tmx.data.IMarketDataMng;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionCcsBaseModel
implements ITradeModel {
    public BooleanProperty normal = new SimpleBooleanProperty(true);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    public BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private ObjectProperty<Instruction> instruction = new SimpleObjectProperty((Object)new Instruction());
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeMktStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeAfterHours = new SimpleObjectProperty();
    private SimpleBooleanProperty canModify = new SimpleBooleanProperty(false);
    private String postil = "";
    private final int INIT_UNIT = 100;
    private static final Logger logger = LogManager.getLogger(InstructionCcsBaseModel.class);
    @Inject
    private MObjFactory of;
    protected MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    protected InstrCcsAccountDistributionModel accTreeModel;
    @Inject
    protected CcsEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private ResourceModel resModel;
    private UserPreCtrl preModel;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private IRiskCheckApi riskApi;
    @Inject
    private PostMngServiceImpl postMng;
    protected Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    protected Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    private static int PAR_VALUE = 100;
    private boolean a = true;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(10);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type", "50");
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
        this.setPriceTypeLimitedStg(node);
        this.limitStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
        this.initPriceGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
        this.initMarketType(node);
        this.setPriceTypeMktStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_after_hours", "1");
        this.initAfterHoursType(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_count_filter", "1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.money.addListener(ob -> this.onMoneyChange());
        this.countPer.addListener(ob -> this.onCountPerChange());
    }

    private void initAfterHoursType(MxNode node) {
        this.setPriceTypeAfterHours(node);
    }

    public void onSecChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        this.mktMng.dye(this.mktItem);
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changePriceStg();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
        this.setMktPrice();
        this.setBidAskPrice();
        this.setAfterHoursPrice();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            if (this.isStar() && this.isMktPrice()) {
                this.setCount(this.getPriceProtected() != 0.0 ? (long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            } else {
                this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            }
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        if (this.isNormal()) {
            ((CcsAccountDistribution)this.getAccDisModel().getRoot().getValue()).setCount(this.getCount());
            if (this.getCount() == 0L) {
                this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                return;
            }
            this.calCountDistribution();
            if (!this.getAccDisModel().isActive() && this.getAccDisModel().getInstructType().equals("4")) {
                this.getAccDisModel().allocateCount();
            }
        }
    }

    private void setAfterHoursPrice() {
        if (!this.isAfterHoursPrice()) {
            return;
        }
        double price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        this.setPrice(price);
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    public void setMktPrice() {
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        if (this.isGemFirst()) {
            this.setPrice(0.0);
        }
    }

    private void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        } else if (this.isBidAskPrice()) {
            this.setBidAskPrice();
        } else if (this.isAfterHoursPrice()) {
            this.setAfterHoursPrice();
        } else {
            this.setPrice(0.0);
        }
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            if (this.isNormal()) {
                if (this.isStar() && this.isMktPrice()) {
                    this.getAccDisModel().setPrice(this.getPriceProtected());
                } else {
                    this.getAccDisModel().setPrice(this.getPrice());
                }
                this.filterAcc();
                if (this.isCountOrSell()) {
                    this.getAccDisModel().calCanBuy();
                    return;
                }
                boolean clear = false;
                if (this.isStar() && this.isMktPrice()) {
                    clear = this.getPriceProtected() == 0.0;
                } else {
                    boolean bl = clear = this.getPrice() == 0.0 && !this.isUnlimited();
                }
                if (clear) {
                    this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                    this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
                    return;
                }
                if (this.getCountStg().getRaw().equals("5")) {
                    this.setCount((long)(this.getMoney() / this.getAccDisModel().getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
                    return;
                }
                this.calCountDistribution();
            }
        });
    }

    private void onMoneyChange() {
        if (this.isStar() && this.isMktPrice()) {
            if (this.getPriceProtected() != 0.0) {
                this.setCount((long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            }
        } else if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        }
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        if (!this.getAccDisModel().isActive() && !((Instruction)this.instruction.get()).isCanModify()) {
            return;
        }
        long total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    public void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanBuy();
        this.getAccDisModel().calAccountCanSell();
        this.getAccDisModel().filterAcc();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized ObservableList<Boolean> submit(TreeItem<CcsAccountDistribution> root) {
        ObservableList returnList = FxUtils.newList();
        for (CcsSingleEntrust en : this.getEntrustList(true)) {
            try {
                if (this.instruction.get() != null) {
                    en.setInstructionId(((Instruction)this.instruction.get()).getId());
                    if (!((Instruction)this.instruction.get()).getId().isEmpty()) {
                        Resource resource = this.resModel.getResource((Instruction)this.instruction.get());
                        if (resource == null) {
                            returnList.add((Object)false);
                            continue;
                        }
                        en.setResourceId(resource.getId());
                        en.setOrdQuantityCapacity(((Instruction)this.instruction.get()).getOrderAdvice().getOrderQty());
                    }
                }
                en.submit();
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public synchronized ObservableList<Boolean> submitAdvice() throws MException {
        ObservableList returnList = FxUtils.newList();
        for (OrderAdvice oa : this.getOrderAdvices()) {
            try {
                InstructionSubmitResult submitResult = oa.submit();
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
                returnList.add((Object)true);
            }
            catch (MException e) {
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)e, "");
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public synchronized ObservableList<Boolean> submitAdvice(boolean riskCheck) throws MException {
        ObservableList returnList = FxUtils.newList();
        for (OrderAdvice oa : this.getOrderAdvices(riskCheck)) {
            try {
                InstructionSubmitResult submitResult = oa.submit();
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
                returnList.add((Object)true);
            }
            catch (MException e) {
                this.mpMng.regularInst(oa, this.getAccDisModel().getInstructType(), (Object)e, "");
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getDirection() {
        return this.isBuy() ? "\u4e70\u5165" : "\u5356\u51fa";
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is(Integer.toString(50));
    }

    protected void changeMarketPriceType() {
        MxNode node = this.getPriceTypeMktStg();
        if (node == null) {
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initMarketType(node);
        }
    }

    private void changePriceStg() {
        MxNode node = this.getPriceStg();
        if (node == null) {
            return;
        }
        String old = node.getRaw();
        if (this.isBond() && this.isMktPrice()) {
            node.removeOthers("50");
            node.addNode("0");
            node.setRaw("50");
        } else if (this.isBond()) {
            node.removeNode("49");
            node.removeNode("99");
            if (old.equals("49") || old.equals("99")) {
                node.setRaw("50");
            }
        } else {
            this.getPriceStg().addNode("49");
            if (!this.isStar() && !this.isGem()) {
                node.removeNode("99");
                if (old.equals("99")) {
                    node.setRaw("50");
                }
            } else {
                node.addNode("99");
            }
        }
        this.setPriceStg(node);
    }

    public boolean isStar() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().getCode().startsWith("688");
    }

    public boolean isGem() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().isGem();
    }

    public boolean isGemFirst() {
        if (this.mktItem.getRefItem().getStatus() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u9996\u65e5");
    }

    protected void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            node.removeOthers("1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    protected int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    protected void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        MxNode nodeDistStg = this.getDistStg();
        if (this.isBuy()) {
            this.countStgBuy(nodeCountStg);
            this.limitStgBuy(this.getPriceTypeLimitedStg());
            this.distStgBuy(nodeDistStg);
        } else {
            this.countStgSell(nodeCountStg);
            this.limitStgSell(this.getPriceTypeLimitedStg());
            this.distStgSell(nodeDistStg);
        }
        if (this.isMktPrice() && this.isValidRef()) {
            this.setPrice(this.isBuy() ? this.mktItem.getUpLimitPrice() : this.mktItem.getDownLimitPrice());
        }
        if (this.isStar() && this.isMktPrice()) {
            this.setPrice(this.getPriceProtected());
        }
        if (this.getAccDisModel().isActive()) {
            this.filterAcc();
        }
    }

    public CcsSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    public InstrCcsAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().clearSelect();
        this.getAccDisModel().selectSecAcc(secAcc, mkt);
    }

    public void setPresetPstAcct(String secAcc, String mkt) {
        this.getAccDisModel().selectSecAcc(secAcc, mkt);
    }

    public void setAccDistModel(InstrCcsAccountDistributionModel accDistModel) {
        this.accTreeModel = accDistModel;
    }

    public List<CcsSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                CcsSingleEntrust en;
                block41: {
                    block43: {
                        block42: {
                            block40: {
                                en = this.createEntrust(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId(), ((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                                en.setFundAccount((FundAccount)((CcsAccountDistribution)acc.getValue()).getAcc());
                                en.setSecAccount(((CcsAccountDistribution)secAcc.getValue()).getSecAcc());
                                en.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                                en.setInvestorSecId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                                if (this.isReverseRepo()) {
                                    en.setSide(this.buy.get() ? 71 : 70);
                                } else {
                                    en.setSide(this.buy.get() ? 49 : 50);
                                }
                                en.setQuantity(((CcsAccountDistribution)secAcc.getValue()).getCount());
                                en.setCanSell(((CcsAccountDistribution)secAcc.getValue()).getCanSell());
                                en.setMarket(this.mktItem.getRefItem().getMarket());
                                en.setSecType(this.mktItem.getRefItem().getType());
                                en.setPrice(this.getPrice());
                                en.setAppID(this.isReverseRepo() ? "110" : "010");
                                if (!"50".equals(this.getPriceStg().getRaw())) break block40;
                                en.setOrderType(50);
                                en.setPrice(this.getPrice());
                                if (0.0 == this.getPrice() && "3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                                    en.setPrice(this.mktItem.getNowPrice());
                                }
                                break block41;
                            }
                            if (!"0".equals(this.getPriceStg().getRaw())) break block42;
                            en.setOrderType(0);
                            en.setPrice(this.getPrice());
                            break block41;
                        }
                        if (!"99".equals(this.getPriceStg().getRaw())) break block43;
                        en.setOrderType(99);
                        en.setPrice(this.getPrice());
                        break block41;
                    }
                    en.setOrderType(49);
                    switch (this.getPriceTypeMktStg().getRaw()) {
                        case "SH1": {
                            en.setMaxLevels(5);
                            en.setTif(48);
                            break;
                        }
                        case "SH2": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SH3": {
                            en.setMaxLevels(1);
                            en.setTif(48);
                            break;
                        }
                        case "SH4": {
                            en.setMaxLevels(0);
                            en.setTif(48);
                            break;
                        }
                        case "SZ1": {
                            en.setTif(48);
                            en.setMaxLevels(1);
                            break;
                        }
                        case "SZ2": {
                            en.setTif(48);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ3": {
                            en.setTif(51);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ4": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SZ5": {
                            en.setTif(52);
                            en.setMaxLevels(0);
                            break;
                        }
                    }
                    if (this.isStar()) {
                        en.setPrice(this.getPriceProtected());
                    }
                }
                if (this.isStar()) {
                    en.setAppID("700");
                }
                if (this.mktItem.getRefItem().isGem()) {
                    en.setAppID("GEM");
                }
                en.setSec(this.mktItem.getRefItem().getCode());
                en.setSecName(this.mktItem.getRefItem().getName());
                if (this.isAutoSlice()) {
                    this.entrustSplit.setRefItem(this.getValidRef());
                    List splitList = this.entrustSplit.split(en, this.getSliceSize());
                    enList.addAll(splitList);
                    continue;
                }
                enList.add(en);
            }
        }
        return enList;
    }

    public List<OrderAdvice> getOrderAdvices(boolean riskChcek) throws MException {
        return this.getOrderAdviceListByRiskCheck(riskChcek);
    }

    public List<OrderAdvice> getOrderAdvices() throws MException {
        return this.getOrderAdviceListByRiskCheck(false);
    }

    private List<OrderAdvice> getOrderAdviceListByRiskCheck(boolean riskChcek) throws MException {
        LinkedList<OrderAdvice> adviceList = new LinkedList<OrderAdvice>();
        FilteredList accTreeItems = null;
        accTreeItems = riskChcek ? this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && !((CcsAccountDistribution)ad.getValue()).isRiskForbid()) : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
        for (TreeItem acc : accTreeItems) {
            OrderAdvice oa;
            block43: {
                block45: {
                    block44: {
                        block42: {
                            oa = (OrderAdvice)this.of.create(OrderAdvice.class);
                            AppointedTraderSetting traderSetting = this.fundTraderMap.get(((CcsAccountDistribution)acc.getValue()).getAcc());
                            String expiredDate = this.insExpiredMap.get(((CcsAccountDistribution)acc.getValue()).getAcc());
                            if (traderSetting != null) {
                                oa.setTraderUserIds(traderSetting.getAppointedTraderIds());
                            }
                            oa.setInsExpiredDate(expiredDate);
                            if (this.getAccDisModel().getInstructType().equals("1") || this.getAccDisModel().getInstructType().equals("2")) {
                                oa.setCanModify(this.isCanModify() && (this.isUnlimited() || this.isUpLimit() || this.isDownLimit()));
                            } else {
                                oa.setCanModify(((Instruction)this.instruction.getValue()).isCanModify());
                            }
                            oa.setInstructionPanelType(this.getAccDisModel().getInstructType());
                            if (this.isReverseRepo()) {
                                oa.setSide(this.buy.get() ? 71 : 70);
                            } else {
                                oa.setSide(this.buy.get() ? 49 : 50);
                            }
                            oa.setAccntLevel(0);
                            oa.setMarket(this.mktItem.getRefItem().getMarket());
                            oa.setSec(this.mktItem.getRefItem().getCode());
                            oa.setSecType(this.mktItem.getRefItem().getType());
                            oa.setSecName(this.mktItem.getRefItem().getName());
                            oa.setProductId(this.accountService.getAccountFromCache(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getProductId());
                            List stepList = this.instrAccModel.getWorkflow(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId()).getSteps();
                            if (stepList != null && !stepList.isEmpty()) {
                                for (AccntStepAttribute step : stepList) {
                                    if (1 != step.getStepId()) continue;
                                    oa.setFlowAttriId(step.getFlowAttriId());
                                    oa.setStepAttrId(step.getStepAttriId());
                                    break;
                                }
                            }
                            oa.setInstructionType(2);
                            oa.setStar(this.isStar());
                            if (!"50".equals(this.getPriceStg().getRaw())) break block42;
                            oa.setOrdType(50);
                            oa.setPriceLimit(Integer.valueOf(this.getPriceTypeLimitedStg().getRaw()).intValue());
                            oa.setPrice(this.getPrice());
                            if ("3".equals(this.getPriceTypeLimitedStg().getRaw()) && this.isValidRef()) {
                                oa.setPrice(this.mktItem.getNowPrice());
                            }
                            break block43;
                        }
                        if (!"0".equals(this.getPriceStg().getRaw())) break block44;
                        oa.setOrdType(0);
                        oa.setPriceTypeBidAsk(Integer.valueOf(this.getPriceTypeBidAskStg().getRaw()).intValue());
                        oa.setPrice(this.getPrice());
                        break block43;
                    }
                    if (!"99".equals(this.getPriceStg().getRaw())) break block45;
                    oa.setOrdType(99);
                    oa.setPriceLimit(Integer.valueOf(this.getPriceTypeAfterHours().getRaw()).intValue());
                    oa.setPrice(this.getPrice());
                    break block43;
                }
                oa.setOrdType(49);
                oa.setMarketPriceLimit(this.getPriceTypeMktStg().getRaw());
                oa.setPrice(this.getPrice());
                switch (this.getPriceTypeMktStg().getRaw()) {
                    case "SH1": {
                        oa.setMaxLevels(5);
                        oa.setTif(48);
                        break;
                    }
                    case "SH2": {
                        oa.setTif(51);
                        oa.setMaxLevels(5);
                        break;
                    }
                    case "SH3": {
                        oa.setMaxLevels(1);
                        oa.setTif(48);
                        break;
                    }
                    case "SH4": {
                        oa.setMaxLevels(0);
                        oa.setTif(48);
                        break;
                    }
                    case "SZ1": {
                        oa.setTif(48);
                        oa.setMaxLevels(1);
                        break;
                    }
                    case "SZ2": {
                        oa.setTif(48);
                        oa.setMaxLevels(0);
                        break;
                    }
                    case "SZ3": {
                        oa.setTif(51);
                        oa.setMaxLevels(0);
                        break;
                    }
                    case "SZ4": {
                        oa.setTif(51);
                        oa.setMaxLevels(5);
                        break;
                    }
                    case "SZ5": {
                        oa.setTif(52);
                        oa.setMaxLevels(0);
                        break;
                    }
                }
                if (this.isStar()) {
                    oa.setProtectedLimitPrice(this.getPriceProtected());
                }
            }
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L)) {
                AccntSecInfo accntSec = new AccntSecInfo();
                accntSec.setAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId());
                accntSec.setInvestorId(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId());
                accntSec.setSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                accntSec.setParentId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                accntSec.setMarket(this.mktItem.getRefItem().getMarket());
                accntSec.setOrderQty(((CcsAccountDistribution)secAcc.getValue()).getCount());
                orderQty += ((CcsAccountDistribution)secAcc.getValue()).getCount();
                accntSecList.add(accntSec);
            }
            oa.setAccSecInfoList(accntSecList);
            oa.setOrderQty(orderQty);
            oa.setPostil(this.postil);
            oa.setAmount(this.getMoney(oa));
            if (accntSecList.isEmpty()) continue;
            adviceList.add(oa);
        }
        return adviceList;
    }

    private int getParValue(OrderAdvice item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(OrderAdvice item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getOrderQty() * (long)this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getOrderQty() * item.getPrice() * 10.0;
        }
        if (this.isStar() && "49".equals(((MxNode)this.priceStg.getValue()).getRaw())) {
            return (double)item.getOrderQty() * item.getProtectedLimitPrice();
        }
        return (double)item.getOrderQty() * item.getPrice();
    }

    public WorkFlowDescriptor getWorkFlowByFundAccount(FundAccount fundAcc) {
        return this.instrAccModel.getWorkflow(fundAcc.getParentId());
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public void create(String instructType) {
        this.getAccDisModel().setInstructPanelType(instructType);
        try {
            this.getAccDisModel().securityProperty().bind((ObservableValue)this.security);
            this.getAccDisModel().normalProperty().bind((ObservableValue)this.normal);
            this.getAccDisModel().buyProperty().bind((ObservableValue)this.buy);
            this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
            this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
            this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
            this.getAccDisModel().create();
            this.onCountStgChange();
            this.onDistStgChange();
            this.onPriceStgChange();
            this.onPriceStgChange();
            this.onAccFilterStgChange();
        }
        catch (MException | Exception e) {
            logger.error("\u521b\u5efa\u8d26\u53f7\u6811\u51fa\u9519", e);
        }
    }

    public ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public ObjectProperty<MxNode> priceTypeMktStgProperty() {
        return this.priceTypeMktStg;
    }

    public MxNode getPriceTypeMktStg() {
        return (MxNode)this.priceTypeMktStgProperty().get();
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStgProperty().set((Object)priceTypeMktStg);
    }

    public ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    public boolean isSpecify() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("2");
    }

    public boolean isAfterHours() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public boolean isUpLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("1");
    }

    public boolean isDownLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("4");
    }

    private void limitStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("1");
        node.addNode("3");
        node.setRaw(oldNodeRaw.equals("4") ? "1" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void limitStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("4");
        node.addNode("3");
        node.setRaw(oldNodeRaw.equals("1") ? "4" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void initPriceGear(MxNode node) {
        node.removeOthers("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    private MxNode initMarketType(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.setRaw("0");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode shMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SH1");
        node.addNode("SH2");
        if (this.isStar()) {
            node.addNode("SH3");
            node.addNode("SH4");
        }
        node.removeNode("0");
        node.setRaw("SH1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode szMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        node.removeNode("0");
        node.setRaw("SZ1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    public boolean isMktPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("49");
    }

    public boolean isBidAskPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("0");
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public ObservableList<Boolean> submitApprove(Instruction instruction) throws MException {
        ObservableList returnList = FxUtils.newList();
        Iterator<OrderAdvice> iterator = this.getOrderAdvices().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public RiskCheckResult riskRangeCheck(TreeItem<CcsAccountDistribution> acc) {
        RiskCheckResult res = new RiskCheckResult();
        res.setAcc(acc);
        try {
            PUnifyRiskService.InstructionRiskCheckReq.Builder insB = PUnifyRiskService.InstructionRiskCheckReq.newBuilder();
            PUnifyRiskService.InstructionRiskCheckInfo.Builder infoB = PUnifyRiskService.InstructionRiskCheckInfo.newBuilder();
            infoB.setPartyId(this.baseApi.getPartyId());
            infoB.setProductId(((CcsAccountDistribution)acc.getValue()).getAcc().getProductId());
            infoB.setExtAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
            infoB.setSecurityType(this.mktItem.getRefItem().getType());
            infoB.setMarket(this.mktItem.getRefItem().getMarket());
            infoB.setSecurityId(this.mktItem.getRefItem().getCode());
            int side = this.isReverseRepo() ? (this.buy.get() ? 71 : 70) : (this.buy.get() ? 49 : 50);
            infoB.setSideValue(side);
            insB.setOpUser(this.baseApi.getOpUser());
            insB.addInstrInfo(infoB.build());
            PUnifyRiskService.InstructionRiskCheckResp resp = this.riskApi.riskRangeCheck(insB.build());
            if (PRiskConstants.Risk_Action.RISK_ACTION_WARN.equals((Object)resp.getRiskAction())) {
                res.operate("warn");
            } else if (PRiskConstants.Risk_Action.RISK_ACTION_FORBID.equals((Object)resp.getRiskAction())) {
                res.operate("forbid");
            } else {
                res.operate("PASSED");
                return res;
            }
            res.getReason().append(String.valueOf(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId()) + "\u98ce\u63a7\u6821\u9a8c\u5931\u8d25");
            for (PUnifyRiskService.InstructionRiskCheckResult checkRes : resp.getCheckResultList()) {
                for (PUnifyRiskService.RiskCheckResult check : checkRes.getRiskcheckresultList()) {
                    res.getReason().append(check.getRemark()).append("\n");
                }
            }
        }
        catch (MException | Exception e) {
            res.operate("warn");
            res.getReason().append(((CcsAccountDistribution)acc.getValue()).getAcc().getInvestId()).append("\u8c03\u7528\u98ce\u63a7\u6821\u9a8c\u51fa\u9519").append(e.getMessage()).append("\n");
        }
        return res;
    }

    public ObjectProperty<Instruction> instructionProperty() {
        return this.instruction;
    }

    public Instruction getInstruction() {
        return (Instruction)this.instructionProperty().get();
    }

    public void setInstruction(Instruction instruction) {
        this.instructionProperty().set((Object)instruction);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public final SimpleBooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public final boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public final void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public InstructionAccountModel getInstrAccModel() {
        return this.instrAccModel;
    }

    public void setInstrAccModel(InstructionAccountModel instrAccModel) {
        this.instrAccModel = instrAccModel;
    }

    public InstructionModel getInstructionModel() {
        return this.instructionModel;
    }

    public void setPreModel(UserPreCtrl preModel) {
        this.preModel = preModel;
    }

    public ObjectProperty<MxNode> priceTypeAfterHoursProperty() {
        return this.priceTypeAfterHours;
    }

    public MxNode getPriceTypeAfterHours() {
        return (MxNode)this.priceTypeAfterHoursProperty().get();
    }

    public void setPriceTypeAfterHours(MxNode priceTypeAfterHours) {
        this.priceTypeAfterHoursProperty().set((Object)priceTypeAfterHours);
    }

    public DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public void setPostil(String postil) {
        this.postil = postil;
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public AppointedTraderSetting buildTraderSetting(WorkFlowDescriptor workFlow) {
        AppointedTraderSetting traderSettings = new AppointedTraderSetting();
        List postIds = ((AccntStepAttribute)workFlow.getSteps().get(workFlow.getSteps().size() - 1)).getObjIds();
        if (postIds == null || postIds.isEmpty()) {
            return traderSettings;
        }
        List users = null;
        try {
            users = this.postMng.getUserList(postIds, this.baseApi.getPartyId(), true);
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u804c\u4f4did\uff0c\u67e5\u8be2\u5176\u6240\u6709\u7528\u6237\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (users == null || users.isEmpty()) {
            return traderSettings;
        }
        traderSettings.setUsers(users);
        for (User user : users) {
            traderSettings.getAppointedTraderIds().add(user.getId());
        }
        return traderSettings;
    }
}

