/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.models.regular.InstrCcsAccountDistributionModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.InstructionAccountModel;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstrCcsAccountMcDistributionModel
extends InstrCcsAccountDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    private AlgoParam algoAdvice;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    private static final Logger logger = LogManager.getLogger(InstrCcsAccountMcDistributionModel.class);

    @Override
    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public TreeItem<CcsAccountDistribution> getRoot() {
        return this.root;
    }

    @Override
    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    @Override
    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    @Override
    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    @Override
    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    protected void filterFundAcc() {
        this.showAll((MxTreeList<CcsAccountDistribution>)this.accMxList);
        if (this.refItem != null && !"".equals(this.refItem.getMarket())) {
            this.accMxList.getOrList().forEach(accEach -> {
                if ("XSHE".equals(this.refItem.getMarket()) && this.isSouthCenter(accEach.getAcc())) {
                    accEach.setShow(true);
                } else if ("XSHG".equals(this.refItem.getMarket()) && this.isSHCenter(accEach.getAcc())) {
                    accEach.setShow(true);
                } else {
                    accEach.setShow(false);
                }
            });
        }
        this.mapSecDisMxList.keySet().forEach(each -> {
            if (((MxTreeList)this.mapSecDisMxList.get(each)).getObList().size() == 0) {
                this.accMxList.getOrList().forEach(accEach -> {
                    if (accEach.getAcc().getExtAccntId().equals(each)) {
                        accEach.setShow(false);
                    }
                });
            }
        });
        this.accMxList.filter(this.pdShow);
    }

    private boolean isSHCenter(CcsFundAccount acc) {
        return "77777-01-01".equals(acc.getCounterId());
    }

    private boolean isSouthCenter(CcsFundAccount acc) {
        return "77777-01-02".equals(acc.getCounterId());
    }

    protected void showAll(MxTreeList<CcsAccountDistribution> distList) {
        if (distList.getOrList() == null) {
            return;
        }
        distList.getOrList().forEach(each -> {
            if (each.isIsSecAcc()) {
                each.setShow(true);
                return;
            }
            if ("77777-01-01".equals(each.getAcc().getCounterId()) || "77777-01-02".equals(each.getAcc().getCounterId())) {
                each.setShow(true);
            } else {
                each.setShow(false);
            }
        });
        distList.filter(this.pdShow);
    }

    @Override
    public AlgoParam getAlgoAdvice() {
        return this.algoAdvice;
    }

    @Override
    public void setAlgoAdvice(AlgoParam algoAdvice) {
        this.algoAdvice = algoAdvice;
    }

    @Override
    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    @Override
    public BooleanProperty activeProperty() {
        return this.active;
    }

    @Override
    public boolean isActive() {
        return this.activeProperty().get();
    }

    @Override
    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    @Override
    public Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    @Override
    public OrderAdvice getAdvice() {
        return this.advice;
    }

    @Override
    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }
}

