/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.instructions.models.portfolio.InstrPortfoDistributionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstrCcsAccountDistributionModel
extends CcsAccountDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    private AlgoParam algoAdvice;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    private static final Logger logger = LogManager.getLogger(InstrPortfoDistributionModel.class);

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    public void fillAccount(Instruction instruction) {
        List list;
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.setInstruction(instruction);
        this.setAdvice(instruction.getOrderAdvice());
        this.setAlgoAdvice(instruction.getAlgoParam());
        String market = "";
        if (instruction.getType().getRaw().equals("2")) {
            list = this.advice.getAccSecInfoList();
            market = this.advice.getMarket();
        } else {
            list = this.algoAdvice.getAccSecInfoList();
            market = this.algoAdvice.getMarket();
        }
        if (instruction.getIsOrderStep()) {
            for (AccntSecInfo accSec : list) {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + market) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + market);
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + market, accSec.getOrderAvailableQuantity());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderAvailableQuantity() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + market, accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            }
        } else {
            for (AccntSecInfo accSec : list) {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + market) != null) {
                    oldCount = (Long)this.mapQuantiy.get(String.valueOf(accSec.getAccntId()) + market);
                }
                this.mapQuantiy.put(String.valueOf(accSec.getSecAccntId()) + market, accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccntId(), accSec.getOrderQty() + oldCount);
                this.mapWeight.put(String.valueOf(accSec.getSecAccntId()) + market, accSec.getOrderWeight());
                this.mapWeight.put(accSec.getAccntId(), accSec.getOrderWeight() + oldWeight);
            }
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createTree();
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u6295\u7ec4\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public AlgoParam getAlgoAdvice() {
        return this.algoAdvice;
    }

    public void setAlgoAdvice(AlgoParam algoAdvice) {
        this.algoAdvice = algoAdvice;
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }
}

