/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.regular;

import cms.tmx.core.MException;
import cms.tmx.define.BsDict;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.instructions.models.portfolio.InstrPortfoDistributionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class HKCcsAccountDistributionModel
extends CcsAccountDistributionModel {
    private ObSimpleInstruction instruction;
    private OrderAdvice advice;
    private AlgoParam algoAdvice;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;
    private static final Logger logger = LogManager.getLogger(InstrPortfoDistributionModel.class);
    private StringProperty market = new SimpleStringProperty("");
    private Boolean isShow = true;

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        return this.accMng.getHkAccountMap();
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    protected void createTree() throws MException {
        ((CcsAccountDistribution)this.root.getValue()).setSelected(this.isSelected());
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new ConcurrentHashMap(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, this.root.getChildren(), accList);
        if (this.getInstructType().equals("3") && this.isShow().booleanValue()) {
            return;
        }
        if (this.getAccountMap() == null) {
            return;
        }
        this.mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(this.getAccountMap());
        HashSet accSet = new HashSet(this.mapAccount.keySet());
        for (FundAccount acc : accSet) {
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(acc);
            CcsAccountDistribution accDst = new CcsAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.setWeight(this.mapWeight.get(fundAcc.getNewCashAccntId()) == null ? 0 : (Integer)this.mapWeight.get(fundAcc.getNewCashAccntId()));
            accDst.setCount(this.mapQuantiy.get(fundAcc.getNewCashAccntId()) == null ? 0L : (Long)this.mapQuantiy.get(fundAcc.getNewCashAccntId()));
            accDst.setAccntName(fundAcc.getAccountName());
            if (this.mapWeight.isEmpty()) {
                accList.add(accDst);
            } else if (this.mapWeight.get(fundAcc.getNewCashAccntId()) != null) {
                accList.add(accDst);
            }
            this.accMxList.update(accList);
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : (List)this.mapAccount.get(acc)) {
                if ("NEEQ".equals(secAcc.getExchange().getRaw())) continue;
                CcsAccountDistribution secDst = new CcsAccountDistribution();
                boolean isHk = BsDict.HKUSA_MARKET.contains(this.getMarket());
                if (this.mapWeight.isEmpty()) {
                    if (this.isHk() && isHk) {
                        secAccList.add(secDst);
                    } else if (!this.isHk() && !isHk) {
                        secAccList.add(secDst);
                    }
                } else if (this.mapWeight.get(secAcc.getExtSecAccntId()) != null) {
                    if (this.isHk() && isHk) {
                        secAccList.add(secDst);
                    } else if (!this.isHk() && !isHk) {
                        secAccList.add(secDst);
                    }
                }
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setAccParentId(fundAcc.getParentId());
                secDst.setWeight(this.mapWeight.get(secAcc.getExtSecAccntId()) == null ? 1 : (Integer)this.mapWeight.get(secAcc.getExtSecAccntId()));
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setSelected(this.isSelected());
                secDst.selectedProperty().addListener(ob -> this.calCount());
                secDst.setCount(this.mapQuantiy.get(secAcc.getExtSecAccntId()) == null ? 0L : (Long)this.mapQuantiy.get(secAcc.getExtSecAccntId()));
            }
            if (secAccList.size() == 0) continue;
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem)this.root.getChildren().get(accList.size() - 1), ((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        this.filterFundAcc();
        this.checkSingle();
        this.calEffectiveSecAccCount();
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    public void fillAccount(ObSimpleInstruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.setInstruction(instruction);
        List list = instruction.getOrderDetail().getAccntSecInfo();
        instruction.getMarket().getValue();
        if (instruction.getIsOrderStep()) {
            for (AccntSecInfo accSec : list) {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getAvailableQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getAvailableQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            }
        } else {
            for (AccntSecInfo accSec : list) {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getOrderQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            }
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createTree();
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u6295\u7ec4\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public AlgoParam getAlgoAdvice() {
        return this.algoAdvice;
    }

    public void setAlgoAdvice(AlgoParam algoAdvice) {
        this.algoAdvice = algoAdvice;
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }

    public final StringProperty marketProperty() {
        return this.market;
    }

    public final String getMarket() {
        return (String)this.marketProperty().get();
    }

    public final void setMarket(String market) {
        this.marketProperty().set((Object)market);
    }

    public Boolean isShow() {
        return this.isShow;
    }

    public void setIsShow(Boolean isShow) {
        this.isShow = isShow;
    }
}

