/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.portfolio.basket;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.PortfBasketTradeSettings;
import cms.tmx.web.service.IUserSettingsService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserSettingPortfBasketTrade {
    @Inject
    protected MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType = "6";
    private String menuId = "200065001";
    private String algoBeginTime;
    private String algoEndTime;
    private boolean algoEnable;
    private boolean unfinishedAfterOrder = false;
    private static final Logger logger = LogManager.getLogger(UserSettingPortfBasketTrade.class);
    private MEventHandler reload = event -> this.doSet();

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", this.reload);
        this.doSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", this.reload);
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void doSet() {
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof PortfBasketTradeSettings) {
                PortfBasketTradeSettings basket = (PortfBasketTradeSettings)PortfBasketTradeSettings.class.cast(settings);
                this.setAlgoBeginTime(basket.getArithDefBeginTime());
                this.setAlgoEndTime(basket.getArithDefEndTime());
                this.setAlgoEnable(basket.isEnabled());
                this.setUnfinishedAfterOrder("1".equals(basket.getUnfinishedAfterOrder()));
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public String getAlgoBeginTime() {
        return this.algoBeginTime;
    }

    public void setAlgoBeginTime(String algoBeginTime) {
        this.algoBeginTime = algoBeginTime;
    }

    public String getAlgoEndTime() {
        return this.algoEndTime;
    }

    public void setAlgoEndTime(String algoEndTime) {
        this.algoEndTime = algoEndTime;
    }

    public boolean isAlgoEnable() {
        return this.algoEnable;
    }

    public void setAlgoEnable(boolean algoEnable) {
        this.algoEnable = algoEnable;
    }

    public boolean isUnfinishedAfterOrder() {
        return this.unfinishedAfterOrder;
    }

    public void setUnfinishedAfterOrder(boolean unfinishedAfterOrder) {
        this.unfinishedAfterOrder = unfinishedAfterOrder;
    }
}

