/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.portfolio;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.models.AlgoTradeModel;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.instructions.models.portfolio.InstructionPortfolioBaseModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.views.portfolio.AlgoQueryPart;
import cms.tmx.trade.entrust.CcsSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionPortfolioAlgoModel {
    private static final Logger logger = LogManager.getLogger(InstructionPortfolioAlgoModel.class);
    public InstructionPortfolioBaseModel baseModel;
    @Inject
    private AlgoModel param;
    @Inject
    protected ExecutorService exe;
    private LongProperty countAlgo = new SimpleLongProperty();
    private double priceAmount;
    @Inject
    private MObjFactory of;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    private AlgoTradeModel tradeModel;
    @Inject
    private MEventService es;
    private static int PAR_VALUE = 100;

    public void initAlgo() {
        this.countAlgo.addListener(ob -> this.onCountAlgoChange());
        this.baseModel.getMI().nowPriceProperty().addListener((ob, old, now) -> Platform.runLater(() -> {
            if (!this.baseModel.isNormal()) {
                this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
                if (this.baseModel.getMI().getNowPrice() == 0.0) {
                    this.baseModel.getAccDisModel().clearCanBuy(this.baseModel.getAccDisModel().getRoot());
                    return;
                }
                this.baseModel.filterAcc();
            }
        }));
        this.baseModel.normal.addListener(ob -> this.onNormalChange());
    }

    private void onNormalChange() {
        if (this.baseModel.isNormal()) {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getPrice());
            ((PortfolioAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.baseModel.getCount());
        } else {
            this.baseModel.getAccDisModel().setPrice(this.baseModel.getMI().getNowPrice());
            ((PortfolioAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
        }
        this.baseModel.calCountDistribution();
    }

    private void onCountAlgoChange() {
        if (!this.baseModel.isNormal()) {
            ((PortfolioAccountDistribution)this.baseModel.getAccDisModel().getRoot().getValue()).setCount(this.getCountAlgo());
            if (this.getCountAlgo() == 0L) {
                this.baseModel.getAccDisModel().clearCount(this.baseModel.getAccDisModel().getRoot());
                return;
            }
            this.baseModel.calCountDistribution();
            if (!this.baseModel.getAccDisModel().isActive() && this.baseModel.getAccDisModel().getInstructType().equals("4")) {
                this.baseModel.getAccDisModel().getAllocateModel().allocateCount();
            }
        }
    }

    public synchronized RespResult submitInstruction() throws MException {
        RespResult result = new RespResult();
        for (AlgoParam ad : this.getOrderAdvice()) {
            try {
                InstructionSubmitResult submitResult = ad.submit();
                result.incrementSuccessed();
                this.mpMng.algoInst(ad, this.baseModel.getAccDisModel().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
            }
            catch (MException e) {
                result.incrementFailed(e.getMessage());
                this.mpMng.algoInst(ad, this.baseModel.getAccDisModel().getInstructType(), (Object)e, "");
            }
        }
        return result;
    }

    public RespResult submitApprove(Instruction instruction) throws MException {
        RespResult result = new RespResult();
        try {
            this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
            result.incrementSuccessed();
        }
        catch (MException e) {
            result.incrementFailed(e.getMessage());
        }
        return result;
    }

    public RespResult execute(Instruction instruction) throws MException {
        RespResult result = new RespResult();
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
        result.incrementSuccessed();
        return result;
    }

    public synchronized RespResult submitOrder(String instructionId, String resourceId) throws MException {
        ObservableList list = FxUtils.newList();
        for (TreeItem<PortfolioAccountDistribution> portItem : this.baseModel.getSelectedItems((TreeItem<PortfolioAccountDistribution>)this.baseModel.getAccDisModel().getRoot())) {
            for (TreeItem<PortfolioAccountDistribution> fundItem : this.baseModel.getSelectedItems(portItem)) {
                for (TreeItem<PortfolioAccountDistribution> secItem : this.baseModel.getNoZeroItems(fundItem)) {
                    AlgoParam param = (AlgoParam)this.of.create(AlgoParam.class);
                    param.update((Object)this.param);
                    Portfolio protfolio = ((PortfolioAccountDistribution)portItem.getValue()).getPortfolio();
                    CcsFundAccount fundAcc = ((PortfolioAccountDistribution)fundItem.getValue()).getAcc();
                    SecAccount secAcc = ((PortfolioAccountDistribution)secItem.getValue()).getSecAcc();
                    if (fundAcc instanceof CcsSubFundAccount && secAcc instanceof CcsSubSecAccount) {
                        CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAcc);
                        CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAcc);
                        param.setPortfolio(protfolio.getId());
                        param.setPortfolioName(protfolio.getName());
                        param.setFundAccId(fundAcc.getExtAccntId());
                        param.setSecAccId(secAcc.getExtSecAccntId());
                        param.setSubFundId(subFundAcc.getSubAccntId());
                        param.setSubSecId(subSecAcc.getSubSecAccntId());
                        param.setCount((int)((PortfolioAccountDistribution)secItem.getValue()).getCount());
                        param.setReference(instructionId);
                        param.setResourceId(resourceId);
                        list.add((Object)param);
                        continue;
                    }
                    throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                }
            }
        }
        CountDownLatch latch = new CountDownLatch(list.size());
        Semaphore sema = new Semaphore(5);
        RespResult result = new RespResult();
        for (AlgoParam param : list) {
            this.exe.execute(() -> {
                try {
                    try {
                        sema.acquire();
                        int type = param.getAlgorithm().getType();
                        switch (type) {
                            case 15: 
                            case 16: 
                            case 19: 
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: {
                                this.tradeModel.submitMise(param);
                                break;
                            }
                            default: {
                                this.tradeModel.submit(param);
                            }
                        }
                        result.incrementSuccessed();
                    }
                    catch (MException | Exception e) {
                        logger.error((Object)e, e);
                        result.incrementFailed(e.getMessage());
                        sema.release();
                        latch.countDown();
                    }
                }
                finally {
                    sema.release();
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.es.sendEvent(AlgoQueryPart.class.getName(), null);
        return result;
    }

    public List<CcsSingleEntrust> getEntrustList() throws MException {
        LinkedList<CcsSingleEntrust> enList = new LinkedList<CcsSingleEntrust>();
        for (TreeItem<PortfolioAccountDistribution> portItem : this.baseModel.getSelectedItems((TreeItem<PortfolioAccountDistribution>)this.baseModel.getAccDisModel().getRoot())) {
            for (TreeItem<PortfolioAccountDistribution> fundItem : this.baseModel.getSelectedItems(portItem)) {
                for (TreeItem<PortfolioAccountDistribution> secItem : this.baseModel.getNoZeroItems(fundItem)) {
                    Portfolio protfolio = ((PortfolioAccountDistribution)portItem.getValue()).getPortfolio();
                    CcsFundAccount fundAcc = ((PortfolioAccountDistribution)fundItem.getValue()).getAcc();
                    SecAccount secAcc = ((PortfolioAccountDistribution)secItem.getValue()).getSecAcc();
                    String fundAccId = fundAcc.getExtAccntId();
                    String secAccId = secAcc.getExtSecAccntId();
                    CcsSingleEntrust en = this.baseModel.createEntrust(fundAccId, secAccId);
                    if (this.baseModel.isReverseRepo()) {
                        en.setSide(this.param.isBuy() ? 71 : 70);
                    } else {
                        en.setSide(this.param.isBuy() ? 49 : 50);
                    }
                    en.setFundAccount((FundAccount)fundAcc);
                    en.setSecAccount(secAcc);
                    en.setInvestorId(fundAcc.getInvestId());
                    en.setInvestorSecId(secAcc.getInverstorSecId());
                    en.setQuantity(((PortfolioAccountDistribution)secItem.getValue()).getCount());
                    en.setSec(this.param.getCode());
                    en.setSecName(this.param.getName());
                    en.setMarket(this.param.getMarket());
                    en.setSecType(this.param.getType());
                    double price = this.baseModel.getMI().getNowPrice();
                    price = price == 0.0 ? this.baseModel.getMI().getClosePrice() : price;
                    en.setPrice(price);
                    this.priceAmount = en.getPrice();
                    en.setCanSell(((PortfolioAccountDistribution)secItem.getValue()).getCanSell());
                    en.setOrderType(50);
                    en.setAppID(this.baseModel.isReverseRepo() ? "110" : "010");
                    if (!(fundAcc instanceof CcsSubFundAccount) || !(secAcc instanceof CcsSubSecAccount)) {
                        throw new MException(1, "\u8d26\u53f7\u9519\u8bef");
                    }
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(fundAcc);
                    CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAcc);
                    en.setPortfolioId(protfolio.getId());
                    en.setPortfolioName(protfolio.getName());
                    en.setSubAccntId(subFundAcc.getSubAccntId());
                    en.setSubSecAccntId(subSecAcc.getSubSecAccntId());
                    enList.add(en);
                }
            }
        }
        return enList;
    }

    public List<AlgoParam> getOrderAdvice() throws MException {
        LinkedList<AlgoParam> adviceList = new LinkedList<AlgoParam>();
        for (TreeItem<PortfolioAccountDistribution> portfo : this.baseModel.getSelectedItems((TreeItem<PortfolioAccountDistribution>)this.baseModel.getAccDisModel().getRoot())) {
            AlgoParam orderAdvice = (AlgoParam)this.of.create(AlgoParam.class);
            orderAdvice.update((Object)this.param);
            if (this.baseModel.isReverseRepo()) {
                orderAdvice.setSide(this.param.isBuy() ? 71 : 70);
            } else {
                orderAdvice.setSide(this.param.isBuy() ? 49 : 50);
            }
            orderAdvice.setPortfolio(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId());
            orderAdvice.setPortfolioName(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getName());
            orderAdvice.setInstructionPanelType(this.baseModel.getAccDisModel().getInstructType());
            orderAdvice.setAccntLevel(1);
            List stepList = this.baseModel.instrAccModel.getWorkflow(((PortfolioAccountDistribution)portfo.getValue()).getPortfolio().getId()).getSteps();
            if (stepList != null && !stepList.isEmpty()) {
                for (AccntStepAttribute step : stepList) {
                    if (1 != step.getStepId()) continue;
                    orderAdvice.setFlowAttriId(step.getFlowAttriId());
                    orderAdvice.setStepAttrId(step.getStepAttriId());
                    break;
                }
            }
            orderAdvice.setInstructionType(9);
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            for (TreeItem<PortfolioAccountDistribution> acc : this.baseModel.getSelectedItems(portfo)) {
                if (((PortfolioAccountDistribution)acc.getValue()).getAcc() instanceof CcsSubFundAccount) {
                    CcsSubFundAccount subFundAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(((PortfolioAccountDistribution)acc.getValue()).getAcc());
                    if (StringUtils.isEmpty((String)orderAdvice.getInsExpiredDate())) {
                        orderAdvice.setInsExpiredDate(this.baseModel.getInsExpiredMap().get(subFundAcc));
                    }
                    for (TreeItem<PortfolioAccountDistribution> secAcc : this.baseModel.getNoZeroItems(acc)) {
                        if (((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc() instanceof CcsSubSecAccount) {
                            AccntSecInfo accntSec = new AccntSecInfo();
                            accntSec.setAccntId(subFundAcc.getSubAccntId());
                            accntSec.setInvestorId(subFundAcc.getInvestId());
                            accntSec.setParentId(subFundAcc.getParentId());
                            accntSec.setSubParentId(subFundAcc.getParentSubAccntId());
                            CcsSubSecAccount subSecAcc = (CcsSubSecAccount)CcsSubSecAccount.class.cast(((PortfolioAccountDistribution)secAcc.getValue()).getSecAcc());
                            accntSec.setSecAccntId(subSecAcc.getSubSecAccntId());
                            accntSec.setOrderQty(((PortfolioAccountDistribution)secAcc.getValue()).getCount());
                            orderQty += ((PortfolioAccountDistribution)secAcc.getValue()).getCount();
                            accntSec.setMarket(subSecAcc.getExchange().getRaw());
                            accntSecList.add(accntSec);
                            continue;
                        }
                        throw new MException(1, "\u8bc1\u5238\u8d26\u53f7\u9519\u8bef");
                    }
                    continue;
                }
                throw new MException(1, "\u8d44\u91d1\u8d26\u53f7\u9519\u8bef");
            }
            if (accntSecList.isEmpty()) continue;
            orderAdvice.setAccSecInfoList(accntSecList);
            orderAdvice.setCount((int)orderQty);
            orderAdvice.setPrice(this.priceAmount);
            orderAdvice.setAmount(this.getMoney(orderAdvice));
            adviceList.add(orderAdvice);
        }
        return adviceList;
    }

    private int getParValue(AlgoParam item) {
        return item.getMarket().equals("XSHG") ? 10 * PAR_VALUE : PAR_VALUE;
    }

    private double getMoney(AlgoParam item) {
        switch (item.getSide()) {
            case 70: 
            case 71: {
                return item.getCount() * this.getParValue(item);
            }
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getType())) {
            return (double)item.getCount() * item.getPrice() * 10.0;
        }
        return (double)item.getCount() * item.getPrice();
    }

    public void setParam(AlgoParam param) {
        this.param.getMI().setRefItem(this.baseModel.getMI().getRefItem());
        this.param.update((Object)param);
    }

    public AlgoParam getParam() {
        return this.param;
    }

    public IntegerProperty minuteProperty() {
        return this.param.minuteProperty();
    }

    public final LongProperty countAlgoProperty() {
        return this.countAlgo;
    }

    public final long getCountAlgo() {
        return this.countAlgoProperty().get();
    }

    public final void setCountAlgo(long countAlgo) {
        this.countAlgoProperty().set(countAlgo);
    }
}

