/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.lighting;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.ICancelOrderApi;
import cms.tmx.api.trade.INewOrderSingleApi;
import cms.tmx.api.trade.IQueryOrderApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMessage;
import cms.tmx.datatype.proto.workflow.PInstructionManagement;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.OrderFactory;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.ObLightingInstruction;
import cms.tmx.http.instruction.api.LightingInstructionApi;
import cms.tmx.http.instruction.dto.LightingInstruction;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.mng.LightingInstructionMng;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LightingInstructionModel
extends MxModel {
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MScheduler sdChanged;
    @Inject
    private IRefDataMng refMng;
    private AtomicInteger count = new AtomicInteger(0);
    @Inject
    private IBaseApi baseApi;
    @Inject
    private INewOrderSingleApi orderApi;
    @Inject
    private IQueryOrderApi apiOrderQuery;
    @Inject
    private LightingInstructionMng insMng;
    @Inject
    private LightingInstructionApi insApi;
    @Inject
    private ICancelOrderApi cancelApi;
    @Inject
    private IBaseApi apiBase;
    @Inject
    private MObjFactory of;
    private Set<String> executedIds = new HashSet<String>();
    private Set<String> canceledIds = new HashSet<String>();
    private MxList<ObLightingInstruction> list = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private static final int CHANGE_INTERVAL = 20;
    @Inject
    protected MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    protected OrderFactory ftOrder;
    @Inject
    @Named(value="fixed.fileorder.pool")
    protected ExecutorService fixedPool;
    private MEventHandler handler = event -> this.onPush(event);
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.sdChanged.setInterval(20);
        this.es.subscribe("uap.push.InstructionEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> this.query(), 240L, TimeUnit.SECONDS);
        });
    }

    private void onPush(MEvent event) {
        JsonPrimitive pushMsg = (JsonPrimitive)event.getObj(JsonPrimitive.class);
        this.logger.info("lighting instruction push :" + pushMsg.toString());
        String pushMsgJson = pushMsg.toString().replace("\\", "");
        pushMsgJson = pushMsgJson.substring(1, pushMsgJson.length() - 1);
        LightingInstruction lightIns = (LightingInstruction)this.gson.fromJson(pushMsgJson, LightingInstruction.class);
        ObLightingInstruction obTopIns = new ObLightingInstruction();
        this.logger.info("lighting instruction push id:" + lightIns.getId() + "|" + lightIns.getAction().getValue());
        obTopIns.setId(lightIns.getId());
        ObLightingInstruction ObLightingInstruction2 = (ObLightingInstruction)this.getList().get((MxObject)obTopIns);
        if (ObLightingInstruction2 == null) {
            obTopIns.update((Object)lightIns);
            this.insMng.transferField(obTopIns);
            this.getList().add((MxObject)obTopIns);
        } else {
            ObLightingInstruction2.update((Object)lightIns);
            this.insMng.transferField(ObLightingInstruction2);
        }
        this.change();
    }

    private void change() {
        this.sdChanged.schedule(event -> this.changed());
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("instruction query failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        this.getList().update(this.insMng.query());
        this.changed();
    }

    public MxList<ObLightingInstruction> getList() {
        return this.list;
    }

    public void batchLightingExe(List<ObLightingInstruction> exeList) {
        PInstructionManagement.ExecuteActionReq.newBuilder();
        ArrayList<ObLightingInstruction> ordList = new ArrayList<ObLightingInstruction>();
        for (ObLightingInstruction obLightingInstruction : exeList) {
            if (this.executedIds.contains(obLightingInstruction.getId())) continue;
            ordList.add(obLightingInstruction);
            this.executedIds.add(obLightingInstruction.getId());
        }
        this.newOrder(ordList);
    }

    void newOrder(List<ObLightingInstruction> ordList) {
        if (ordList.size() == 0) {
            return;
        }
        try {
            this.newOrderBatch(ordList);
        }
        catch (Exception e) {
            this.logger.error("\u6781\u901f\u6307\u4ee4\u5feb\u6377\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
    }

    private void cancelResourceAndOrder(ObLightingInstruction instruction) {
        this.fixedPool.execute(() -> {});
        this.fixedPool.execute(() -> {});
    }

    public void orderCancel(ObLightingInstruction instruction) throws MException {
        if (!StringUtils.isEmpty((String)instruction.getClInstructionId())) {
            PComponent.Instrument.Builder inst = PComponent.Instrument.newBuilder();
            String clInstructionId = instruction.getClInstructionId();
            PMessage.OrderCancelRequest.Builder builder = PMessage.OrderCancelRequest.newBuilder();
            builder.setOpUser(this.apiBase.getOpUser());
            builder.setOrigClOrdId(clInstructionId);
            builder.setClOrdId(clInstructionId);
            inst.setApplId("010");
            inst.setMarketGroup("CCS");
            inst.setMarket("XSHG");
            builder.setExtAccntId(((AccntSecInfo)instruction.getOrderAdvice().getAccSecInfoList().get(0)).getAccntId());
            builder.setInstrument(inst);
            try {
                this.cancelApi.submit(builder.build());
            }
            catch (MException mException) {
                this.logger.error("\u6839\u636e\u524d\u7aef\u6d41\u6c34\u53f7\u64a4\u6307\u4ee4\u5355\u5931\u8d25");
            }
        }
    }

    private void newOrderBatch(List<ObLightingInstruction> instructions) {
        for (ObLightingInstruction ins : instructions) {
            this.fixedPool.execute(() -> {
                LightingInstruction lighting = new LightingInstruction();
                lighting.setId(ins.getId());
                this.logger.info("\u6307\u4ee4\u6267\u884cid" + ins.getId());
                try {
                    this.insApi.executeLightingInstruction(lighting);
                }
                catch (MException | Exception e) {
                    this.logger.error("\u6307\u4ee4\u6267\u884c\u5931\u8d25", e);
                }
            });
        }
    }

    void batchOrderByPage(String accountId, List<ObLightingInstruction> instructions) throws MException {
        PMessage.NewOrderBatchRequest.Builder nob = PMessage.NewOrderBatchRequest.newBuilder();
        PComponent.Instrument.Builder pi = PComponent.Instrument.newBuilder();
        pi.setMarketGroup("CCS");
        nob.setInstrument(pi.build());
        nob.setExtAccntId(String.valueOf(this.count.incrementAndGet()));
        nob.setOpUser(this.baseApi.getOpUser());
        for (ObLightingInstruction instruction : instructions) {
            List accSecInfoList = instruction.getOrderAdvice().getAccSecInfoList();
            for (AccntSecInfo accntSecInfo : accSecInfoList) {
                String market = instruction.getOrderAdvice().getMarket();
                double price = instruction.getOrderAdvice().getPrice();
                int bstype = instruction.getOrderAdvice().getSide();
                String sec_code = instruction.getOrderAdvice().getSec();
                long count = accntSecInfo.getOrderQty();
                if (count <= 0L) continue;
                RefItem item = this.refMng.getItem(market, sec_code);
                PComponent.Instrument.Builder builderI = PComponent.Instrument.newBuilder();
                builderI.setSecurityId(sec_code);
                builderI.setMarket(market);
                if (item != null) {
                    builderI.setSecurityType(item.getType());
                }
                if ("XSHG".equals(market) && sec_code.startsWith("688")) {
                    builderI.setApplId("700");
                } else if (item != null && item.isGem()) {
                    builderI.setApplId("GEM");
                } else {
                    builderI.setApplId("010");
                }
                builderI.setMarketGroup("CCS");
                PComponent.Instrument instrument = builderI.build();
                PMessage.NewOrderSingle.Builder builderO = PMessage.NewOrderSingle.newBuilder();
                builderO.setInstrument(instrument);
                builderO.setOrdTypeValue(50);
                builderO.setSideValue(bstype);
                builderO.setOpUser(this.apiBase.getOpUser());
                builderO.setOrderQty((double)count);
                builderO.setPrice(price);
                builderO.setClOrdId(instruction.getClInstructionId());
                builderO.setExtAccntId(accntSecInfo.getAccntId());
                builderO.setExtSecAccntId(accntSecInfo.getSecAccntId());
                builderO.setInstructionId(instruction.getId());
                builderO.setReference(instruction.getId());
                builderO.setResourceId(instruction.getResourceId());
                PMessage.NewOrderSingle order = builderO.build();
                nob.addOrders(order);
            }
        }
        this.orderApi.batchSubmit(nob.build());
    }
}

