/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.fix;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.instructions.models.fix.FixPositionModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.query.current.models.InstructionAccountModelNew;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.Alert;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FixTradeAccountDistributionModel
extends CcsAccountDistributionModel {
    @Inject
    private MxAlert alert;
    @Inject
    private InstructionAccountModelNew instructionAccModel;
    private ObSimpleInstruction instruction;
    @Inject
    private FixPositionModel posModel;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getPassiveAccMap(this.instruction);
    }

    public synchronized TreeItem<CcsAccountDistribution> create() throws MException {
        this.posModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstPosition));
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.queryPostition();
        this.buy.addListener(ob -> this.calCanBuy());
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    protected void queryPostition() {
        this.exe.execute(() -> this.posModel.initQuery());
    }

    public void hide() {
        this.mapSecDisMxList.keySet().forEach(each -> this.hideAll((MxTreeList<CcsAccountDistribution>)((MxTreeList)this.mapSecDisMxList.get(each))));
        this.hideAll((MxTreeList<CcsAccountDistribution>)this.accMxList);
    }

    protected void hideAll(MxTreeList<CcsAccountDistribution> distList) {
        if (distList.getOrList() == null) {
            return;
        }
        distList.getOrList().forEach(each -> each.setShow(false));
        distList.filter(this.pdShow);
    }

    protected void calCanBuyByPosition(TreeItem<CcsAccountDistribution> item) {
        FilteredList subItemList = item.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
        if (subItemList.size() == 1) {
            long cansell = new Double(this.posModel.getCanSell(((CcsAccountDistribution)((TreeItem)subItemList.get(0)).getValue()).getSecAcc(), this.getSecurity())).longValue();
            this.setCanBuy(cansell);
        } else {
            this.setCanBuy(0L);
        }
    }

    public void calAccountCanSell() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (CcsAccountDistribution subItem : ((MxTreeList)this.mapSecDisMxList.get(strEach)).getOrList()) {
                long canSell = new Double(this.posModel.getCanSell(subItem.getSecAcc(), this.getSecurity())).longValue();
                subItem.setCanSell(canSell);
                canSellTotal += canSell;
            }
            for (CcsAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getExtAccntId().equals(strEach)) continue;
                accItem.setCanSell(canSellTotal);
            }
        }
    }

    protected long calByCanSell(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected())) {
                CcsAccountDistribution secAccItem = (CcsAccountDistribution)eachSub.getValue();
                long cansell = new Double(this.posModel.getCanSell(secAccItem.getSecAcc(), this.getSecurity())).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)cansell * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((CcsAccountDistribution)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    public void filterAcc() {
        if (this.isActive()) {
            super.filterAcc();
        } else {
            this.calCount();
        }
    }

    public void fillAccount(ObSimpleInstruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.instruction = instruction;
        List list = instruction.getOrderDetail().getAccntSecInfo();
        String secMarket = instruction.getSecMarket();
        if (instruction.getIsOrderStep()) {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getAvailableQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getAvailableQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        } else {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = (Long)this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getOrderQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        }
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createFixTree(secMarket);
            this.accMxList.getOrList().forEach(item -> {
                if (!item.getAcc().getNewCashAccntId().equals(((AccntSecInfo)list.get(0)).getAccountId().getCashAccntId())) {
                    item.setShow(false);
                } else {
                    item.setShow(true);
                    MxTreeList secs = (MxTreeList)this.mapSecDisMxList.get(item.getAcc().getExtAccntId());
                    if (secs != null) {
                        secs.getOrList().forEach(sec -> {
                            if (!sec.getSecAcc().getNewSecAccntId().equals(((AccntSecInfo)list.get(0)).getAccountId().getSecAccntId())) {
                                sec.setShow(false);
                            } else {
                                sec.setShow(true);
                            }
                        });
                    }
                }
            });
            this.accMxList.filter(this.pdShow);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6784\u5efaFIX\u534f\u8bae\u4ea4\u6613\u8d26\u53f7\u6811\u5931\u8d25" + e.getMessage());
        }
    }

    public void createFixTree(String market) throws MException {
        ((CcsAccountDistribution)this.root.getValue()).setSelected(this.isSelected());
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new ConcurrentHashMap(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, this.root.getChildren(), accList);
        if (this.accMng.getAccountMap() == null) {
            return;
        }
        this.mapAccount = new HashMap(this.accMng.getAccountMap());
        HashSet accSet = new HashSet(this.mapAccount.keySet());
        for (FundAccount acc : accSet) {
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(acc);
            CcsAccountDistribution accDst = new CcsAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.setWeight(this.mapWeight.get(fundAcc.getExtAccntId()) == null ? 0 : (Integer)this.mapWeight.get(fundAcc.getNewCashAccntId()));
            accDst.setCount(this.mapQuantiy.get(fundAcc.getExtAccntId()) == null ? 0L : (Long)this.mapQuantiy.get(fundAcc.getNewCashAccntId()));
            accDst.setAccntName(fundAcc.getAccountName());
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : (List)this.mapAccount.get(acc)) {
                boolean isHkAccnt;
                if (!market.equals(secAcc.getExchange().getRaw())) continue;
                CcsAccountDistribution secDst = new CcsAccountDistribution();
                boolean bl = isHkAccnt = "SHSC".equals(secAcc.getExchange().getRaw()) || "SZSC".equals(secAcc.getExchange().getRaw());
                if (this.isHkwolun() && isHkAccnt) {
                    secAccList.add(secDst);
                } else if (!this.isHkwolun() && !isHkAccnt) {
                    secAccList.add(secDst);
                }
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setAccParentId(fundAcc.getParentId());
                secDst.setWeight(this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 1 : (Integer)this.mapWeight.get(String.valueOf(secAcc.getExtSecAccntId()) + secAcc.getExchange().getRaw()));
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setSelected(this.isSelected());
                secDst.selectedProperty().addListener(ob -> this.calCount());
                secDst.setCount(this.mapQuantiy.get(String.valueOf(secAcc.getNewSecAccntId()) + secAcc.getExchange().getRaw()) == null ? 0L : (Long)this.mapQuantiy.get(String.valueOf(secAcc.getNewSecAccntId()) + secAcc.getExchange().getRaw()));
            }
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem)this.root.getChildren().get(accList.size() - 1), ((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), secMxList);
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.checkSingle();
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }
}

