/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.fix;

import cms.tmx.core.MScheduler;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.NewPositionModel;
import cms.tmx.query.utils.QueryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FixPositionModel
extends NewPositionModel<ObPosition> {
    @Inject
    protected FundAccountMngServiceImpl accntMngService;
    @Inject
    protected MScheduler sdFullQuery;
    protected Map<String, Position> map = new HashMap<String, Position>();
    protected BooleanProperty mapChange = new SimpleBooleanProperty(true);
    private Map<String, ObPosition> ccsPstMap;
    protected static final List<String> parts = Arrays.asList("cms.tmx.instructions.part.fix.position.query");
    private InvalidationListener lst = ob -> {
        List list = this.getList();
        synchronized (list) {
            this.ccsPstMap = this.getList().stream().collect(Collectors.toMap(ObPosition::unique, p -> p, (old, now) -> old));
        }
        this.mapChange();
    };

    @PostConstruct
    public void init() {
        this.setMarketGrp("CCS");
        this.setMarketIndicator("");
        this.setMarkets(new String[]{"XSHG", "XSHE"});
        super.init();
        this.changed.addListener(this.lst);
    }

    protected List<String> getParts() {
        return parts;
    }

    public Set<String> getNewSecAccntIds() {
        return this.accntMap.getNewSecAccntIds(new String[]{"XSHG", "XSHE"});
    }

    public Set<SecAccount> getSecAccounts() {
        HashSet<SecAccount> hashSet = new HashSet<SecAccount>();
        hashSet.addAll(this.accntMap.getCcsSecAccountMap().values());
        return hashSet;
    }

    protected void update(List<PositionNew> listSrc) {
        List<ObPosition> listPosition = this.updatePosition(listSrc, true);
        this.list.update(listPosition);
        this.changed();
    }

    public List<ObPosition> updatePosition(List<PositionNew> listSrc, boolean isAll) {
        ArrayList<ObPosition> listOb = new ArrayList<ObPosition>();
        for (PositionNew posNew : listSrc) {
            if (!this.getMarkets().contains(posNew.getInstrument().getMarket())) continue;
            this.afterUpdate(posNew);
            ObPosition obPos = new ObPosition();
            obPos.update((Object)posNew);
            obPos.setUnit(QueryUtils.getUnit((String)obPos.getSecType(), (String)obPos.getMarket().getRaw()));
            listOb.add(obPos);
        }
        this.exe.execute(() -> {
            if (isAll) {
                this.queryAndGetNewPrice(listOb);
                this.list.update(listOb);
            }
            this.changed();
        });
        return listOb;
    }

    protected void updatePosition(Position position) {
        this.afterUpdate(position);
        position.setUnit(QueryUtils.getUnit((String)position.getInstrument().getSecurityType(), (String)position.getInstrument().getMarket()));
        String key = String.valueOf(position.getPosAccnt().getSecAccntId()) + position.getInstrument().getSecurityId() + position.getPosStatistic().getStatus();
        Position old = this.map.get(key);
        if (old == null) {
            this.map.put(key, position);
            ObPosition ob = new ObPosition();
            ob.update((Object)position);
            this.list.add((MxObject)ob);
        } else {
            old.update((Object)position);
        }
        this.changed();
    }

    private void afterUpdate(PositionNew position) {
        if (position.getAccntId() != null) {
            position.setInvestorId(this.accntMngService.getCcsInvesId(position.getAccntId()));
        }
        if (position.getSecAccntId() != null) {
            position.setInvestorSecId(this.accntMap.getAllCcsInverstorSecId(position.getSecAccntId()));
        }
    }

    private void afterUpdate(Position position) {
        if (position.getPosAccnt().getAccntId() != null) {
            position.setInvestorId(this.accntMngService.getCcsInvesId(position.getPosAccnt().getAccntId()));
        }
        if (position.getPosAccnt().getSecAccntId() != null) {
            position.setInverstorSecId(this.accntMap.getAllCcsInverstorSecId(position.getPosAccnt().getSecAccntId()));
        }
    }

    protected void mapChange() {
        this.mapChangeProperty().set(!this.mapChangeProperty().get());
    }

    public BooleanProperty mapChangeProperty() {
        return this.mapChange;
    }

    public boolean isMapChange() {
        return this.mapChangeProperty().get();
    }

    public void setMapChange(boolean mapChange) {
        this.mapChangeProperty().set(mapChange);
    }

    public double getCanSell(SecAccount secAcc, String security) {
        ObPosition pos = this.getPosition(secAcc, security);
        if (pos != null) {
            return pos.getSecAvail();
        }
        return 0.0;
    }

    public ObPosition getPosition(SecAccount account, String code) {
        return this.getPosition(account.getNewSecAccntId(), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObPosition getPosition(String account, String code) {
        ObPosition item = null;
        if (this.ccsPstMap == null || this.ccsPstMap.isEmpty()) {
            MxList mxList = this.list;
            synchronized (mxList) {
                for (ObPosition pos : this.getList()) {
                    if (!account.equals(pos.getSecAccntId()) || !code.equals(pos.getSecurityId())) continue;
                    item = pos;
                    break;
                }
            }
        } else {
            item = this.ccsPstMap.get(String.valueOf(account) + code + "0");
        }
        return item;
    }
}

