/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.fix;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.GetOrdersReq;
import cms.tmx.http.api.strategy.dto.GetOrdersResp;
import cms.tmx.http.api.strategy.dto.OrdEvent;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.http.api.strategy.dto.SingleOrder;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.DateTimeUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FixOrderModel
extends MxModel {
    @Inject
    protected MScheduler sdPushChange;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    protected MEventService es;
    @Inject
    protected IUserService userService;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected MxList<Order> list = new MxList();
    protected static final int FULL_PUSH_CHANGE_INTERVAL = 1000;
    protected MEventHandler handler = event -> this.onPush(event);
    protected Gson gson = new Gson();
    protected boolean isUnfinishedOrder = false;
    protected Map<String, Order> map = new HashMap<String, Order>();
    protected ConcurrentHashMap<String, Integer> statusMap = new ConcurrentHashMap();
    @Inject
    private OrderServiceNewApi newApi;

    public void changed() {
        this.sdPushChange.schedule(e -> super.changed());
    }

    protected Integer getStatusNo(SingleOrder order) {
        if (order.getCanCancelFlag() != 1) {
            return 99999999;
        }
        if (order.getOrdStatus() == null) {
            return -1;
        }
        if (order.getOrdStatus().getValue().equals("87")) {
            return 0;
        }
        if (order.getOrdStatus().getValue().equals("65")) {
            return 1;
        }
        if (order.getOrdStatus().getValue().equals("48")) {
            return 2;
        }
        if (order.getOrdStatus().getValue().equals("49")) {
            return (int)(1000.0 + order.getCumQty());
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        OrdEvent ordEvent = (OrdEvent)this.gson.fromJson((JsonElement)obj, OrdEvent.class);
        for (SingleOrder order : ordEvent.getOrder()) {
            if (!"XSHE".equals(order.getInstrument().getMarket()) && !"XSHG".equals(order.getInstrument().getMarket())) {
                return;
            }
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit((String)order.getInstrument().getSecurityType(), (String)order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            ConcurrentHashMap<String, Integer> concurrentHashMap = this.statusMap;
            synchronized (concurrentHashMap) {
                String sysOrderId = order.getOrderId();
                Integer statusOld = this.statusMap.get(sysOrderId);
                Integer statusNow = this.getStatusNo(order);
                if (statusOld == null) {
                    this.statusMap.put(sysOrderId, statusNow);
                } else {
                    if (statusNow < statusOld) {
                        this.logger.error(String.valueOf(this.isUnfinishedOrder ? "\u672a\u5b8c\u6210\u63a8\u9001" : "\u59d4\u6258\u63a8\u9001") + ", \u4e22\u5f03\u672c\u6b21\u63a8\u9001:" + " hashCode:" + System.identityHashCode((Object)this) + "_" + order.getOrderId());
                        return;
                    }
                    this.statusMap.put(sysOrderId, statusNow);
                }
                if (this.isUnfinishedOrder) {
                    if (order.getCanCancelFlag() == 1) {
                        this.list.updatePart((MxObject)order.convert());
                    } else if (this.list.getListMap().get(order.convert()) != null) {
                        this.list.remove((MxObject)order.convert());
                    }
                } else {
                    this.list.updatePart((MxObject)order.convert());
                }
            }
        }
        this.changed();
    }

    @PostConstruct
    protected void init() {
        this.sdPushChange.setInterval(1000);
        this.es.subscribe("uap.push.OrdEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
        if (this.list.getList().size() == 0) {
            try {
                this.query();
            }
            catch (MException | Exception e) {
                this.logger.error(e.getMessage(), e);
            }
        }
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.OrdEvent", this.handler);
    }

    public void query() throws IOException, MException {
        GetOrdersReq req = new GetOrdersReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("CCS");
        req.setCanCancelFlag(this.isUnfinishedOrder ? 1 : 0);
        req.setBeginDate(DateTimeUtils.getDate());
        req.setEndDate(DateTimeUtils.getDate());
        req.setExtCashAccntId(this.fundApi.getFundAccountList().stream().map(item -> item.getNewCashAccntId()).collect(Collectors.toList()));
        Fragment fragment = new Fragment();
        fragment.setOffset(1);
        fragment.setSize(200);
        req.setFragment(fragment);
        GetOrdersResp resp = this.newApi.getOrders(req);
        this.list.clear();
        this.list.addAll(resp.getData().stream().filter(item -> "XSHE".equals(item.getInstrument().getMarket()) || "XSHG".equals(item.getInstrument().getMarket())).collect(Collectors.toList()));
        int queryTimes = (int)Math.ceil((double)resp.getTotal() * 1.0 / (double)fragment.getSize());
        while (--queryTimes > 0) {
            fragment.setOffset(fragment.getSize() + fragment.getOffset());
            req.setFragment(fragment);
            GetOrdersResp res = this.newApi.getOrders(req);
            this.list.addAll(res.getData().stream().filter(item -> "XSHE".equals(item.getInstrument().getMarket()) || "XSHG".equals(item.getInstrument().getMarket())).collect(Collectors.toList()));
        }
        for (Order order : this.list.getList()) {
            order.setExtraFields();
            order.setUnit(QueryUtils.getUnit((String)order.getInstrument().getSecurityType(), (String)order.getInstrument().getMarket()));
            order.setUserName((String)this.userService.getUserName(order.getUserId()).get());
            this.map.put(order.getOrderId(), order);
        }
        this.changed();
    }

    public List<Order> getList() {
        return this.list.getList();
    }
}

