/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.fix;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.OrderServiceNewApi;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.data.GetExecutionsReq;
import cms.tmx.http.data.GetExecutionsResp;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FixDealModel
extends MxModel {
    @Inject
    protected OrderServiceNewApi api;
    @Inject
    protected HttpBaseApi baseApi;
    @Inject
    private MEventService es;
    @Inject
    protected IFundAccountService fundApi;
    @Inject
    protected CcsAccountMap accntMap;
    @Inject
    protected ScheduledExecutorService ses;
    protected Gson gson = new Gson();
    protected List<Execution> list = new ArrayList<Execution>();
    protected Map<String, Execution> map = new HashMap<String, Execution>();
    private MEventHandler handler = event -> this.onPush(event);

    @PostConstruct
    private void init() {
        this.es.subscribe("uap.push.ExecEvent", this.handler);
        this.es.subscribe("requery_data", event -> {
            ScheduledFuture<?> scheduledFuture = this.ses.schedule(() -> {
                try {
                    this.query();
                }
                catch (MException | IOException e) {
                    this.logger.error((Object)e, e);
                }
            }, 30L, TimeUnit.SECONDS);
        });
    }

    @PreDestroy
    private void destory() {
        this.es.unSubscribe("uap.push.ExecEvent", this.handler);
    }

    public void query() throws IOException, MException {
        GetExecutionsReq req = new GetExecutionsReq();
        req.setOpUser(this.baseApi.getHttpOpUser());
        req.setMarketGroup("CCS");
        req.setExtCashAccntId(this.fundApi.getFundAccountList().stream().map(item -> item.getNewCashAccntId()).collect(Collectors.toList()));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = LocalDate.now().format(formatter);
        req.setBeginDate(date);
        req.setEndDate(date);
        Fragment fragment = new Fragment();
        fragment.setSize(150);
        fragment.setOffset(1);
        GetExecutionsResp resp = null;
        this.list.clear();
        do {
            req.setFragment(fragment);
            resp = this.api.getNewDeals(req);
            this.list.addAll(resp.getData().stream().filter(item -> "XSHE".equals(item.getInstrument().getMarket()) || "XSHG".equals(item.getInstrument().getMarket())).collect(Collectors.toList()));
            fragment.setOffset(resp.getData().size() + fragment.getOffset());
        } while (resp.getTotal() > fragment.getOffset());
        for (Execution exec : this.list) {
            exec.setExtraFields();
            this.afterUpdate(exec);
            this.map.put(exec.getExecId(), exec);
        }
        this.changed();
    }

    protected void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)this.gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution exec : execEvent.getExecution()) {
            if (!exec.getInstrument().getMarketGroup().equals("CCS")) {
                return;
            }
            exec.setExtraFields();
            this.afterUpdate(exec);
            this.map.put(exec.getExecId(), exec);
            this.list.add(exec);
        }
        this.changed();
    }

    private void afterUpdate(Execution exec) {
        exec.setUnit(QueryUtils.getUnit((String)exec.getInstrument().getSecurityType(), (String)exec.getInstrument().getMarket()));
        FundAccount fund = this.fundApi.getFundAccountNew(exec.getExtCashAccntId(), exec.getInstrument().getMarketGroup());
        if (fund != null) {
            exec.setAccountName(fund.getAccountName());
        }
    }

    public List<Execution> getList() {
        return this.list;
    }
}

