/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.basket;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.data.utils.Gears;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.User;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.factory.BasketTradeItemFactory;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.entity.trade.instruction.BasketOrderAdvice;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.instructions.models.basket.BasketAlgoModel;
import cms.tmx.instructions.models.basket.InstructionBasketAccSetModel;
import cms.tmx.instructions.models.basket.InstructionBasketDistributionModel;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IPostService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.trade.entrust.BatchEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.trade.models.basket.BasketGearPriceModel;
import cms.tmx.trade.models.basket.BasketInfo;
import cms.tmx.trade.utils.TradeUtils;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionBasketTradeModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(InstructionBasketTradeModel.class);
    @Inject
    public BasketAlgoModel algoModel;
    @Inject
    private IBaseApi baseApi;
    private ObservableList<CcsFundAccount> listAccount = FxUtils.newList();
    protected ObservableList<BasketTradeItem> listItem = FxUtils.newList();
    private Map<CcsFundAccount, ObservableList<BasketTradeItem>> mapItem = new HashMap<CcsFundAccount, ObservableList<BasketTradeItem>>(500);
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private BooleanProperty sell = new SimpleBooleanProperty(false);
    private BooleanProperty buySell = new SimpleBooleanProperty(false);
    private StringProperty errInfo = new SimpleStringProperty("");
    private BooleanProperty canModify = new SimpleBooleanProperty(true);
    protected ObjectProperty<MxNode> gear = new SimpleObjectProperty();
    protected ObjectProperty<MxNode> priceLimitType = new SimpleObjectProperty();
    private DoubleProperty floating = new SimpleDoubleProperty();
    protected ObjectProperty<MxNode> stg = new SimpleObjectProperty();
    private DoubleProperty countBsk = new SimpleDoubleProperty(1.0);
    private DoubleProperty countBskForAdgust = new SimpleDoubleProperty(0.0);
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty assetPct = new SimpleDoubleProperty();
    private DoubleProperty canBuyPct = new SimpleDoubleProperty();
    private DoubleProperty canSellPct = new SimpleDoubleProperty();
    private DoubleProperty amount = new SimpleDoubleProperty();
    private LongProperty totalQuantity = new SimpleLongProperty();
    private BooleanProperty pctUnit = new SimpleBooleanProperty(true);
    private IntegerProperty num = new SimpleIntegerProperty();
    private BooleanProperty filterUp = new SimpleBooleanProperty(false);
    private BooleanProperty filterDown = new SimpleBooleanProperty(false);
    private BooleanProperty filterAll = new SimpleBooleanProperty(false);
    private BooleanProperty smartSell = new SimpleBooleanProperty(false);
    private BooleanProperty useInventory = new SimpleBooleanProperty(false);
    private static final int REFRESH_MARKET_INTERVAL = 800;
    private static final int CALCULATE_INTERVAL = 400;
    private static final int REFRESH_INTERVAL = 1000;
    public static final int FIRST_SETP_ID = 1;
    private DoubleProperty exeRatio = new SimpleDoubleProperty();
    private BooleanProperty normal = new SimpleBooleanProperty(true);
    private Map<String, String> extAccProductMap = new HashMap<String, String>();
    private Map<CcsFundAccount, List<SecAccount>> selectedMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    @Inject
    private CcsPositionModel ccsPosModel;
    @Inject
    private MessagePromptMng mpMng;
    @Inject
    private InstructionBasketDistributionModel instAccDistModel;
    @Inject
    private BasketInfo bi;
    @Inject
    private InstructionBasketAccSetModel basketAccModel;
    @Inject
    private MObjFactory of;
    @Inject
    private BasketGearPriceModel priceModel;
    @Inject
    private BatchEntrust batchEntrust;
    @Inject
    private MScheduler sdUpdateMkt;
    @Inject
    private MScheduler posChange;
    @Inject
    protected MScheduler calChange;
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    protected IFundAccountService fundAccService;
    @Inject
    private ISecAccountService secAccService;
    @Inject
    protected IPostService postMng;
    @Inject
    public InstructionAccountModel instrAccModel;
    @Inject
    protected InstructionModel insModel;
    @Inject
    private IRefDataMng refMng;
    private String instructionPanelType = "";
    private Instruction instruction;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected BasketTradeItemFactory bskTradeItemFactory;
    @Inject
    protected InstructionExecMng resourceDetailMng;
    private String lastGear = new String("");
    private double lastFloating = 0.0;
    protected Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    protected Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();
    @Inject
    private IMarketDataMng marketMng;
    private InvalidationListener lstnBi = ob -> {
        if (!"3".equals(this.instructionPanelType) && !"4".equals(this.instructionPanelType)) {
            this.filterStg();
            this.reloadSecs();
        } else {
            this.calSecs();
        }
    };
    private ListChangeListener<? super BasketTradeItem> lstnItems = change -> {
        while (change.next()) {
            if (!change.wasAdded() && !change.wasRemoved()) continue;
            this.calSecs();
        }
    };
    private InvalidationListener lstMkt = ob -> {
        System.err.println("\u884c\u60c5\u53d8\u52a8111111111111111");
        this.getSdUpdateMkt().schedule(event -> {
            System.err.println("\u884c\u60c5\u53d8\u52a8");
            if (this.getItems().isEmpty()) {
                return;
            }
            Platform.runLater(() -> {
                long begin = System.currentTimeMillis();
                this.onFilterMktChange();
                if (!"4".equals(this.getInstructionPanelType()) || !"2".equals(this.getPriceLimitType().getRaw())) {
                    for (BasketTradeItem item : this.getItems()) {
                        if (!item.isSelected()) continue;
                        this.calPrice(item);
                    }
                }
                if (!this.getStg().is("1")) {
                    this.calCount();
                }
                this.calTotal();
                this.getBi().calInfo();
                System.err.println("\u884c\u60c5\u53d8\u52a8\u89e6\u53d1\u5237\u65b0\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin));
            });
        });
    };
    private boolean flag = true;
    public ChangeListener<Boolean> lstn = (obv, old, now) -> {
        if (this.flag) {
            this.flag = false;
            if (!now.booleanValue() && this.isFilterAll()) {
                this.setFilterAll(false);
            }
            int select = this.getSelectedList().size();
            int up = this.getUpList().size();
            int down = this.getDownList().size();
            int stop = this.getStopList().size();
            if (now.booleanValue()) {
                if (this.isFilterUp() && this.listItem.size() == select + up + stop) {
                    this.setFilterAll(true);
                } else if (this.isFilterDown() && this.listItem.size() == select + down + stop) {
                    this.setFilterAll(true);
                } else if (this.isFilterUp() && this.isFilterDown() && this.listItem.size() == select + up + down + stop) {
                    this.setFilterAll(true);
                } else if (this.listItem.size() == select + stop) {
                    this.setFilterAll(true);
                }
            }
            this.flag = true;
        }
    };
    private InvalidationListener lstPosition = ob -> {
        for (BasketTradeItem item : this.getItems()) {
            this.subscribePosition(item);
        }
        this.getPosChange().schedule(event -> this.calSecs());
    };

    @PostConstruct
    public void init() {
        MxNode node = MxNodeFactory.createNew((String)"basket_strategy_type", (String)"1");
        this.stgProperty().set((Object)node);
        node = ((MxNode)this.of.create(MxNode.class)).load("bsk_handicap", "-1");
        this.initPriceGear(node);
        this.gearProperty().set((Object)node);
        node = MxNodeFactory.createNew((String)"basket_price_type", (String)"2");
        this.priceLimitTypeProperty().set((Object)node);
        this.buyProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.sellProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.buySellProperty().addListener((ob, old, newV) -> this.onBsChange((boolean)newV));
        this.filterUpProperty().addListener(ob -> this.onFilterChange("basket_filter_up"));
        this.filterDownProperty().addListener(ob -> this.onFilterChange("basket_filter_down"));
        this.filterAllProperty().addListener(ob -> this.onFilterAllChange());
        this.gearProperty().addListener(data -> this.onPriceChange());
        this.floatingProperty().addListener(data -> this.onPriceChange());
        this.pctUnitProperty().addListener(ob -> this.onPriceChange());
        this.countBskProperty().addListener(data -> this.calSecs());
        this.countBskForAdgustProperty().addListener(data -> this.reloadSecs());
        this.moneyProperty().addListener(data -> this.calSecs());
        this.assetPctProperty().addListener(data -> this.calSecs());
        this.canBuyPctProperty().addListener(data -> this.calSecs());
        this.canSellPctProperty().addListener(data -> this.calSecs());
        this.stgProperty().addListener(data -> this.calSecs());
        this.priceLimitTypeProperty().addListener(data -> this.calSecs());
        this.smartSellProperty().addListener((ob, old, newV) -> this.onSmartSellChange((boolean)newV));
        this.useInventoryProperty().addListener((ob, old, newV) -> this.onUseInventoryChange((boolean)newV));
        this.getBi().changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnBi));
        this.getBi().mktChangedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.getLstMkt()));
        this.getPosChange().setInterval(1000);
        this.calChange.setInterval(400);
        this.getSdUpdateMkt().setInterval(800);
        this.getItems().addListener((ListChangeListener)new WeakListChangeListener(this.lstnItems));
        this.getPostModel().mapChangeProProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.getLstPosition()));
        this.exeRatioProperty().addListener((ob, old, newV) -> this.calSecs());
        this.getPostModel().initQuery();
    }

    private void onPriceChange() {
        this.clearManualModifyFlag();
        this.getSdUpdateMkt().schedule(event -> {
            System.err.println("price change");
            Platform.runLater(() -> {
                long begin = System.currentTimeMillis();
                if (!"4".equals(this.getInstructionPanelType()) || !"2".equals(this.getPriceLimitType().getRaw())) {
                    for (BasketTradeItem item : this.getItems()) {
                        if (!item.isSelected()) continue;
                        this.calPrice(item);
                    }
                }
                if (!this.getStg().is("1")) {
                    this.calCount();
                }
                this.calTotal();
                logger.info("\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u5237\u65b0\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin));
            });
        });
    }

    public void onSecAccChange() {
    }

    public void onFilterChange(String filterFlag) {
        for (BasketTradeItem item : this.getItems()) {
            this.checkItemDisable(item, filterFlag);
        }
    }

    public void onFilterMktChange() {
        for (BasketTradeItem item : this.getItems()) {
            this.checkMktItemDisable(item);
        }
    }

    public void onFilterAllChange() {
        if (this.flag) {
            this.flag = false;
            for (BasketTradeItem item : this.getItems()) {
                if (!item.isVisible()) continue;
                this.checkAllItemDisable(item);
            }
            this.flag = true;
        }
    }

    protected void checkMktItemDisable(BasketTradeItem item) {
        BasketItem info = item.getItem();
        if (info == null || info.getMktItem() == null) {
            return;
        }
        if (info.getMktItem().getStop().getValue().booleanValue()) {
            item.setSelected(false);
            item.setDisabled(true);
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitUp().getValue().booleanValue() || info.getMktItem().getLimitDown().getValue().booleanValue()) {
            return;
        }
        item.setSelected(item.isManuallySelected());
        item.setDisable(false);
    }

    protected void checkAllItemDisable(BasketTradeItem item) {
        boolean all = this.isFilterAll();
        BasketItem info = item.getItem();
        if (info == null || info.getMktItem() == null) {
            return;
        }
        if (info.getMktItem().getStop().getValue().booleanValue()) {
            item.setSelected(false);
            item.setDisabled(true);
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitUp().getValue().booleanValue()) {
            if (this.isFilterUp()) {
                return;
            }
            item.setDisabled(false);
            item.setSelected(all);
            return;
        }
        if (info.getMktItem().getLimitDown().getValue().booleanValue()) {
            if (this.isFilterDown()) {
                return;
            }
            item.setDisabled(false);
            item.setSelected(all);
            return;
        }
        item.setSelected(all);
        item.setManuallySelected(all);
    }

    public ObservableList<BasketTradeItem> getStopList() {
        return this.getItems().filtered(pd -> pd.getItem().getMktItem().getStop().getValue());
    }

    public ObservableList<BasketTradeItem> getUpList() {
        return this.getItems().filtered(pd -> pd.getItem().getMktItem().getLimitUp().getValue());
    }

    public ObservableList<BasketTradeItem> getDownList() {
        return this.getItems().filtered(pd -> pd.getItem().getMktItem().getLimitDown().getValue());
    }

    protected void reloadSecs() {
        this.getMapItem().clear();
        this.getItems().clear();
        for (CcsFundAccount acc : this.getAccList()) {
            this.addAccSecs(acc);
        }
    }

    public void addAccSecs(CcsFundAccount acc) {
        this.setErrInfo("");
        LinkedList<BasketTradeItem> listTmp = new LinkedList<BasketTradeItem>();
        if (this.getBi().getItemShowList() == null) {
            return;
        }
        if (this.getMapItem().get(acc) != null && !this.getMapItem().get(acc).isEmpty()) {
            return;
        }
        for (BasketItem info : this.getBi().getItemShowList()) {
            if (info.getRefItem() == null) {
                this.setErrInfo(String.valueOf(this.getErrInfo()) + info.getSecurityId() + "\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5 ");
                continue;
            }
            BasketTradeItem item = this.bskTradeItemFactory.create();
            item.setBasketName(this.getBi().getBasket().getName());
            item.setAcc(acc);
            try {
                ObservableList secList = null;
                List<SecAccount> selectList = this.getBasketAccSetModel().getSelectedMap().get(acc);
                if (this.getBasketAccSetModel().getSelectedMap() != null && selectList != null) {
                    secList = FXCollections.observableList(selectList);
                }
                if (secList == null) {
                    secList = FXCollections.observableList(this.instAccDistModel.getAccountMap().get(acc));
                }
                if (!secList.isEmpty()) {
                    FilteredList validSecs = secList.filtered(fd -> fd.getExchange().getRaw().equals(info.getMarket().getRaw()));
                    if (validSecs.isEmpty()) continue;
                    item.setSecAcc((SecAccount)validSecs.get(0));
                }
            }
            catch (MException e) {
                logger.error(e.getMessage());
            }
            item.setItem(info);
            item.setRlWeight(info.getWeight());
            item.getBsTrade().setRaw(this.isBuyItem(item) ? "49" : "50");
            listTmp.add(item);
            this.checkItemDisable(item, "");
            this.subscribePosition(item);
            item.selectedProperty().addListener(ob -> this.calSecs());
        }
        this.getItems().addAll(listTmp);
        this.getMapItem().put(acc, (ObservableList<BasketTradeItem>)FXCollections.observableList(listTmp));
        this.calSecs();
    }

    public void removeAccSecs(CcsFundAccount acc) {
        List accItemList = (List)this.getMapItem().get(acc);
        if (accItemList != null) {
            this.getItems().removeAll((Collection)accItemList);
            this.getMapItem().remove(acc);
        }
    }

    private void queryPostition() {
        this.exe.execute(() -> this.getPostModel().query());
    }

    private void onUseInventoryChange(boolean newV) {
        if (this.getStg().is("6")) {
            return;
        }
        if (newV) {
            for (BasketTradeItem item : this.getItems().filtered(pd -> pd.getBsTrade().getRaw().equals("49"))) {
                this.setEntrustCount(item, item.getBuyCount());
            }
            this.calCount();
            this.calTotal();
        } else {
            this.calSecs();
        }
    }

    private void onSmartSellChange(boolean newV) {
        if (newV) {
            for (BasketTradeItem item : this.getItems().filtered(pd -> pd.getBsTrade().getRaw().equals("50"))) {
                this.setEntrustCount(item, item.getSellCount());
            }
            this.calCount();
            this.calTotal();
        } else {
            this.calSecs();
        }
    }

    public void refresh() {
        this.fundAccService.queryFundAccountList();
        this.queryPostition();
        this.bi.refresh();
    }

    public void calSecs() {
        this.calChange.schedule(event -> Platform.runLater(() -> {
            long b = System.currentTimeMillis();
            if (!"4".equals(this.getInstructionPanelType()) || !"2".equals(this.getPriceLimitType().getRaw())) {
                for (BasketTradeItem item : this.getItems()) {
                    item.clear(!"4".equals(this.getInstructionPanelType()) && !"3".equals(this.getInstructionPanelType()));
                    if (!item.isSelected() || !item.isVisible()) continue;
                    this.calPrice(item);
                }
            }
            this.calAbWeight();
            this.calCount();
            this.calTotal();
            this.changed();
            logger.info("\u7bee\u5b50\u6743\u91cd\u53ca\u6570\u91cf\u8ba1\u7b97\u8017\u65f6\uff1a" + (System.currentTimeMillis() - b));
        }));
    }

    private void calAbWeight() {
        this.getMapItem().values().forEach(each -> {
            double weight;
            double undefineWeight = 0.0;
            double buyWeight = 0.0;
            double sellWeight = 0.0;
            for (BasketTradeItem item : each.filtered(pd -> pd.isSelected() && pd.isVisible())) {
                weight = item.getItem().getWeight();
                switch (item.getBsTrade().getRaw()) {
                    case "49": {
                        buyWeight += weight;
                        break;
                    }
                    case "50": {
                        sellWeight += weight;
                        break;
                    }
                    default: {
                        undefineWeight += weight;
                    }
                }
            }
            for (BasketTradeItem item : each) {
                weight = item.getItem().getWeight();
                switch (item.getBsTrade().getRaw()) {
                    case "49": {
                        if (buyWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / buyWeight * 100.0), (int)4) : 0.0);
                        break;
                    }
                    case "50": {
                        if (sellWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / sellWeight * 100.0), (int)4) : 0.0);
                        break;
                    }
                    default: {
                        if (undefineWeight == 0.0) {
                            item.setAbWeight(0.0);
                            break;
                        }
                        item.setAbWeight(item.isSelected() ? DecimalUtils.getValueByScale((double)(weight / undefineWeight * 100.0), (int)4) : 0.0);
                    }
                }
            }
        });
    }

    private void clearManualModifyFlag() {
        for (BasketTradeItem basketTradeItem : this.getItems()) {
            basketTradeItem.setManualModify(false);
        }
    }

    private void calPrice(BasketTradeItem item) {
        boolean checkLmt;
        boolean isLmt;
        double price;
        block21: {
            block19: {
                if (item.isManualModify()) {
                    return;
                }
                price = this.getPriceModel().getPrice(item, this.getGear(), this.getFloating(), this.isPctUnit());
                isLmt = false;
                checkLmt = false;
                if (!this.isNormal()) break block19;
                switch (this.getInstructionPanelType()) {
                    case "1": 
                    case "2": {
                        isLmt = this.isLmitType();
                        break;
                    }
                    case "3": {
                        isLmt = this.isLmitType();
                        break;
                    }
                    case "4": {
                        isLmt = false;
                        checkLmt = this.isLmitType();
                        break;
                    }
                    case "0": {
                        isLmt = false;
                        break;
                    }
                }
                break block21;
            }
            isLmt = this.isLmitType();
        }
        this.setPriceBuyLmtType(item, price, isLmt, checkLmt);
    }

    private boolean isLmitType() {
        return "1".equals(this.getPriceLimitType().getRaw()) || "4".equals(this.getPriceLimitType().getRaw()) || "5".equals(this.getPriceLimitType().getRaw());
    }

    private void setPriceBuyLmtType(BasketTradeItem item, double price, boolean isLmt, boolean checkLmt) {
        boolean updateLimitPrice;
        item.setIsLmt(isLmt);
        boolean bl = updateLimitPrice = !"4".equals(this.getInstructionPanelType()) && !"3".equals(this.getInstructionPanelType());
        if (this.isBuy()) {
            if (isLmt) {
                if (updateLimitPrice) {
                    item.setUpperLimitPrice(price);
                }
            } else if (checkLmt) {
                item.setBuyPrice(price > item.getUpperLimitPrice() ? item.getUpperLimitPrice() : price);
            } else {
                item.setBuyPrice(price);
            }
            return;
        }
        if (this.isSell()) {
            if (isLmt) {
                if (updateLimitPrice) {
                    item.setLowerLimitPrice(price);
                }
            } else if (checkLmt) {
                item.setSellPrice(price > item.getLowerLimitPrice() ? price : item.getLowerLimitPrice());
            } else {
                item.setSellPrice(price);
            }
            return;
        }
        if (item.getBsTrade().getRaw().equals("49")) {
            if (isLmt) {
                if (updateLimitPrice) {
                    item.setUpperLimitPrice(price);
                }
            } else if (checkLmt) {
                item.setBuyPrice(price > item.getUpperLimitPrice() ? item.getUpperLimitPrice() : price);
            } else {
                item.setBuyPrice(price);
            }
        } else if (isLmt) {
            if (updateLimitPrice) {
                item.setLowerLimitPrice(price);
            }
        } else if (checkLmt) {
            item.setSellPrice(price > item.getLowerLimitPrice() ? price : item.getLowerLimitPrice());
        } else {
            item.setSellPrice(price);
        }
    }

    private void calTotal() {
        HashSet<String> setSecs = new HashSet<String>();
        double total = 0.0;
        long totalQty = 0L;
        for (BasketTradeItem item : this.getItems().filtered(i -> i.isSelected() && i.isVisible())) {
            boolean isBuy;
            boolean bl = isBuy = this.isBuySell() ? item.getBsTrade().getRaw().equals("49") : this.isBuy();
            if ("4".equals(this.getInstructionPanelType())) {
                if (this.isNormal()) {
                    total += item.getAmt(isBuy);
                } else {
                    double prc = item.getLmtPrice(isBuy);
                    if (item.getItem().getMktItem() != null) {
                        if (item.getItem().getMktItem().getNowPrice() > 0.0) {
                            prc = item.getItem().getMktItem().getNowPrice();
                        } else if (item.getItem().getMktItem().getClosePrice() > 0.0) {
                            prc = item.getItem().getMktItem().getClosePrice();
                        }
                    }
                    total += prc * (double)item.getCount(isBuy) * (double)item.getUnitWeight();
                }
            } else {
                total = this.isLmitType() ? (total += item.getLmtAmt(isBuy)) : (total += item.getAmt(isBuy));
            }
            totalQty += item.getCount(isBuy);
            if (item.getCount(isBuy) <= 0L) continue;
            setSecs.add(item.getItem().getSecurityId());
        }
        this.setAmount(total);
        this.setNum(setSecs.size());
        this.setTotalQuantity(totalQty);
    }

    protected void calCount() {
        if (this.getStg().is("1")) {
            this.allocateCount();
        } else if (this.getStg().is("2")) {
            this.allocateMoney();
        } else if (this.getStg().is("5")) {
            this.allocateByPos();
        } else if (this.getStg().is("6")) {
            this.allocateByPosAdjust();
        } else {
            this.allocateByPer();
        }
        this.calSpecialCount();
    }

    private void calSpecialCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected() && item.isVisible())) {
            double per = this.getCanSellPct() / 100.0;
            long count = item2.getCount(this.isBuy());
            if (this.isBuy()) {
                if (this.isUseInventory()) {
                    count -= (long)item2.getPosition();
                }
                count = (count = MathUtils.calCount((long)count, (int)this.getUnit(item2))) < 0L ? 0L : count;
                item2.setBuyCount(count);
            } else if (this.isSell()) {
                boolean canSellSmaller = (long)item2.getCanSell() <= count;
                long l = count = this.isSmartSell() ? Math.min((long)item2.getCanSell(), count) : count;
                if (count != (long)item2.getCanSell()) {
                    count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 || canSellSmaller && this.isSmartSell() ? 1 : this.getUnit(item2)));
                }
                item2.setSellCount(count);
            } else if (item2.getBsTrade().getRaw().equals("49")) {
                count = item2.getCount(true);
                if (this.isUseInventory()) {
                    count -= (long)item2.getPosition();
                }
                count = (count = MathUtils.calCount((long)count, (int)this.getUnit(item2))) < 0L ? 0L : count;
                item2.setBuyCount(count);
            } else {
                count = item2.getCount(false);
                long l = count = this.isSmartSell() ? Math.min((long)item2.getCanSell(), count) : count;
                if (count != (long)item2.getCanSell()) {
                    count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item2)));
                    item2.setSellCount(count);
                }
            }
            item2.setAvailableQty(count);
            item2.setTargetCount(count);
        }
    }

    private void allocateByPosAdjust() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected() && item.isVisible())) {
            this.allocateByPosAdjust(item2);
        }
        this.calSecs();
    }

    private void allocateByPosAdjust(BasketTradeItem item) {
        double count = this.getCountBskForAdgust();
        long number = item.getItem().getCount();
        if (count == 0.0 || number == 0L || !this.isBuySell()) {
            return;
        }
        Double target = count * (double)number;
        long pos = item.getPosition();
        double value = target - (double)pos;
        long actual = 0L;
        if (value < 0.0) {
            item.getBsTrade().setRaw("50");
            actual = Double.valueOf(value).intValue() == item.getCanSell() ? MathUtils.calCount((Double)Math.abs(value), (int)1) : MathUtils.calCount((Double)Math.abs(value), (int)this.getUnit(item));
        } else {
            item.getBsTrade().setRaw("49");
            actual = MathUtils.calCount((Double)Math.abs(value), (int)this.getUnit(item));
        }
        this.setEntrustCount(item, actual);
    }

    protected void allocateCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected() && item.isVisible())) {
            this.allocateItemCount(item2);
        }
    }

    private void allocateItemCount(BasketTradeItem item) {
        double count = this.getCountBsk();
        long number = item.getItem().getCount();
        if (count == 0.0 || number == 0L) {
            return;
        }
        long actual = 0L;
        actual = "50".equals(item.getBsTrade().getRaw()) && MathUtils.calCount((Double)(count * (double)number), (int)1) == (long)item.getCanSell() ? MathUtils.calCount((Double)(count * (double)number), (int)1) : MathUtils.calCount((Double)(count * (double)number), (int)this.getUnit(item));
        this.setEntrustCount(item, actual);
    }

    private long setEntrustCount(BasketTradeItem item, long count) {
        double per = this.getCanSellPct() / 100.0;
        if (this.isBuy()) {
            count = (count = MathUtils.calCount((long)count, (int)this.getUnit(item))) < 0L ? 0L : count;
            item.setBuyCount(count);
        } else if (this.isSell()) {
            if (count != (long)item.getCanSell()) {
                count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item)));
            }
            item.setSellCount(count);
        } else if (item.getBsTrade().getRaw().equals("49")) {
            count = (count = MathUtils.calCount((long)count, (int)this.getUnit(item))) < 0L ? 0L : count;
            item.setBuyCount(count);
        } else {
            if (count != (long)item.getCanSell()) {
                count = MathUtils.calCount((long)count, (int)(this.getStg().getRaw().equals("5") && per == 1.0 ? 1 : this.getUnit(item)));
            }
            item.setSellCount(count);
        }
        item.setTargetCount(count);
        item.setAvailableQty(count);
        return count;
    }

    protected boolean isBuyItem(BasketTradeItem item) {
        if (!this.getBi().getBasket().hasDirection()) {
            return !this.isSell();
        }
        return item.getItem().getBs().is("49");
    }

    private void allocateMoney() {
        for (CcsFundAccount acc : this.getAccList()) {
            this.allcateAccountMoney(acc);
        }
    }

    private void allcateAccountMoney(CcsFundAccount acc, double money) {
        if (this.getMapItem().get(acc) == null) {
            return;
        }
        ObservableList list = FXCollections.observableList((List)((List)this.getMapItem().get(acc)));
        if (list == null) {
            return;
        }
        if (money <= 0.0) {
            return;
        }
        boolean bBuy = this.isBuy();
        for (BasketTradeItem item : list.filtered(pd -> pd.isSelected() && pd.isVisible())) {
            double price;
            double abWeight = item.getAbWeight();
            if (abWeight <= 0.0) continue;
            double d = price = item.isIsLmt() ? item.getLmtPrice(bBuy) : item.getPrice(bBuy);
            if (price <= 0.0) continue;
            double moneyItem = money * abWeight / 100.0;
            long count = 0L;
            count = price > 0.0 && "50".equals(item.getBsTrade().getRaw()) && Double.valueOf(moneyItem / (price * (double)item.getUnitWeight())).intValue() == item.getCanSell() ? (long)MathUtils.calCount((double)moneyItem, (double)(price * (double)item.getUnitWeight()), (int)1) : (long)MathUtils.calCount((double)moneyItem, (double)(price * (double)item.getUnitWeight()), (int)this.getUnit(item));
            count = this.setEntrustCount(item, count);
        }
    }

    private void allcateAccountMoney(CcsFundAccount acc) {
        double money = this.getMoney();
        this.allcateAccountMoney(acc, money);
    }

    private void allocateByPos() {
        for (CcsFundAccount acc : this.getAccList()) {
            this.allocateByPos(acc);
        }
    }

    private void allocateByPos(CcsFundAccount acc) {
        double per = this.getCanSellPct() / 100.0;
        if (per <= 0.0) {
            return;
        }
        List listBasketTradeItem = (List)this.getMapItem().get(acc);
        if (listBasketTradeItem == null || listBasketTradeItem.isEmpty()) {
            return;
        }
        for (BasketTradeItem item : listBasketTradeItem) {
            int canSell = item.getCanSell();
            if (!item.isSelected() || !item.isVisible() || canSell <= 0) {
                item.setSellCount(0L);
                continue;
            }
            long count = new Double((double)canSell * per).longValue();
            count = this.setEntrustCount(item, count);
        }
    }

    private void allocateByPer() {
        for (CcsFundAccount model : this.getAccList()) {
            this.allocateByPer(model);
        }
    }

    private void allocateByPer(CcsFundAccount model) {
        double base = model.getAvailable();
        if (this.getStg().is("3")) {
            base = model.getAssetAmt();
        }
        double per = this.getPct() / 100.0;
        double money = base * per;
        this.allcateAccountMoney(model, money);
    }

    private double getPct() {
        if (this.getStg().is("3")) {
            return this.getAssetPct();
        }
        if (this.getStg().is("4")) {
            return this.getCanBuyPct();
        }
        if (this.getStg().is("5")) {
            return this.getCanSellPct();
        }
        return 0.0;
    }

    protected void checkItemDisable(BasketTradeItem item, String filterFlag) {
        BasketItem info = item.getItem();
        if (info == null || info.getMktItem() == null) {
            return;
        }
        if ("basket_filter_up".equals(filterFlag)) {
            if (info.getMktItem().getLimitUp().getValue().booleanValue()) {
                item.setSelected(!this.isFilterUp());
                item.setDisabled(this.isFilterUp());
            }
            return;
        }
        if ("basket_filter_down".equals(filterFlag)) {
            if (info.getMktItem().getLimitDown().getValue().booleanValue()) {
                item.setSelected(!this.isFilterDown());
                item.setDisabled(this.isFilterDown());
            }
            return;
        }
        if (info.getMktItem().getStop().getValue().booleanValue()) {
            item.setSelected(false);
            item.setDisabled(true);
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitUp().getValue().booleanValue()) {
            item.setSelected(!this.isFilterUp());
            item.setDisabled(this.isFilterUp());
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        if (info.getMktItem().getLimitDown().getValue().booleanValue()) {
            item.setSelected(!this.isFilterDown());
            item.setDisabled(this.isFilterDown());
            if (!item.isManuallySelected()) {
                item.setSelected(false);
            }
            return;
        }
        item.setSelected(item.isManuallySelected());
        item.setDisable(false);
    }

    public ObservableList<BasketTradeItem> getItems() {
        return this.listItem;
    }

    public void onBsChange(boolean newV) {
        if (!newV) {
            return;
        }
        this.reloadBuyStgAndPriceType();
        this.getBi().filterBasketItem();
    }

    public void reloadBuyStgAndPriceType() {
        if (this.isBuy()) {
            this.buyStg(this.getStg());
            this.priceLimitTypeBuy(this.getPriceLimitType());
        } else if (this.isSell()) {
            this.sellStg(this.getStg());
            this.priceLimitTypeSell(this.getPriceLimitType());
        } else {
            this.buySellStg(this.getStg());
            this.priceLimitTypeBuySell(this.getPriceLimitType());
        }
    }

    private void priceLimitTypeBuySell(MxNode node) {
        block23: {
            String oldNodeRaw;
            block21: {
                block22: {
                    oldNodeRaw = node.getRaw();
                    if (!this.isNormal()) break block21;
                    if (!"0".equals(this.getInstructionPanelType())) break block22;
                    this.removeOthers(node, "2");
                    node.setRaw("2");
                    break block23;
                }
                this.removeOthers(node, "2");
                node.addNode("3");
                node.addNode("5");
                switch (oldNodeRaw) {
                    case "1": 
                    case "4": {
                        node.setRaw("5");
                        break;
                    }
                }
                break block23;
            }
            this.removeOthers(node, "3");
            node.addNode("5");
            switch (oldNodeRaw) {
                case "2": {
                    node.setRaw("3");
                    break;
                }
                case "1": 
                case "4": {
                    node.setRaw("5");
                    break;
                }
            }
        }
        this.setPriceLimitType(node);
    }

    private void priceLimitTypeSell(MxNode node) {
        block23: {
            String oldNodeRaw;
            block21: {
                block22: {
                    oldNodeRaw = node.getRaw();
                    if (!this.isNormal()) break block21;
                    if (!"0".equals(this.getInstructionPanelType())) break block22;
                    this.removeOthers(node, "2");
                    node.setRaw("2");
                    break block23;
                }
                this.removeOthers(node, "2");
                node.addNode("3");
                node.addNode("4");
                switch (oldNodeRaw) {
                    case "1": 
                    case "5": {
                        node.setRaw("4");
                        break;
                    }
                }
                break block23;
            }
            this.removeOthers(node, "3");
            node.addNode("4");
            switch (oldNodeRaw) {
                case "2": {
                    node.setRaw("3");
                    break;
                }
                case "1": 
                case "5": {
                    node.setRaw("4");
                    break;
                }
            }
        }
        this.setPriceLimitType(node);
    }

    public void priceLimitTypeBuy(MxNode node) {
        block23: {
            String oldNodeRaw;
            block21: {
                block22: {
                    oldNodeRaw = node.getRaw();
                    if (!this.isNormal()) break block21;
                    if (!"0".equals(this.getInstructionPanelType())) break block22;
                    this.removeOthers(node, "2");
                    node.setRaw("2");
                    break block23;
                }
                this.removeOthers(node, "2");
                node.addNode("3");
                node.addNode("1");
                switch (oldNodeRaw) {
                    case "4": 
                    case "5": {
                        node.setRaw("1");
                        break;
                    }
                }
                break block23;
            }
            this.removeOthers(node, "3");
            node.addNode("1");
            switch (oldNodeRaw) {
                case "2": {
                    node.setRaw("3");
                    break;
                }
                case "4": 
                case "5": {
                    node.setRaw("1");
                    break;
                }
            }
        }
        this.setPriceLimitType(node);
    }

    public ObservableList<BasketTradeItem> getEntrustList(boolean canStarBuy, boolean canStarSell) {
        FilteredList list = this.getItems().filtered(pd -> pd.isSelected() && pd.isVisible() && pd.getAmt(pd.getBsTrade().getRaw().equals("49")) != 0.0);
        if (!this.isNormal()) {
            return list.filtered(item -> {
                if (item.getItem().getRefItem().isGem()) {
                    return true;
                }
                if ("49".equals(item.getBsTrade().getRaw()) && canStarBuy) {
                    return true;
                }
                if ("50".equals(item.getBsTrade().getRaw()) && canStarSell) {
                    return true;
                }
                return !item.getItem().getSecurityId().startsWith("688");
            });
        }
        return list;
    }

    public ObservableList<BasketTradeItem> getEntrustBasket() {
        ObservableList items = FxUtils.newList();
        Map<CcsFundAccount, List<BasketTradeItem>> accntItemMap = this.getItems().stream().collect(Collectors.groupingBy(BasketTradeItem::getAcc));
        for (CcsFundAccount ccsFundAccount : accntItemMap.keySet()) {
            BasketTradeItem item = this.bskTradeItemFactory.create();
            item.setAcc(ccsFundAccount);
            double totalAmount = 0.0;
            long orderQty = 0L;
            double buyAmount = 0.0;
            String tip = "";
            boolean trigged = false;
            for (BasketTradeItem basketTradeItem : accntItemMap.get(ccsFundAccount)) {
                boolean isBuy;
                if (!basketTradeItem.isSelected() || !basketTradeItem.isVisible() || !this.isStarAndCan(basketTradeItem)) continue;
                item.setBasketName(basketTradeItem.getBasketName());
                if (!trigged && basketTradeItem.isTrigged()) {
                    tip = basketTradeItem.getTip();
                    trigged = true;
                    item.setBasketTrigged(trigged);
                    item.setBasketTip(tip);
                }
                if (isBuy = "49".equals(basketTradeItem.getBsTrade().getRaw())) {
                    buyAmount += basketTradeItem.getAmt(isBuy);
                }
                totalAmount += basketTradeItem.getAmt(isBuy);
                orderQty += basketTradeItem.getCount(isBuy);
            }
            if (orderQty == 0L) continue;
            if (buyAmount > ccsFundAccount.getAvailable()) {
                item.setBasketTip("\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3");
                item.setBasketTrigged(true);
            }
            item.setBasketTotalAmt(totalAmount);
            item.setBasketSide(this.getBasketSide());
            item.setBuyCount(orderQty);
            if ("1".equals(((MxNode)this.stg.getValue()).getRaw())) {
                item.setBuyCount((long)Double.valueOf(this.countBskProperty().get()).intValue());
                item.setBasketStrategy(String.valueOf(this.getCountBsk()) + "\u4efd");
            } else {
                item.setBasketStrategy(((MxNode)this.stg.getValue()).getValue());
            }
            item.setItem(new BasketItem());
            items.add((Object)item);
        }
        return items;
    }

    private String getBasketSide() {
        if (this.isBuy()) {
            return "49";
        }
        if (this.isSell()) {
            return "50";
        }
        return "0";
    }

    public ObservableList<BasketTradeItem> getSelectedList() {
        return this.getItems().filtered(pd -> pd.isSelected());
    }

    public void setAccList(ObservableList<CcsFundAccount> list) {
        this.listAccount = list;
    }

    public ObservableList<CcsFundAccount> getAccList() {
        return this.listAccount;
    }

    private void initPriceGear(MxNode node) {
        this.removeOthers(node, "100");
        node.addNode("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
        node.addNode("-100");
        node.addNode("11");
        node.addNode("12");
    }

    private void removeOthers(MxNode mxNode, String raw) {
        mxNode.removeOthersAndAddThis(raw);
    }

    public void buyStg(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        switch (oldNodeRaw) {
            case "5": {
                node.setRaw("4");
                break;
            }
            case "6": {
                node.setRaw("1");
                break;
            }
        }
        this.setStg(node);
    }

    private void sellStg(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("5");
        switch (oldNodeRaw) {
            case "4": {
                node.setRaw("5");
                break;
            }
            case "6": {
                node.setRaw("1");
                break;
            }
        }
        this.setStg(node);
    }

    public void reloadStg() {
        MxNode node = this.getStg();
        if (node == null) {
            node = MxNodeFactory.createNew((String)"basket_strategy_type", (String)"1");
            this.setStg(node);
        }
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("5");
        node.addNode("4");
        node.addNode("6");
    }

    private void buySellStg(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.setRaw("1");
        if (this.getBi().getBasket() != null && !this.getBi().getBasket().hasDirection()) {
            node.addNode("6");
        }
        if ("6".equals(oldNodeRaw)) {
            node.setRaw("6");
        }
        this.setStg(node);
    }

    public void create(String instructPanelType) {
        this.setInstructionPanelType(instructPanelType);
        this.getInstAccDistModel().setInstructPanelType(instructPanelType);
        try {
            this.getInstAccDistModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
    }

    public final BooleanProperty buyProperty() {
        return this.getBuy();
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public BasketInfo getBasketInfo() {
        return this.getBi();
    }

    public final DoubleProperty floatingProperty() {
        return this.floating;
    }

    public final double getFloating() {
        return this.floatingProperty().get();
    }

    public final void setFloating(double floating) {
        this.floatingProperty().set(floating);
    }

    public final DoubleProperty amountProperty() {
        return this.amount;
    }

    public final double getAmount() {
        return this.amountProperty().get();
    }

    public void setAmount(double amount) {
        this.amountProperty().set(amount);
    }

    public final ObjectProperty<MxNode> gearProperty() {
        return this.gear;
    }

    public final MxNode getGear() {
        return (MxNode)this.gearProperty().get();
    }

    public final void setGear(MxNode gear) {
        this.gearProperty().set((Object)gear);
    }

    public ObjectProperty<MxNode> stgProperty() {
        return this.stg;
    }

    public MxNode getStg() {
        return (MxNode)this.stgProperty().get();
    }

    public void setStg(MxNode stg) {
        this.stgProperty().set((Object)stg);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public BooleanProperty pctUnitProperty() {
        return this.pctUnit;
    }

    public boolean isPctUnit() {
        return this.pctUnitProperty().get();
    }

    public void setPctUnit(boolean pctUnit) {
        this.pctUnitProperty().set(pctUnit);
    }

    public IntegerProperty numProperty() {
        return this.num;
    }

    public int getNum() {
        return this.numProperty().get();
    }

    public void setNum(int num) {
        this.numProperty().set(num);
    }

    public BooleanProperty filterUpProperty() {
        return this.filterUp;
    }

    public boolean isFilterUp() {
        return this.filterUpProperty().get();
    }

    public void setFilterUp(boolean filterUp) {
        this.filterUpProperty().set(filterUp);
    }

    public BooleanProperty filterDownProperty() {
        return this.filterDown;
    }

    public boolean isFilterDown() {
        return this.filterDownProperty().get();
    }

    public void setFilterDown(boolean filterDown) {
        this.filterDownProperty().set(filterDown);
    }

    public final BooleanProperty sellProperty() {
        return this.getSell();
    }

    public final boolean isSell() {
        return this.sellProperty().get();
    }

    public final void setSell(boolean sell) {
        this.sellProperty().set(sell);
    }

    public final BooleanProperty buySellProperty() {
        return this.getBuySell();
    }

    public final boolean isBuySell() {
        return this.buySellProperty().get();
    }

    public final void setBuySell(boolean buySell) {
        this.buySellProperty().set(buySell);
    }

    public final BooleanProperty smartSellProperty() {
        return this.smartSell;
    }

    public final boolean isSmartSell() {
        return this.smartSellProperty().get();
    }

    public final void setSmartSell(boolean smartSell) {
        this.smartSellProperty().set(smartSell);
    }

    public final BooleanProperty useInventoryProperty() {
        return this.useInventory;
    }

    public final boolean isUseInventory() {
        return this.useInventoryProperty().get() && !this.getStg().is("6");
    }

    public final void setUseInventory(boolean useInventory) {
        this.useInventoryProperty().set(useInventory);
    }

    public final DoubleProperty assetPctProperty() {
        return this.assetPct;
    }

    public final double getAssetPct() {
        return this.assetPctProperty().get();
    }

    public final void setAssetPct(double assetPct) {
        this.assetPctProperty().set(assetPct);
    }

    public final DoubleProperty canBuyPctProperty() {
        return this.canBuyPct;
    }

    public final double getCanBuyPct() {
        return this.canBuyPctProperty().get();
    }

    public final void setCanBuyPct(double canBuyPct) {
        this.canBuyPctProperty().set(canBuyPct);
    }

    public final DoubleProperty canSellPctProperty() {
        return this.canSellPct;
    }

    public final double getCanSellPct() {
        return this.canSellPctProperty().get();
    }

    public final void setCanSellPct(double canSellPct) {
        this.canSellPctProperty().set(canSellPct);
    }

    private int getUnit(BasketTradeItem item) {
        if (item.getItem().getRefItem() == null) {
            return 1;
        }
        return item.getItem().getRefItem().getBuyUnit();
    }

    public LongProperty totalQuantityProperty() {
        return this.totalQuantity;
    }

    public long getTotalQuantity() {
        return this.totalQuantityProperty().get();
    }

    public void setTotalQuantity(long totalQuantity) {
        this.totalQuantityProperty().set(totalQuantity);
    }

    public BasketGearPriceModel getPriceModel() {
        return this.priceModel;
    }

    public BatchEntrust getBatchEntrust() {
        return this.batchEntrust;
    }

    public PositionModel<? extends Position> getPostModel() {
        return this.ccsPosModel;
    }

    public Map<CcsFundAccount, ObservableList<BasketTradeItem>> getMapItem() {
        return this.mapItem;
    }

    public void setMapItem(Map<CcsFundAccount, ObservableList<BasketTradeItem>> mapItem) {
        this.mapItem = mapItem;
    }

    public BasketInfo getBi() {
        return this.bi;
    }

    public MScheduler getSdUpdateMkt() {
        return this.sdUpdateMkt;
    }

    public void setSdUpdateMkt(MScheduler sdUpdateMkt) {
        this.sdUpdateMkt = sdUpdateMkt;
    }

    public InvalidationListener getLstPosition() {
        return this.lstPosition;
    }

    public void setLstPosition(InvalidationListener lstPosition) {
        this.lstPosition = lstPosition;
    }

    public BooleanProperty getBuy() {
        return this.buy;
    }

    public void setBuy(BooleanProperty buy) {
        this.buy = buy;
    }

    public BooleanProperty getSell() {
        return this.sell;
    }

    public void setSell(BooleanProperty sell) {
        this.sell = sell;
    }

    public BooleanProperty getBuySell() {
        return this.buySell;
    }

    public void setBuySell(BooleanProperty buySell) {
        this.buySell = buySell;
    }

    public void setBatchEntrust(BatchEntrust batchEntrust) {
        this.batchEntrust = batchEntrust;
    }

    public MObjFactory getOf() {
        return this.of;
    }

    public void setOf(MObjFactory of) {
        this.of = of;
    }

    public InvalidationListener getLstMkt() {
        return this.lstMkt;
    }

    public void setLstMkt(InvalidationListener lstMkt) {
        this.lstMkt = lstMkt;
    }

    public BasketSubmitResult entrust() throws MException {
        BasketSubmitResult result = this.getBatchEntrust().submit(this.instruction, this.getEntrustList(true, true), this.getBi().getBasket(), "");
        for (String id : result.getSuccessedIds()) {
            MEvent event = new MEvent();
            event.put((Object)"listId", (Object)id);
            event.put((Object)"isPortfolio", (Object)false);
            this.es.postEvent("basket.submit", event);
        }
        return result;
    }

    public BasketSubmitResult submitInstruction() throws MException {
        BasketSubmitResult result = new BasketSubmitResult();
        List<BasketOrderAdvice> basketOrderAdvices = this.getBasketOrderAdvice();
        if (basketOrderAdvices.size() == 0) {
            throw new MException(0, "\u7bee\u5b50\u6210\u4efd\u80a1\u4e3a\u7a7a");
        }
        for (BasketOrderAdvice basketOrderAdvice : basketOrderAdvices) {
            try {
                InstructionSubmitResult submitResult = basketOrderAdvice.submit();
                result.getSuccessedTimes().getAndIncrement();
                this.mpMng.basketInst(basketOrderAdvice, this.instructionPanelType, (Object)submitResult.getInstructionId(), submitResult.getReason());
            }
            catch (MException e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
                this.mpMng.basketInst(basketOrderAdvice, this.instructionPanelType, (Object)e, "");
                result.getFailedTimes().getAndIncrement();
                result.setDesc("\n" + result.getDesc() + e.getMessage());
            }
        }
        return result;
    }

    private List<BasketOrderAdvice> getBasketOrderAdvice() throws MException {
        LinkedList<BasketOrderAdvice> adviceList = new LinkedList<BasketOrderAdvice>();
        Map<CcsFundAccount, List<BasketTradeItem>> accntItemMap = this.getItems().stream().collect(Collectors.groupingBy(BasketTradeItem::getAcc));
        for (CcsFundAccount acc : accntItemMap.keySet()) {
            AppointedTraderSetting traderSetting;
            BasketOrderAdvice boa = (BasketOrderAdvice)this.of.create(BasketOrderAdvice.class);
            boa.setInstructionPanelType(this.instructionPanelType);
            String productId = "";
            if (StringUtils.isEmpty((String)this.extAccProductMap.get(acc.getExtAccntId()))) {
                this.extAccProductMap.put(acc.getExtAccntId(), this.accountService.getAccountFromCache(acc.getParentId()).getProductId());
            }
            if (!StringUtils.isEmpty((String)this.insExpiredMap.get(acc))) {
                boa.setInsExpiredDate(this.insExpiredMap.get(acc));
            }
            if ((traderSetting = this.fundTraderMap.get(acc)) != null) {
                boa.setTraderUserIds(traderSetting.getAppointedTraderIds());
            }
            productId = this.extAccProductMap.get(acc.getExtAccntId());
            this.buildBasketOrderAdvice(productId, acc, boa);
            long orderQty = 0L;
            double totalAmount = 0.0;
            for (BasketTradeItem item : accntItemMap.get(acc)) {
                if (!this.isStarAndCan(item) || !item.isSelected() || !item.isVisible()) continue;
                BasketSecurityInst bs = new BasketSecurityInst();
                bs.setSelected(item.isSelected() && item.isVisible());
                bs.setSecurityId(item.getItem().getSecurityId());
                bs.setSymbol(item.getItem().getSecurityName());
                bs.setMarket(item.getItem().getMarket().getRaw());
                bs.setSide(Integer.valueOf(item.getBsTrade().getRaw()).intValue());
                bs.setSecurityType(item.getItem().getSecurityType());
                bs.setOrderPrice(item.getPrice(item.getBsTrade().getRaw().equals("49")));
                bs.setOrderQty((double)item.getCount(item.getBsTrade().getRaw().equals("49")));
                bs.setSampleQty((double)item.getItem().getCount());
                bs.setRelativeWeight(item.getItem().getWeight());
                bs.setFixedPrice(item.getItem().getPrice());
                orderQty = (long)((double)orderQty + bs.getOrderQty());
                bs.setWeight(item.getAbWeight());
                bs.setParentId(item.getAcc().getParentId());
                bs.setExtAccntId(item.getAcc().getExtAccntId());
                bs.setExtSecAccntId(item.getSecAcc().getExtSecAccntId());
                bs.setInvestorId(item.getAcc().getInvestId());
                bs.setLimitPriceUp(item.getUpperLimitPrice());
                bs.setLimitPriceLow(item.getLowerLimitPrice());
                if (StringUtils.isEmpty((String)boa.getInvestorId())) {
                    boa.setInvestorId(item.getAcc().getInvestId());
                }
                bs.setOrderAmount(item.getAmt("49".equals(item.getBsTrade().getRaw())));
                boa.getItemList().add(bs);
                totalAmount += bs.getOrderAmount();
            }
            if (orderQty == 0L) continue;
            boa.setOrderQty(orderQty);
            boa.setAmount(totalAmount);
            adviceList.add(boa);
        }
        return adviceList;
    }

    private void buildBasketOrderAdvice(String productId, CcsFundAccount acc, BasketOrderAdvice boa) {
        if (this.isNormal()) {
            boa.setInstructionType(4);
            if (this.isLmitType() || "3".equals(this.getPriceLimitType().getRaw())) {
                boa.setCanModify(this.isCanModify());
            }
        } else {
            String typeSell;
            boa.setInstructionType(12);
            boa.setAlgoParamBuy((AlgoParam)this.algoModel.getAlgoBuy());
            boa.setAlgoParamSell((AlgoParam)this.algoModel.getAlgoSell());
            String typeBuy = this.algoModel.getAlgoTypeBuy().getRaw();
            if (!typeBuy.isEmpty()) {
                boa.setAlgoTypeBuy(Integer.valueOf(typeBuy).intValue());
            }
            if (!(typeSell = this.algoModel.getAlgoTypeSell().getRaw()).isEmpty()) {
                boa.setAlgoTypeSell(Integer.valueOf(typeSell).intValue());
            }
        }
        boa.setAutoSell(this.isSmartSell());
        boa.setFixedPriceLimit(this.getPriceLimitType().getRaw());
        boa.setUsePosition(this.isUseInventory());
        boa.setProductId(productId);
        if (!this.pctUnit.get()) {
            boa.setFloatPrice(this.floating.get());
        } else {
            boa.setFloatPercent(this.floating.get());
        }
        boa.setSide(this.getSide());
        boa.setBasketId(this.getBi().getBasket().getId());
        boa.setFixedPriceLimit(((MxNode)this.priceLimitTypeProperty().get()).getRaw());
        boa.setBasketName(this.getBi().getBasket().getName());
        boa.setPriceType(Integer.valueOf(((MxNode)this.gear.getValue()).getRaw()).intValue());
        boa.setStrategyType(Integer.valueOf(((MxNode)this.stg.getValue()).getRaw()).intValue());
        if ("6".equals(((MxNode)this.stg.getValue()).getRaw())) {
            boa.setStrategyValue(this.countBskForAdgustProperty().get());
        } else {
            boa.setStrategyValue(this.countBskProperty().get());
        }
        List stepList = this.instrAccModel.getWorkflow(acc.getParentId()).getSteps();
        if (stepList != null && !stepList.isEmpty()) {
            for (AccntStepAttribute step : stepList) {
                if (1 != step.getStepId()) continue;
                boa.setFlowAttriId(step.getFlowAttriId());
                boa.setStepAttrId(step.getStepAttriId());
                break;
            }
        }
    }

    public InstructionBasketAccSetModel getBasketAccSetModel() {
        return this.basketAccModel;
    }

    public void setBasketAccSetModel(InstructionBasketAccSetModel basketAccModel) {
        this.basketAccModel = basketAccModel;
    }

    public void setBi(BasketInfo bi) {
        this.bi = bi;
    }

    private int getSide() {
        if (this.buy.get()) {
            return 1;
        }
        if (this.sell.get()) {
            return 2;
        }
        if (this.buySell.get()) {
            return 3;
        }
        return 0;
    }

    private void filterStg() {
        if (this.isBuy()) {
            this.buyStg(this.getStg());
        } else if (this.isSell()) {
            this.sellStg(this.getStg());
        } else {
            this.buySellStg(this.getStg());
        }
    }

    public void fillBasketTradeItems(Instruction instruction, boolean isApprove) throws MException {
        this.setErrInfo("");
        this.getItems().clear();
        this.getMapItem().clear();
        this.getBi().setItemList(FXCollections.observableList(new LinkedList()));
        this.setInstruction(instruction);
        BasketOrderAdvice basketOrderAdvice = instruction.getBasketOrderAdvice();
        List exeList = basketOrderAdvice.getExeList();
        if (exeList.isEmpty()) {
            exeList = this.resourceDetailMng.query(instruction, 2, "");
        }
        Map<InstructionExec, InstructionExec> exeMap = exeList.stream().collect(Collectors.toMap(t -> t, t -> t));
        List itemList = basketOrderAdvice.getItemList();
        Map<String, List<BasketSecurityInst>> accBasketMap = itemList.stream().collect(Collectors.groupingBy(BasketSecurityInst::getExtAccntId));
        ObservableList bsList = FxUtils.newList();
        ArrayList<RefItem> refItems = new ArrayList<RefItem>();
        for (String extAccId : accBasketMap.keySet()) {
            ObservableList bsTradeList = FxUtils.newList();
            List<BasketSecurityInst> list = accBasketMap.get(extAccId);
            FundAccount fundAccount = this.fundAccService.getFundAccount(extAccId, instruction.getMarketGrp());
            if (!(fundAccount instanceof CcsFundAccount)) continue;
            CcsFundAccount acc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            Map<String, SecAccount> secMap = ((List)this.secAccService.getSecAccountMap().get(acc)).stream().collect(Collectors.toMap(SecAccount::getSecMapKey, t -> t));
            for (BasketSecurityInst basketInst : list) {
                InstructionExec instructionExec = this.getExeLeg(instruction, basketOrderAdvice, exeMap, basketInst);
                BasketTradeItem btItem = this.bskTradeItemFactory.create();
                btItem.setAcc(acc);
                btItem.setBasketName(basketOrderAdvice.getBasketName());
                btItem.setTargetCount(Double.valueOf(basketInst.getOrderQty()).longValue());
                btItem.setSecAcc(secMap.get(String.valueOf(basketInst.getExtSecAccntId()) + basketInst.getMarket()));
                btItem.setSelected(basketInst.isSelected());
                btItem.setRlWeight(basketInst.getRelativeWeight());
                btItem.setUnPickInAdvice(!basketInst.isSelected());
                btItem.setPrice("49".equals(String.valueOf(basketInst.getSide())), basketInst.getOrderPrice());
                btItem.setUpperLimitPrice(basketInst.getLimitPriceUp());
                btItem.setLowerLimitPrice(basketInst.getLimitPriceLow());
                btItem.setClOrderId(basketInst.getClOrderId());
                if (isApprove || !basketInst.isSelected()) {
                    btItem.setDisabled(true);
                }
                BasketItem bti = new BasketItem();
                bti.setSecurityId(basketInst.getSecurityId());
                bti.setSecurityType(basketInst.getSecurityType());
                bti.getBs().setRaw(String.valueOf(basketInst.getSide()));
                bti.setWeight(basketInst.getRelativeWeight());
                bti.setUnit(TradeUtils.getUnitBySecTypeAndMarket((String)basketInst.getSecurityType(), (String)basketInst.getMarket()));
                bti.setPrice(basketInst.getFixedPrice());
                bti.setCount(Double.valueOf(basketInst.getSampleQty()).longValue());
                RefItem refItem = this.refMng.getItem(basketInst.getSecurityType(), basketInst.getMarket(), basketInst.getSecurityId());
                if (refItem == null) {
                    logger.error(String.valueOf(basketInst.getSecurityType()) + basketInst.getMarket() + basketInst.getSecurityId() + "\u6ca1\u6709\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5");
                    this.setErrInfo(String.valueOf(this.getErrInfo()) + basketInst.getSecurityId() + "\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5  ");
                    continue;
                }
                refItems.add(refItem);
                bti.setRefItem(refItem);
                btItem.setItem(bti);
                bsList.add((Object)bti);
                btItem.getBsTrade().setRaw(String.valueOf(basketInst.getSide()));
                if (instructionExec == null) {
                    btItem.setCount("49".equals(String.valueOf(basketInst.getSide())), 0);
                    btItem.setAvailableQty(0L);
                } else {
                    btItem.setCount("49".equals(String.valueOf(basketInst.getSide())), Double.valueOf(instructionExec.getAvailableQty()).intValue());
                    btItem.setAvailableQty(instructionExec.getAvailableQty());
                }
                this.exeRatio.set(100.0);
                btItem.setTargetCount(Double.valueOf(basketInst.getOrderQty()).longValue());
                btItem.selectedProperty().addListener(ob -> this.calSecs());
                btItem.setAbWeight(basketInst.getWeight());
                this.subscribePosition(btItem);
                this.getItems().add((Object)btItem);
                bsTradeList.add((Object)btItem);
            }
            this.getMapItem().put(acc, (ObservableList<BasketTradeItem>)bsTradeList);
        }
        try {
            Gears gears = new Gears();
            gears.setBuys();
            gears.setSells();
            this.marketMng.query(refItems, gears);
        }
        catch (Exception exception) {
            logger.error("\u7bee\u5b50\u6210\u5206\u80a1\u56de\u586b\u65f6\uff0c\u67e5\u8be2\u884c\u60c5\u5931\u8d25");
        }
        this.getBi().getBasket().setDirection(false);
        this.getBi().getBasket().setList((List)bsList);
        this.getBi().onBasketChange();
    }

    protected void setDownCount(BasketTradeItem item, Number newV) {
        int unit = item.getItem().getRefItem().getBuyUnit();
        unit = unit == 0 ? 1 : unit;
        item.setCount("49".equals(item.getBsTrade().getRaw()), Double.valueOf((double)item.getAvailableQty() * newV.doubleValue() / (double)(100 * unit)).intValue() * unit);
    }

    private InstructionExec getExeLeg(Instruction instruction, BasketOrderAdvice basketOrderAdvice, Map<InstructionExec, InstructionExec> exeMap, BasketSecurityInst basketInst) {
        InstructionExec exeItem = new InstructionExec();
        exeItem.setSecId(basketInst.getSecurityId());
        exeItem.setInstructId(instruction.getId());
        exeItem.setMarket(basketInst.getMarket());
        exeItem.setExtAccntId(basketInst.getExtAccntId());
        exeItem.setExtSecAccntId(basketInst.getExtSecAccntId());
        exeItem.setSubAccntId(basketInst.getSubAccntId());
        exeItem.setSubSecAccntId(basketInst.getSubSecAccntId());
        exeItem.setPeFlag(0);
        return exeMap.get(exeItem);
    }

    private synchronized void subscribePosition(BasketTradeItem btItem) {
        CcsPosition pos = null;
        Position position = this.getPostModel().getPositionInMap(btItem.getSecAcc(), btItem.getItem().getSecurityId());
        if (position instanceof CcsPosition) {
            pos = (CcsPosition)CcsPosition.class.cast(position);
        }
        if (pos != null) {
            btItem.canSellProperty().bind((ObservableValue)pos.canVolProperty());
            btItem.positionProperty().bind((ObservableValue)pos.totalVolProperty());
            btItem.setPositionExisted(true);
        } else {
            btItem.canSellProperty().unbind();
            btItem.setCanSell(0);
            btItem.positionProperty().unbind();
            btItem.setPosition(0);
        }
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionType) {
        this.instructionPanelType = instructionType;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public InstructionBasketDistributionModel getInstAccDistModel() {
        return this.instAccDistModel;
    }

    public DoubleProperty countBskProperty() {
        return this.countBsk;
    }

    public double getCountBsk() {
        return this.countBskProperty().get();
    }

    public void setCountBsk(double countBsk) {
        this.countBskProperty().set(countBsk);
    }

    public DoubleProperty countBskForAdgustProperty() {
        return this.countBskForAdgust;
    }

    public double getCountBskForAdgust() {
        return this.countBskForAdgustProperty().get();
    }

    public void setCountBskForAdgust(double countBskForAdgust) {
        this.countBskForAdgustProperty().set(countBskForAdgust);
    }

    public DoubleProperty exeRatioProperty() {
        return this.exeRatio;
    }

    public double getExeRatio() {
        return this.exeRatioProperty().get();
    }

    public void setExeRatio(double exeRatio) {
        this.exeRatioProperty().set(exeRatio);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public MScheduler getPosChange() {
        return this.posChange;
    }

    public void setPosChange(MScheduler posChange) {
        this.posChange = posChange;
    }

    public Map<CcsFundAccount, List<SecAccount>> getSelectedMap() {
        return this.selectedMap;
    }

    public void setSelectedMap(Map<CcsFundAccount, List<SecAccount>> selectedMap) {
        this.selectedMap = selectedMap;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public ObjectProperty<MxNode> priceLimitTypeProperty() {
        return this.priceLimitType;
    }

    public MxNode getPriceLimitType() {
        return (MxNode)this.priceLimitTypeProperty().get();
    }

    public void setPriceLimitType(MxNode priceType) {
        this.priceLimitTypeProperty().set((Object)priceType);
    }

    public BooleanProperty canModifyProperty() {
        return this.canModify;
    }

    public boolean isCanModify() {
        return this.canModifyProperty().get();
    }

    public void setCanModify(boolean canModify) {
        this.canModifyProperty().set(canModify);
    }

    public StringProperty errInfoProperty() {
        return this.errInfo;
    }

    public String getErrInfo() {
        return (String)this.errInfoProperty().get();
    }

    public void setErrInfo(String errInfo) {
        this.errInfoProperty().set((Object)errInfo);
    }

    private boolean isStarAndCan(BasketTradeItem item) {
        if (!this.isNormal()) {
            boolean canStar = false;
            if ("49".equals(item.getBsTrade().getRaw()) && this.algoModel.canStarBuy()) {
                canStar = true;
            }
            if ("50".equals(item.getBsTrade().getRaw()) && this.algoModel.canStarSell()) {
                canStar = true;
            }
            if (!canStar && item.getItem().getSecurityId().startsWith("688")) {
                return false;
            }
            if (item.getItem().getRefItem().isGem()) {
                return true;
            }
        }
        return true;
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public AppointedTraderSetting buildTraderSetting(WorkFlowDescriptor workFlow) {
        AppointedTraderSetting traderSettings = new AppointedTraderSetting();
        List postIds = ((AccntStepAttribute)workFlow.getSteps().get(workFlow.getSteps().size() - 1)).getObjIds();
        if (postIds == null || postIds.isEmpty()) {
            return traderSettings;
        }
        List users = null;
        try {
            users = this.postMng.getUserList(postIds, this.baseApi.getPartyId(), true);
        }
        catch (MException e) {
            logger.error("\u6839\u636e\u804c\u4f4did\uff0c\u67e5\u8be2\u5176\u6240\u6709\u7528\u6237\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (users == null || users.isEmpty()) {
            return traderSettings;
        }
        traderSettings.setUsers(users);
        for (User user : users) {
            traderSettings.getAppointedTraderIds().add(user.getId());
        }
        return traderSettings;
    }

    public WorkFlowDescriptor getWorkFlowByFundAccount(FundAccount fundAcc) {
        return this.instrAccModel.getWorkflow(fundAcc.getParentId());
    }

    public final BooleanProperty filterAllProperty() {
        return this.filterAll;
    }

    public final boolean isFilterAll() {
        return this.filterAllProperty().get();
    }

    public final void setFilterAll(boolean filterAll) {
        this.filterAllProperty().set(filterAll);
    }
}

