/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.basket;

import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.BasketSecurityInst;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.models.basket.InstructionBasketInfoApprove;
import cms.tmx.instructions.models.basket.InstructionBasketTradeModel;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionBasketApproveModel
extends InstructionBasketTradeModel {
    @Inject
    private InstructionBasketInfoApprove bi;
    private List<BasketSecurityInst> insBasketItem;

    public List<BasketSecurityInst> getInsBasketItem() {
        return this.insBasketItem;
    }

    public void setInsBasketItem(List<BasketSecurityInst> insBasketItem) {
        this.insBasketItem = insBasketItem;
    }

    @Override
    @PostConstruct
    public void init() {
        this.setBi(this.bi);
        super.init();
    }

    public BasketSubmitResult submitApprove(Instruction instruction) {
        BasketSubmitResult result = new BasketSubmitResult();
        try {
            this.insModel.approve(instruction, MxDict.WORKFLOW_APPROVE, "");
            result.getSuccessedTimes().getAndIncrement();
        }
        catch (MException e) {
            result.getFailedTimes().getAndIncrement();
            result.setDesc("\n" + result.getDesc() + e.getMessage());
        }
        return result;
    }

    @Override
    protected void calCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected())) {
            if (item2.getBsTrade().getRaw().equals("49")) {
                item2.setBuyCount(item2.getTargetCount());
                continue;
            }
            item2.setSellCount(item2.getTargetCount());
        }
    }

    @Override
    protected void checkItemDisable(BasketTradeItem item, String filterFlag) {
    }
}

