/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.basket;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.instructions.models.basket.InstructionBasketDistributionModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class InstructionBasketAccSetModel {
    @Inject
    private InstructionBasketDistributionModel instAccDistModel;
    private String instructType = "";
    private Map<CcsFundAccount, List<SecAccount>> selectedMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private List<CcsFundAccount> selectedFundList = new ArrayList<CcsFundAccount>();
    protected MxTreeList<CcsAccountDistribution> accMxList;
    protected Map<String, MxTreeList<CcsAccountDistribution>> mapSecDisMxList;
    protected TreeItem<CcsAccountDistribution> root = new TreeItem((Object)new CcsAccountDistribution());
    private final int MAP_CAP = 100;
    @Inject
    private MObjFactory of;
    private Map<CcsFundAccount, List<SecAccount>> mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>();

    public Map<CcsFundAccount, List<SecAccount>> getSelectedMap() {
        if (!this.selectedMap.isEmpty()) {
            return this.selectedMap;
        }
        this.root.getChildren().forEach(accItem -> {
            if (((CcsAccountDistribution)accItem.getValue()).isSelected()) {
                LinkedList secList = new LinkedList();
                accItem.getChildren().forEach(secItem -> {
                    if (((CcsAccountDistribution)secItem.getValue()).isSelected()) {
                        secList.add(((CcsAccountDistribution)secItem.getValue()).getSecAcc());
                    }
                });
                this.selectedMap.put(((CcsAccountDistribution)accItem.getValue()).getAcc(), secList);
            }
        });
        return this.selectedMap;
    }

    public TreeItem<CcsAccountDistribution> getRoot() {
        return this.root;
    }

    @PostConstruct
    private void init() throws MException {
        this.createTree();
    }

    private void createTree() throws MException {
        this.instAccDistModel.clearSelect();
        this.instAccDistModel.setInstructPanelType("0");
        this.getMapAccount().clear();
        for (CcsFundAccount item : this.instAccDistModel.getAccountMap().keySet()) {
            this.getMapAccount().put(item, this.instAccDistModel.getAccountMap().get(item));
        }
        ((CcsAccountDistribution)this.root.getValue()).setSelected(true);
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.mapSecDisMxList = new HashMap<String, MxTreeList<CcsAccountDistribution>>(100);
        this.accMxList = new CcsAccountDistTreeList(this.root, this.root.getChildren(), accList);
        for (CcsFundAccount fundAcc : this.getMapAccount().keySet()) {
            CcsAccountDistribution accDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
            accDst.setAcc(fundAcc);
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<CcsAccountDistribution> secAccList = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : this.getMapAccount().get(fundAcc)) {
                if (!"XSHE".equals(secAcc.getExchange().getRaw()) && !"XSHG".equals(secAcc.getExchange().getRaw())) continue;
                CcsAccountDistribution secDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
                secAccList.add(secDst);
                secDst.setSecAcc(secAcc);
                secDst.setIsSecAcc(true);
            }
            CcsAccountDistTreeList secMxList = new CcsAccountDistTreeList((TreeItem)this.root.getChildren().get(accList.size() - 1), ((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), (MxTreeList<CcsAccountDistribution>)secMxList);
        }
    }

    public void rebuildTree() throws MException {
        this.clearShowAndSelected();
        for (CcsAccountDistribution fundDis : this.accMxList.getOrList()) {
            if (this.selectedMap.isEmpty()) {
                this.pickTwoDefault(fundDis.getAcc(), fundDis);
                continue;
            }
            if (!this.selectedMap.isEmpty() && this.selectedMap.keySet().contains(fundDis.getAcc()) && this.getSelectedFundList().contains(fundDis.getAcc())) {
                this.reSelected(fundDis.getAcc(), fundDis);
                continue;
            }
            if (this.selectedMap.isEmpty() || this.selectedMap.keySet().contains(fundDis.getAcc()) || !this.getSelectedFundList().contains(fundDis.getAcc())) continue;
            this.pickTwoDefault(fundDis.getAcc(), fundDis);
        }
        this.selectedMap.clear();
    }

    private void clearShowAndSelected() throws MException {
        for (TreeItem fundItem : this.root.getChildren()) {
            fundItem.setExpanded(false);
        }
        this.accMxList.getOrList().forEach(item -> item.setShow(false));
        this.accMxList.getOrList().forEach(item -> item.setSelected(false));
        for (MxTreeList<CcsAccountDistribution> secTreeList : this.mapSecDisMxList.values()) {
            secTreeList.getOrList().forEach(item -> item.setSelected(false));
        }
        this.instAccDistModel.setInstructPanelType(this.getInstructType());
        if (this.instAccDistModel.getAccountMap() == null) {
            this.accMxList.getOrList().stream().forEach(item -> item.setShow(false));
            this.accMxList.filter(item -> item.isShow());
            return;
        }
        for (CcsFundAccount account : this.instAccDistModel.getAccountMap().keySet()) {
            this.accMxList.getOrList().stream().forEach(item -> {
                if (account.equals((Object)item.getAcc())) {
                    item.setShow(true);
                }
            });
        }
        this.accMxList.filter(item -> item.isShow());
    }

    private void reSelected(CcsFundAccount fundAcc, CcsAccountDistribution accDst) {
        accDst.setSelected(true);
        List<SecAccount> secList = this.selectedMap.get(fundAcc);
        if (this.mapSecDisMxList.get(fundAcc.getExtAccntId()) != null) {
            for (CcsAccountDistribution secDis : this.mapSecDisMxList.get(fundAcc.getExtAccntId()).getOrList()) {
                if (!secList.contains(secDis.getSecAcc())) continue;
                secDis.setSelected(true);
            }
        }
    }

    private void pickTwoDefault(CcsFundAccount fundAcc, CcsAccountDistribution accDst) {
        if (!this.getSelectedFundList().contains(fundAcc)) {
            return;
        }
        accDst.setSelected(true);
        boolean xshg = true;
        boolean xshe = true;
        if (this.mapSecDisMxList.get(fundAcc.getExtAccntId()) != null) {
            for (CcsAccountDistribution secDis : this.mapSecDisMxList.get(fundAcc.getExtAccntId()).getOrList()) {
                if (this.getSelectedFundList().contains(fundAcc) && xshg && "XSHG".equals(secDis.getSecAcc().getExchange().getRaw())) {
                    secDis.setSelected(true);
                    xshg = false;
                }
                if (!this.getSelectedFundList().contains(fundAcc) || !xshe || !"XSHE".equals(secDis.getSecAcc().getExchange().getRaw())) continue;
                secDis.setSelected(true);
                xshe = false;
            }
        }
    }

    public Map<CcsFundAccount, List<SecAccount>> getMapAccount() {
        return this.mapAccount;
    }

    public void setMapAccount(Map<CcsFundAccount, List<SecAccount>> mapAccount) {
        this.mapAccount = mapAccount;
    }

    public List<CcsFundAccount> getSelectedFundList() {
        return this.selectedFundList;
    }

    public void setSelectedFundList(List<CcsFundAccount> selectedFundList) {
        this.selectedFundList = selectedFundList;
    }

    public InstructionBasketDistributionModel getInstAccDistModel() {
        return this.instAccDistModel;
    }

    public void setInstAccDistModel(InstructionBasketDistributionModel instAccDistModel) {
        this.instAccDistModel = instAccDistModel;
    }

    public String getInstructType() {
        return this.instructType;
    }

    public void setInstructType(String instructType) {
        this.instructType = instructType;
    }

    public void setSelectedMap(Map<CcsFundAccount, List<SecAccount>> selectedMap) {
        this.selectedMap = selectedMap;
    }
}

