/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.basket;

import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoMiseTradeApi;
import cms.tmx.api.trade.info.MiseBasketInfo;
import cms.tmx.api.trade.info.MiseExtraFields;
import cms.tmx.api.trade.info.MiseGatewayData;
import cms.tmx.api.trade.info.MiseParam;
import cms.tmx.api.trade.info.MiseRemark;
import cms.tmx.api.trade.info.MiseRequset;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.instructions.models.basket.InstructionBasketTradeModel;
import cms.tmx.instructions.models.portfolio.basket.InstructionPortfBsktTradeModel;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class BasketAlgoModel
extends MxModel {
    private ObjectProperty<MxNode> algoTypeBuy = new SimpleObjectProperty((Object)new MxNode());
    private ObjectProperty<MxNode> algoTypeSell = new SimpleObjectProperty((Object)new MxNode());
    @Inject
    private AlgoModel algoBuy;
    @Inject
    private AlgoModel algoSell;
    @Inject
    private IAlgoMiseTradeApi algoApi;
    @Inject
    protected IBaseApi baseApi;
    private MxModel model;
    @Inject
    private MObjFactory of;

    @PostConstruct
    private void init() {
        MxNode node = MxNodeFactory.create((String)"basket_algorithm_type", (String)"");
        this.algoTypeBuyProperty().set((Object)node);
        this.algoTypeSellProperty().set((Object)node);
    }

    public void setBasketTradeModel(MxModel model) {
        this.model = model;
    }

    public AlgoModel getAlgoBuy() {
        return this.algoBuy;
    }

    public AlgoModel getAlgoSell() {
        return this.algoSell;
    }

    public void setAlgoBuy(AlgoModel model) {
        this.algoBuy = model;
    }

    public void setAlgoSell(AlgoModel model) {
        this.algoSell = model;
    }

    public void submit(MiseRequset request) throws MException {
        this.algoApi.miseOrder(request);
    }

    public MiseRequset getMiseRequest(Basket basket, CcsFundAccount accnt, boolean isBuy, String algoType, String instructionId, String resourceId) throws MException {
        String endTime;
        String startTime;
        String id = basket.getId();
        String name = basket.getName();
        MiseParam para = new MiseParam();
        boolean isPort = false;
        CcsSubFundAccount sf = null;
        InstructionBasketTradeModel modelRegular = (InstructionBasketTradeModel)((Object)this.of.create(InstructionBasketTradeModel.class));
        InstructionPortfBsktTradeModel modelPortf = (InstructionPortfBsktTradeModel)((Object)this.of.create(InstructionPortfBsktTradeModel.class));
        FilteredList listItem = null;
        String portfolioId = "";
        String investorId = accnt.getInvestId();
        boolean canStar = BasketAlgoModel.canStart(algoType);
        if (accnt instanceof CcsSubFundAccount) {
            isPort = true;
            sf = (CcsSubFundAccount)accnt;
            para.setBiz_acct(sf.getSubAccntId());
            modelPortf = (InstructionPortfBsktTradeModel)((Object)InstructionPortfBsktTradeModel.class.cast(this.model));
            listItem = modelPortf.getEntrustList(canStar, canStar);
            portfolioId = sf.getPortfolioId();
        } else {
            para.setBiz_acct(accnt.getInvestId());
            modelRegular = (InstructionBasketTradeModel)((Object)InstructionBasketTradeModel.class.cast(this.model));
            listItem = modelRegular.getEntrustList(canStar, canStar);
        }
        listItem = listItem.filtered(item -> item.getBsTrade().getRaw().equals("49") == isBuy && item.getAcc().getInvestId().equals(accnt.getInvestId()));
        if (listItem.isEmpty()) {
            throw new MException(0, String.valueOf(isBuy ? "\u4e70\u5165" : "\u5356\u51fa") + "\u7b97\u6cd5\u6210\u4efd\u80a1\u4e3a\u7a7a");
        }
        Long sum = listItem.stream().collect(Collectors.summingLong(t -> t.getCount(isBuy)));
        if (sum <= 0L) {
            throw new MException(0, String.valueOf(isBuy ? "\u4e70\u5165" : "\u5356\u51fa") + "\u7b97\u6cd5\u6210\u4efd\u80a1\u6570\u91cf\u4e0d\u5408\u6cd5");
        }
        String type = "";
        switch (algoType) {
            case "14": {
                type = "BasketTrade";
                break;
            }
            case "15": {
                type = "TWAPBasketTrade";
                break;
            }
            case "16": {
                type = "VWAPBasketTrade";
                break;
            }
            case "19": {
                type = "HighLowLimitTWAP";
                break;
            }
            case "20": {
                type = "HighLowLimitVWAP";
            }
        }
        para.setAlgo_type(type);
        para.setBranch_code("");
        para.setOpUser(this.baseApi.getOpUser());
        para.setProduct_id("");
        para.setBroker_id("");
        para.setCounter_id("1");
        para.setOrder_flag("1");
        para.setGateway_id("0");
        ArrayList<Object[]> basketArr = new ArrayList<Object[]>();
        this.logger.info("basket algo submit have item:" + listItem.size());
        for (BasketTradeItem tradeItem : listItem) {
            String applId;
            if (tradeItem.getCount(isBuy) <= 0L || !tradeItem.isSelected()) continue;
            BasketItem item2 = tradeItem.getItem();
            MiseBasketInfo arr = new MiseBasketInfo();
            arr.setMarketCode("XSHG".equals(item2.getMarket().getRaw()) ? "1" : "2");
            arr.setSecCode(item2.getSecurityId());
            SecAccount sec = tradeItem.getSecAcc();
            CcsSubSecAccount subSecAccnt = null;
            if (isPort) {
                subSecAccnt = (CcsSubSecAccount)sec;
                arr.setHolderAccNo(subSecAccnt.getSubSecAccntId());
            } else {
                arr.setHolderAccNo(tradeItem.getSecAcc().getInverstorSecId());
            }
            tradeItem.getSecAcc().getExtSecAccntId();
            arr.setCount(Long.valueOf(tradeItem.getCount(isBuy)));
            arr.setSide(tradeItem.getBsTrade().getRaw().equals("49") ? "01" : "02");
            arr.setSampleVol(Integer.valueOf(1));
            arr.setWeight(Integer.valueOf(0));
            String reserved1 = "";
            if ("HighLowLimitTWAP".equals(type) || "HighLowLimitVWAP".equals(type)) {
                double limitUp = tradeItem.getUpperLimitPrice();
                double limitLow = tradeItem.getLowerLimitPrice();
                reserved1 = isBuy ? String.valueOf(limitUp) + "#" : "#" + limitLow;
            }
            arr.setReserved1(reserved1);
            String string = applId = item2.getSecurityType().equals("REPO") ? "110" : "010";
            if (item2.getSecurityId().startsWith("688")) {
                applId = "700";
            }
            String reserved2 = String.valueOf(item2.getSecurityType()) + "#" + applId;
            if (isPort) {
                reserved2 = String.valueOf(reserved2) + "#" + subSecAccnt.getInverstorSecId();
            }
            arr.setReserved2(reserved2);
            basketArr.add(arr.getBasketInfo());
        }
        this.logger.info("basket algo submit reality item:" + basketArr.size());
        MiseExtraFields extraFields = new MiseExtraFields();
        extraFields.setBasket(basketArr);
        if (isBuy) {
            extraFields.setBase_price_type(Integer.valueOf(Integer.parseInt(this.algoBuy.getPriceterms().getRaw())));
            extraFields.setAbove_price_rate(Double.valueOf(this.algoBuy.getExceedPrice()));
            extraFields.setBase_vol_type(Integer.valueOf(Integer.parseInt(this.algoBuy.getDatumQty().getRaw())));
            extraFields.setBase_vol_rate(Integer.valueOf(this.algoBuy.getDatumPercent()));
            extraFields.setEntrust_interval(Integer.valueOf(this.algoBuy.getOrderIntevel()));
            extraFields.setWithdraw_interval(Integer.valueOf(this.algoBuy.getCancelIntevel()));
            extraFields.setAbove_price_index(Integer.valueOf(this.algoBuy.getMinitabQty()));
            extraFields.setPrice_limit_range(Integer.valueOf(this.algoBuy.getWaveRang()));
            extraFields.setMin_order_vol(Integer.valueOf(this.algoBuy.getMinQty()));
            extraFields.setMax_order_vol(Integer.valueOf(this.algoBuy.getMaxQty()));
            startTime = String.valueOf(this.complement(this.algoBuy.getStartHour())) + this.complement(this.algoBuy.getStartMinute()) + "00";
            extraFields.setStart_time(startTime);
            endTime = String.valueOf(this.complement(this.algoBuy.getEndHour())) + this.complement(this.algoBuy.getEndMinute()) + "00";
            extraFields.setEnd_time(endTime);
            extraFields.setMax_entrust_num(Integer.valueOf(this.algoBuy.getOrderTime()));
            extraFields.setLast_entrust_vol_rate(Integer.valueOf(100));
            extraFields.setAggressiveLevel(Integer.valueOf(this.algoBuy.getAggress()));
            extraFields.setNumSlice(Integer.valueOf(this.algoBuy.getSlice()));
        } else {
            extraFields.setBase_price_type(Integer.valueOf(Integer.parseInt(this.algoSell.getPriceterms().getRaw())));
            extraFields.setAbove_price_rate(Double.valueOf(this.algoSell.getExceedPrice()));
            extraFields.setBase_vol_type(Integer.valueOf(Integer.parseInt(this.algoSell.getDatumQty().getRaw())));
            extraFields.setBase_vol_rate(Integer.valueOf(this.algoSell.getDatumPercent()));
            extraFields.setEntrust_interval(Integer.valueOf(this.algoSell.getOrderIntevel()));
            extraFields.setWithdraw_interval(Integer.valueOf(this.algoSell.getCancelIntevel()));
            extraFields.setAbove_price_index(Integer.valueOf(this.algoSell.getMinitabQty()));
            extraFields.setPrice_limit_range(Integer.valueOf(this.algoSell.getWaveRang()));
            extraFields.setMin_order_vol(Integer.valueOf(this.algoSell.getMinQty()));
            extraFields.setMax_order_vol(Integer.valueOf(this.algoSell.getMaxQty()));
            startTime = String.valueOf(this.complement(this.algoSell.getStartHour())) + this.complement(this.algoSell.getStartMinute()) + "00";
            extraFields.setStart_time(startTime);
            endTime = String.valueOf(this.complement(this.algoSell.getEndHour())) + this.complement(this.algoSell.getEndMinute()) + "00";
            extraFields.setEnd_time(endTime);
            extraFields.setMax_entrust_num(Integer.valueOf(this.algoSell.getOrderTime()));
            extraFields.setLast_entrust_vol_rate(Integer.valueOf(100));
            extraFields.setAggressiveLevel(Integer.valueOf(this.algoSell.getAggress()));
            extraFields.setNumSlice(Integer.valueOf(this.algoSell.getSlice()));
        }
        MiseRemark remark = new MiseRemark();
        remark.setBasket_id(id);
        remark.setBasket_name(name);
        if (isBuy) {
            remark.setSide(Integer.valueOf(49));
        } else {
            remark.setSide(Integer.valueOf(50));
        }
        if (accnt instanceof CcsSubFundAccount) {
            remark.setPortfolio_name(sf.getPortfolioName());
            remark.setInvestorId(sf.getInvestId());
        }
        remark.setEvaluation_version("2");
        extraFields.setRemark(remark.toString());
        String currId = accnt.getCurrencyId();
        PBase.OpUser user = this.baseApi.getOpUser();
        MiseGatewayData gateway = new MiseGatewayData(user, currId, portfolioId, investorId, resourceId, instructionId);
        extraFields.setGateway_data(gateway.toString());
        extraFields.setTrade_platform_id(accnt.getCounterId());
        para.setExtra_fields(extraFields.toString());
        MiseRequset request = new MiseRequset();
        request.setPARA(para);
        return request;
    }

    public String complement(Object obj) {
        String str = obj.toString();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)str)) {
            str = "0" + str;
        }
        return str;
    }

    public final ObjectProperty<MxNode> algoTypeBuyProperty() {
        return this.algoTypeBuy;
    }

    public final MxNode getAlgoTypeBuy() {
        return (MxNode)this.algoTypeBuyProperty().get();
    }

    public final void setAlgoTypeBuy(MxNode algoTypeBuy) {
        this.algoTypeBuyProperty().set((Object)algoTypeBuy);
    }

    public final ObjectProperty<MxNode> algoTypeSellProperty() {
        return this.algoTypeSell;
    }

    public final MxNode getAlgoTypeSell() {
        return (MxNode)this.algoTypeSellProperty().get();
    }

    public final void setAlgoTypeSell(MxNode algoTypeSell) {
        this.algoTypeSellProperty().set((Object)algoTypeSell);
    }

    public static boolean canStart(String algoType) {
        switch (algoType) {
            case "14": 
            case "15": 
            case "16": 
            case "19": 
            case "20": {
                return true;
            }
        }
        return false;
    }

    public boolean canStarBuy() {
        return BasketAlgoModel.canStart(this.getAlgoTypeBuy().getRaw());
    }

    public boolean canStarSell() {
        return BasketAlgoModel.canStart(this.getAlgoTypeSell().getRaw());
    }
}

