/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.adjust;

import cms.tmx.api.trade.info.MiseBasketInfo;
import cms.tmx.api.trade.info.MiseExtraFields;
import cms.tmx.api.trade.info.MiseGatewayData;
import cms.tmx.api.trade.info.MiseParam;
import cms.tmx.api.trade.info.MiseRemark;
import cms.tmx.api.trade.info.MiseRequset;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.instructions.models.adjust.AdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.IAdjPosAlgoCapitalModel;
import cms.tmx.instructions.models.adjust.PortfAdjPosAlgoCapitalModel;
import cms.tmx.query.current.models.CcsPortfPositionModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.trade.message.MessagePromptMng;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfAdjPosAlgoModel
extends AdjPosAlgoModel {
    @Inject
    protected PortfAdjPosAlgoCapitalModel capitalModel;
    @Inject
    protected CcsPortfPositionModel posModel;
    @Inject
    private MessagePromptMng msg;
    private static final String MISE_SUCCESS = "0";

    @Override
    public String submit() throws MException {
        String basketId = this.basket == null ? "" : this.basket.getId();
        String basketName = this.basket == null ? "" : this.basket.getName();
        MiseParam para = new MiseParam();
        CcsSubFundAccount sf = (CcsSubFundAccount)this.capitalModel.getSelectedFund();
        para.setAlgo_type("BasketPosAdj");
        para.setBiz_acct(sf.getSubAccntId());
        para.setBranch_code("");
        para.setOpUser(this.baseApi.getOpUser());
        para.setProduct_id("");
        para.setBroker_id("");
        para.setCounter_id("1");
        para.setOrder_flag("1");
        para.setGateway_id(MISE_SUCCESS);
        MiseExtraFields extraFields = new MiseExtraFields();
        ArrayList<Object[]> basketArr = new ArrayList<Object[]>();
        for (BasketAlgoItem item : this.getAdjustItems()) {
            if (!item.isAdjust()) continue;
            MiseBasketInfo arr = new MiseBasketInfo();
            arr.setMarketCode("XSHG".equals(item.getMarket().getRaw()) ? "1" : "2");
            arr.setSecCode(item.getCode());
            CcsSubSecAccount ss = (CcsSubSecAccount)this.capitalModel.getSelectedSec(item.getMarket().getRaw());
            arr.setHolderAccNo(ss.getSubSecAccntId());
            arr.setCount(Long.valueOf(item.isBs() ? item.getOrderQtyBuy() : item.getOrderQtySell()));
            arr.setSide(item.isBs() ? "01" : "02");
            arr.setSampleVol(Integer.valueOf(1));
            arr.setWeight(Integer.valueOf(0));
            arr.setReserved1("");
            arr.setReserved2(String.valueOf(item.getType()) + "#010#" + ss.getInverstorSecId());
            basketArr.add(arr.getBasketInfo());
        }
        extraFields.setBasket(basketArr);
        extraFields.setFund_control(Boolean.valueOf(this.controlMoney));
        extraFields.setExtra_fund(this.money);
        extraFields.setNumSlice(Integer.valueOf(this.algoParam.getSlice()));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HHmmSS");
        extraFields.setStart_time(LocalTime.of(this.algoParam.getStartHour(), this.algoParam.getStartMinute()).format(dtf));
        extraFields.setEnd_time(LocalTime.of(this.algoParam.getEndHour(), this.algoParam.getEndMinute()).format(dtf));
        MiseRemark remark = new MiseRemark();
        remark.setAdj_type(this.getAdjType().getRaw());
        remark.setAdj_way(this.getAdjWay().getRaw());
        double adjWayValue = 0.0;
        if ("1".equals(this.getAdjWay().getRaw())) {
            adjWayValue = this.getCountBsk();
        } else if ("2".equals(this.getAdjWay().getRaw())) {
            adjWayValue = this.getMoneyStg();
        }
        remark.setAdj_way_value(Double.valueOf(adjWayValue));
        remark.setAdj_scale(Integer.valueOf(this.adjScale));
        remark.setBasket_id(basketId);
        remark.setBasket_name(basketName);
        remark.setAccnt_id(sf.getSubAccntId());
        remark.setPortfolio_name(this.capitalModel.getSelectedPortf().getName());
        remark.setControl_boolean(Boolean.valueOf(this.controlImpact));
        remark.setControl_impact(Double.valueOf(this.percent));
        remark.setEvaluation_version("2");
        extraFields.setRemark(remark.toString());
        String currency = this.capitalModel.getSelectedFund().getCurrencyId();
        String portfolioId = this.capitalModel.getSelectedPortf().getId();
        String investId = this.capitalModel.getSelectedFund().getInvestId();
        PBase.OpUser user = this.baseApi.getOpUser();
        MiseGatewayData gateway = new MiseGatewayData(user, currency, portfolioId, investId, this.resource, this.reference);
        extraFields.setGateway_data(gateway.toString());
        extraFields.setTrade_platform_id(this.capitalModel.getSelectedFund().getCounterId());
        para.setExtra_fields(extraFields.toString());
        MiseRequset request = new MiseRequset();
        request.setPARA(para);
        String orderId = "";
        try {
            MEvent miseOrder = this.algoApi.miseOrder(request);
            String reason = "";
            String code = miseOrder.getStr("ret_code");
            if (!MISE_SUCCESS.equals(code)) {
                reason = miseOrder.getStr("ret_msg");
                miseOrder.put((Object)"reason", (Object)reason);
            }
            miseOrder.put((Object)"bask_id", (Object)basketId);
            miseOrder.put((Object)"bask_name", (Object)basketId);
            miseOrder.put((Object)"inst_id", (Object)this.capitalModel.getSelectedFund().getInvestId());
            miseOrder.put((Object)"status", (Object)(MISE_SUCCESS.equals(code) ? "1" : "-1"));
            orderId = miseOrder.getStr("algo_order_id");
            this.msg.algoMiseOrder(miseOrder, (Object)orderId);
        }
        catch (MException e) {
            MEvent event = new MEvent();
            event.put((Object)"bask_id", (Object)basketId);
            event.put((Object)"bask_name", (Object)basketName);
            event.put((Object)"inst_id", (Object)this.capitalModel.getSelectedFund().getInvestId());
            this.msg.algoMiseOrder(event, (Object)e);
            throw e;
        }
        this.refreshStragety();
        this.algoParam = null;
        return orderId;
    }

    @Override
    protected PositionModel<?> getPosModel() {
        return this.posModel;
    }

    @Override
    protected List<CcsPosition> getPosList() {
        return new LinkedList<CcsPosition>((Collection<CcsPosition>)this.posModel.getList());
    }

    @Override
    public IAdjPosAlgoCapitalModel getCapitalModel() {
        return this.capitalModel;
    }

    @Override
    protected boolean initPosItemPre(CcsPosition pos) {
        CcsPortfPosition pPosi;
        Portfolio portf = this.capitalModel.getSelectedPortf();
        return pos instanceof CcsPortfPosition && (pPosi = (CcsPortfPosition)CcsPortfPosition.class.cast(pos)).getPortfolioId().equals(portf.getId());
    }

    @Override
    public void setItemAccount() {
        for (BasketAlgoItem item : this.listItem) {
            String market = item.getMarket().getRaw();
            CcsFundAccount fund = this.capitalModel.getSelectedFund();
            CcsSubSecAccount sec = (CcsSubSecAccount)this.capitalModel.getSelectedSec(market);
            item.setInvestorId(fund.getInvestId());
            item.setInvestorSecId(sec.getInverstorSecId());
            item.setExtAccntId(sec.getExtAccntId());
            item.setExtSecAccntId(sec.getExtSecAccntId());
            item.setSubAccntId(sec.getSubAccntId());
            item.setSubSecAccntId(sec.getSubSecAccntId());
        }
    }
}

