/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.adjust;

import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.instructions.models.adjust.IAdjPosAlgoCapitalModel;
import cms.tmx.instructions.models.portfolio.basket.InstrPortfoBsktDistributionModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.PortfolioAccountModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PortfAdjPosAlgoCapitalModel
implements IAdjPosAlgoCapitalModel {
    private static final Logger logger = LogManager.getLogger(PortfAdjPosAlgoCapitalModel.class);
    @Inject
    private InstrPortfoBsktDistributionModel portfDistModel;
    @Inject
    private PortfolioAccountModel portfMng;
    protected MxTreeList<PortfolioAccountDistribution> accMxList;
    protected Map<String, MxTreeList<PortfolioAccountDistribution>> mapSecDisMxList;
    private Portfolio selectedPortf;
    private CcsFundAccount selectedFund;
    private SecAccount secXshg;
    private SecAccount secXshe;
    protected TreeItem<PortfolioAccountDistribution> root;
    private ObservableList<Portfolio> listPortf = FxUtils.newList();
    private Map<Portfolio, PortfolioAccountDistribution> mapPortf = new HashMap<Portfolio, PortfolioAccountDistribution>();
    private Map<CcsFundAccount, PortfolioAccountDistribution> mapFund = new HashMap<CcsFundAccount, PortfolioAccountDistribution>();
    private Map<SecAccount, PortfolioAccountDistribution> mapSec = new HashMap<SecAccount, PortfolioAccountDistribution>();

    @Override
    public void init(String instructionPanelType) {
        try {
            this.initPortf(instructionPanelType);
        }
        catch (MException e) {
            logger.error("\u521d\u59cb\u5316\u6295\u7ec4\u8d26\u53f7\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void initPortf(String instructionPanelType) throws MException {
        this.getPortfDistModel().setInstructType(instructionPanelType);
        this.root = this.getPortfDistModel().create();
        this.filterEmptyPortfolio();
        ObservableList list = this.root.getChildren();
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = this.root.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeItem portfItem = (TreeItem)iterator.next();
            if (portfItem.getChildren().size() == 0) {
                iterator.remove();
                continue;
            }
            this.listPortf.add((Object)((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio());
            this.mapPortf.put(((PortfolioAccountDistribution)portfItem.getValue()).getPortfolio(), (PortfolioAccountDistribution)portfItem.getValue());
            for (TreeItem fundItem : portfItem.getChildren()) {
                this.mapFund.put(((PortfolioAccountDistribution)fundItem.getValue()).getAcc(), (PortfolioAccountDistribution)fundItem.getValue());
                for (TreeItem secItem : fundItem.getChildren()) {
                    this.mapSec.put(((PortfolioAccountDistribution)secItem.getValue()).getSecAcc(), (PortfolioAccountDistribution)secItem.getValue());
                }
            }
        }
    }

    private void filterEmptyPortfolio() {
        Iterator iterator = this.root.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeItem next = (TreeItem)iterator.next();
            if (next.getChildren().size() != 0) continue;
            iterator.remove();
        }
    }

    public void selectedPortf(Portfolio portf) {
        if (portf == null || this.selectedPortf == portf) {
            return;
        }
        this.selectedPortf = portf;
        Map map = this.portfMng.getMap(portf);
        this.selectedFund = (CcsFundAccount)map.keySet().iterator().next();
        boolean xshg = true;
        boolean xshe = true;
        for (SecAccount sec : (List)map.get(this.selectedFund)) {
            String market = sec.getExchange().getRaw();
            if (xshg && "XSHG".equals(market)) {
                this.secXshg = sec;
                xshg = false;
            }
            if (!xshe || !"XSHE".equals(market)) continue;
            this.secXshe = sec;
            xshe = false;
        }
        this.reset();
    }

    public void selectedCapital(Portfolio portf, CcsFundAccount fund, SecAccount xshg, SecAccount xshe) {
        this.selectedPortf = portf;
        this.selectedFund = fund;
        this.secXshg = xshg;
        this.secXshe = xshe;
    }

    @Override
    public void reset() {
        boolean selected;
        for (PortfolioAccountDistribution dist : this.mapPortf.values()) {
            selected = dist.getPortfolio().equals((Object)this.selectedPortf);
            dist.setSelected(selected);
        }
        for (PortfolioAccountDistribution dist : this.mapFund.values()) {
            selected = dist.getAcc().equals((Object)this.selectedFund);
            dist.setSelected(selected);
        }
        for (PortfolioAccountDistribution dist : this.mapSec.values()) {
            SecAccount sec = dist.getSecAcc();
            boolean selected2 = sec.equals((Object)this.secXshe) || dist.getSecAcc().equals((Object)this.secXshg);
            dist.setSelected(selected2);
        }
    }

    public boolean checkCapital(double money) {
        double available = this.selectedFund.getAvailable();
        return available > money;
    }

    public TreeItem<PortfolioAccountDistribution> getRoot() {
        return this.root;
    }

    public List<Portfolio> getListPortf() {
        return this.listPortf;
    }

    public Portfolio getSelectedPortf() {
        return this.selectedPortf;
    }

    @Override
    public CcsFundAccount getSelectedFund() {
        return this.selectedFund;
    }

    @Override
    public SecAccount getSelectedSec(String market) {
        if ("XSHG".equals(market)) {
            return this.secXshg;
        }
        if ("XSHE".equals(market)) {
            return this.secXshe;
        }
        return null;
    }

    public InstrPortfoBsktDistributionModel getPortfDistModel() {
        return this.portfDistModel;
    }
}

