/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.adjust;

import cms.tmx.core.MException;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.PInstruction;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.instructions.models.adjust.CcsAdjPosAlgoModel;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.utils.DateTimeUtils;
import cms.tmx.utils.StringUtils;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsAdjPosAlgoInstructModel
extends CcsAdjPosAlgoModel {
    private Map<String, String> extAccProductMap = new HashMap<String, String>();
    private AtomicInteger cfmPacks = new AtomicInteger(0);
    private AtomicInteger packIndex = new AtomicInteger(1);
    private MException exception = null;
    private String uuid = "";
    private String instructionId = "";
    private static final int maxWaitTime = 10000;
    public static final int FIRST_SETP_ID = 1;
    private double amount;
    @Inject
    protected IAccountService accountService;
    @Inject
    public InstructionAccountModel instrAccModel;
    @Inject
    protected InstructionModel insModel;

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (this.insModel.getList().getList().isEmpty()) {
            this.insModel.query();
        }
    }

    private void initAtomic() {
        this.uuid = UUID.randomUUID().toString();
        this.packIndex = new AtomicInteger(1);
        this.cfmPacks = new AtomicInteger(0);
        this.exception = null;
    }

    @Override
    public String submit() throws MException {
        List<BasketAlgoItem> list = this.getAdjustItems();
        if (list.isEmpty()) {
            return "";
        }
        this.setProduct();
        this.setWorkflow();
        this.setItemAccount();
        this.initAtomic();
        long startTime = System.currentTimeMillis();
        PBase.Fragment fragment = this.baseApi.getFragment(list.size());
        int index = 0;
        while (this.packIndex.intValue() <= fragment.getTotalFragNum()) {
            int endIndex = index + 150 > fragment.getTotalDataNum() ? fragment.getTotalDataNum() - 1 : index + 150 - 1;
            List<BasketAlgoItem> fragOrderList = list.subList(index, endIndex + 1);
            this.exe.execute(() -> {
                try {
                    this.fragmentSubmit(fragOrderList, fragment);
                }
                catch (MException e) {
                    this.exception = e;
                }
            });
            index += 150;
            this.packIndex.getAndIncrement();
        }
        while (this.cfmPacks.intValue() < fragment.getTotalFragNum()) {
            if (this.exception != null) {
                throw this.exception;
            }
            if (System.currentTimeMillis() - startTime <= 10000L) continue;
            throw new MException(-1, "\u8d85\u65f6");
        }
        if (!StringUtils.isEmpty((String)this.instructionId)) {
            this.insApi.submitInstruction(this.instructionId, "");
        }
        this.setAlgoParam(null);
        return this.instructionId;
    }

    private void setProduct() throws MException {
        CcsFundAccount acc = this.capitalModel.getSelectedFund();
        if (StringUtils.isEmpty((String)this.extAccProductMap.get(acc.getExtAccntId()))) {
            Account accnt = this.accountService.getAccountFromCache(acc.getParentId());
            String productId = accnt.getProductId();
            this.extAccProductMap.put(acc.getExtAccntId(), productId);
        }
        this.setProductId(this.extAccProductMap.get(acc.getExtAccntId()));
    }

    private void setWorkflow() {
        CcsFundAccount acc = this.capitalModel.getSelectedFund();
        List stepList = this.instrAccModel.getWorkflow(acc.getParentId()).getSteps();
        if (stepList != null && !stepList.isEmpty()) {
            for (AccntStepAttribute step : stepList) {
                if (1 != step.getStepId()) continue;
                this.setFlowAttriId(step.getFlowAttriId());
                this.setStepAttrId(step.getStepAttriId());
                break;
            }
        }
    }

    private void fragmentSubmit(List<BasketAlgoItem> list, PBase.Fragment fragment) throws MException {
        PInstruction.Instruction.Builder insb = PInstruction.Instruction.newBuilder();
        insb.setName(this.getBasketName());
        insb.setPortfolioId(this.getPortfolioId());
        insb.setProductId(this.getProductId());
        insb.setStepAttrId(this.getStepAttrId());
        insb.setFlowAttrId(this.getFlowAttriId());
        insb.setType(PInstruction.InstructionType.INST_TYPE_ADJ_POS_ALGO.getNumber());
        Any any = this.buildAny(list);
        insb.setDetails(any);
        insb.setEstimatedOrderAmount(this.amount);
        int actionId = this.getActionId();
        if (StringUtils.isEmpty((String)"")) {
            insb.setExpireDate(DateTimeUtils.getDate());
        }
        this.instructionId = this.insApi.newInstruction(insb.build(), fragment, this.uuid, actionId);
        this.cfmPacks.getAndIncrement();
    }

    public Any buildAny(List<BasketAlgoItem> fragOrderList) {
        return this.buildBasketOrderAdvice(fragOrderList);
    }

    private Any buildBasketOrderAdvice(List<BasketAlgoItem> fragOrderList) {
        PInstruction.AdjustPosAlgoOrderAdvice.Builder advice = PInstruction.AdjustPosAlgoOrderAdvice.newBuilder();
        advice.setAdjMethodValue(Integer.parseInt(this.getAdjType().getRaw()));
        advice.setStrategyTypeValue(Integer.parseInt(this.getAdjWay().getRaw()));
        if ("1".equals(this.getAdjWay().getRaw())) {
            advice.setStrategyValue(this.getCountBsk());
        } else if ("2".equals(this.getAdjWay().getRaw())) {
            advice.setStrategyValue(this.getMoneyStg());
        } else if ("7".equals(this.getAdjWay().getRaw())) {
            advice.setStrategyValue(this.getPctStg());
        }
        advice.setAdjScaleValue(1);
        CcsFundAccount fund = this.capitalModel.getSelectedFund();
        advice.setInvestorId(fund.getInvestId());
        advice.setShgSecAccntId(this.capitalModel.getSelectedSec("XSHG").getInverstorSecId());
        advice.setSheSecAccntId(this.capitalModel.getSelectedSec("XSHE").getInverstorSecId());
        advice.setBasketId(this.basket == null ? "" : this.basket.getId());
        advice.setBasketName(this.basket == null ? "" : this.basket.getName());
        PAlgorithmTrade.AdjustPosParam.Builder param = PAlgorithmTrade.AdjustPosParam.newBuilder();
        param.setStartHour(this.algoParam.getStartHour());
        param.setStartMinute(this.algoParam.getStartMinute());
        param.setEndHour(this.algoParam.getEndHour());
        param.setEndMinute(this.algoParam.getEndMinute());
        param.setTimeSliceCount(this.algoParam.getSlice());
        param.setOrderDepth(this.algoParam.getDepth());
        param.setSweepRatio(this.algoParam.getPercentDepth());
        param.setWithdrawInterval(this.algoParam.getDelay());
        advice.setAlgorithmParam(Any.pack((Message)param.build()));
        advice.setMoneyControl(this.controlMoney);
        if (this.controlMoney) {
            advice.setMoneyControlValue(this.money);
        }
        advice.setImpactControl(this.controlImpact);
        if (this.controlImpact) {
            advice.setImpactControlValue(this.percent);
        }
        this.amount = 0.0;
        for (BasketAlgoItem item : fragOrderList) {
            PInstruction.AdjustPosSecInst.Builder inst = PInstruction.AdjustPosSecInst.newBuilder();
            inst.setExtAccntId(item.getExtAccntId());
            inst.setExtSecAccntId(item.getExtSecAccntId());
            inst.setSubAccntId(item.getSubAccntId());
            inst.setSubSecAccntId(item.getSubSecAccntId());
            inst.setParentId(fund.getParentId());
            inst.setSecurityType(item.getType());
            inst.setSecurityId(item.getCode());
            inst.setSymbol(item.getName());
            inst.setMarket(item.getMarket().getRaw());
            inst.setDestPos((double)item.getDestPos());
            inst.setRelativeWeight(item.getDestWeight());
            inst.setAjustRatio(item.getStgPct());
            inst.setBuyOrderQty((double)item.getOrderQtyBuy());
            inst.setSellOrderQty((double)item.getOrderQtySell());
            inst.setBuyAmount(item.getBuyMoney());
            inst.setSellAmount(item.getSellMoney());
            inst.setAvgQtyPerDay((double)item.getDailyAvgQty());
            inst.setRemark(item.getRemark());
            inst.setEstimatedOrderAmount(item.getAmt());
            inst.setTargetMktValue(item.getTargetMktValue());
            this.amount += item.getAmt();
            advice.addAdjustPosSecInst(inst);
        }
        Any any = Any.pack((Message)advice.build());
        return any;
    }

    public void approve(Instruction instruction) throws MException {
        this.insModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
        this.setAlgoParam(null);
    }

    public String execute(Instruction instruction) throws MException {
        if (this.checkAlgoParam()) {
            this.updateInst(instruction);
        }
        this.insModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, "");
        String id = super.submit();
        this.setAlgoParam(null);
        return id;
    }

    public boolean isRunningStatusInst() {
        CcsFundAccount fund = this.getCapitalModel().getSelectedFund();
        String capitalId = fund.getInvestId();
        if (fund instanceof CcsSubFundAccount) {
            capitalId = ((CcsSubFundAccount)CcsSubFundAccount.class.cast(fund)).getSubAccntId();
        }
        return this.insModel.isRunningStatus(capitalId);
    }
}

