/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.adjust;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.instructions.models.adjust.IAdjPosAlgoCapitalModel;
import cms.tmx.instructions.models.basket.InstructionBasketDistributionModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.trade.utils.CcsAccountDistTreeList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CcsAdjPosAlgoCapitalModel
implements IAdjPosAlgoCapitalModel {
    private static final Logger logger = LogManager.getLogger(CcsAdjPosAlgoCapitalModel.class);
    @Inject
    private InstructionBasketDistributionModel instAccDistModel;
    @Inject
    private MObjFactory of;
    protected TreeItem<CcsAccountDistribution> root = new TreeItem((Object)new CcsAccountDistribution());
    private Map<CcsFundAccount, CcsAccountDistribution> mapFund = new HashMap<CcsFundAccount, CcsAccountDistribution>();
    private Map<SecAccount, CcsAccountDistribution> mapSec = new HashMap<SecAccount, CcsAccountDistribution>();
    private ObservableList<CcsFundAccount> listFund = FxUtils.newList();
    private Map<CcsFundAccount, List<SecAccount>> mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>();
    private CcsFundAccount selectedFund;
    private SecAccount secXshg;
    private SecAccount secXshe;
    protected MxTreeList<CcsAccountDistribution> accMxList;
    private final int MAP_CAP = 100;
    protected Map<String, MxTreeList<CcsAccountDistribution>> mapSecDisMxList = new HashMap<String, MxTreeList<CcsAccountDistribution>>(100);

    @Override
    public void init(String instructionPanelType) {
        try {
            this.initAcc(instructionPanelType);
            this.createTree();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void initAcc(String instructionPanelType) throws MException {
        this.instAccDistModel.setInstructPanelType(instructionPanelType);
        this.instAccDistModel.create();
        this.instAccDistModel.getAccountMap();
        Map<CcsFundAccount, List<SecAccount>> map = this.instAccDistModel.getAccountMap();
        if (map == null) {
            return;
        }
        for (CcsFundAccount fund : map.keySet()) {
            List<SecAccount> list = map.get(fund);
            if (list == null || list.isEmpty()) continue;
            this.getMapAccount().put(fund, list);
        }
    }

    public TreeItem<CcsAccountDistribution> getRoot() {
        return this.root;
    }

    public void createTree() {
        ((CcsAccountDistribution)this.root.getValue()).setSelected(true);
        LinkedList<CcsAccountDistribution> accList = new LinkedList<CcsAccountDistribution>();
        this.accMxList = new CcsAccountDistTreeList(this.root, this.root.getChildren(), accList);
        for (CcsFundAccount fundAcc : this.getMapAccount().keySet()) {
            LinkedList<CcsAccountDistribution> listSec = new LinkedList<CcsAccountDistribution>();
            for (SecAccount secAcc : this.getMapAccount().get(fundAcc)) {
                String market = secAcc.getExchange().getRaw();
                if (!"XSHE".equals(market) && !"XSHG".equals(market)) continue;
                CcsAccountDistribution secDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
                this.mapSec.put(secAcc, secDst);
                secDst.setSecAcc(secAcc);
                listSec.add(secDst);
                secDst.setIsSecAcc(true);
            }
            if (listSec.isEmpty()) continue;
            CcsAccountDistribution accDst = (CcsAccountDistribution)this.of.create(CcsAccountDistribution.class);
            accDst.setAcc(fundAcc);
            accList.add(accDst);
            this.listFund.add((Object)fundAcc);
            this.accMxList.update(accList);
            this.mapFund.put(fundAcc, accDst);
            TreeItem tiFund = (TreeItem)this.root.getChildren().get(accList.size() - 1);
            CcsAccountDistTreeList listMtSec = new CcsAccountDistTreeList(tiFund, tiFund.getChildren(), listSec);
            this.mapSecDisMxList.put(fundAcc.getExtAccntId(), (MxTreeList<CcsAccountDistribution>)listMtSec);
        }
    }

    public void selectedFund(CcsFundAccount fund) {
        if (fund == null || this.selectedFund == fund) {
            return;
        }
        this.selectedFund = fund;
        boolean xshg = true;
        boolean xshe = true;
        for (SecAccount sec : this.getMapAccount().get(fund)) {
            String market = sec.getExchange().getRaw();
            if (xshg && "XSHG".equals(market)) {
                this.secXshg = sec;
                xshg = false;
            }
            if (!xshe || !"XSHE".equals(market)) continue;
            this.secXshe = sec;
            xshe = false;
        }
        this.reset();
    }

    public void selectedCapital(CcsFundAccount fund, SecAccount xshg, SecAccount xshe) {
        this.selectedFund = fund;
        this.secXshg = xshg;
        this.secXshe = xshe;
    }

    @Override
    public void reset() {
        for (CcsAccountDistribution dist : this.mapFund.values()) {
            boolean selected = dist.getAcc().equals((Object)this.selectedFund);
            dist.setSelected(selected);
        }
        for (CcsAccountDistribution dist : this.mapSec.values()) {
            SecAccount sec = dist.getSecAcc();
            boolean selected = sec.equals((Object)this.secXshe) || dist.getSecAcc().equals((Object)this.secXshg);
            dist.setSelected(selected);
        }
    }

    public boolean checkCapital(double money) {
        double available = this.selectedFund.getAvailable();
        return available > money;
    }

    @Override
    public CcsFundAccount getSelectedFund() {
        return this.selectedFund;
    }

    public Map<CcsFundAccount, List<SecAccount>> getMapAccount() {
        return this.mapAccount;
    }

    public ObservableList<CcsFundAccount> getListFund() {
        return this.listFund;
    }

    @Override
    public SecAccount getSelectedSec(String market) {
        if ("XSHG".equals(market)) {
            return this.secXshg;
        }
        if ("XSHE".equals(market)) {
            return this.secXshe;
        }
        return null;
    }
}

