/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.models.adjust;

import cms.tmx.api.data.IRefItem;
import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IAlgoMiseTradeApi;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PInstruction;
import cms.tmx.datatype.proto.quant.PAlgorithmTrade;
import cms.tmx.datatype.proto.trade.PInstructionService;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoParam;
import cms.tmx.entity.trade.AvgQtyQueryParam;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.DailyAvgQty;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.basket.BasketItem;
import cms.tmx.entity.trade.instruction.AdjustPosAdvice;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionExec;
import cms.tmx.instructions.models.adjust.CcsAdjPosAlgoModel;
import cms.tmx.instructions.models.adjust.IAdjPosAlgoCapitalModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.mng.InstructionExecMng;
import cms.tmx.query.current.models.AlgoStrategyQueryModel;
import cms.tmx.query.current.models.PositionModel;
import cms.tmx.query.current.views.AlgoStrategyQueryPart;
import cms.tmx.query.history.IDailyAvgQtyService;
import cms.tmx.trade.models.basket.BasketMngModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AdjPosAlgoModel
extends AdjustPosAdvice {
    @Inject
    protected ExecutorService exe;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected IDailyAvgQtyService avgQtyService;
    @Inject
    protected BasketMngModel basketModel;
    @Inject
    protected IMarketDataMng mktMng;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    protected IAlgoMiseTradeApi algoApi;
    @Inject
    protected AlgoStrategyQueryModel strategyModel;
    @Inject
    protected InstructionExecMng resourceMng;
    @Inject
    protected IInstructionApi<?> insApi;
    protected static final Logger logger = LogManager.getLogger(CcsAdjPosAlgoModel.class);
    public static final String EXPLAIN = "\u8ba1\u7b97\u516c\u5f0f\u8bf4\u660e\uff1a\n\u65e5\u5747\u6210\u4ea4\u91cf= \u2211\u5f53\u65e5\u6743\u91cd*\u5f53\u65e5\u6210\u4ea4\u91cf / \u2211\u6bcf\u65e5\u6743\u91cd \uff1b\n\u6628\u65e5\u6743\u91cd\uff08T\u65e5\uff09=1 \uff1b \nT-1\u65e5\u6743\u91cd=T\u65e5\u6743\u91cd-\u9012\u51cf\u6bd4\u4f8b\uff1b\u9ed8\u8ba4\u503c0\uff0c\u8868\u793a\u6bcf\u65e5\u6743\u91cd\u76f8\u7b49";
    protected ObservableList<BasketAlgoItem> listItem = FxUtils.newList();
    protected Map<MarketItem, BasketAlgoItem> mapSub = new HashMap<MarketItem, BasketAlgoItem>();
    private transient BooleanProperty changedMkt = new SimpleBooleanProperty();
    protected AlgoParam oldAlgoParam = null;
    private AtomicLong lastTime = new AtomicLong(0L);
    @Inject
    private MEventService es;

    @PostConstruct
    public void init() {
        if (this.strategyModel.getList().isEmpty()) {
            this.strategyModel.query();
        }
    }

    public void init(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
        this.getCapitalModel().init(instructionPanelType);
    }

    protected void initPosition() {
        if (this.getPosModel().getList().isEmpty()) {
            this.exe.execute(() -> this.getPosModel().query());
        }
    }

    protected List<BasketAlgoItem> initBskItems(Basket basket) {
        HashMap<String, BasketAlgoItem> map = new HashMap<String, BasketAlgoItem>();
        if (basket != null) {
            for (BasketItem bskItem : basket.getList().stream().filter(item -> !"SHSC".equals(item.getMarket().getRaw()) && !"SZSC".equals(item.getMarket().getRaw())).collect(Collectors.toList())) {
                BasketAlgoItem item2 = new BasketAlgoItem();
                item2.setBasketItem(true);
                item2.update((Object)bskItem);
                this.updatePosition(item2);
                map.put(item2.getCode(), item2);
                if (!this.getAdjType().getRaw().equals("1")) continue;
                item2.setBs("49".equals(bskItem.getBs().getRaw()));
            }
        }
        String secXshg = this.getCapitalModel().getSelectedSec("XSHG").getExtSecAccntId();
        String secXshe = this.getCapitalModel().getSelectedSec("XSHE").getExtSecAccntId();
        if (this.getAdjType().getRaw().equals("0")) {
            for (CcsPosition pos : this.getPosList()) {
                boolean pre = this.initPosItemPre(pos);
                String secId = pos.getExtSecAccId();
                if (!pre || map.get(pos.getSecId()) != null || !secId.equals(secXshg) && !secId.equals(secXshe)) continue;
                BasketAlgoItem item3 = new BasketAlgoItem();
                item3.update((Object)pos);
                map.put(pos.getSecId(), item3);
            }
        }
        LinkedList<BasketAlgoItem> list = new LinkedList<BasketAlgoItem>();
        list.addAll(map.values());
        return list;
    }

    protected List<BasketAlgoItem> initInstItems(AdjustPosAdvice advice) {
        LinkedList<BasketAlgoItem> list = new LinkedList<BasketAlgoItem>();
        for (BasketAlgoItem baItem : advice.getItems()) {
            BasketAlgoItem item = new BasketAlgoItem();
            item.update((Object)baItem);
            this.updatePosition(item);
            list.add(item);
        }
        return list;
    }

    protected void updatePosition(BasketAlgoItem algo) {
        SecAccount secAcc = this.getCapitalModel().getSelectedSec(algo.getMarket().getRaw());
        if (secAcc != null) {
            CcsPosition pos = (CcsPosition)this.getPosModel().getPositionInMap(secAcc, algo.getCode());
            if (pos != null) {
                algo.setNowPos(pos.getTotalVol());
                algo.setCanVol(pos.getCanVol());
                algo.setCapitalization(pos.getCapitalization());
                algo.setPosExisted(true);
                return;
            }
            String inverstorId = this.getCapitalModel().getSelectedFund().getInvestId();
            String inverstorSecId = secAcc.getInverstorSecId();
            String info = String.join((CharSequence)",", inverstorId, inverstorSecId, algo.getMarket().getRaw(), algo.getCode());
            logger.info("\u672a\u83b7\u53d6\u5230\u6301\u4ed3\uff1a" + info);
        }
    }

    public void trial(Basket basket) throws MException {
        boolean isPctStg = this.getAdjWay().getRaw().equals("7");
        if (!isPctStg && basket == null) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        this.lastTime.set(nowTime);
        this.basket = basket;
        List<BasketAlgoItem> list = this.initBskItems(basket);
        this.calculate(list, nowTime);
        this.setItemAccount();
    }

    public void trial(AdjustPosAdvice advice) throws MException {
        if (advice == null || advice.getItems().isEmpty()) {
            return;
        }
        Long nowTime = System.currentTimeMillis();
        this.lastTime.set(nowTime);
        List<BasketAlgoItem> list = this.initInstItems(advice);
        this.calculateInst(list, nowTime);
    }

    private void calculateInst(List<BasketAlgoItem> list, Long nowTime) {
        this.queryMarketItem(list, false);
        for (BasketAlgoItem item : list) {
            String code;
            String market;
            String type = item.getType();
            RefItem refItem = this.refMng.getItem(type, market = item.getMarket().getRaw(), code = item.getCode());
            if (refItem != null) {
                this.calCanQtyInst(item, refItem);
                this.unsupportedCodeCheck(item, refItem);
                continue;
            }
            logger.error("\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5\uff1a" + String.join((CharSequence)",", type, market, code));
        }
        if (this.lastTime.get() == nowTime.longValue()) {
            this.listItem.setAll(list);
            this.changed();
        }
    }

    private void calCanQtyInst(BasketAlgoItem item, RefItem refItem) {
        long now = item.getNowPos();
        long dest = item.getDestPos();
        int unit = refItem.getBuyUnit();
        double p = this.percent / 100.0;
        int limitQty = (int)(p * (double)item.getDailyAvgQty()) / unit * unit;
        if (!item.isBs()) {
            unit = dest == 0L ? 1 : unit;
            Long sell = Long.valueOf(now - dest) / (long)unit * (long)unit;
            long canVol = item.getCanVol();
            if (sell > canVol) {
                sell = canVol;
            }
            if (this.controlImpact && sell > (long)limitQty) {
                sell = limitQty;
            }
            if (item.getOrderQtySell() != sell.longValue()) {
                String remark = item.getRemark();
                remark = String.valueOf(remark) + (remark.isEmpty() ? "\u6301\u4ed3\u53d8\u52a8" : ",\u6301\u4ed3\u53d8\u52a8");
                item.setRemark(remark);
            }
            item.setAdjust(true);
            item.setSelected(true);
            double volRatio = (double)item.getOrderQtySell() / (double)item.getDailyAvgQty() * 100.0;
            item.setVolRatio(this.ratioCheck(volRatio));
        } else {
            item.setBs(true);
            unit = refItem.getBuyUnit();
            Long buy = Long.valueOf(dest - now) / (long)unit * (long)unit;
            if (this.controlImpact && buy > (long)limitQty) {
                buy = limitQty;
            }
            if (item.getOrderQtyBuy() != buy.longValue()) {
                String remark = item.getRemark();
                remark = String.valueOf(remark) + (remark.isEmpty() ? "\u6301\u4ed3\u53d8\u52a8" : ",\u6301\u4ed3\u53d8\u52a8");
                item.setRemark(remark);
            }
            if (buy == 0L) {
                return;
            }
            item.setAdjust(true);
            item.setSelected(true);
            double volRatio = (double)item.getOrderQtyBuy() / (double)item.getDailyAvgQty() * 100.0;
            item.setVolRatio(this.ratioCheck(volRatio));
        }
    }

    protected void calculate(List<BasketAlgoItem> list, Long nowTime) throws MException {
        List<RefItem> listRef = this.queryMarketItem(list, true);
        Map<String, DailyAvgQty> mapAvg = this.queryAvgQty(listRef);
        for (BasketAlgoItem item : list) {
            this.updateMarketStatus(item);
            String type = item.getType();
            String market = item.getMarket().getRaw();
            String code = item.getCode();
            String key = String.join((CharSequence)",", type, market, code);
            DailyAvgQty avg = mapAvg.get(key);
            if (avg != null) {
                item.setDailyAvgQty(avg.getAvgQty());
            }
            RefItem refItem = this.refMng.getItem(type, market, code);
            this.unsupportedCodeCheck(item, refItem);
            if (refItem == null || !item.getRemark().isEmpty()) continue;
            this.calCanQty(item, refItem);
        }
        if (this.lastTime.get() == nowTime.longValue()) {
            this.listItem.setAll(list);
            this.changed();
        }
    }

    public void calCanQty(BasketAlgoItem item, RefItem refItem) {
        this.calCanQty(item, refItem, false);
    }

    public void calCanQty(BasketAlgoItem item, RefItem refItem, boolean editCommit) {
        int bondXshgUnit = 1;
        if ("BOND".equals(refItem.getType()) && "XSHG".equals(refItem.getMarket())) {
            bondXshgUnit = 10;
        }
        int unit = refItem.getBuyUnit();
        if ("2".equals(this.getAdjWay().getRaw())) {
            if (item.getNowPrice() == 0.0) {
                item.setRemark("\u4ef7\u683c\u4e3a0");
                return;
            }
            double destPos = item.getAbsWeight() / 100.0 * this.getMoneyStg() / item.getNowPrice();
            item.setDestPos((long)destPos / (long)unit * (long)unit / (long)bondXshgUnit);
            item.setTargetMktValue((double)Math.round(this.getMoneyStg() * (item.getAbsWeight() / 100.0) * 100.0) / 100.0);
        } else if ("7".equals(this.getAdjWay().getRaw())) {
            if (!editCommit) {
                item.setStgPct(this.getPctStg());
            }
            long qty = (long)((double)item.getNowPos() * item.getStgPct() / 100.0) / (long)unit * (long)unit;
            item.setDestPos(item.getNowPos() + (this.isPtcStgBuy() ? qty : -qty));
        } else if ("1".equals(this.getAdjType().getRaw())) {
            item.setDestPos(item.getNowPos() + (item.isBs() ? item.getDestPos() : -item.getDestPos()));
        }
        long now = item.getNowPos();
        long dest = item.getDestPos();
        double p = this.percent / 100.0;
        int limitQty = (int)(p * (double)item.getDailyAvgQty()) / unit * unit;
        if (now > dest) {
            item.setBs(false);
            unit = dest == 0L ? 1 : unit;
            Long sell = Long.valueOf(now - dest) / (long)unit * (long)unit;
            long canVol = item.getCanVol();
            if (sell > canVol) {
                sell = canVol;
                item.setRemark("\u53ef\u5356\u6570\u4e0d\u8db3\uff0c\u59d4\u6258\u6570\u91cf\u53d6\u53ef\u5356\u6570\u91cf");
            }
            if (this.controlImpact && sell > (long)limitQty) {
                item.setRemark("\u51b2\u51fb\u63a7\u5236\uff0c\u6570\u91cf" + sell + "\u8c03\u6574\u4e3a" + limitQty);
                sell = limitQty;
            }
            item.setOrderQtySell(sell.longValue());
            item.setSellMoney(item.getNowPrice() * (double)sell.longValue() * (double)bondXshgUnit);
            item.setAdjust(sell != 0L);
            double volRatio = (double)item.getOrderQtySell() / (double)item.getDailyAvgQty() * 100.0;
            item.setVolRatio(this.ratioCheck(volRatio));
        } else if (now < dest) {
            item.setBs(true);
            unit = refItem.getBuyUnit();
            Long buy = Long.valueOf(dest - now) / (long)unit * (long)unit;
            if (buy == 0L) {
                return;
            }
            if (this.controlImpact && buy > (long)limitQty) {
                item.setRemark("\u51b2\u51fb\u63a7\u5236\uff0c\u6570\u91cf" + buy + "\u8c03\u6574\u4e3a" + limitQty);
                buy = limitQty;
            }
            if (buy == 0L) {
                return;
            }
            item.setOrderQtyBuy(buy.longValue());
            item.setBuyMoney(item.getNowPrice() * (double)buy.longValue() * (double)bondXshgUnit);
            item.setAdjust(true);
            double volRatio = (double)item.getOrderQtyBuy() / (double)item.getDailyAvgQty() * 100.0;
            item.setVolRatio(this.ratioCheck(volRatio));
        }
        if (editCommit) {
            if (now == dest) {
                item.setOrderQtyBuy(0L);
                item.setBuyMoney(0.0);
                item.setOrderQtySell(0L);
                item.setSellMoney(0.0);
                item.setAdjust(false);
            }
            item.setSelected(item.isAdjust());
        }
    }

    private String ratioCheck(double ratio) {
        if (ratio == 0.0) {
            return "";
        }
        return ratio < 0.01 ? "<0.01" : StringUtils.toStr((double)ratio, (int)2);
    }

    private void updateMarketStatus(BasketAlgoItem algo) {
        String code;
        String market;
        String type = algo.getType();
        RefItem ref = this.refMng.getItem(type, market = algo.getMarket().getRaw(), code = algo.getCode());
        if (ref == null) {
            algo.setSupportedCode(false);
            algo.setRemark("\u4ee3\u7801\u4e0d\u5b58\u5728");
            return;
        }
        MarketItem mkt = this.mktMng.getInfo((IRefItem)ref);
        if (mkt == null) {
            return;
        }
        algo.setNowPrice(this.getMktNowPrice(mkt));
        if (mkt.getStop().getValue().booleanValue()) {
            algo.setSupportedCode(false);
            algo.setRemark(mkt.getStatus());
        }
    }

    private double getMktNowPrice(MarketItem mkt) {
        double nowPrice = mkt.getNowPrice() == 0.0 ? mkt.getClosePrice() : mkt.getNowPrice();
        int scale = mkt.getRefItem().getScale();
        BigDecimal bigDecimal = new BigDecimal(nowPrice);
        bigDecimal.setScale(scale, 4);
        return bigDecimal.doubleValue();
    }

    public List<RefItem> queryMarketItem(List<BasketAlgoItem> items, boolean calByMkt) {
        HashMap<RefItem, BasketAlgoItem> mapRef = new HashMap<RefItem, BasketAlgoItem>();
        LinkedList<RefItem> list = new LinkedList<RefItem>();
        for (BasketAlgoItem item : items) {
            String code;
            String market;
            String type = item.getType();
            RefItem ref2 = this.refMng.getItem(type, market = item.getMarket().getRaw(), code = item.getCode());
            if (ref2 == null) continue;
            list.add(ref2);
            mapRef.put(ref2, item);
        }
        Gears gears = new Gears();
        this.mktMng.query(list, gears);
        list.forEach(ref -> ((BasketAlgoItem)mapRef.get(ref)).setNowPrice(this.getMktNowPrice(this.mktMng.getInfo((IRefItem)ref))));
        return list;
    }

    private void addMarketListener(Map<RefItem, BasketAlgoItem> mapNow, Collection<MarketItem> c, boolean calByMkt) {
        c.forEach(mkt -> {
            BasketAlgoItem old = this.mapSub.get(mkt);
            if (old == null) {
                mkt.changedProperty().addListener(ob -> {
                    BasketAlgoItem now = this.mapSub.get(mkt);
                    if (now == null) {
                        return;
                    }
                    Platform.runLater(() -> {
                        now.setNowPrice(this.getMktNowPrice((MarketItem)mkt));
                        if (calByMkt && "2".equals(this.getAdjWay().getRaw()) && now.isSupportedCode()) {
                            this.calCanQty(now, mkt.getRefItem());
                            this.changedMkt();
                        }
                    });
                });
            }
            BasketAlgoItem now = (BasketAlgoItem)mapNow.get(mkt.getRefItem());
            this.mapSub.put((MarketItem)mkt, now);
        });
    }

    private Map<String, DailyAvgQty> queryAvgQty(List<RefItem> listRef) throws MException {
        AvgQtyQueryParam param = new AvgQtyQueryParam();
        param.setMarketGrp("CCS");
        param.setDayNum(20);
        param.setWeightType(2);
        param.setWeight(10);
        param.setItems(listRef);
        Map mapAvg = this.avgQtyService.query(param);
        return mapAvg;
    }

    public List<BasketAlgoItem> getAdjustItems() {
        LinkedList<BasketAlgoItem> list = new LinkedList<BasketAlgoItem>();
        for (BasketAlgoItem item : this.listItem) {
            if (!item.isAdjust() || !item.isSelected()) continue;
            list.add(item);
        }
        return list;
    }

    public boolean isRunningStatus() {
        CcsFundAccount fund = this.getCapitalModel().getSelectedFund();
        String capitalId = fund.getInvestId();
        if (fund instanceof CcsSubFundAccount) {
            capitalId = ((CcsSubFundAccount)CcsSubFundAccount.class.cast(fund)).getSubAccntId();
        }
        return this.strategyModel.isRunningStatus(capitalId);
    }

    public ObservableList<BasketAlgoItem> getItems() {
        return this.listItem;
    }

    public void clear() {
        this.listItem.clear();
        this.mapSub.clear();
    }

    private void unsupportedCodeCheck(BasketAlgoItem item, RefItem refItem) {
    }

    public void fillAdjItems(Instruction instruction) throws MException {
        AdjustPosAdvice adjAdvice = instruction.getAdjustPosAdvice();
        List exeList = adjAdvice.getExes();
        if (exeList.isEmpty()) {
            exeList = this.resourceMng.query(instruction, 2, "");
        }
        Map<String, InstructionExec> exeMap = exeList.stream().collect(Collectors.toMap(e -> e.getSecId(), e -> e));
        for (BasketAlgoItem item : adjAdvice.getItems()) {
            InstructionExec exec = exeMap.get(item.getCode());
            item.setAvailOrderQty(exec.getAvailableQty());
            item.setCount(item.isBs(), (int)item.getAvailOrderQty());
        }
    }

    public void updateInst(Instruction instruction) throws MException {
        PInstructionService.UpdateInstructionReq.Builder reqBud = PInstructionService.UpdateInstructionReq.newBuilder();
        reqBud.setInstructionId(instruction.getId());
        PInstruction.AdjustPosAlgoOrderAdvice.Builder advice = PInstruction.AdjustPosAlgoOrderAdvice.newBuilder();
        PAlgorithmTrade.AdjustPosParam.Builder param = PAlgorithmTrade.AdjustPosParam.newBuilder();
        param.setStartHour(this.algoParam.getStartHour());
        param.setStartMinute(this.algoParam.getStartMinute());
        param.setEndHour(this.algoParam.getEndHour());
        param.setEndMinute(this.algoParam.getEndMinute());
        param.setTimeSliceCount(this.algoParam.getSlice());
        param.setOrderDepth(this.algoParam.getDepth());
        param.setSweepRatio(this.algoParam.getPercentDepth());
        param.setWithdrawInterval(this.algoParam.getDelay());
        advice.setAlgorithmParam(Any.pack((Message)param.build()));
        Any any = Any.pack((Message)advice.build());
        PInstruction.Instruction.Builder insbud = PInstruction.Instruction.newBuilder();
        insbud.setDetails(any);
        reqBud.setInstruction(insbud);
        PInstructionService.UpdateAdviceParam.Builder uap = PInstructionService.UpdateAdviceParam.newBuilder();
        LinkedList<PInstructionService.UpdateAdviceParam> list = new LinkedList<PInstructionService.UpdateAdviceParam>();
        list.add(uap.build());
        reqBud.setUpdateScope(1);
        this.insApi.updateInstructionReq(reqBud);
    }

    protected boolean checkAlgoParam() {
        if (this.algoParam.getStartHour() != this.oldAlgoParam.getStartHour()) {
            return true;
        }
        if (this.algoParam.getEndHour() != this.oldAlgoParam.getEndHour()) {
            return true;
        }
        if (this.algoParam.getStartMinute() != this.oldAlgoParam.getStartMinute()) {
            return true;
        }
        if (this.algoParam.getEndMinute() != this.oldAlgoParam.getEndMinute()) {
            return true;
        }
        if (this.algoParam.getSlice() != this.oldAlgoParam.getSlice()) {
            return true;
        }
        if (this.algoParam.getDepth() != this.oldAlgoParam.getDepth()) {
            return true;
        }
        if (this.algoParam.getPercentDepth() != this.oldAlgoParam.getPercentDepth()) {
            return true;
        }
        return this.algoParam.getDelay() != this.oldAlgoParam.getDelay();
    }

    protected abstract String submit() throws MException;

    public void setInstAlgoParam(AlgoParam param) {
        this.oldAlgoParam = new AlgoParam();
        this.oldAlgoParam.update((Object)param);
        this.setAlgoParam(param);
    }

    public AlgoParam getAlgoParam() {
        return this.algoParam;
    }

    public void setControlMoney(boolean control) {
        this.controlMoney = control;
    }

    public void setControlImpact(boolean control) {
        this.controlImpact = control;
    }

    public boolean checkMoney(double money) {
        this.money = money;
        double available = this.getCapitalModel().getSelectedFund().getAvailable();
        return available >= money;
    }

    public void setPercent(double percent) {
        this.percent = percent;
    }

    protected JsonElement packGatewayData(String ... strs) {
        String str = String.join((CharSequence)"#", strs);
        JsonPrimitive json = new JsonPrimitive(str);
        return json;
    }

    public void changedMkt() {
        this.changedMkt.set(!this.changedMkt.get());
    }

    public BooleanProperty changedMktProperty() {
        return this.changedMkt;
    }

    protected void refreshStragety() {
        this.es.sendEvent(AlgoStrategyQueryPart.class.getName(), null);
    }

    protected abstract PositionModel<?> getPosModel();

    protected abstract List<CcsPosition> getPosList();

    public abstract IAdjPosAlgoCapitalModel getCapitalModel();

    protected abstract boolean initPosItemPre(CcsPosition var1);

    public boolean isRepo() {
        for (BasketAlgoItem item : this.listItem) {
            if (!item.isAdjust() || item.getType().equals("REPO")) continue;
            return false;
        }
        return true;
    }

    public abstract void setItemAccount();
}

