/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.viewers;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.BsDict;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.TaskLog;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.instruction.dto.ConfirmExecutionReq;
import cms.tmx.instructions.http.viewers.InstructionOtcFundBasePart;
import cms.tmx.instructions.http.viewers.InstructionOtcFundConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionOtcFundConfirmPart
extends InstructionOtcFundBasePart {
    private static final Logger logger = LogManager.getLogger(InstructionOtcFundConfirmPart.class);
    @FXML
    private HBox hBoxUnitCost;
    @FXML
    private HBox hBoxConfirmQty;
    @FXML
    private HBox hBoxConfirmAmt;
    @FXML
    private HBox hBoxConfirmFee;
    @FXML
    private HBox hBoxQtyConfirmDate;
    @FXML
    private HBox hBoxRedeemConfirmDate;
    @FXML
    private HBox hBoxConfirmBonusAmt;
    @FXML
    private HBox hBoxConfirmBonusQty;
    @FXML
    private HBox hBoxBonusConfirmDate;
    @FXML
    private HBox hBoxConfirmProvistonQty;
    @FXML
    private HBox hBoxProvistonConfirmDate;
    @FXML
    private TextField txtUnitCost;
    @FXML
    private TextField txtConfirmQty;
    @FXML
    private TextField txtConfirmAmt;
    @FXML
    private TextField txtConfirmFee;
    @FXML
    private TextField txtConfirmBonusAmt;
    @FXML
    private TextField txtConfirmBonusQty;
    @FXML
    private DatePicker qtyConfirmDate;
    @FXML
    private DatePicker redeemConfirmDate;
    @FXML
    private DatePicker bonusConfirmDate;
    @FXML
    private DatePicker provistonConfirmDate;
    @FXML
    private Button btnConfirm;
    @FXML
    private Label txtConfirmAmtMag;
    @FXML
    private Label txtConfirmQtyMag;
    @FXML
    private Label txtConfirmFeeMag;
    @FXML
    private Label txtConfirmBonusAmtMag;
    @FXML
    private Label txtConfirmBonusQtyMag;
    @Inject
    private NewInstructionModel insModel;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private WorkflowTemplateApi workflowApi;
    protected Map<String, List<Node>> confirmPanelMap = new HashMap<String, List<Node>>();
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObInstruction)) {
            return;
        }
        ObInstruction ins = (ObInstruction)ObInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        if (this.initFinished.get()) {
            this.clearInfo();
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.partType = "PART_TYPE_CONFIRM";
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        CssUtils.addStyleClass((Control)this.btnConfirm, (String)"btnRed");
        this.hBoxOtcTradePart.getChildren().clear();
        this.hBoxOtcTradePart.getChildren().add((Object)this.vBoxInsPart);
        this.hBoxOtcTradePart.getChildren().add((Object)this.vBoxConfirmPart);
        this.hBoxOtcTradePart.getChildren().add((Object)this.vBoxUploadPart);
        this.initComponentMap();
        super.initialize();
        this.controlComponent();
        this.initFinished.set(true);
        this.txtInterest.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.doFill();
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnConfirm.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    @Override
    protected void submitOrder() {
    }

    @Override
    @FXML
    protected void confirm() {
        if (this.instruction == null) {
            return;
        }
        try {
            this.check();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        if (!this.confirmAgain()) {
            return;
        }
        try {
            this.confirmTrade();
            this.recordLog();
        }
        catch (MException e) {
            if (e.getCode() == 100071) {
                try {
                    this.confirmWorkflow();
                }
                catch (MException me) {
                    logger.error("\u7c3f\u8bb0\u786e\u8ba4\u5df2\u63d0\u4ea4\uff0c\u4f46\u6307\u4ee4\u6d41\u8f6c\u5931\u8d25", (Throwable)me);
                    this.alert.alert(Alert.AlertType.ERROR, "\u7c3f\u8bb0\u786e\u8ba4\u5df2\u63d0\u4ea4\uff0c\u4f46\u6307\u4ee4\u6d41\u8f6c\u5931\u8d25");
                    return;
                }
                this.clearInfo();
                this.alert.alert(Alert.AlertType.INFORMATION, "\u7c3f\u8bb0\u786e\u8ba4\u6210\u529f");
                return;
            }
            logger.error("\u7c3f\u8bb0\u786e\u8ba4\u63d0\u4ea4\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u7c3f\u8bb0\u786e\u8ba4\u63d0\u4ea4\u5931\u8d25 " + e.getMessage());
            return;
        }
        try {
            this.confirmWorkflow();
        }
        catch (MException e) {
            logger.error("\u7c3f\u8bb0\u786e\u8ba4\u63d0\u4ea4\u6307\u4ee4\u6d41\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u7c3f\u8bb0\u786e\u8ba4\u63d0\u4ea4\u6307\u4ee4\u6d41\u5931\u8d25 " + e.getMessage());
            return;
        }
        this.clearInfo();
        this.alert.alert(Alert.AlertType.INFORMATION, "\u7c3f\u8bb0\u786e\u8ba4\u6210\u529f");
    }

    private void recordLog() throws MException {
        TaskLog log = new TaskLog();
        List workflowTasks = this.instruction.getWorkflowTasks();
        Iterator iterator = workflowTasks.iterator();
        if (iterator.hasNext()) {
            WorkflowTask workflowTask = (WorkflowTask)iterator.next();
            cms.tmx.entity.web.workflow.Node node = workflowTask.getNode();
            if (node.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_EXECUTE.actionId)) {
                log.setNodeId(node.getNodeId());
                log.setNodeName(node.getNodeName());
            } else {
                return;
            }
        }
        log.setWorkflowId(this.instruction.getEntryId());
        log.setOpUser(this.baseApi.getUserId());
        log.setOperate(WorkflowOptEnum.NEW_WORKFLOW_EXECUTE.actionId);
        this.workflowApi.recordTaskLog(log);
    }

    private boolean confirmAgain() {
        InstructionOtcFundConfirmDialog obj = (InstructionOtcFundConfirmDialog)((Object)this.of.create(InstructionOtcFundConfirmDialog.class));
        Execution execution = this.getExecution();
        switch (this.panelType) {
            case "REDEEM": 
            case "CREATION_BUY": 
            case "SUBSCRIBE_BUY": {
                execution.setLastAmount(StringUtils.parseDouble((String)this.txtConfirmAmt.getText(), (int)2));
                break;
            }
        }
        obj.setSide((String)BsDict.NEW_INSTRUCTION_SIDE_MAP.get(execution.getSide().name()));
        obj.setUnitCost(StringUtils.toStr((double)execution.getLastPx(), (int)4));
        obj.setConfirmAmt(StringUtils.toStr((double)execution.getLastAmount(), (int)2));
        obj.setConfirmFee(StringUtils.toStr((double)execution.getExecFee(), (int)2));
        obj.setConfirmQty(StringUtils.toStr((double)execution.getLastQty(), (int)2));
        obj.setConfirmDate(execution.getExecDate());
        MxDialog dialog = this.df.create((DialogObj)obj, "\u518d\u6b21\u786e\u8ba4");
        ButtonType launch = dialog.launch();
        return launch.equals(ButtonType.OK);
    }

    private void confirmTrade() throws MException {
        ConfirmExecutionReq confirmReq = new ConfirmExecutionReq();
        confirmReq.setMarketGroup("OTC");
        Execution execution = this.getExecution();
        ArrayList<WorkflowAttachment> confirmAttachments = new ArrayList<WorkflowAttachment>();
        for (WorkflowAttachment workflowAttachment : this.attachmentList) {
            if (!"confirmation".equals(workflowAttachment.getType())) continue;
            confirmAttachments.add(workflowAttachment);
        }
        execution.setAttachment(this.gson.toJson(confirmAttachments));
        confirmReq.setExecution(execution);
        this.insModel.confirmExecution(confirmReq);
    }

    private Execution getExecution() {
        Execution execution = new Execution();
        execution.setInstructionId(this.instruction.getId());
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                execution.setSide(Side.SIDE_SUBSCRIBE);
                execution.setLastPx(StringUtils.parseDouble((String)this.txtUnitCost.getText()));
                execution.setLastQty(StringUtils.parseDouble((String)this.txtConfirmQty.getText()));
                execution.setLastAmount(StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecFee(StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecDate(((LocalDate)this.qtyConfirmDate.getValue()).toString().replaceAll("-", ""));
                execution.setInterest(StringUtils.parseDouble((String)this.txtInterest.getText()));
                break;
            }
            case "CREATION_BUY": {
                execution.setSide(Side.SIDE_CREATION);
                execution.setLastPx(StringUtils.parseDouble((String)this.txtUnitCost.getText()));
                execution.setLastQty(StringUtils.parseDouble((String)this.txtConfirmQty.getText()));
                execution.setLastAmount(StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecFee(StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecDate(((LocalDate)this.qtyConfirmDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "REDEEM": {
                execution.setSide(Side.SIDE_REDEEM);
                execution.setLastPx(StringUtils.parseDouble((String)this.txtUnitCost.getText()));
                execution.setLastQty(StringUtils.parseDouble((String)this.txtConfirmQty.getText()));
                execution.setLastAmount(StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) + StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecFee(StringUtils.parseDouble((String)this.txtConfirmFee.getText()));
                execution.setExecDate(((LocalDate)this.redeemConfirmDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "BONUS_CASH": {
                execution.setSide(Side.SIDE_CASH_DIVIDEND);
                execution.setLastPx(this.instruction.getOtcOrderDetail().getPrice());
                execution.setLastAmount(StringUtils.parseDouble((String)this.txtConfirmBonusAmt.getText()));
                execution.setExecDate(((LocalDate)this.bonusConfirmDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "BONUS_INVEST": {
                execution.setSide(Side.SIDE_DIVIDEND_REINVEST);
                execution.setLastPx(this.instruction.getOtcOrderDetail().getPrice());
                execution.setLastQty(StringUtils.parseDouble((String)this.txtConfirmBonusQty.getText()));
                execution.setExecDate(((LocalDate)this.bonusConfirmDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "PROVISTON": {
                execution.setSide(Side.SIDE_PROVISTON);
                execution.setLastPx(this.instruction.getOtcOrderDetail().getPrice());
                execution.setLastQty(StringUtils.parseDouble((String)this.txtConfirmProvistonQty.getText()));
                execution.setExecDate(((LocalDate)this.provistonConfirmDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
        }
        return execution;
    }

    private void confirmWorkflow() throws MException {
        WorkflowTask task = null;
        List workflowTasks = this.instruction.getWorkflowTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            if (!workflowTask.getPermissibleList().contains("4")) continue;
            task = workflowTask;
        }
        this.insModel.confirm(this.instruction, "4", task, (List)this.attachmentList);
    }

    private void calAmount(String ol, String newV) {
        if (ol.equals(newV)) {
            return;
        }
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                this.txtConfirmAmt.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmQty.getText(), (int)2) * StringUtils.parseDouble((String)this.txtUnitCost.getText(), (int)4) + StringUtils.parseDouble((String)this.txtConfirmFee.getText(), (int)2)), (int)2));
                this.txtInterest.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmAmt.getText(), (int)2) - StringUtils.parseDouble((String)this.confirmedBuyAmt.getText(), (int)2) - StringUtils.parseDouble((String)this.txtConfirmFee.getText(), (int)2)), (int)2));
                break;
            }
            case "CREATION_BUY": {
                this.txtConfirmAmt.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmQty.getText(), (int)2) * StringUtils.parseDouble((String)this.txtUnitCost.getText(), (int)4) + StringUtils.parseDouble((String)this.txtConfirmFee.getText(), (int)2)), (int)2));
                break;
            }
            case "REDEEM": {
                this.txtConfirmAmt.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmQty.getText(), (int)2) * StringUtils.parseDouble((String)this.txtUnitCost.getText(), (int)4) - StringUtils.parseDouble((String)this.txtConfirmFee.getText(), (int)2)), (int)2));
                break;
            }
            case "BONUS_CASH": 
            case "BONUS_INVEST": {
                this.txtConfirmAmt.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmQty.getText(), (int)2) * StringUtils.parseDouble((String)this.txtUnitCost.getText(), (int)4)), (int)2));
                break;
            }
        }
    }

    private void calOthers() {
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                this.txtInterest.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.txtConfirmAmt.getText(), (int)2) - StringUtils.parseDouble((String)this.confirmedBuyAmt.getText(), (int)2) - StringUtils.parseDouble((String)this.txtConfirmFee.getText(), (int)2)), (int)2));
                break;
            }
        }
    }

    @Override
    protected void check() throws MException {
        if (this.instruction == null) {
            throw new MException(1, "\u8bf7\u56de\u586b\u6307\u4ee4");
        }
        if ("SUBSCRIBE_BUY".equals(this.panelType) || "CREATION_BUY".equals(this.panelType)) {
            ArrayList<WorkflowAttachment> confirmAttachments = new ArrayList<WorkflowAttachment>();
            for (WorkflowAttachment workflowAttachment : this.attachmentList) {
                if (!"confirmation".equals(workflowAttachment.getType())) continue;
                confirmAttachments.add(workflowAttachment);
            }
            if (confirmAttachments.size() == 0) {
                throw new MException(1, "\u8bf7\u4e0a\u4f20\u4efd\u989d\u786e\u8ba4\u4e66");
            }
        }
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                if (StringUtils.parseDouble((String)this.txtUnitCost.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5355\u4f4d\u51c0\u503c");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u4efd\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u91d1\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmFee.getText()) < 0.0) {
                    throw new MException(1, "\u8d39\u7528\u4e0d\u53ef\u4e3a\u8d1f");
                }
                if (this.qtyConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u4efd\u989d\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtInterest.getText()) > this.instruction.getOtcOrderDetail().getOrderAmount()) {
                    throw new MException(1, "\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u7533\u8d2d/\u8ba4\u8d2d\u91d1\u989d");
                }
                if (((LocalDate)this.qtyConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) < 0) {
                    throw new MException(1, "\u4efd\u989d\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u4ea4\u6613\u65e5\u671f");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtConfirmFee.getText()) <= 0.0) {
                    throw new MException(1, "\u8ba4\u8d2d\u7684\u7c3f\u8bb0\u91d1\u989d \u9700\u8981 \u5927\u4e8e \u8d39\u7528");
                }
                if (!(StringUtils.parseDouble((String)this.confirmedBuyAmt.getText()) + StringUtils.parseDouble((String)this.txtInterest.getText()) - StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) < 0.0)) break;
                throw new MException(1, "\u8ba4\u8d2d\u91d1\u989d+\u5229\u606f-\u8d39\u7528\u9700\u8981\u4e0d\u5c0f\u4e8e \u91d1\u989d");
            }
            case "CREATION_BUY": {
                if (StringUtils.parseDouble((String)this.txtUnitCost.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5355\u4f4d\u51c0\u503c");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u4efd\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u91d1\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmFee.getText()) < 0.0) {
                    throw new MException(1, "\u8d39\u7528\u4e0d\u53ef\u4e3a\u8d1f");
                }
                if (this.qtyConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u4efd\u989d\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtInterest.getText()) > this.instruction.getOtcOrderDetail().getOrderAmount()) {
                    throw new MException(1, "\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u7533\u8d2d/\u8ba4\u8d2d\u91d1\u989d");
                }
                if (((LocalDate)this.qtyConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) < 0) {
                    throw new MException(1, "\u4efd\u989d\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u4ea4\u6613\u65e5\u671f");
                }
                if (!(StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) - StringUtils.parseDouble((String)this.txtConfirmFee.getText()) <= 0.0)) break;
                throw new MException(1, "\u7533\u8d2d\u7684\u7c3f\u8bb0\u91d1\u989d \u9700\u8981 \u5927\u4e8e \u8d39\u7528");
            }
            case "REDEEM": {
                if (StringUtils.parseDouble((String)this.txtUnitCost.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5355\u4f4d\u51c0\u503c");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u4efd\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u91d1\u989d");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmFee.getText()) < 0.0) {
                    throw new MException(1, "\u8d39\u7528\u4e0d\u53ef\u4e3a\u8d1f");
                }
                if (this.redeemConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u8d4e\u56de\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmQty.getText()) > this.instruction.getOtcOrderDetail().getOrderQty()) {
                    throw new MException(1, "\u4efd\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u8d4e\u56de\u4efd\u989d");
                }
                if (((LocalDate)this.redeemConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) >= 0) break;
                throw new MException(1, "\u8d4e\u56de\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u4ea4\u6613\u65e5\u671f");
            }
            case "BONUS_CASH": {
                if (StringUtils.parseDouble((String)this.txtConfirmBonusAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5206\u7ea2\u91d1\u989d");
                }
                if (this.bonusConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmBonusAmt.getText()) > this.instruction.getOtcOrderDetail().getOrderAmount()) {
                    throw new MException(1, "\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u5206\u7ea2\u91d1\u989d");
                }
                if (((LocalDate)this.bonusConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) >= 0) break;
                throw new MException(1, "\u5206\u7ea2\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u5206\u7ea2\u65e5\u671f");
            }
            case "BONUS_INVEST": {
                if (StringUtils.parseDouble((String)this.txtConfirmBonusQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5206\u7ea2\u4efd\u989d");
                }
                if (this.bonusConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmBonusQty.getText()) > this.instruction.getOtcOrderDetail().getOrderQty()) {
                    throw new MException(1, "\u4efd\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u5206\u7ea2\u4efd\u989d");
                }
                if (((LocalDate)this.bonusConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) >= 0) break;
                throw new MException(1, "\u5206\u7ea2\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u5206\u7ea2\u65e5\u671f");
            }
            case "PROVISTON": {
                if (StringUtils.parseDouble((String)this.txtConfirmProvistonQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u63d0\u53d6\u4efd\u989d");
                }
                if (this.provistonConfirmDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u53d6\u786e\u8ba4\u65e5");
                }
                if (StringUtils.parseDouble((String)this.txtConfirmProvistonQty.getText()) > this.instruction.getOtcOrderDetail().getOrderQty()) {
                    throw new MException(1, "\u4efd\u989d\u4e0d\u80fd\u5927\u4e8e\u6307\u4ee4\u63d0\u53d6\u4efd\u989d");
                }
                if (((LocalDate)this.provistonConfirmDate.getValue()).toString().replaceAll("-", "").compareTo(this.instruction.getOtcOrderDetail().getTradeDate()) >= 0) break;
                throw new MException(1, "\u5206\u7ea2\u786e\u8ba4\u65e5\u4e0d\u5f97\u65e9\u4e8e\u5206\u7ea2\u65e5\u671f");
            }
        }
    }

    @Override
    protected void clearInfo() {
        super.clearInfo();
        this.instruction = null;
        this.btnConfirm.setDisable(true);
        this.tradeDate.getEditor().setText("");
        this.tradeDate.setValue(null);
        this.bonusDate.getEditor().setText("");
        this.bonusDate.setValue(null);
        this.txtUnitCost.setText(null);
        this.txtConfirmQty.setText(null);
        this.txtConfirmFee.setText(null);
        this.txtConfirmAmt.setText(null);
        this.txtConfirmBonusAmt.setText(null);
        this.txtConfirmBonusQty.setText(null);
        this.qtyConfirmDate.getEditor().setText("");
        this.qtyConfirmDate.setValue(null);
        this.redeemConfirmDate.getEditor().setText("");
        this.redeemConfirmDate.setValue(null);
        this.bonusConfirmDate.getEditor().setText("");
        this.bonusConfirmDate.setValue(null);
    }

    private void initComponentMap() {
        List<Node> confirmedBuyHBoxs = Arrays.asList(this.hBoxUnitCost, this.hBoxConfirmQty, this.hBoxConfirmAmt, this.hBoxInterest, this.hBoxConfirmFee, this.hBoxQtyConfirmDate, this.btnConfirm);
        List<Node> creationBuyhboxs = Arrays.asList(this.hBoxUnitCost, this.hBoxConfirmQty, this.hBoxConfirmAmt, this.hBoxConfirmFee, this.hBoxQtyConfirmDate, this.btnConfirm);
        List<Node> redeemHBoxs = Arrays.asList(this.hBoxUnitCost, this.hBoxConfirmQty, this.hBoxConfirmAmt, this.hBoxConfirmFee, this.hBoxRedeemConfirmDate, this.btnConfirm);
        List<Node> bonusCashHBoxs = Arrays.asList(this.hBoxConfirmBonusAmt, this.hBoxBonusConfirmDate, this.btnConfirm);
        List<Node> bonusInvestHBoxs = Arrays.asList(this.hBoxConfirmBonusQty, this.hBoxBonusConfirmDate, this.btnConfirm);
        List<Node> provistonBoxs = Arrays.asList(this.hBoxConfirmProvistonQty, this.hBoxProvistonConfirmDate, this.btnConfirm);
        this.confirmPanelMap.put("SUBSCRIBE_BUY", confirmedBuyHBoxs);
        this.confirmPanelMap.put("CREATION_BUY", creationBuyhboxs);
        this.confirmPanelMap.put("REDEEM", redeemHBoxs);
        this.confirmPanelMap.put("BONUS_CASH", bonusCashHBoxs);
        this.confirmPanelMap.put("BONUS_INVEST", bonusInvestHBoxs);
        this.confirmPanelMap.put("PROVISTON", provistonBoxs);
        this.vBoxConfirmPart.getChildren().setAll(confirmedBuyHBoxs);
    }

    private void controlComponent() {
        this.txtUnitCost.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(4), null, (UnaryOperator)new DoubleFilter(true, 3, 4)));
        this.txtConfirmQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.txtConfirmAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtConfirmFee.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtConfirmBonusAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtConfirmBonusQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.txtConfirmProvistonQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        TextFieldUtils.showMagnitude((Label)this.txtConfirmAmtMag, (TextField)this.txtConfirmAmt);
        TextFieldUtils.showMagnitude((Label)this.txtConfirmQtyMag, (TextField)this.txtConfirmQty);
        TextFieldUtils.showMagnitude((Label)this.txtConfirmFeeMag, (TextField)this.txtConfirmFee);
        TextFieldUtils.showMagnitude((Label)this.txtConfirmBonusAmtMag, (TextField)this.txtConfirmBonusAmt);
        TextFieldUtils.showMagnitude((Label)this.txtConfirmBonusQtyMag, (TextField)this.txtConfirmBonusQty);
        this.qtyConfirmDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.redeemConfirmDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.bonusConfirmDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.provistonConfirmDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.qtyConfirmDate.setEditable(false);
        this.redeemConfirmDate.setEditable(false);
        this.bonusConfirmDate.setEditable(false);
        this.provistonConfirmDate.setEditable(false);
        this.btnOrder.setVisible(false);
        this.cmbPortfolio.setDisable(true);
        this.txtCode.setDisable(true);
        this.lbName.setDisable(true);
        this.confirmedBuyAmt.setDisable(true);
        this.appliedBuyAmt.setDisable(true);
        this.redeemQty.setDisable(true);
        this.bonusAmt.setDisable(true);
        this.bonusQty.setDisable(true);
        this.tradeDate.setDisable(true);
        this.redeemDate.setDisable(true);
        this.bonusDate.setDisable(true);
        this.cmbSide.setDisable(true);
        this.cmbBonusType.setDisable(true);
        this.cmbCounterParty.setDisable(true);
        this.lbBankAcc.setDisable(true);
        this.lbSetAcc.setDisable(true);
        this.cmbTradePlatform.setDisable(true);
        this.lbConfirmation.setVisible(true);
        this.hbConfirmation.setVisible(true);
        this.personCode.disableProperty().unbind();
        this.personCode.setDisable(true);
        this.txtTargetCode.setDisable(true);
        this.txtConfirmAmt.textProperty().addListener(ob -> this.calOthers());
        this.txtUnitCost.textProperty().addListener((ob, ol, newv) -> this.calAmount((String)ol, (String)newv));
        this.txtConfirmQty.textProperty().addListener((ob, ol, newv) -> this.calAmount((String)ol, (String)newv));
        this.txtConfirmFee.textProperty().addListener((ob, ol, newv) -> this.calAmount((String)ol, (String)newv));
    }

    @Override
    protected void reloadComponent() {
        if (this.cmbSide.getValue() == null) {
            return;
        }
        switch (((MxNode)this.cmbSide.getValue()).getRaw()) {
            case "1": {
                this.panelType = "SUBSCRIBE_BUY";
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "0": {
                this.panelType = "CREATION_BUY";
                this.canBuyCol.setVisible(true);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "2": {
                this.panelType = "REDEEM";
                this.lbQty.setText("\u8d4e\u56de\u4efd\u989d");
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                break;
            }
            case "3": {
                if (this.cmbBonusType.getValue() == null) {
                    this.cmbBonusType.getSelectionModel().select(0);
                }
                this.panelType = "0".equals(((MxNode)this.cmbBonusType.getValue()).getRaw()) ? "BONUS_CASH" : "BONUS_INVEST";
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "4": {
                this.panelType = "TRANSFER";
                this.lbQty.setText("\u8f6c\u6362\u4efd\u989d");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().add(4, (Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().add(5, (Object)this.targetNameHbox);
                break;
            }
            case "5": {
                this.panelType = "PROVISTON";
                this.btnOrder.setText("\u4e1a\u7ee9\u8ba1\u63d0");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) break;
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                break;
            }
        }
        this.componentBox.getChildren().setAll((Collection)this.panelMap.get(this.panelType));
        this.vBoxConfirmPart.getChildren().setAll((Collection)this.confirmPanelMap.get(this.panelType));
        this.layout();
        this.changeTable();
        Platform.runLater(() -> {
            this.componentBox.requestFocus();
            this.vBoxConfirmPart.requestFocus();
            if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() != null) {
                this.reloadByTradeCouter((String)this.cmbTradePlatform.getSelectionModel().getSelectedItem());
            }
        });
    }

    private boolean validOrderFill(ObInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"FundDetail"}) && ins.getIsOrderStep();
    }
}

