/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.viewers;

import cms.tmx.api.mng.IAssetGrpApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.dialog.MxFastWebDialog;
import cms.tmx.control.dialog.MxFileChooser;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.formatters.DoubleFilter;
import cms.tmx.control.formatters.DoubleStrConverter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.datatype.proto.assetgroup.PAssetgroupService;
import cms.tmx.define.BsDict;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.data.OtcRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.trade.instruction.RiskMonitor;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateReq;
import cms.tmx.entity.web.workflow.GetWorkflowTemplateResp;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowBusinessType;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.Party;
import cms.tmx.http.api.strategy.dto.PartySub;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.calendar.api.CalendarServiceApi;
import cms.tmx.http.calendar.dto.GetBusinessDateReq;
import cms.tmx.http.calendar.dto.GetBusinessDateResp;
import cms.tmx.http.data.FundInfo;
import cms.tmx.http.data.MaintenanceServiceApi;
import cms.tmx.http.data.Valuation;
import cms.tmx.http.data.dto.UpdateSecurityReq;
import cms.tmx.http.instruction.api.QuotaServiceApi;
import cms.tmx.http.instruction.api.QuotaSettingsServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.GetQuotaDetailReq;
import cms.tmx.http.instruction.dto.GetQuotaValueReq;
import cms.tmx.http.instruction.dto.GetThresholdListReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.instruction.dto.OtcOrderDetail;
import cms.tmx.http.instruction.dto.Quota;
import cms.tmx.http.instruction.dto.QuotaValue;
import cms.tmx.http.security.dto.FundParams;
import cms.tmx.http.security.dto.Security;
import cms.tmx.http.statement.api.OtcQueryProductReq;
import cms.tmx.http.statement.api.OtcSignProductReq;
import cms.tmx.http.statement.api.RouterServiceApi;
import cms.tmx.http.valuation.api.EvaluationServiceApi;
import cms.tmx.http.valuation.dto.GetValuationReq;
import cms.tmx.http.valuation.dto.PutValuationReq;
import cms.tmx.http.workflow.dto.CounterPartyAccount;
import cms.tmx.instructions.http.models.InstructionOtcFundAccSetModel;
import cms.tmx.instructions.http.models.InstructionOtcFundBaseModel;
import cms.tmx.instructions.http.viewers.InstructionOtcAccSetDialog;
import cms.tmx.instructions.http.viewers.OtcFundDetailDialog;
import cms.tmx.instructions.models.regular.InstructionCcsBaseModel;
import cms.tmx.instructions.utils.CounterPartyConverter;
import cms.tmx.instructions.utils.CounterPartySuggest;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.jxb.FastWebBrowserPart;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.CounterPartyMngService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.current.views.BankAccntSelectDialog;
import cms.tmx.query.current.views.InstructionOtcFundDialog;
import cms.tmx.query.otc.models.OtcMarketPositionModel;
import cms.tmx.rights.IUiRightService;
import cms.tmx.trade.api.ITradeModel;
import cms.tmx.trade.api.ITradePart;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cms.tmx.web.api.workflow.WorkflowTemplateApi;
import cmx.tmx.data.INewRefMng;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import okhttp3.Response;

public class InstructionOtcFundBasePart
extends MxPart
implements ITradePart {
    @FXML
    protected ComboBox<Portfolio> cmbPortfolio;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    protected Button btnOrder;
    @FXML
    protected TextField confirmedBuyAmt;
    @FXML
    protected TextField appliedBuyAmt;
    @FXML
    protected TextField redeemQty;
    @FXML
    protected TextField redeemAmt;
    @FXML
    protected TextField bonusAmt;
    @FXML
    protected TextField bonusQty;
    @FXML
    protected DatePicker tradeDate;
    @FXML
    protected DatePicker redeemDate;
    @FXML
    protected DatePicker bonusDate;
    @FXML
    protected ComboBox<MxNode> cmbSide;
    @FXML
    protected ComboBox<MxNode> cmbBonusType;
    @FXML
    protected ComboBox<String> cmbTradePlatform;
    @FXML
    protected ComboBox<CounterPartyAccount> cmbCounterParty;
    @FXML
    protected Label lbBankAcc;
    @FXML
    protected Label lbOA;
    @FXML
    protected Label lbContract;
    @FXML
    protected Label lbConfirmation;
    @FXML
    protected HBox hbOA;
    @FXML
    protected HBox hbContract;
    @FXML
    protected HBox hbConfirmation;
    @FXML
    protected Label lbFileOA;
    @FXML
    protected Label lbFileContract;
    @FXML
    protected Label lbFileConfirmation;
    @FXML
    protected Label lbFileScaleAttachment;
    @FXML
    protected Label lbUploadOA;
    @FXML
    protected Label lbUploadContract;
    @FXML
    protected Label lbUploadScaleAttachment;
    @FXML
    protected Label lbUploadConfirmation;
    @FXML
    protected HBox hBoxOtcTradePart;
    @FXML
    protected VBox vBoxInsPart;
    @FXML
    protected VBox vBoxConfirmPart;
    @FXML
    protected VBox vBoxUploadPart;
    @FXML
    protected VBox componentBox;
    @FXML
    protected VBox hbAccntTree;
    @FXML
    protected VBox hbUpload;
    @FXML
    protected VBox hbMonitoring;
    @FXML
    protected HBox hBoxConfirmedBuyAmt;
    @FXML
    protected HBox hBoxAppliedBuyAmt;
    @FXML
    protected HBox hBoxTradeDate;
    @FXML
    protected HBox hBoxRedeemDate;
    @FXML
    protected HBox hBoxRedeemQty;
    @FXML
    protected HBox hBoxBonusDate;
    @FXML
    protected HBox hBoxBonusType;
    @FXML
    protected HBox hBoxBonusAmt;
    @FXML
    protected HBox hBoxBonusQty;
    @FXML
    protected HBox hBoxCounterParty;
    @FXML
    protected HBox hBoxOrderBtn;
    @FXML
    protected HBox hBoxRedeemAmt;
    @FXML
    protected Label lbSetAcc;
    @FXML
    protected Label lbQty;
    @FXML
    protected Label bonusQtyMag;
    @FXML
    protected Label bonusAmtMag;
    @FXML
    protected Label redeemQtyMag;
    @FXML
    protected Label redeemAmtMag;
    @FXML
    protected Label appliedBuyAmtMag;
    @FXML
    protected Label confirmedBuyAmtMag;
    @FXML
    protected Label lbTrialRefresh;
    @FXML
    protected TableView<RiskMonitor> tableTrial;
    @FXML
    protected TableColumn<RiskMonitor, String> colObjName;
    @FXML
    protected TableColumn<RiskMonitor, String> colObjType;
    @FXML
    protected TableColumn<RiskMonitor, String> colNowValue;
    @FXML
    protected TableColumn<RiskMonitor, String> colIndexName;
    @FXML
    protected TableColumn<RiskMonitor, String> colDeptAuthor;
    @FXML
    protected TableColumn<RiskMonitor, String> colCompAuthor;
    @FXML
    protected Label lbssuer;
    @FXML
    protected Label lbScale;
    @FXML
    protected Label lbOpenDay;
    @FXML
    protected ComboBox<String> cmbInvested;
    @FXML
    protected ComboBox<MxNode> cmbMethod;
    @FXML
    protected TextField txtNewUnitCost;
    @FXML
    protected TextField txtNewScale;
    @FXML
    protected TextField txtParentFundSize;
    @FXML
    protected Label lbUpdateFoundWay;
    @FXML
    protected Label lbUpdateValuation;
    @FXML
    protected Label lbCancelValuation;
    @FXML
    protected Label lbCancelFoundWay;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, Portfolio> portfolioCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, String> secAcctCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, Number> availableCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, Number> amountCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, Number> canBuyCol;
    @FXML
    protected TableColumn<PortfolioAccountDistribution, Number> canSellCol;
    @FXML
    protected TableView<PortfolioAccountDistribution> portfolioTreeTable;
    @FXML
    protected VBox vBoxTip;
    @FXML
    protected Label lbTipOne;
    @FXML
    protected Label lbTipTwo;
    @FXML
    protected Label lbTipThree;
    @FXML
    protected Label lbTipFour;
    @FXML
    protected Label lbTipFive;
    @FXML
    protected CheckBox checkBoxAgreement;
    @FXML
    protected HBox hBoxAgreement;
    @FXML
    protected HBox hbScaleAttachment;
    @FXML
    protected HBox hbOperate;
    @FXML
    protected HBox hbOne;
    @FXML
    protected HBox hBoxPersonCode;
    @FXML
    protected TextField personCode;
    @FXML
    protected HBox targetCodeHbox;
    @FXML
    protected HBox targetNameHbox;
    @FXML
    protected Label lbTargetName;
    @FXML
    protected TextField txtTargetCode;
    @FXML
    protected HBox hBoxInterest;
    @FXML
    protected TextField txtInterest;
    @FXML
    protected HBox hBoxProvistonDate;
    @FXML
    protected HBox hBoxProvistonType;
    @FXML
    protected HBox hBoxProvistonQty;
    @FXML
    protected DatePicker provistonDate;
    @FXML
    protected ComboBox<String> cmbProvistonType;
    @FXML
    protected TextField provistonQty;
    @FXML
    protected TextField txtConfirmProvistonQty;
    @Inject
    protected CalendarServiceApi calendarApi;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    protected INewRefMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MObjFactory of;
    @Inject
    protected OtcPortfolioAccountModel portfolioModel;
    @Inject
    protected DialogFactory df;
    @Inject
    protected UserPreOrderTips setTips;
    @Inject
    protected WorkflowTemplateApi workflowTemplateApi;
    @Inject
    protected CounterPartyMngService cpService;
    @Inject
    protected InstructionOtcFundBaseModel otcModel;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    protected MxFileChooser fileChooser;
    @Inject
    protected EvaluationServiceApi valuationApi;
    @Inject
    protected IUiRightService rightsModel;
    @Inject
    protected InstructionOtcFundAccSetModel accSetModel;
    @Inject
    protected OtcMarketPositionModel posModel;
    @Inject
    protected RouterServiceApi routerApi;
    protected static final String PART_TYPE_INSTRUCTION = "PART_TYPE_INSTRUCTION";
    protected static final String PART_TYPE_APPROVE = "PART_TYPE_APPROVE";
    protected static final String PART_TYPE_CONFIRM = "PART_TYPE_CONFIRM";
    protected static final String SUBSCRIBE_BUY = "SUBSCRIBE_BUY";
    protected static final String CREATION_BUY = "CREATION_BUY";
    protected static final String REDEEM = "REDEEM";
    protected static final String BONUS_CASH = "BONUS_CASH";
    protected static final String BONUS_INVEST = "BONUS_INVEST";
    protected static final String TRANSFER = "TRANSFER";
    protected static final String PROVISTON = "PROVISTON";
    protected static final String SELL = "\u76f4\u9500";
    protected static final String HCJK = "\u6c47\u6210\u91d1\u79d1";
    protected static final String FOCUS = "\u4e00\u6237\u901a";
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected static final HashMap<String, String> PANEL_SIDE_MAP = new HashMap<String, String>(5){
        protected static final long serialVersionUID = 1L;
        {
            this.put(InstructionOtcFundBasePart.CREATION_BUY, Side.SIDE_CREATION.getValue());
            this.put(InstructionOtcFundBasePart.REDEEM, Side.SIDE_REDEEM.getValue());
            this.put(InstructionOtcFundBasePart.SUBSCRIBE_BUY, Side.SIDE_SUBSCRIBE.getValue());
            this.put(InstructionOtcFundBasePart.BONUS_CASH, Side.SIDE_CASH_DIVIDEND.getValue());
            this.put(InstructionOtcFundBasePart.BONUS_INVEST, Side.SIDE_DIVIDEND_REINVEST.getValue());
            this.put(InstructionOtcFundBasePart.TRANSFER, Side.SIDE_TRANSFER.getValue());
            this.put(InstructionOtcFundBasePart.PROVISTON, Side.SIDE_PROVISTON.getValue());
        }
    };
    protected static final List<String> listInvested = Arrays.asList("\u80a1\u7968\u578b", "\u503a\u5238\u578b", "\u8d27\u5e01\u578b", "\u6df7\u5408\u578b", "FOF", "\u5176\u4ed6\u578b");
    protected String partType = "PART_TYPE_INSTRUCTION";
    protected String confirmSymbol = "";
    protected String panelType = "";
    protected SecConverter secCvt;
    protected boolean priceSettle = false;
    protected Map<String, List<Node>> panelMap = new HashMap<String, List<Node>>();
    protected Map<String, List<CcsOrder>> map;
    protected CcsSubFundAccount subFund;
    protected String subFundAcc = "";
    protected String subSecAcc = "";
    protected Gson gson = new Gson();
    protected SecSuggest spCode = new SecSuggest(true);
    protected CounterPartySuggest cpSuggest = CounterPartySuggest.getCounterPartySuggest();
    protected ObInstruction instruction = null;
    protected AtomicBoolean initFinished = new AtomicBoolean(false);
    protected AutoCompletion<RefItem> autoCompletionNormal;
    protected AutoCompletion<RefItem> autoCompletionNormalTarget;
    protected MxNode sideNode = MxNodeFactory.createNew((String)"otc_side");
    protected ObservableList<WorkflowAttachment> attachmentList = FxUtils.newList();
    protected ObservableList<WorkflowAttachment> fundSizeAttachmentList = FxUtils.newList();
    protected ObservableList<RiskMonitor> trialList = FxUtils.newList();
    protected MxList<PortfolioAccountDistribution> mlist = new MxList();
    protected RefItem refItem = null;
    protected RefItem refItemTarget = null;
    protected Valuation valuation;
    protected final String FUND_SIZE_TYPE = "fundScaleAttachment";
    protected double price = 0.0;
    protected double priceTarget = 0.0;
    protected boolean gs = false;
    protected boolean jg = false;
    protected BooleanProperty canUpdate = new SimpleBooleanProperty(false);
    protected MEventHandler hSetPst = event -> {
        RefItem refItem;
        if (!PART_TYPE_INSTRUCTION.equals(this.partType)) {
            return;
        }
        this.txtCode.setText(event.getStr("posCode"));
        if (this.cmbCounterParty.getItems().size() == 0) {
            this.getCounterBanks();
        }
        for (CounterPartyAccount party : this.cmbCounterParty.getItems()) {
            if (!party.getCounterParty().getId().equals(event.getStr("posCounterpartyId"))) continue;
            this.cmbCounterParty.getSelectionModel().select((Object)party);
        }
        this.refItem = refItem = this.refMng.getItem(event.getStr("posSecType"), event.getStr("posSecMarket"), event.getStr("posCode"));
        this.doChange(refItem, event.getStr("posCode"));
    };
    protected InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    protected String BOOK_FOUR = "http://www.newone.com.cn/pagecontroller/one?id=43220&blank=1";
    protected String BOOK_FIVE = "https://www.newone.com.cn/public/contract/jycptzrfxgzs_20170623.html";
    @Inject
    protected MConfService cs;
    protected String buySymbol = "\u4e70\u5165";
    protected String sellSymbol = "\u5356\u51fa";
    protected Map<String, Boolean> signMap = new HashMap<String, Boolean>();
    @Inject
    protected HttpClientService https;
    protected static final String DELETE = "  \u5220\u9664";
    protected static final String ADD = "+\u9644\u4ef6";
    @Inject
    protected QuotaServiceApi quotaApi;
    @Inject
    protected QuotaSettingsServiceApi quotaSetApi;
    protected Map<String, CcsSubFundAccount> mapTrial = new HashMap<String, CcsSubFundAccount>();
    @Inject
    protected AccountMngServiceImpl accountMng;
    @Inject
    protected FundAccountMngServiceImpl fundAccMng;
    @Inject
    protected IAssetGrpApi grpAai;
    @Inject
    protected AssetGrpMngServiceImpl grpService;
    @Inject
    protected PortfolioAccountModel portAccModel;
    @Inject
    protected ProductMngServiceImpl pmng;
    @Inject
    protected MaintenanceServiceApi maintenanceApi;

    @Inject
    public InstructionOtcFundBasePart() {
    }

    public void onShowEvent(MEvent event) {
    }

    @PreDestroy
    protected void close() {
        this.refMng.changedProperty().removeListener(this.listener);
        this.es.unSubscribe("otc.panel.set.code", this.hSetPst);
    }

    @FXML
    public void initialize() {
        this.exe.execute(() -> this.initAcc());
        this.exe.execute(() -> this.initCounterParty());
        this.initType();
        this.initValue();
        this.initLis();
        this.initControls();
        this.subscribe();
        this.createTable();
        this.initByRights();
    }

    private void initType() {
        this.gs = this.rightsModel.registerCheck(new String[]{"cms.tmx.instructions.part.otc.gs"});
        this.jg = this.rightsModel.registerCheck(new String[]{"cms.tmx.instructions.part.otc.jg"});
    }

    protected void initByRights() {
        if (this.jg && this.gs) {
            this.vBoxUploadPart.getChildren().remove((Object)this.hbUpload);
            this.vBoxUploadPart.getChildren().remove((Object)this.hbMonitoring);
        } else if (this.jg && !this.gs) {
            this.vBoxUploadPart.getChildren().remove((Object)this.hbUpload);
            this.vBoxUploadPart.getChildren().remove((Object)this.hbMonitoring);
        } else if (!this.jg && this.gs) {
            this.vBoxUploadPart.getChildren().remove((Object)this.hbAccntTree);
        } else if (!this.jg && !this.gs) {
            this.vBoxUploadPart.setVisible(false);
        }
        if (this.jg) {
            this.createAcctTree();
            this.portfolioModel.changedProperty().addListener((ob, old, newV) -> this.changeTable());
        }
    }

    protected void subscribe() {
        this.es.subscribe("otc.panel.set.code", this.hSetPst);
        this.es.subscribe("otc_ref_new", event -> {
            if (event.getObj() instanceof RefItem) {
                this.spCode.addPossibleSuggestions((Object[])new RefItem[]{(RefItem)RefItem.class.cast(event.getObj())});
            }
            this.doChange(this.refItem, this.refItem == null ? "" : this.refItem.getCode());
        });
        this.es.subscribe("otc_ref_delete", event -> {
            if (event.getObj() instanceof RefItem) {
                RefItem delRef = (RefItem)RefItem.class.cast(event.getObj());
                if (this.refItem != null && delRef.getCode().equals(this.refItem.getCode())) {
                    Platform.runLater(() -> {
                        this.txtCode.setUserData(null);
                        this.onSecurityChange(this.txtCode, "");
                    });
                }
                if (this.refItemTarget != null && delRef.getCode().equals(this.refItemTarget.getCode())) {
                    Platform.runLater(() -> {
                        this.txtTargetCode.setUserData(null);
                        this.onSecurityChangeTarget(this.txtTargetCode, "");
                    });
                }
                this.spCode.removePossibleSuggestions((Object)delRef);
            }
        });
        this.es.subscribe("counterparty_create", event -> {
            if (event.getObj() instanceof CounterPartyAccount) {
                this.cpSuggest.addPossibleSuggestions(new CounterPartyAccount[]{(CounterPartyAccount)CounterPartyAccount.class.cast(event.getObj())});
            }
        });
        this.es.subscribe("counterparty_delete", event -> {
            if (event.getObj() instanceof CounterPartyAccount) {
                CounterPartyAccount cp = (CounterPartyAccount)CounterPartyAccount.class.cast(event.getObj());
                if (this.cmbCounterParty.getValue() == cp) {
                    this.cmbCounterParty.getSelectionModel().clearSelection();
                }
                this.cpSuggest.removePossibleSuggestions(cp);
            }
        });
        this.posModel.changedProperty().addListener((ob, olv, ne) -> this.changeTable());
    }

    protected synchronized void changeTable() {
        if (!this.jg) {
            return;
        }
        Portfolio portfolio = (Portfolio)this.cmbPortfolio.getSelectionModel().getSelectedItem();
        if (portfolio == null || this.refItem == null || this.cmbSide.getValue() == null) {
            this.mlist.clear();
            return;
        }
        Portfolio realPortfolio = this.portfolioModel.getPortfolio(portfolio.getId(), "OTC");
        PortfolioAccountDistribution p = new PortfolioAccountDistribution();
        p.setPortfolio(realPortfolio);
        p.setAcc((CcsFundAccount)this.subFund);
        p.setInvestorSecId(this.portfolioModel.getSubSecAccountByIdAndMarket(this.subSecAcc, "XOTC") == null ? "" : this.portfolioModel.getSubSecAccountByIdAndMarket(this.subSecAcc, "XOTC").getInverstorSecId());
        double available = realPortfolio.getAvailable();
        double newUnitCost = StringUtils.parseDouble((String)this.txtNewUnitCost.getText());
        switch (((MxNode)this.cmbSide.getValue()).getRaw()) {
            case "1": {
                if (newUnitCost != 0.0) {
                    double subscribePrice = StringUtils.parseDouble((String)this.confirmedBuyAmt.getText());
                    p.setCountDouble(subscribePrice / newUnitCost);
                    break;
                }
                p.setCountDouble(0.0);
                break;
            }
            case "0": {
                if (newUnitCost != 0.0) {
                    p.setCanBuy(new BigDecimal(available / newUnitCost).longValue());
                } else {
                    p.setCanBuy(0L);
                }
                if (newUnitCost != 0.0) {
                    double creationPrice = StringUtils.parseDouble((String)this.appliedBuyAmt.getText());
                    p.setCountDouble(creationPrice / newUnitCost);
                    break;
                }
                p.setCountDouble(0.0);
                break;
            }
            case "2": 
            case "4": {
                if (this.refItem != null) {
                    String key = String.valueOf(realPortfolio.getId()) + "," + this.refItem.getCode();
                    Double balance = this.posModel.getBalance(key);
                    p.setCanSellDouble(balance == null ? 0.0 : balance);
                }
                p.setCountDouble(StringUtils.parseDouble((String)this.redeemQty.getText()));
                break;
            }
        }
        Platform.runLater(() -> {
            if (this.mlist.getList().size() == 1) {
                ((PortfolioAccountDistribution)this.mlist.getList().get(0)).updateThis(p);
            } else {
                this.mlist.add((MxObject)p);
            }
            this.portfolioTreeTable.refresh();
        });
    }

    protected void afterTableRestore() {
        this.canBuyCol.setVisible(true);
        this.canSellCol.setVisible(false);
    }

    protected void createAcctTree() {
        this.portfolioCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).portfolioProperty());
        this.accountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).accProperty());
        this.secAcctCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).investorSecIdProperty());
        this.availableCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).getPortfolio().availableProperty());
        this.amountCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).countDoubleProperty());
        this.canBuyCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((PortfolioAccountDistribution)data.getValue()).canSellDoubleProperty());
        this.availableCol.setCellFactory(p -> new DoubleTableCell());
        this.canBuyCol.setCellFactory(data -> new NumberTableCell());
        this.canSellCol.setCellFactory(p -> new EditTableCell(2));
        this.canSellCol.setEditable(false);
        this.amountCol.setCellFactory(p -> new EditTableCell(2));
        this.amountCol.setEditable(false);
        this.portfolioTreeTable.setItems(this.mlist.getList());
        this.portfolioTreeTable.setPlaceholder((Node)new Label());
        this.availableCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemRefresh);
        this.portfolioTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.changeTable());
        TableUtils.orgnizeClmWidth(this.portfolioTreeTable);
    }

    protected void showOrHideHBox(boolean show) {
        this.hbScaleAttachment.setVisible(show);
        this.hbOperate.setVisible(show);
        this.hbOne.setVisible(show);
    }

    protected void initCounterParty() {
        this.lbBankAcc.setTooltip(new Tooltip());
        if (!this.getCounterBanks()) {
            return;
        }
        ArrayList counterparties = new ArrayList(this.cmbCounterParty.getItems());
        HashMap<String, CounterPartyAccount> cpMap = new HashMap<String, CounterPartyAccount>();
        for (CounterPartyAccount apAcc : counterparties) {
            if (apAcc.getCounterParty() == null) continue;
            cpMap.put(apAcc.toString(), apAcc);
        }
        Platform.runLater(() -> this.cmbCounterParty.setEditable(true));
        CounterPartyConverter conver = new CounterPartyConverter(cpMap);
        this.cmbCounterParty.setConverter(conver);
        this.cpSuggest.addPossibleSuggestions(counterparties);
        Search.bindAutoCompletion((TextField)this.cmbCounterParty.getEditor(), (Callback)this.cpSuggest, conver).changedProperty().addListener((ob, oldV, newV) -> {
            if (this.cmbCounterParty.getUserData() != null) {
                this.cmbCounterParty.setValue((Object)((CounterPartyAccount)this.cmbCounterParty.getUserData()));
            }
        });
        this.cmbCounterParty.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null || newV.getAccountNo().isEmpty()) {
                this.lbBankAcc.setVisible(false);
            } else {
                this.lbBankAcc.setVisible(true);
                this.lbBankAcc.getTooltip().setText((String)newV.getAccountNo().get(0));
                newV.setSelectedAccNO((String)newV.getAccountNo().get(0));
            }
        });
        this.lbBankAcc.setOnMouseClicked(event -> {
            if (this.cmbCounterParty.getValue() == null) {
                return;
            }
            BankAccntSelectDialog obj = (BankAccntSelectDialog)this.of.create(BankAccntSelectDialog.class);
            obj.setPartyAccount((CounterPartyAccount)this.cmbCounterParty.getValue());
            MxDialog dialog = this.df.create((DialogObj)obj, "\u94f6\u884c\u5361\u53f7\u9009\u62e9");
            ButtonType bt = dialog.launch();
            if (bt.equals(ButtonType.OK)) {
                this.lbBankAcc.getTooltip().setText(((CounterPartyAccount)this.cmbCounterParty.getValue()).getSelectedAccNO());
            }
        });
        if (this.instruction != null) {
            for (CounterPartyAccount party : this.cmbCounterParty.getItems()) {
                if (!party.getCounterParty().getId().equals(this.instruction.getOtcOrderDetail().getParty().getPartyId())) continue;
                if (this.instruction.getOtcOrderDetail().getParty().getPartySub().size() > 0) {
                    party.setSelectedAccNO(((PartySub)this.instruction.getOtcOrderDetail().getParty().getPartySub().get(0)).getPartySubId());
                }
                this.cmbCounterParty.getSelectionModel().select((Object)party);
            }
        }
    }

    protected boolean getCounterBanks() {
        this.cmbCounterParty.getItems().setAll((Collection)this.cpService.getCounterBanks());
        return true;
    }

    protected void initAcc() {
        ArrayList<Portfolio> portfolioList = new ArrayList<Portfolio>(this.portfolioModel.getPortfolios());
        portfolioList.removeIf(portfolio -> this.portfolioModel.getMap(portfolio) == null || this.portfolioModel.getMap(portfolio).isEmpty());
        Tooltip tooltip = new Tooltip();
        this.cmbPortfolio.setTooltip(tooltip);
        this.cmbPortfolio.getItems().setAll(portfolioList);
        this.cmbPortfolio.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.subFundAcc = "";
                this.subSecAcc = "";
                this.subFund = null;
                tooltip.setText("");
                this.cmbTradePlatform.getItems().clear();
                return;
            }
            tooltip.setText(newV.getName());
            Map accSecMap = this.portfolioModel.getMap(newV);
            for (Map.Entry entry : accSecMap.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                if (entry.getKey() instanceof CcsSubFundAccount) {
                    this.subFund = (CcsSubFundAccount)CcsSubFundAccount.class.cast(entry.getKey());
                }
                if (((List)entry.getValue()).get(0) instanceof CcsSubSecAccount) {
                    CcsSubSecAccount subSec = (CcsSubSecAccount)CcsSubSecAccount.class.cast(((List)entry.getValue()).get(0));
                    this.subFundAcc = subSec.getSubAccntId();
                    this.subSecAcc = subSec.getSubSecAccntId();
                }
                if (!StringUtils.isEmpty((String)this.subFundAcc) && !StringUtils.isEmpty((String)this.subSecAcc)) break;
            }
            this.accSetModel.setAccSecMap(accSecMap);
            this.accSetModel.setSubFundAcc(this.subFundAcc);
            this.accSetModel.setSubSecAcc(this.subSecAcc);
            this.accSetModel.fillTree();
            this.cmbTradePlatform.getItems().clear();
            for (CcsFundAccount fundAccount : accSecMap.keySet()) {
                List list;
                if ("99999-04-01".equals(fundAccount.getCounterId()) && !this.cmbTradePlatform.getItems().contains((Object)SELL)) {
                    this.cmbTradePlatform.getItems().add((Object)SELL);
                }
                if ("55555-04-01".equals(fundAccount.getCounterId()) && !this.cmbTradePlatform.getItems().contains((Object)HCJK)) {
                    this.cmbTradePlatform.getItems().add((Object)HCJK);
                }
                if (!"99999-01-01".equals(fundAccount.getCounterId()) || this.cmbTradePlatform.getItems().contains((Object)FOCUS) || (list = (List)accSecMap.get(fundAccount)) == null || list.isEmpty() || !list.stream().anyMatch(item -> "XOTC".equals(item.getExchange().getRaw()))) continue;
                this.cmbTradePlatform.getItems().add((Object)FOCUS);
            }
            if (!this.cmbTradePlatform.getItems().isEmpty()) {
                this.cmbTradePlatform.getSelectionModel().select(0);
            }
            this.trial();
            this.changeTable();
        });
        this.cmbTradePlatform.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null || newV.isEmpty()) {
                return;
            }
            this.reloadByTradeCouter((String)newV);
            this.subFund = this.accSetModel.getSubFund();
            this.subFundAcc = this.accSetModel.getSubFundAcc();
            this.subSecAcc = this.accSetModel.getSubSecAcc();
            this.changeTable();
        });
    }

    protected void hide() {
        this.vBoxTip.setVisible(false);
        this.hBoxAgreement.setVisible(false);
        this.checkBoxAgreement.setSelected(false);
        if (this.componentBox.getChildren().contains((Object)this.vBoxTip)) {
            this.componentBox.getChildren().remove((Object)this.vBoxTip);
        }
        if (this.componentBox.getChildren().contains((Object)this.hBoxAgreement)) {
            this.componentBox.getChildren().remove((Object)this.hBoxAgreement);
        }
    }

    protected void addOrRemoveSide(boolean add) {
        if (this.sideNode == null) {
            return;
        }
        if (add) {
            this.sideNode.addNode("3");
        } else {
            String oldNodeRaw = this.sideNode.getRaw();
            this.sideNode.removeNode("3");
            this.sideNode.setRaw(oldNodeRaw.equals("3") ? "0" : oldNodeRaw);
        }
        this.setSideNode(this.sideNode);
    }

    protected void addOrRemoveTransFer(boolean add) {
        if (this.sideNode == null) {
            return;
        }
        if (add) {
            this.sideNode.addNode("4");
        } else {
            String oldNodeRaw = this.sideNode.getRaw();
            this.sideNode.removeNode("4");
            this.sideNode.setRaw(oldNodeRaw.equals("4") ? "0" : oldNodeRaw);
            this.refItemTarget = null;
        }
        this.setSideNode(this.sideNode);
    }

    protected void addOrRemoveProviston(boolean add) {
        if (this.sideNode == null) {
            return;
        }
        if (add) {
            this.sideNode.addNode("5");
        } else {
            String oldNodeRaw = this.sideNode.getRaw();
            this.sideNode.removeNode("5");
            this.sideNode.setRaw(oldNodeRaw.equals("5") ? "0" : oldNodeRaw);
            if (!PART_TYPE_INSTRUCTION.equals(this.partType)) {
                this.refItemTarget = null;
            }
        }
        this.setSideNode(this.sideNode);
    }

    protected void initLis() {
        this.refMng.changedProperty().addListener(this.listener);
        this.cmbSide.valueProperty().addListener((ob, oldV, newV) -> {
            if (oldV != null && "4".equals(oldV.getRaw())) {
                this.txtTargetCode.setText("");
                this.doChange(this.refItem, this.txtCode.getText());
                this.onSecurityChange(this.txtCode, this.txtCode.getText());
                this.trial();
                this.setRefItemInfo();
                this.queryValuationInfo(true);
            } else if ("4".equals(newV.getRaw())) {
                this.txtTargetCode.setText("");
                this.lbTargetName.setText("");
                this.showRefItemInfo(false);
                this.showValuationInfo(false);
                this.priceTarget = 0.0;
                this.trialList.clear();
            }
            this.reloadComponent();
        });
        this.cmbBonusType.valueProperty().addListener(ob -> this.reloadComponent());
    }

    protected void initValue() {
        List<Object> confirmedBuyHBoxs = new LinkedList();
        List<Object> creationBuyhboxs = new LinkedList();
        if (this.jg) {
            confirmedBuyHBoxs = Arrays.asList(this.hBoxConfirmedBuyAmt, this.hBoxPersonCode, this.hBoxTradeDate, this.hBoxRedeemDate, this.hBoxCounterParty, this.hBoxOrderBtn);
            creationBuyhboxs = Arrays.asList(this.hBoxAppliedBuyAmt, this.hBoxPersonCode, this.hBoxTradeDate, this.hBoxRedeemDate, this.hBoxCounterParty, this.hBoxOrderBtn);
        } else {
            confirmedBuyHBoxs = Arrays.asList(this.hBoxConfirmedBuyAmt, this.hBoxTradeDate, this.hBoxRedeemDate, this.hBoxCounterParty, this.hBoxOrderBtn);
            creationBuyhboxs = Arrays.asList(this.hBoxAppliedBuyAmt, this.hBoxTradeDate, this.hBoxRedeemDate, this.hBoxCounterParty, this.hBoxOrderBtn);
        }
        List<Node> redeemHBoxs = Arrays.asList(this.hBoxRedeemQty, this.hBoxRedeemAmt, this.hBoxTradeDate, this.hBoxCounterParty, this.hBoxOrderBtn);
        List<Node> transferHBoxs = Arrays.asList(this.hBoxRedeemQty, this.hBoxRedeemAmt, this.hBoxTradeDate, this.hBoxCounterParty, this.hBoxOrderBtn);
        List<Node> bonusCashHBoxs = Arrays.asList(this.hBoxBonusDate, this.hBoxBonusType, this.hBoxBonusAmt, this.hBoxCounterParty, this.hBoxOrderBtn);
        List<Node> bonusInvestHBoxs = Arrays.asList(this.hBoxBonusDate, this.hBoxBonusType, this.hBoxBonusQty, this.hBoxCounterParty, this.hBoxOrderBtn);
        List<Node> provistonHBoxs = Arrays.asList(this.hBoxProvistonDate, this.hBoxProvistonType, this.hBoxProvistonQty, this.hBoxOrderBtn);
        this.panelMap.put(SUBSCRIBE_BUY, confirmedBuyHBoxs);
        this.panelMap.put(CREATION_BUY, creationBuyhboxs);
        this.panelMap.put(REDEEM, redeemHBoxs);
        this.panelMap.put(BONUS_CASH, bonusCashHBoxs);
        this.panelMap.put(BONUS_INVEST, bonusInvestHBoxs);
        this.panelMap.put(TRANSFER, transferHBoxs);
        this.panelMap.put(PROVISTON, provistonHBoxs);
        this.panelType = CREATION_BUY;
        this.componentBox.getChildren().setAll(creationBuyhboxs);
    }

    protected Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"FUND"});
    }

    protected void initControls() {
        this.lbName.setTooltip(new Tooltip());
        this.lbName.getTooltip().textProperty().bind((ObservableValue)this.lbName.textProperty());
        this.lbTargetName.setTooltip(new Tooltip());
        this.lbTargetName.getTooltip().textProperty().bind((ObservableValue)this.lbTargetName.textProperty());
        this.lbConfirmation.setVisible(false);
        this.hbConfirmation.setVisible(false);
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.lbBankAcc.setVisible(false);
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.setAllSuggestions(this.getRefItems());
        this.autoCompletionNormal = Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormalTarget = Search.bindAutoCompletion((TextField)this.txtTargetCode, (Callback)this.spCode, (StringConverter)this.secCvt);
        this.autoCompletionNormal.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange(this.txtCode, (String)newV);
            this.trial();
            this.setRefItemInfo();
            this.queryValuationInfo(true);
            this.layout();
        }));
        this.autoCompletionNormalTarget.changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChangeTarget(this.txtTargetCode, (String)newV);
            this.trial();
            this.setRefItemInfo();
            this.queryValuationInfo(true);
            this.layout();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 20)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtTargetCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 20)));
        this.txtTargetCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocusTarget((Boolean)newV));
        this.personCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[0-9]*", 6)));
        this.personCode.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() == null || ((String)this.cmbTradePlatform.getSelectionModel().getSelectedItem()).isEmpty()) {
                this.personCode.clear();
                return true;
            }
            if (!FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem())) {
                this.personCode.clear();
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.cmbTradePlatform.getSelectionModel().selectedItemProperty()}));
        this.checkRights(this.sideNode);
        this.cmbSide.setItems(this.sideNode.getNodes());
        this.cmbSide.getSelectionModel().select(0);
        MxNode node = MxNodeFactory.createNew((String)"bonus_type");
        this.cmbBonusType.setItems(node.getNodes());
        this.cmbBonusType.getSelectionModel().select(0);
        this.cmbTradePlatform.setItems(FxUtils.newList());
        this.redeemQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.redeemQty.textProperty().addListener(ob -> this.calRedeemAmount());
        this.bonusQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.confirmedBuyAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.appliedBuyAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.bonusAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.redeemAmt.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.provistonQty.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(), null, (UnaryOperator)new DoubleFilter(true, 11, 2)));
        this.confirmedBuyAmt.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.bonusAmt.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.appliedBuyAmt.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.redeemAmt.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.bonusQty.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.redeemQty.textProperty().addListener((ob, old, newV) -> this.changeTable());
        this.cmbBonusType.getSelectionModel().selectedItemProperty().addListener((ob, old, newV) -> this.changeTable());
        ObservableList provistons = FxUtils.newList();
        provistons.add((Object)"\u63d0\u53d6\u4efd\u989d");
        this.cmbProvistonType.setItems(provistons);
        this.cmbProvistonType.getSelectionModel().select(0);
        this.tradeDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.redeemDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.bonusDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.provistonDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.tradeDate.setValue((Object)LocalDate.now());
        this.bonusDate.setValue((Object)LocalDate.now());
        this.provistonDate.setValue((Object)LocalDate.now());
        this.tradeDate.setEditable(false);
        this.provistonDate.setEditable(false);
        this.redeemDate.setEditable(false);
        this.bonusDate.setEditable(false);
        this.redeemAmt.setEditable(false);
        TextFieldUtils.showMagnitude((Label)this.bonusQtyMag, (TextField)this.bonusQty);
        TextFieldUtils.showMagnitude((Label)this.bonusAmtMag, (TextField)this.bonusAmt);
        TextFieldUtils.showMagnitude((Label)this.redeemQtyMag, (TextField)this.redeemQty);
        TextFieldUtils.showMagnitude((Label)this.redeemAmtMag, (TextField)this.redeemAmt);
        TextFieldUtils.showMagnitude((Label)this.appliedBuyAmtMag, (TextField)this.appliedBuyAmt);
        TextFieldUtils.showMagnitude((Label)this.confirmedBuyAmtMag, (TextField)this.confirmedBuyAmt);
        this.tradeDate.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                return;
            }
            GetBusinessDateReq bizDateReq = new GetBusinessDateReq();
            String newDate = newV.toString().replaceAll("-", "");
            bizDateReq.setDate(newV.toString().replaceAll("-", ""));
            bizDateReq.setMarket("XSHG");
            bizDateReq.setMarketGrp("CCS");
            try {
                GetBusinessDateResp bizDateResp = this.calendarApi.GetBusinessDate(bizDateReq);
                if (!newDate.equals(bizDateResp.getLatestBusinessDate())) {
                    Platform.runLater(() -> {
                        this.alert.alert(Alert.AlertType.ERROR, "\u9009\u62e9\u7684\u65e5\u671f\u4e0d\u662f\u4ea4\u6613\u65e5");
                        this.tradeDate.setValue(null);
                    });
                }
            }
            catch (MException e) {
                this.logger.error("\u573a\u5916\u57fa\u91d1\u6821\u9a8c\u4ea4\u6613\u65e5\u51fa\u9519", (Throwable)e);
            }
        });
        this.lbUploadOA.setOnMouseClicked(event -> this.uploadFile(this.lbUploadOA, "oa"));
        this.lbUploadContract.setOnMouseClicked(event -> this.uploadFile(this.lbUploadContract, "contract"));
        this.lbUploadConfirmation.setOnMouseClicked(event -> this.uploadFile(this.lbUploadConfirmation, "confirmation"));
        this.lbUploadScaleAttachment.setOnMouseClicked(event -> {
            if (!this.lbUploadScaleAttachment.isDisable()) {
                this.uploadFile(this.lbUploadScaleAttachment, "fundScaleAttachment");
            }
        });
        this.lbCancelValuation.setDisable(true);
        this.lbCancelFoundWay.setDisable(true);
        this.cmbInvested.setItems(FXCollections.observableList(listInvested));
        node = MxNodeFactory.create((String)"fund_issuance_way");
        this.cmbMethod.setItems(node.getNodes());
        Tooltip tooltip = new Tooltip();
        this.cmbMethod.setTooltip(tooltip);
        this.cmbMethod.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> tooltip.setText(now == null ? "" : now.getValue()));
        this.txtNewUnitCost.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(4), null, (UnaryOperator)new DoubleFilter(true, 12, 4)));
        this.txtNewScale.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtParentFundSize.setTextFormatter(new TextFormatter((StringConverter)new DoubleStrConverter(2), null, (UnaryOperator)new DoubleFilter(true, 12, 2)));
        this.txtNewScale.textProperty().addListener((ob, old, now) -> {
            if (this.lbUpdateValuation.isVisible() && "\u4fdd\u5b58".equals(this.lbUpdateValuation.getText())) {
                this.canUpdate.setValue(Boolean.valueOf(true));
            }
        });
        this.txtParentFundSize.textProperty().addListener((ob, old, now) -> {
            if (this.lbUpdateValuation.isVisible() && "\u4fdd\u5b58".equals(this.lbUpdateValuation.getText())) {
                this.canUpdate.setValue(Boolean.valueOf(true));
            }
        });
        this.lbUploadScaleAttachment.disableProperty().bind((ObservableValue)this.canUpdate.not());
        this.lbUpdateFoundWay.setOnMouseClicked(event -> {
            String txt = this.lbUpdateFoundWay.getText();
            if ("\u4fee\u6539".equals(txt)) {
                this.lbUpdateFoundWay.setText("\u4fdd\u5b58");
                this.cmbInvested.setDisable(false);
                this.cmbMethod.setDisable(false);
                this.lbCancelFoundWay.setDisable(false);
            } else if (this.updateFundInfo()) {
                this.lbUpdateFoundWay.setText("\u4fee\u6539");
                this.cmbInvested.setDisable(true);
                this.cmbMethod.setDisable(true);
                this.lbCancelFoundWay.setDisable(true);
            }
        });
        this.lbUpdateValuation.setOnMouseClicked(event -> {
            String txt = this.lbUpdateValuation.getText();
            if ("\u4fee\u6539".equals(txt)) {
                this.lbUpdateValuation.setText("\u4fdd\u5b58");
                this.txtNewUnitCost.setDisable(false);
                this.txtNewScale.setDisable(false);
                this.txtParentFundSize.setDisable(false);
                this.lbCancelValuation.setDisable(false);
            } else {
                boolean success = this.updateValuationInfo();
                if (success) {
                    this.lbUpdateValuation.setText("\u4fee\u6539");
                    this.txtNewUnitCost.setDisable(true);
                    this.txtNewScale.setDisable(true);
                    this.txtParentFundSize.setDisable(true);
                    this.lbCancelValuation.setDisable(true);
                }
            }
        });
        this.lbCancelValuation.setOnMouseClicked(event -> {
            String txt = this.lbUpdateValuation.getText();
            if ("\u4fdd\u5b58".equals(txt)) {
                if (this.refItem != null) {
                    this.lbUpdateValuation.setVisible(true);
                    this.lbCancelValuation.setVisible(true);
                    this.lbCancelValuation.setDisable(true);
                    this.updateNewPrice();
                    this.calRedeemAmount();
                } else {
                    this.lbName.setText("");
                    this.showValuationInfo(false);
                    this.price = 0.0;
                    this.calRedeemAmount();
                }
                this.fundSizeAttachmentList.clear();
                this.canUpdate.setValue(Boolean.valueOf(false));
                this.lbUpdateValuation.setText("\u4fee\u6539");
                this.txtCode.selectEnd();
                this.txtCode.deselect();
                this.txtTargetCode.selectEnd();
                this.txtTargetCode.deselect();
                this.queryValuationInfo(true);
                this.layout();
            }
        });
        this.lbCancelFoundWay.setOnMouseClicked(event -> {
            if (this.refItem != null) {
                this.checkLength(this.refItem, this.txtCode.getText().length());
                this.showRefItemInfo(true);
                this.lbUpdateFoundWay.setVisible(true);
                this.lbCancelFoundWay.setDisable(true);
                this.lbCancelFoundWay.setVisible(true);
                this.cmbInvested.setDisable(true);
                this.cmbMethod.setDisable(true);
                this.lbUpdateFoundWay.setText("\u4fee\u6539");
            } else {
                this.lbUpdateFoundWay.setText("");
                this.showRefItemInfo(false);
                this.lbCancelFoundWay.setDisable(true);
            }
            this.setRefItemInfo();
            this.layout();
        });
        this.lbTipOne.setOnMouseClicked(event -> this.showAgreementFund(this.refItem == null ? "" : this.refItem.getCode(), "1", "\u57fa\u91d1\u5408\u540c"));
        this.lbTipTwo.setOnMouseClicked(event -> this.showAgreementFund(this.refItem == null ? "" : this.refItem.getCode(), "0", "\u57fa\u91d1\u62db\u52df\u8bf4\u660e\u4e66"));
        this.lbTipThree.setOnMouseClicked(event -> this.showAgreement(this.refItem == null ? "" : this.refItem.getCode(), "\u57fa\u91d1\u4ea7\u54c1\u8d44\u6599\u6982\u8981"));
        this.lbTipFour.setOnMouseClicked(event -> this.showAgreementFixUrl(this.BOOK_FOUR, "\u8bc1\u5238\u6295\u8d44\u57fa\u91d1\u6295\u8d44\u4eba\u6743\u76ca\u987b\u77e5"));
        this.lbTipFive.setOnMouseClicked(event -> this.showAgreementFixUrl(this.BOOK_FIVE, "\u91d1\u878d\u4ea7\u54c1\u6295\u8d44\u4eba\u98ce\u9669\u544a\u77e5\u4e66"));
        this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
        this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
    }

    protected void showAgreementFixUrl(String url, String name) {
        OtcFundDetailDialog sd = (OtcFundDetailDialog)((Object)this.of.create(OtcFundDetailDialog.class));
        String env = this.cs.getValue("client_env");
        if (env == null || env.isEmpty() || "test".equals(env) || "integ".equals(env)) {
            sd.setPath("http://172.253.40.140:8080/cms/pif/files/2020/08/31/290047c7f4acc670a2b6d76d6e623288.pdf");
        } else {
            sd.setPath(url);
        }
        MxFastWebDialog dialog = this.df.createWeb((FastWebBrowserPart)sd, name, 800, 600);
        dialog.launch();
        dialog.disposeBrowser();
    }

    protected void showAgreement(String code, String name) {
        OtcFundDetailDialog sd = (OtcFundDetailDialog)((Object)this.of.create(OtcFundDetailDialog.class));
        String realUrl = this.cs.getValue("pdf.url");
        if (realUrl == null || realUrl.isEmpty()) {
            sd.setPath("http://172.253.40.140:8080/cms/pif/files/2020/08/31/290047c7f4acc670a2b6d76d6e623288.pdf");
        } else {
            sd.setPath(String.valueOf(realUrl) + "cpdm=" + code + "&wdfl=46");
        }
        MxFastWebDialog dialog = this.df.createWeb((FastWebBrowserPart)sd, name, 800, 600);
        dialog.launch();
        dialog.disposeBrowser();
    }

    protected void showAgreementFund(String code, String type, String name) {
        OtcFundDetailDialog sd = (OtcFundDetailDialog)((Object)this.of.create(OtcFundDetailDialog.class));
        String realUrl = this.cs.getValue("fundsm.url");
        if (realUrl == null || realUrl.isEmpty()) {
            sd.setPath("http://172.253.40.140:8080/cms/pif/files/2020/08/31/290047c7f4acc670a2b6d76d6e623288.pdf");
        } else {
            sd.setPath(String.valueOf(realUrl) + "code=" + code + "&type=" + type);
        }
        MxFastWebDialog dialog = this.df.createWeb((FastWebBrowserPart)sd, name, 800, 600);
        dialog.launch();
        dialog.disposeBrowser();
    }

    protected void calRedeemAmount() {
        if (this.refItem == null) {
            this.redeemAmt.setText("");
        } else if (this.price == 0.0) {
            this.updateNewPrice();
        } else {
            this.redeemAmt.setText(StringUtils.toStr((double)(StringUtils.parseDouble((String)this.redeemQty.getText(), (int)2) * this.price), (int)2));
        }
    }

    protected void onMktItemChange() {
        this.checkLength((RefItem)this.txtCode.getUserData(), this.txtCode.getText().length());
    }

    public void setBuySymbol(String buySymbol) {
        this.buySymbol = buySymbol;
    }

    public void setSellSymbol(String sellSymbol) {
        this.sellSymbol = sellSymbol;
    }

    public String getBuySymbol() {
        return this.buySymbol;
    }

    public String getSellSymbol() {
        return this.sellSymbol;
    }

    protected void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.checkLength((RefItem)this.txtCode.getUserData(), this.txtCode.getText().length());
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void loseFocusTarget(Boolean val) {
        if (!val.booleanValue() && this.txtTargetCode.getText().length() > 0) {
            this.checkLengthTarget((RefItem)this.txtTargetCode.getUserData(), this.txtTargetCode.getText().length());
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtTargetCode.selectAll());
        }
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        System.out.println("on security change");
        this.refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            this.refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(this.refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void onSecurityChangeTarget(TextField txtCode, String newText) {
        this.refItemTarget = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            this.refItemTarget = (RefItem)RefItem.class.cast(obj);
        }
        if (this.refItemTarget != null) {
            this.checkLengthTarget(this.refItemTarget, txtCode.getText().length());
            this.showRefItemInfo(true);
            this.lbUpdateValuation.setVisible(true);
            this.lbUpdateFoundWay.setVisible(true);
            this.lbCancelFoundWay.setDisable(true);
            this.lbCancelFoundWay.setVisible(true);
            this.lbCancelValuation.setVisible(true);
            this.lbCancelValuation.setDisable(true);
            this.updateTargetNewPrice();
            this.calRedeemAmount();
            this.cmbInvested.setDisable(true);
            this.cmbMethod.setDisable(true);
        } else {
            this.lbTargetName.setText("");
            this.showRefItemInfo(false);
            this.lbCancelFoundWay.setDisable(true);
            this.showValuationInfo(false);
            this.priceTarget = 0.0;
            this.calRedeemAmount();
        }
    }

    protected void doChange(RefItem refItem, String newText) {
        this.otcModel.getMktItem().setRefItem(refItem);
        String side = ((MxNode)this.cmbSide.getValue()).getRaw();
        if (refItem != null) {
            this.txtCode.textProperty().set((Object)refItem.getCode());
            this.checkLength(refItem, this.txtCode.getText().length());
            if (!"4".equals(side)) {
                this.showRefItemInfo(true);
                this.lbUpdateValuation.setVisible(true);
                this.lbUpdateFoundWay.setVisible(true);
                this.lbCancelFoundWay.setDisable(true);
                this.lbCancelFoundWay.setVisible(true);
                this.lbCancelValuation.setVisible(true);
                this.lbCancelValuation.setDisable(true);
                this.updateNewPrice();
                this.calRedeemAmount();
                this.cmbInvested.setDisable(true);
                this.cmbMethod.setDisable(true);
            }
            this.checkAggrementNeedToBeSigned();
            if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() != null && !FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem())) {
                this.showOrHideHBox(true);
            }
        } else {
            this.lbName.setText("");
            if (!"4".equals(side)) {
                this.showRefItemInfo(false);
                this.lbCancelFoundWay.setDisable(true);
                this.showValuationInfo(false);
                this.price = 0.0;
                this.calRedeemAmount();
            }
            this.hide();
        }
        this.fundSizeAttachmentList.clear();
        this.canUpdate.setValue(Boolean.valueOf(false));
        this.lbUpdateValuation.setText("\u4fee\u6539");
        this.lbUpdateFoundWay.setText("\u4fee\u6539");
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        this.changeTable();
        this.layout();
    }

    protected void checkAggrementNeedToBeSigned() {
        if (this.cmbSide == null) {
            return;
        }
        if (!"1".equals(((MxNode)this.cmbSide.getValue()).getRaw()) && !"0".equals(((MxNode)this.cmbSide.getValue()).getRaw())) {
            return;
        }
        if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() == null || !FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem())) {
            return;
        }
        if (this.subFund == null) {
            return;
        }
        try {
            if (!this.componentBox.getChildren().contains((Object)this.vBoxTip)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.vBoxTip);
            }
            if (!this.componentBox.getChildren().contains((Object)this.hBoxAgreement)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxAgreement);
            }
            if (this.vBoxTip.getChildren().contains((Object)this.lbTipThree)) {
                this.vBoxTip.getChildren().remove((Object)this.lbTipThree);
            }
            this.vBoxTip.setVisible(true);
            this.hBoxAgreement.setVisible(true);
            this.checkBoxAgreement.setVisible(true);
            Boolean sign = this.signMap.get(this.refItem.getCode());
            if (sign != null && sign.booleanValue()) {
                if (!this.vBoxTip.getChildren().contains((Object)this.lbTipThree)) {
                    this.vBoxTip.getChildren().add((Object)this.lbTipThree);
                }
                return;
            }
            OtcQueryProductReq req = new OtcQueryProductReq();
            req.setSecuCode(this.refItem.getCode());
            req.setInvestorId(this.subFund.getInvestId());
            if (this.routerApi.queryProduct(req)) {
                this.signMap.put(this.refItem.getCode(), true);
                if (!this.vBoxTip.getChildren().contains((Object)this.lbTipThree)) {
                    this.vBoxTip.getChildren().add((Object)this.lbTipThree);
                }
            }
        }
        catch (MException | Exception e) {
            this.logger.error((Object)e, e);
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u57fa\u91d1\u7b7e\u7ea6\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
    }

    protected void checkLength(RefItem refItem, int length) {
        Platform.runLater(() -> {
            if (refItem == null || "".equals(refItem.getName())) {
                this.lbName.setText(INVALID_CODE);
            } else {
                this.lbName.setText(refItem.getName());
            }
        });
    }

    protected void checkLengthTarget(RefItem refItem, int length) {
        Platform.runLater(() -> {
            if (refItem == null || "".equals(refItem.getName())) {
                this.lbTargetName.setText(INVALID_CODE);
            } else {
                this.lbTargetName.setText(refItem.getName());
            }
        });
    }

    @FXML
    public void order() {
        this.submitOrder();
        this.layout();
    }

    @FXML
    protected void confirm() {
    }

    protected void submitOrder() {
        String text;
        WorkflowTemplate template;
        try {
            this.check();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return;
        }
        GetWorkflowTemplateReq getWorkflowReq = new GetWorkflowTemplateReq();
        getWorkflowReq.setOrg(this.baseApi.getPartyId());
        getWorkflowReq.setObjType("3");
        getWorkflowReq.setObjId(((Portfolio)this.cmbPortfolio.getValue()).getId());
        getWorkflowReq.setAssetClass("1");
        getWorkflowReq.setMarket(this.refItem.getMarket());
        getWorkflowReq.setSecurityId(this.refItem.getCode());
        getWorkflowReq.setSecurityType(this.refItem.getType());
        getWorkflowReq.setUserId(this.baseApi.getUserId());
        getWorkflowReq.setPostId(this.baseApi.getPostId());
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_REN_GOU.getCode());
                break;
            }
            case "CREATION_BUY": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_ISSUE.getCode());
                break;
            }
            case "REDEEM": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_SHU_HUI.getCode());
                break;
            }
            case "BONUS_CASH": 
            case "BONUS_INVEST": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_FEN_HONG.getCode());
                break;
            }
            case "TRANSFER": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_TRANSFER.getCode());
                break;
            }
            case "PROVISTON": {
                getWorkflowReq.setBusinessType(WorkflowBusinessType.TYPE_PROVISTON.getCode());
                break;
            }
        }
        try {
            GetWorkflowTemplateResp getWorkflowResp = this.workflowTemplateApi.getWorkflowTemplate(getWorkflowReq);
            if (getWorkflowResp.getList() == null || getWorkflowResp.getList().size() == 0) {
                this.alert.alert(Alert.AlertType.ERROR, "\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u6548\u7684\u6307\u4ee4\u6d41\u8bbe\u7f6e");
                return;
            }
            template = (WorkflowTemplate)getWorkflowResp.getList().get(0);
        }
        catch (MException mException) {
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u6307\u4ee4\u6d41\u6a21\u677f\u51fa\u9519");
            return;
        }
        this.updateNewPrice();
        NewInstructionReq newInsReq = new NewInstructionReq();
        Instruction ins = new Instruction();
        if ("1".equals(template.getNode().getFrozenCapital())) {
            ins.setDoFreezeCash();
        }
        if ("1".equals(template.getNode().getFrozenVouchers())) {
            ins.setDoFreezeSec();
        }
        if ("1".equals(template.getNode().getFastApprove())) {
            ins.setDoFastApprove();
        }
        Instrument instrument = new Instrument();
        OtcOrderDetail detail = new OtcOrderDetail();
        ins.setType("FundDetail");
        ins.setFlowAttrId(template.getInstanceId());
        ins.setPortfolioId(((Portfolio)this.cmbPortfolio.getValue()).getId());
        ins.setName(template.getInstanceName());
        detail.setType("type.googleapis.com/proto.instruction.FundDetail");
        detail.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
        instrument.setSecurityId(this.refItem.getCode());
        instrument.setSymbol(this.refItem.getName());
        instrument.setSecurityType(this.refItem.getType());
        instrument.setSecuritySubType("PUBLIC");
        instrument.setMarket(this.refItem.getMarket());
        if (this.panelType.equals(TRANSFER)) {
            Instrument underlying = new Instrument();
            underlying.setSecurityId(this.refItemTarget.getCode());
            underlying.setSymbol(this.refItemTarget.getName());
            underlying.setSecurityType(this.refItemTarget.getType());
            underlying.setSecuritySubType("PUBLIC");
            underlying.setMarket(this.refItemTarget.getMarket());
            underlying.setCurrencyId("CNY");
            underlying.setMarketGroup("OTC");
            this.updateTargetNewPrice();
            underlying.setProductComplex(Double.toString(BigDecimal.valueOf(this.priceTarget).setScale(4, RoundingMode.DOWN).doubleValue()));
            detail.setUnderlying(underlying);
        }
        if ("99999-04-01".equals(this.subFund.getCounterId()) || "55555-04-01".equals(this.subFund.getCounterId())) {
            instrument.setMarketGroup("OTC");
        } else if ("99999-01-01".equals(this.subFund.getCounterId())) {
            instrument.setMarketGroup("CCS");
            instrument.setApplId("810");
            this.cmbCounterParty.getSelectionModel().clearSelection();
            this.redeemDate.setValue(null);
        }
        instrument.setCurrencyId("CNY");
        detail.setInstrument(instrument);
        detail.setAttachment(this.gson.toJson(this.attachmentList));
        detail.setSide(PANEL_SIDE_MAP.get(this.panelType));
        detail.setPrice(BigDecimal.valueOf(this.price).setScale(4, RoundingMode.DOWN).doubleValue());
        AccntSecInfo accntSecInfo = new AccntSecInfo();
        AccountId accountId = new AccountId();
        accountId.setCashAccntId(this.subFundAcc);
        accountId.setSecAccntId(this.subSecAcc);
        accntSecInfo.setAccountId(accountId);
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                accntSecInfo.setOrderAmount(StringUtils.parseDouble((String)this.confirmedBuyAmt.getText()));
                detail.setTradeDate(((LocalDate)this.tradeDate.getValue()).toString().replaceAll("-", ""));
                if (this.redeemDate.getValue() == null) break;
                detail.setContractExpireDate(((LocalDate)this.redeemDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "CREATION_BUY": {
                accntSecInfo.setOrderAmount(StringUtils.parseDouble((String)this.appliedBuyAmt.getText()));
                detail.setTradeDate(((LocalDate)this.tradeDate.getValue()).toString().replaceAll("-", ""));
                if (this.redeemDate.getValue() == null) break;
                detail.setContractExpireDate(((LocalDate)this.redeemDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "REDEEM": 
            case "TRANSFER": {
                accntSecInfo.setOrderQty(StringUtils.parseDouble((String)this.redeemQty.getText()));
                detail.setTradeDate(((LocalDate)this.tradeDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "BONUS_CASH": {
                accntSecInfo.setOrderAmount(StringUtils.parseDouble((String)this.bonusAmt.getText()));
                detail.setTradeDate(((LocalDate)this.bonusDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "BONUS_INVEST": {
                accntSecInfo.setOrderQty(StringUtils.parseDouble((String)this.bonusQty.getText()));
                detail.setTradeDate(((LocalDate)this.bonusDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
            case "PROVISTON": {
                accntSecInfo.setOrderQty(StringUtils.parseDouble((String)this.provistonQty.getText()));
                detail.setTradeDate(((LocalDate)this.provistonDate.getValue()).toString().replaceAll("-", ""));
                break;
            }
        }
        detail.getAccntSecInfo().add(accntSecInfo);
        if (this.cmbCounterParty.getValue() != null && SELL.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem())) {
            Party party = new Party();
            party.setPartyId(((CounterPartyAccount)this.cmbCounterParty.getValue()).getCounterParty().getId());
            PartySub partySub = new PartySub();
            partySub.setPartySubId(((CounterPartyAccount)this.cmbCounterParty.getValue()).getSelectedAccNO());
            party.getPartySub().add(partySub);
            detail.setParty(party);
        }
        if (FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem()) && (SUBSCRIBE_BUY.equals(this.panelType) || CREATION_BUY.equals(this.panelType)) && !(text = this.personCode.getText()).isEmpty()) {
            if (text.length() == 6) {
                Party party = new Party();
                party.setPartyId(text);
                detail.setParty(party);
            } else {
                this.alert.alert(Alert.AlertType.ERROR, "\u63a8\u8350\u4eba\u4ee3\u7801\u53ea\u80fd\u4e3a\u7a7a\u6216\u80056\u4f4d\u6709\u6548\u6570\u5b57");
                return;
            }
        }
        ins.setDetail((Object)detail);
        newInsReq.setInstruction(ins);
        try {
            Boolean needSign;
            if (!this.isconfirm(newInsReq).booleanValue()) {
                return;
            }
            if ("99999-01-01".equals(this.subFund.getCounterId()) && FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem()) && ("1".equals(((MxNode)this.cmbSide.getValue()).getRaw()) || "0".equals(((MxNode)this.cmbSide.getValue()).getRaw())) && (needSign = this.signMap.get(this.refItem.getCode())) != null && needSign.booleanValue()) {
                OtcSignProductReq req = new OtcSignProductReq();
                req.setSecCode(this.refItem.getCode());
                req.setInvestorId(this.subFund.getInvestId());
                try {
                    String signId = this.routerApi.signProduct(req);
                    ((OtcOrderDetail)OtcOrderDetail.class.cast(newInsReq.getInstruction().getDetail())).setAttachment(signId);
                }
                catch (MException | Exception e1) {
                    this.alert.alert(Alert.AlertType.ERROR, "\u57fa\u91d1" + this.refItem.getCode() + "\u7b7e\u7ea6\u5931\u8d25 \u539f\u56e0:" + e1.getMessage());
                    return;
                }
            }
            this.otcModel.newInstruction(newInsReq);
        }
        catch (MException | Exception e) {
            this.logger.error("\u6307\u4ee4\u63d0\u4ea4\u51fa\u9519", e);
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u63d0\u4ea4\u51fa\u9519:" + e.getMessage());
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u63d0\u4ea4\u6210\u529f");
        this.clearCountCheck();
    }

    protected void updateNewPrice() {
        try {
            GetValuationReq getValuationReq = new GetValuationReq();
            getValuationReq.setMarket(this.refItem.getMarket());
            getValuationReq.getSecurityId().add(this.refItem.getCode());
            List valuations = this.valuationApi.getValuation(getValuationReq);
            if (valuations != null && valuations.size() > 0) {
                this.price = ((Valuation)valuations.get(0)).getNetValue();
            }
        }
        catch (MException | Exception e) {
            this.logger.error("\u83b7\u53d6\u57fa\u91d1\u51c0\u503c\u51fa\u9519 ", e);
        }
        this.price = this.price > 0.0 ? this.price : 1.0;
    }

    protected void updateTargetNewPrice() {
        try {
            GetValuationReq getValuationReq = new GetValuationReq();
            getValuationReq.setMarket(this.refItemTarget.getMarket());
            getValuationReq.getSecurityId().add(this.refItemTarget.getCode());
            List valuations = this.valuationApi.getValuation(getValuationReq);
            if (valuations != null && valuations.size() > 0) {
                this.priceTarget = ((Valuation)valuations.get(0)).getNetValue();
            }
        }
        catch (MException | Exception e) {
            this.logger.error("\u83b7\u53d6\u57fa\u91d1\u51c0\u503c\u51fa\u9519 ", e);
        }
        this.priceTarget = this.priceTarget > 0.0 ? this.priceTarget : 1.0;
    }

    protected void check() throws MException {
        if (this.refItem == null) {
            throw new MException(1, "\u65e0\u6548\u5408\u7ea6\u4ee3\u7801");
        }
        if (this.subFund != null && this.cmbSide.getValue() != null && "99999-01-01".equals(this.subFund.getCounterId()) && ("1".equals(((MxNode)this.cmbSide.getValue()).getRaw()) || "0".equals(((MxNode)this.cmbSide.getValue()).getRaw())) && this.checkBoxAgreement.isVisible() && !this.checkBoxAgreement.isSelected()) {
            throw new MException(1, "\u8bf7\u9605\u8bfb\u5e76\u7b7e\u7f72\u534f\u8bae");
        }
        if (this.cmbPortfolio.getValue() == null) {
            throw new MException(1, "\u8bf7\u9009\u62e9\u6295\u7ec4");
        }
        if (StringUtils.isEmpty((String)this.subFundAcc)) {
            throw new MException(1, "\u6ca1\u6709\u6709\u6548\u7684\u8d44\u91d1\u8d26\u53f7");
        }
        if (StringUtils.isEmpty((String)this.subSecAcc)) {
            throw new MException(1, "\u6ca1\u6709\u6709\u6548\u7684\u8bc1\u5238\u8d26\u53f7");
        }
        switch (this.panelType) {
            case "SUBSCRIBE_BUY": {
                if (StringUtils.parseDouble((String)this.confirmedBuyAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u8ba4\u8d2d\u91d1\u989d");
                }
                if (this.tradeDate.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f");
            }
            case "CREATION_BUY": {
                if (StringUtils.parseDouble((String)this.appliedBuyAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u7533\u8d2d\u91d1\u989d");
                }
                if (this.tradeDate.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f");
            }
            case "REDEEM": {
                if (StringUtils.parseDouble((String)this.redeemQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u8d4e\u56de\u4efd\u989d");
                }
                if (this.tradeDate.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f");
            }
            case "BONUS_CASH": {
                if (StringUtils.parseDouble((String)this.bonusAmt.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5206\u7ea2\u91d1\u989d");
                }
                if (this.bonusDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u65e5\u671f");
                }
                if (this.cmbBonusType.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u65b9\u5f0f");
            }
            case "BONUS_INVEST": {
                if (StringUtils.parseDouble((String)this.bonusQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u5206\u7ea2\u4efd\u989d");
                }
                if (this.bonusDate.getValue() == null) {
                    throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u65e5\u671f");
                }
                if (this.cmbBonusType.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u5206\u7ea2\u65b9\u5f0f");
            }
            case "TRANSFER": {
                if (this.refItemTarget == null) {
                    throw new MException(1, "\u65e0\u6548\u8f6c\u6362\u5408\u7ea6\u4ee3\u7801");
                }
                if (StringUtils.parseDouble((String)this.redeemQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u8f6c\u6362\u4efd\u989d");
                }
                if (this.tradeDate.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u65e5\u671f");
            }
            case "PROVISTON": {
                if (StringUtils.parseDouble((String)this.provistonQty.getText()) <= 0.0) {
                    throw new MException(1, "\u8bf7\u8f93\u5165\u63d0\u53d6\u4efd\u989d");
                }
                if (this.provistonDate.getValue() != null) break;
                throw new MException(1, "\u8bf7\u9009\u62e9\u63d0\u53d6\u65e5\u671f");
            }
        }
        if (this.cmbTradePlatform.getValue() == null) {
            throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u5e73\u53f0");
        }
        if (this.cmbCounterParty.getValue() == null) {
            String selectedItem = (String)this.cmbTradePlatform.getSelectionModel().getSelectedItem();
            if (SELL.equals(selectedItem) && !this.panelType.equals(PROVISTON)) {
                throw new MException(1, "\u8bf7\u9009\u62e9\u4ea4\u6613\u5bf9\u624b\u65b9");
            }
            if (HCJK.equals(selectedItem) || FOCUS.equals(selectedItem)) {
                this.cmbCounterParty.getSelectionModel().clearSelection();
            }
        }
    }

    protected void clearCountCheck() {
        this.clearInfo();
    }

    protected void clearCountCheckForce() {
    }

    protected void quantityKeyPress(KeyEvent key) {
    }

    public InstructionCcsBaseModel createModel() {
        return (InstructionCcsBaseModel)this.of.create(InstructionCcsBaseModel.class);
    }

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = ((Object)((Object)this)).getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    protected void reloadComponent() {
        if (this.cmbSide.getValue() == null) {
            return;
        }
        switch (((MxNode)this.cmbSide.getValue()).getRaw()) {
            case "1": {
                this.panelType = SUBSCRIBE_BUY;
                this.btnOrder.setText("\u8ba4\u8d2d");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "0": {
                this.panelType = CREATION_BUY;
                this.btnOrder.setText("\u7533\u8d2d");
                this.canBuyCol.setVisible(true);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "2": {
                this.panelType = REDEEM;
                this.btnOrder.setText("\u8d4e\u56de");
                this.lbQty.setText("\u8d4e\u56de\u4efd\u989d");
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                break;
            }
            case "3": {
                if (this.cmbBonusType.getValue() == null) {
                    this.cmbBonusType.getSelectionModel().select(0);
                }
                this.panelType = "0".equals(((MxNode)this.cmbBonusType.getValue()).getRaw()) ? BONUS_CASH : BONUS_INVEST;
                this.btnOrder.setText("\u5206\u7ea2");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "4": {
                this.panelType = TRANSFER;
                this.btnOrder.setText("\u8f6c\u6362");
                this.lbQty.setText("\u8f6c\u6362\u4efd\u989d");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().add(4, (Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().add(5, (Object)this.targetNameHbox);
                break;
            }
            case "5": {
                this.panelType = PROVISTON;
                this.btnOrder.setText("\u4e1a\u7ee9\u8ba1\u63d0");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) break;
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                break;
            }
        }
        this.componentBox.getChildren().setAll((Collection)this.panelMap.get(this.panelType));
        this.layout();
        this.changeTable();
        Platform.runLater(() -> {
            this.componentBox.requestFocus();
            if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() != null) {
                this.reloadByTradeCouter((String)this.cmbTradePlatform.getSelectionModel().getSelectedItem());
            }
        });
    }

    protected void reloadByTradeCouter(String couter) {
        String side;
        String string = side = this.cmbSide.getValue() == null ? "" : ((MxNode)this.cmbSide.getValue()).getRaw();
        if (SELL.equals(couter)) {
            this.hide();
            this.addOrRemoveSide(true);
            this.addOrRemoveTransFer(false);
            this.addOrRemoveProviston(true);
            this.showOrHideHBox(true);
            this.hBoxTradeDate.setDisable(false);
            this.accSetModel.selectFundAccount("99999-04-01");
            if (("0".equals(side) || "1".equals(side)) && !this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxRedeemDate);
                this.hBoxRedeemDate.setVisible(true);
            }
            if (!this.panelType.equals(PROVISTON) && !this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxCounterParty);
                this.hBoxCounterParty.setVisible(true);
            }
        } else if (HCJK.equals(couter)) {
            this.hide();
            this.addOrRemoveSide(true);
            this.addOrRemoveTransFer(true);
            this.addOrRemoveProviston(false);
            this.showOrHideHBox(true);
            this.hBoxTradeDate.setDisable(false);
            this.accSetModel.selectFundAccount("55555-04-01");
            if (("0".equals(side) || "1".equals(side)) && !this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxRedeemDate);
                this.hBoxRedeemDate.setVisible(true);
            }
            if (this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                this.hBoxCounterParty.setVisible(false);
            }
        } else if (FOCUS.equals(couter)) {
            this.addOrRemoveSide(false);
            this.showOrHideHBox(false);
            this.addOrRemoveProviston(false);
            this.addOrRemoveTransFer(false);
            this.hBoxTradeDate.setDisable(true);
            this.tradeDate.setValue((Object)LocalDate.now());
            this.accSetModel.selectFundAccount("99999-01-01");
            if (this.refItem != null) {
                this.checkAggrementNeedToBeSigned();
            }
            if (this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                this.hBoxCounterParty.setVisible(false);
            }
            if (this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().remove((Object)this.hBoxRedeemDate);
                this.hBoxRedeemDate.setVisible(false);
            }
        } else {
            this.hide();
            this.addOrRemoveSide(true);
            this.showOrHideHBox(true);
            this.addOrRemoveProviston(false);
            this.addOrRemoveTransFer(false);
            this.hBoxTradeDate.setDisable(false);
            if (("0".equals(side) || "1".equals(side)) && !this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxRedeemDate);
                this.hBoxRedeemDate.setVisible(true);
            }
            if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxCounterParty);
                this.hBoxCounterParty.setVisible(true);
            }
        }
    }

    protected void fillInstruction() throws MException {
        this.cmbPortfolio.getSelectionModel().clearSelection();
        Portfolio portf = new Portfolio();
        portf.setName("\u6682\u65e0\u6295\u7ec4\u540d\u79f0");
        portf.setId(this.instruction.getPortfolioId());
        ArrayList<Portfolio> portfolioList = new ArrayList<Portfolio>(this.portfolioModel.getPortfolios());
        portfolioList.removeIf(portfolio -> this.portfolioModel.getMap(portfolio) == null || this.portfolioModel.getMap(portfolio).isEmpty());
        this.cmbPortfolio.getItems().setAll(portfolioList);
        if (!this.cmbPortfolio.getItems().contains((Object)portf)) {
            throw new MException(1, "\u56de\u586b\u6295\u7ec4\u4fe1\u606f\u5931\u8d25,\u8bf7\u786e\u5b9a\u662f\u5426\u6709\u8be5\u6295\u7ec4\u7684\u6743\u9650");
        }
        this.cmbPortfolio.getSelectionModel().select((Object)portf);
        this.subFund = this.portfolioModel.getSubFundAccountById(((AccntSecInfo)this.instruction.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId());
        if (this.subFund == null) {
            throw new MException(1, "\u56de\u586b\u5931\u8d25,\u6839\u636e\u6307\u4ee4\u8be6\u60c5\u4ece\u6295\u7ec4\u6a21\u578b\u83b7\u53d6\u4e8c\u7ea7\u8d26\u53f7\u5931\u8d25");
        }
        if (PART_TYPE_INSTRUCTION.equals(this.partType)) {
            this.refItemTarget = null;
            this.subFundAcc = ((AccntSecInfo)this.instruction.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId();
            this.subSecAcc = ((AccntSecInfo)this.instruction.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getSecAccntId();
        }
        this.refItem = this.refMng.getItem(this.instruction.getSecType(), this.instruction.getSecMarket(), this.instruction.getSecurityCode());
        if (this.refItem != null) {
            this.updateNewPrice();
        }
        if ("99999-04-01".equals(this.subFund.getCounterId())) {
            this.cmbTradePlatform.getSelectionModel().select((Object)SELL);
            this.hide();
            if (this.panelMap.get(this.panelType).contains(this.hBoxRedeemDate) && !this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxRedeemDate);
            }
            if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxCounterParty);
            }
        } else if ("55555-04-01".equals(this.subFund.getCounterId())) {
            this.cmbTradePlatform.getSelectionModel().select((Object)HCJK);
            this.hide();
            if (this.panelMap.get(this.panelType).contains(this.hBoxRedeemDate) && !this.componentBox.getChildren().contains((Object)this.hBoxRedeemDate)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxRedeemDate);
            }
            if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) {
                this.componentBox.getChildren().add(this.componentBox.getChildren().size() - 1, (Object)this.hBoxCounterParty);
            }
        } else if ("99999-01-01".equals(this.subFund.getCounterId())) {
            this.cmbTradePlatform.getSelectionModel().select((Object)FOCUS);
            this.checkBoxAgreement.setSelected(true);
            this.checkBoxAgreement.setDisable(true);
        }
        MxNode node = new MxNode();
        this.txtCode.setText(this.instruction.getSecurityCode());
        this.lbName.setText(this.instruction.getSecurityName());
        this.trial();
        this.setRefItemInfo();
        this.queryValuationInfo(true);
        this.changeTable();
        this.lbUpdateFoundWay.setVisible(true);
        this.lbUpdateValuation.setVisible(true);
        this.lbCancelValuation.setVisible(true);
        this.lbCancelFoundWay.setVisible(true);
        LocalDate trade = null;
        if (!StringUtils.isEmpty((String)this.instruction.getTradeDate())) {
            StringBuilder tradeDa = new StringBuilder();
            tradeDa.append(this.instruction.getTradeDate().substring(0, 4)).append("-").append(this.instruction.getTradeDate().substring(4, 6)).append("-").append(this.instruction.getTradeDate().substring(6, 8));
            trade = LocalDate.parse(tradeDa.toString());
        }
        LocalDate redeem = null;
        if (!StringUtils.isEmpty((String)this.instruction.getRedeemDate())) {
            StringBuilder redeemDa = new StringBuilder();
            redeemDa.append(this.instruction.getRedeemDate().substring(0, 4)).append("-").append(this.instruction.getRedeemDate().substring(4, 6)).append("-").append(this.instruction.getRedeemDate().substring(6, 8));
            redeem = LocalDate.parse(redeemDa.toString());
        }
        switch (this.instruction.getSide()) {
            case "SIDE_CASH_DIVIDEND": {
                this.bonusAmt.setText(StringUtils.toThousands((Number)this.instruction.getBonusAmt(), (int)2));
                node.setRaw("3");
                this.bonusDate.getEditor().setText(this.instruction.getTradeDate());
                this.bonusDate.setValue((Object)trade);
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(false);
                this.refItemTarget = null;
                break;
            }
            case "SIDE_DIVIDEND_REINVEST": {
                this.bonusQty.setText(StringUtils.toThousands((Number)this.instruction.getBonusQty(), (int)2));
                node.setRaw("3");
                this.bonusDate.getEditor().setText(this.instruction.getTradeDate());
                this.bonusDate.setValue((Object)trade);
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(false);
                this.refItemTarget = null;
                break;
            }
            case "SIDE_CREATION": {
                this.appliedBuyAmt.setText(StringUtils.toThousands((Number)this.instruction.getSubscribeAmt(), (int)2));
                this.tradeDate.getEditor().setText(this.instruction.getTradeDate());
                this.redeemDate.getEditor().setText(this.instruction.getRedeemDate());
                this.tradeDate.setValue((Object)trade);
                this.redeemDate.setValue((Object)redeem);
                node.setRaw("0");
                this.canBuyCol.setVisible(true);
                this.canSellCol.setVisible(false);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(false);
                this.refItemTarget = null;
                break;
            }
            case "SIDE_SUBSCRIBE": {
                this.confirmedBuyAmt.setText(StringUtils.toThousands((Number)this.instruction.getSubscribeAmt(), (int)2));
                this.tradeDate.getEditor().setText(this.instruction.getTradeDate());
                this.redeemDate.getEditor().setText(this.instruction.getRedeemDate());
                this.tradeDate.setValue((Object)trade);
                this.redeemDate.setValue((Object)redeem);
                node.setRaw("1");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(false);
                this.txtInterest.clear();
                this.refItemTarget = null;
                break;
            }
            case "SIDE_REDEEM": {
                this.redeemQty.setText(StringUtils.toThousands((Number)this.instruction.getRedeemQty(), (int)2));
                this.tradeDate.getEditor().setText(this.instruction.getTradeDate());
                this.tradeDate.setValue((Object)trade);
                node.setRaw("2");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(false);
                this.refItemTarget = null;
                break;
            }
            case "SIDE_TRANSFER": {
                this.redeemQty.setText(StringUtils.toThousands((Number)this.instruction.getTransFerQty(), (int)2));
                this.tradeDate.getEditor().setText(this.instruction.getTradeDate());
                this.tradeDate.setValue((Object)trade);
                node.setRaw("4");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                this.addOrRemoveTransFer(true);
                this.addOrRemoveProviston(false);
                this.refItemTarget = this.refMng.getItem(this.instruction.getUnderlyingSecType(), this.instruction.getUnderlyingSecMarket(), this.instruction.getUnderlyingSecurityCode());
                break;
            }
            case "SIDE_PROVISTON": {
                this.provistonQty.setText(StringUtils.toThousands((Number)this.instruction.getProvistonQty(), (int)2));
                this.provistonQty.setDisable(true);
                node.setRaw("5");
                this.provistonDate.getEditor().setText(this.instruction.getTradeDate());
                this.provistonDate.setValue((Object)trade);
                this.provistonDate.setDisable(true);
                if (PART_TYPE_INSTRUCTION.equals(this.partType)) {
                    this.provistonQty.setDisable(false);
                    this.provistonDate.setDisable(false);
                }
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                this.addOrRemoveTransFer(false);
                this.addOrRemoveProviston(true);
                this.refItemTarget = null;
                if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) break;
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                break;
            }
        }
        this.cmbSide.getSelectionModel().select((Object)node);
        if ("SIDE_CASH_DIVIDEND".equals(this.instruction.getSide())) {
            node.setRaw("0");
        } else if ("SIDE_DIVIDEND_REINVEST".equals(this.instruction.getSide())) {
            node.setRaw("1");
        }
        if (this.refItemTarget != null) {
            this.txtTargetCode.setText(this.refItemTarget.getCode());
            this.lbTargetName.setText(this.refItemTarget.getName());
            this.checkLengthTarget(this.refItemTarget, this.txtTargetCode.getText().length());
            this.showRefItemInfo(true);
            this.lbUpdateValuation.setVisible(true);
            this.lbUpdateFoundWay.setVisible(true);
            this.lbCancelFoundWay.setDisable(true);
            this.lbCancelFoundWay.setVisible(true);
            this.lbCancelValuation.setVisible(true);
            this.lbCancelValuation.setDisable(true);
            this.updateTargetNewPrice();
            this.calRedeemAmount();
            this.cmbInvested.setDisable(true);
            this.cmbMethod.setDisable(true);
            this.trial();
            this.setRefItemInfo();
            this.queryValuationInfo(true);
        }
        this.cmbBonusType.getSelectionModel().select((Object)node);
        if (this.cmbCounterParty.getItems().size() == 0) {
            this.getCounterBanks();
        }
        if (this.instruction.getOtcOrderDetail().getParty() != null) {
            for (CounterPartyAccount party : this.cmbCounterParty.getItems()) {
                if (!party.getCounterParty().getId().equals(this.instruction.getOtcOrderDetail().getParty().getPartyId())) continue;
                if (this.instruction.getOtcOrderDetail().getParty().getPartySub().size() > 0) {
                    party.setSelectedAccNO(((PartySub)this.instruction.getOtcOrderDetail().getParty().getPartySub().get(0)).getPartySubId());
                }
                this.cmbCounterParty.getSelectionModel().select((Object)party);
            }
        }
        if (FOCUS.equals(this.cmbTradePlatform.getSelectionModel().getSelectedItem()) && (SUBSCRIBE_BUY.equals(this.panelType) || CREATION_BUY.equals(this.panelType)) && this.instruction.getOtcOrderDetail().getParty() != null) {
            this.personCode.setText(this.instruction.getOtcOrderDetail().getParty().getPartyId());
        }
        if (!PART_TYPE_INSTRUCTION.equals(this.partType)) {
            this.attachmentList.setAll((Collection)this.instruction.getAttachments());
        }
        this.clearUpload();
        this.attachmentList.forEach(att -> {
            switch (att.getType()) {
                case "oa": {
                    this.lbFileOA.setText(att.getFileName());
                    this.lbUploadOA.setVisible(false);
                    if (!PART_TYPE_INSTRUCTION.equals(this.partType)) break;
                    this.lbUploadOA.setVisible(true);
                    this.lbUploadOA.setText(DELETE);
                    break;
                }
                case "contract": {
                    this.lbFileContract.setText(att.getFileName());
                    this.lbUploadContract.setVisible(false);
                    if (!PART_TYPE_INSTRUCTION.equals(this.partType)) break;
                    this.lbUploadContract.setVisible(true);
                    this.lbUploadContract.setText(DELETE);
                    break;
                }
                case "confirmation": {
                    this.lbFileConfirmation.setText(att.getFileName());
                    this.lbUploadConfirmation.setVisible(false);
                }
            }
            if (PART_TYPE_INSTRUCTION.equals(this.partType)) {
                this.lbUploadOA.setVisible(true);
                this.lbUploadContract.setVisible(true);
            }
        });
        this.reloadByTradeCouter((String)this.cmbTradePlatform.getSelectionModel().getSelectedItem());
        this.checkAggrementNeedToBeSigned();
        if (this.refItem == null) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u56de\u586b\u51fa\u9519\uff1a\u672a\u83b7\u53d6\u5230\u9759\u6001\u884c\u60c5"));
        }
    }

    @FXML
    public void setSecAcc() {
        if (this.cmbPortfolio.getValue() == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u5148\u9009\u62e9\u6295\u7ec4");
            return;
        }
        InstructionOtcAccSetDialog obj = (InstructionOtcAccSetDialog)((Object)this.of.create(InstructionOtcAccSetDialog.class));
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9009\u62e9\u8bc1\u5238\u8d26\u53f7");
        obj.initCheck(this.subFundAcc, this.subSecAcc);
        if (dialog.launch().equals(ButtonType.OK)) {
            this.subFund = this.accSetModel.getSubFund();
            this.subFundAcc = this.accSetModel.getSubFundAcc();
            this.subSecAcc = this.accSetModel.getSubSecAcc();
            this.trial();
            this.changeTable();
        }
    }

    protected void createTable() {
        this.colObjType.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).objTypeProperty());
        this.colObjName.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).objNameProperty());
        this.colObjName.setCellFactory(data -> new TooltipTableCell<RiskMonitor, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((RiskMonitor)this.getValue()).getObjName();
            }
        });
        this.colIndexName.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).indexNameProperty());
        this.colIndexName.setCellFactory(data -> new TooltipTableCell<RiskMonitor, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((RiskMonitor)this.getValue()).getIndexName();
            }
        });
        this.colNowValue.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).nowValueProperty());
        this.colNowValue.setCellFactory(data -> new NowValueCell());
        this.colDeptAuthor.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).deptAuthorProperty());
        this.colDeptAuthor.setCellFactory(data -> new TooltipTableCell<RiskMonitor, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((RiskMonitor)this.getValue()).getDeptAuthor();
            }
        });
        this.colCompAuthor.setCellValueFactory(data -> ((RiskMonitor)data.getValue()).compAuthorProperty());
        this.colCompAuthor.setCellFactory(data -> new TooltipTableCell<RiskMonitor, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((RiskMonitor)this.getValue()).getCompAuthor();
            }
        });
        this.tableTrial.setItems(this.trialList);
        this.tableTrial.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableTrial);
    }

    protected ReadOnlyObjectWrapper<Object> setOperation(WorkflowAttachment attachment) {
        final String[] opStr = new String[]{""};
        HBox box = new HBox(){

            public String toString() {
                return opStr[0];
            }
        };
        switch (this.partType) {
            case "PART_TYPE_INSTRUCTION": 
            case "PART_TYPE_APPROVE": 
            case "PART_TYPE_CONFIRM": {
                if (attachment.isNew()) {
                    Button btnDelete = new Button("\u5220\u9664");
                    btnDelete.getStyleClass().add((Object)"btnOperation");
                    box.setSpacing(10.0);
                    box.setAlignment(Pos.CENTER);
                    btnDelete.setOnAction(event -> this.delete(attachment));
                    opStr[0] = "\u5220\u9664";
                    box.getChildren().add((Object)btnDelete);
                }
                Button btnDown = new Button("\u4e0b\u8f7d");
                btnDown.getStyleClass().add((Object)"btnOperation");
                box.setSpacing(10.0);
                box.setAlignment(Pos.CENTER);
                btnDown.setOnAction(event -> this.download(attachment));
                opStr[0] = "\u5220\u9664";
                box.getChildren().add((Object)btnDown);
                break;
            }
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    protected void download(WorkflowAttachment attachment) {
        try {
            Response response = this.https.doGet("/workflow/file/download?fileName=" + attachment.getId());
            InputStream body = response.body().byteStream();
            if (body != null) {
                ExcelUtils.saveFile((InputStream)body, (String)attachment.getFileName());
            }
        }
        catch (MException | Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void delete(WorkflowAttachment attachment) {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u8ba4\u5220\u9664")) {
            this.attachmentList.remove((Object)attachment);
        }
    }

    protected WorkflowAttachment chooserFile(String type) {
        WorkflowAttachment attachment = null;
        File file = this.fileChooser.get();
        if (file == null) {
            return null;
        }
        if (file.getName().length() > 150) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u540d\u8d85\u8fc7\u957f\u5ea6\u9650\u5236\u9650\u5236\uff1a150");
            return null;
        }
        if (file.length() > 65535000L) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u8d85\u8fc7\u5927\u5c0f\u9650\u5236\uff1a64M");
            return null;
        }
        try {
            attachment = this.workflowTemplateApi.uploadAttachment(file);
            attachment.setType(type);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return null;
        }
        attachment.setNew(true);
        if ("fundScaleAttachment".equals(type)) {
            this.fundSizeAttachmentList.add((Object)attachment);
        } else {
            this.attachmentList.add((Object)attachment);
        }
        return attachment;
    }

    protected void uploadFile(Label lbOpera, String type) {
        WorkflowAttachment att;
        String txt = lbOpera.getText();
        Label lbName = (Label)((HBox)lbOpera.getParent()).getChildren().get(0);
        if (txt.equals(DELETE)) {
            String name = lbName.getText();
            boolean succeed = this.delete(name, type);
            if (succeed) {
                lbOpera.setText(ADD);
                lbName.setText("");
            }
        } else if (txt.equals(ADD) && (att = this.chooserFile(type)) != null) {
            lbOpera.setText(DELETE);
            lbName.setText(att.getFileName());
        }
    }

    protected boolean delete(String name, String type) {
        if (this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u8ba4\u5220\u9664")) {
            if ("fundScaleAttachment".equals(type)) {
                if (!this.fundSizeAttachmentList.isEmpty()) {
                    this.fundSizeAttachmentList.clear();
                }
                this.lbFileScaleAttachment.setText("");
                return true;
            }
            for (WorkflowAttachment att : this.attachmentList) {
                if (!att.getFileName().equals(name)) continue;
                this.attachmentList.remove((Object)att);
                return true;
            }
        }
        return false;
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public ITradeModel getModel() {
        return null;
    }

    protected void clearInfo() {
        this.refItem = null;
        this.refItemTarget = null;
        this.cmbPortfolio.getSelectionModel().clearSelection();
        this.bonusAmt.setText("");
        this.bonusQty.setText("");
        this.confirmedBuyAmt.setText("");
        this.redeemDate.getEditor().setText("");
        this.redeemDate.setValue(null);
        this.appliedBuyAmt.setText("");
        this.redeemDate.getEditor().setText("");
        this.redeemQty.setText("");
        this.redeemAmt.setText("");
        this.cmbSide.getSelectionModel().select(0);
        this.cmbBonusType.getSelectionModel().select(0);
        this.cmbCounterParty.getSelectionModel().clearSelection();
        this.attachmentList.clear();
        this.fundSizeAttachmentList.clear();
        this.trialList.clear();
        TableUtils.autoResizeColumns(this.tableTrial);
        this.lbssuer.setText("");
        this.lbScale.setText("");
        this.lbOpenDay.setText("");
        this.hide();
        this.clearUpload();
        this.showRefItemInfo(false);
        this.showValuationInfo(false);
        this.personCode.setText("");
        this.txtCode.clear();
        this.txtTargetCode.clear();
        this.lbName.setText("");
        this.lbTargetName.setText("");
        this.provistonQty.setText("");
        this.txtConfirmProvistonQty.setText("");
    }

    protected void showRefItemInfo(boolean show) {
        if (!show) {
            this.lbssuer.setText("");
            this.lbScale.setText("");
            this.lbOpenDay.setText("");
            this.cmbInvested.getSelectionModel().clearSelection();
            this.cmbMethod.getSelectionModel().clearSelection();
        }
        this.cmbInvested.setDisable(!show);
        this.cmbMethod.setDisable(!show);
        this.lbUpdateFoundWay.setVisible(show);
        this.lbCancelFoundWay.setVisible(show);
    }

    protected void showValuationInfo(boolean show) {
        if (!show) {
            this.txtNewUnitCost.clear();
            this.txtNewScale.clear();
            this.txtParentFundSize.clear();
            this.lbFileScaleAttachment.setText("");
            this.lbUploadScaleAttachment.setText(ADD);
        }
        this.txtNewUnitCost.setDisable(!show);
        this.txtNewScale.setDisable(!show);
        this.txtParentFundSize.setDisable(!show);
        this.lbCancelValuation.setDisable(!show);
        this.lbUpdateValuation.setVisible(show);
        this.lbCancelValuation.setVisible(show);
    }

    protected void clearUpload() {
        this.lbFileOA.setText("");
        this.lbFileContract.setText("");
        this.lbFileConfirmation.setText("");
        this.lbUploadOA.setText(ADD);
        this.lbUploadOA.setVisible(true);
        this.lbUploadContract.setText(ADD);
        this.lbUploadContract.setVisible(true);
        this.lbUploadConfirmation.setText(ADD);
        this.lbUploadConfirmation.setVisible(true);
    }

    protected Boolean isconfirm(NewInstructionReq newInsReq) {
        InstructionOtcFundDialog obj = (InstructionOtcFundDialog)this.of.create(InstructionOtcFundDialog.class);
        newInsReq.getInstruction().setPortfolioName(((Portfolio)this.cmbPortfolio.getValue()).getName());
        OtcOrderDetail detail = (OtcOrderDetail)newInsReq.getInstruction().getDetail();
        if (this.cmbCounterParty.getValue() != null) {
            detail.setCounterPartyName(((CounterPartyAccount)this.cmbCounterParty.getValue()).getCounterParty().getName());
        }
        obj.setDialog(newInsReq);
        MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u8fbe\u6307\u4ee4\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
        if (dialog.launch() != ButtonType.OK) {
            return false;
        }
        return true;
    }

    @FXML
    protected void trial() {
        if (!this.jg && this.gs) {
            Portfolio portfolio = (Portfolio)this.cmbPortfolio.getSelectionModel().getSelectedItem();
            String side = ((MxNode)this.cmbSide.getValue()).getRaw();
            if (portfolio == null || this.refItem == null && !"4".equals(side)) {
                this.trialList.clear();
                TableUtils.autoResizeColumns(this.tableTrial);
                return;
            }
            GetQuotaValueReq req = new GetQuotaValueReq();
            req.setPortfolioId(portfolio.getId());
            try {
                Account account = this.accountMng.getAccountFromCache(this.subFund.getParentExtAccntId());
                List productIds = this.fundAccMng.getProductIds();
                if (account != null && productIds.contains(account.getProductId())) {
                    req.setProductId(account.getProductId());
                }
            }
            catch (MException e) {
                this.logger.error("\u83b7\u53d6\u573a\u5916\u57fa\u91d1\u8d26\u53f7\u4ea7\u54c1\u51fa\u9519", (Throwable)e);
            }
            try {
                List assetGrpIdsByPost = this.grpAai.getAssetGrpIdsByPost(this.baseApi.getPostId());
                for (String assetId : assetGrpIdsByPost) {
                    PAssetgroupService.AssetGroup assetGrpDetail = this.grpAai.getAssetGrpDetail(assetId);
                    if (!assetGrpDetail.getPortfolioIdList().contains((Object)portfolio.getId())) continue;
                    req.getAssetGroupId().add(assetId);
                }
            }
            catch (MException | Exception e1) {
                this.logger.error("\u67e5\u8be2\u8d44\u4ea7\u7ec4\u51fa\u9519", e1);
            }
            this.mapTrial.put(this.subFund.getParentExtAccntId(), this.subFund);
            req.setAccountId(this.subFund.getParentExtAccntId());
            Instrument inst = new Instrument();
            if (!"4".equals(side)) {
                inst.setSecurityId(this.refItem.getCode());
                inst.setSymbol(this.refItem.getName());
                inst.setSecurityType(this.refItem.getType());
                inst.setMarket(this.refItem.getMarket());
            } else {
                if (this.refItemTarget == null) {
                    this.trialList.clear();
                    TableUtils.autoResizeColumns(this.tableTrial);
                    return;
                }
                inst.setSecurityId(this.refItemTarget.getCode());
                inst.setSymbol(this.refItemTarget.getName());
                inst.setSecurityType(this.refItemTarget.getType());
                inst.setMarket(this.refItemTarget.getMarket());
            }
            req.setInstrument(inst);
            try {
                List listQuota = this.quotaApi.getQuotaValue(req);
                if (listQuota != null && !listQuota.isEmpty()) {
                    this.trialList.setAll(this.queryTreshold(listQuota, portfolio.getName()));
                    TableUtils.autoResizeColumns(this.tableTrial);
                } else {
                    this.trialList.clear();
                    TableUtils.autoResizeColumns(this.tableTrial);
                    this.logger.info("trial is Empty , getQuotaValue resp : " + listQuota);
                }
            }
            catch (MException | Exception e) {
                this.logger.error((Object)e, e);
                this.alert.alert(Alert.AlertType.ERROR, "\u9650\u989d\u67e5\u8be2\u51fa\u9519" + e.getMessage());
            }
        }
    }

    protected Collection<RiskMonitor> queryTreshold(List<QuotaValue> list, String ojbName) throws MException {
        HashMap<Integer, RiskMonitor> map = new HashMap<Integer, RiskMonitor>();
        GetThresholdListReq req = new GetThresholdListReq();
        for (QuotaValue quotaV : list) {
            GetQuotaDetailReq quotaDetailReq = new GetQuotaDetailReq();
            quotaDetailReq.setQuotaId(quotaV.getQuotaId());
            Quota quota = this.quotaSetApi.getQuotaDetail(quotaDetailReq);
            RiskMonitor rm = new RiskMonitor();
            rm.update(quotaV);
            rm.update(quota);
            if ("\u6295\u8d44\u7ec4\u5408".equals(rm.getObjType())) {
                rm.setObjName(this.portAccModel.getPortfolioNameById(rm.getObjName()));
            } else if ("\u4ea7\u54c1".equals(rm.getObjType())) {
                rm.setObjName(this.pmng.getProductDetailFromCache(rm.getObjName()).getName());
            } else if ("\u4ea7\u54c1\u7ec4".equals(rm.getObjType()) || "\u8d26\u6237\u7ec4".equals(rm.getObjType()) || "\u6295\u8d44\u7ec4\u5408\u7ec4".equals(rm.getObjType()) || "\u6df7\u5408\u7ec4".equals(rm.getObjType())) {
                rm.setObjName(this.grpService.getCacheAsset(rm.getObjName()));
            } else {
                rm.setObjName(this.mapTrial.get(rm.getObjName()) == null ? "" : this.mapTrial.get(rm.getObjName()).getInvestId());
            }
            map.put(quotaV.getQuotaId(), rm);
        }
        req.setQuotaIds(Arrays.asList((Integer[])map.keySet().stream().toArray(Integer[]::new)));
        List listThreshold = this.quotaSetApi.getThresholdList(req);
        if (listThreshold == null) {
            return new ArrayList<RiskMonitor>();
        }
        listThreshold.forEach(threshold -> {
            RiskMonitor rm = (RiskMonitor)map.get(threshold.getQuotaId());
            if (rm != null) {
                rm.update(threshold);
            }
        });
        return map.values();
    }

    protected void setRefItemInfo() {
        OtcRefItem otc;
        String side = ((MxNode)this.cmbSide.getValue()).getRaw();
        if (this.refItem == null && !"4".equals(side)) {
            this.showRefItemInfo(false);
            return;
        }
        if (this.refItemTarget == null && "4".equals(side)) {
            this.showRefItemInfo(false);
            return;
        }
        if ("4".equals(side)) {
            otc = (OtcRefItem)OtcRefItem.class.cast(this.refItemTarget);
            if (otc.isNeedQuery()) {
                this.refMng.queryFundInfo(this.refItemTarget);
            }
        } else {
            otc = (OtcRefItem)OtcRefItem.class.cast(this.refItem);
            if (otc.isNeedQuery()) {
                this.refMng.queryFundInfo(this.refItem);
            }
        }
        for (CounterPartyAccount cpa : this.cmbCounterParty.getItems()) {
            if (!cpa.getCounterParty().getName().equals(otc.getIssuer())) continue;
            this.cmbCounterParty.getSelectionModel().select((Object)cpa);
        }
        this.lbssuer.setText(otc.getIssuer());
        this.lbScale.setText(StringUtils.toStr((double)otc.getIssueSize(), (int)2));
        this.lbOpenDay.setText(otc.getNextOpenDate());
        this.cmbInvested.getSelectionModel().select((Object)otc.getInvestedTarget());
        this.cmbMethod.getItems().forEach(node -> {
            if (node.getValue().equals(String.valueOf(otc.getIssueType()))) {
                this.cmbMethod.getSelectionModel().select(node);
                return;
            }
        });
    }

    protected boolean updateFundInfo() {
        UpdateSecurityReq req = new UpdateSecurityReq();
        req.setMarket(this.refItem.getMarket());
        req.setSecurityId(this.refItem.getCode());
        req.setSecurityType(this.refItem.getType());
        FundInfo fund = new FundInfo();
        Security security = new Security();
        Instrument inst = new Instrument();
        inst.setSecurityId(this.refItem.getCode());
        inst.setSymbol(this.refItem.getName());
        inst.setMarket(this.refItem.getMarket());
        security.setInstrument(inst);
        fund.setSecurity(security);
        FundParams param = new FundParams();
        OtcRefItem otc = (OtcRefItem)OtcRefItem.class.cast(this.refItem);
        param.setIssuer(otc.getIssuer());
        param.setInvestedTarget((String)this.cmbInvested.getValue());
        param.setIssueType(((MxNode)this.cmbMethod.getValue()).getValue());
        fund.setParams(param);
        req.setFund(fund);
        try {
            this.maintenanceApi.updateSecurity(req);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u6807\u7684\u4fe1\u606f\u4fee\u6539\u6210\u529f\uff01");
            otc.setInvestedTarget(param.getInvestedTarget());
            otc.setIssueType(param.getIssueType());
            return true;
        }
        catch (MException e) {
            this.logger.error("\u6807\u7684\u4fe1\u606f\u4fee\u6539\u5931\u8d25\uff01", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return false;
        }
    }

    protected void queryValuationInfo(boolean overWrite) {
        try {
            String side = ((MxNode)this.cmbSide.getValue()).getRaw();
            if (this.refItem == null && !"4".equals(side)) {
                this.txtNewUnitCost.clear();
                this.txtNewScale.clear();
                this.txtParentFundSize.clear();
                this.lbFileScaleAttachment.setText("");
                this.lbUploadScaleAttachment.setText(ADD);
                this.lbCancelValuation.setDisable(true);
                this.fundSizeAttachmentList.clear();
                this.txtNewUnitCost.setDisable(true);
                this.txtNewScale.setDisable(true);
                this.txtParentFundSize.setDisable(true);
                return;
            }
            if (this.refItemTarget == null && "4".equals(side)) {
                this.txtNewUnitCost.clear();
                this.txtNewScale.clear();
                this.txtParentFundSize.clear();
                this.lbFileScaleAttachment.setText("");
                this.lbUploadScaleAttachment.setText(ADD);
                this.lbCancelValuation.setDisable(true);
                this.fundSizeAttachmentList.clear();
                this.txtNewUnitCost.setDisable(true);
                this.txtNewScale.setDisable(true);
                this.txtParentFundSize.setDisable(true);
                return;
            }
            GetValuationReq req = new GetValuationReq();
            if ("4".equals(side)) {
                req.setMarket(this.refItemTarget.getMarket());
                req.getSecurityId().add(this.refItemTarget.getCode());
            } else {
                req.setMarket(this.refItem.getMarket());
                req.getSecurityId().add(this.refItem.getCode());
            }
            String endDate = LocalDate.now().toString().replace("-", "");
            req.setEndDate(endDate);
            List listVal = this.valuationApi.getValuation(req);
            String newUnitCost = "0";
            String newScale = "0";
            String newParentFundSize = "0";
            if (listVal != null && listVal.size() > 0) {
                this.valuation = (Valuation)listVal.get(0);
                newUnitCost = StringUtils.toStr((double)this.valuation.getNetValue(), (int)4);
                newScale = StringUtils.toStr((double)this.valuation.getFundSize(), (int)2);
                newParentFundSize = StringUtils.toStr((double)this.valuation.getParentFundSize(), (int)2);
                if (this.valuation.getMark() != null && this.gson.fromJson(this.valuation.getMark(), WorkflowAttachment.class) != null) {
                    WorkflowAttachment attachment = (WorkflowAttachment)this.gson.fromJson(this.valuation.getMark(), WorkflowAttachment.class);
                    this.lbFileScaleAttachment.setText(attachment.getFileName());
                    this.lbUploadScaleAttachment.setText(DELETE);
                } else {
                    this.lbFileScaleAttachment.setText("");
                    this.lbUploadScaleAttachment.setText(ADD);
                }
            } else {
                this.valuation = new Valuation();
                this.lbFileScaleAttachment.setText("");
                this.lbUploadScaleAttachment.setText(ADD);
            }
            this.canUpdate.setValue(Boolean.valueOf(false));
            if (overWrite) {
                this.txtNewUnitCost.setText(newUnitCost);
                this.txtNewScale.setText(newScale);
                this.txtParentFundSize.setText(newParentFundSize);
            }
            this.changeTable();
        }
        catch (MException | Exception e) {
            this.logger.error("\u83b7\u53d6\u57fa\u91d1\u51c0\u503c\u51fa\u9519 ", e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void checkRights(MxNode node) {
        ArrayList list = new ArrayList(node.getNodes());
        for (MxNode no : list) {
            if (this.rightsModel.registerCheck(new String[]{(String)BsDict.NEW_INSTRUCTION_SIDE_FUNC.get(no.getRaw())})) continue;
            node.removeNode(no.getRaw());
        }
    }

    protected boolean updateValuationInfo() {
        double parentFundSize;
        double newUnitCost = StringUtils.parseDouble((String)this.txtNewUnitCost.getText());
        double newScale = StringUtils.parseDouble((String)this.txtNewScale.getText());
        if (newScale > (parentFundSize = StringUtils.parseDouble((String)this.txtParentFundSize.getText()))) {
            this.alert.alert(Alert.AlertType.ERROR, "\u4fee\u6539\u57fa\u91d1\u4f30\u503c\u4fe1\u606f\uff0c\u6700\u65b0\u89c4\u6a21\u4e0d\u5f97\u5927\u4e8e\u6bcd\u57fa\u91d1\u89c4\u6a21");
            return false;
        }
        if (this.fundSizeAttachmentList.isEmpty() && (newScale != this.valuation.getFundSize() || parentFundSize != this.valuation.getParentFundSize())) {
            this.alert.alert(Alert.AlertType.ERROR, this.lbFileScaleAttachment.getText().isEmpty() ? "\u4fee\u6539\u57fa\u91d1\u4f30\u503c\u4fe1\u606f\uff0c\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6" : "\u4fee\u6539\u57fa\u91d1\u4f30\u503c\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u9644\u4ef6");
            return false;
        }
        if (!this.fundSizeAttachmentList.isEmpty()) {
            this.valuation.setMark(this.gson.toJson(this.fundSizeAttachmentList.get(0)));
        }
        if (this.lbFileScaleAttachment.getText().isEmpty()) {
            this.valuation.setMark("");
        }
        this.valuation.setNetValue(newUnitCost);
        this.valuation.setFundSize(newScale);
        this.valuation.setParentFundSize(parentFundSize);
        try {
            PutValuationReq req = new PutValuationReq();
            this.valuation.setMarket(this.refItem.getMarket());
            this.valuation.setSecurityId(this.refItem.getCode());
            String endDate = LocalDate.now().toString().replace("-", "");
            this.valuation.setTradingDate(endDate);
            req.setValuation(this.valuation);
            this.valuationApi.updateValuation(req);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4f30\u503c\u4fe1\u606f\u4fee\u6539\u6210\u529f\uff01");
            this.queryValuationInfo(true);
            this.fundSizeAttachmentList.clear();
            return true;
        }
        catch (MException | Exception e) {
            this.logger.error("\u4f30\u503c\u4fe1\u606f\u4fee\u6539\u5931\u8d25\uff01", e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            return false;
        }
    }

    public MxNode getSideNode() {
        return this.sideNode;
    }

    public void setSideNode(MxNode sideNode) {
        this.sideNode = sideNode;
    }

    class AttachTypeTableCell<S>
    extends TableCell<S, String> {
        AttachTypeTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if ("oa".equals(item)) {
                    this.setText("OA");
                } else if ("contract".equals(item)) {
                    this.setText("\u5408\u540c");
                } else if ("confirmation".equals(item)) {
                    this.setText("\u4efd\u989d\u786e\u8ba4\u4e66");
                } else {
                    this.setText("");
                }
            } else {
                this.setText(null);
            }
        }
    }

    public class NowValueCell
    extends TableCell<RiskMonitor, String> {
        protected Label label = new Label();

        public void updateItem(String value, boolean empty) {
            try {
                if (value == null || empty) {
                    this.setGraphic(null);
                    return;
                }
                this.label.setText(value);
                RiskMonitor riskM = (RiskMonitor)this.getTableRow().getItem();
                if (riskM.getNowVal() > riskM.getCompVal() && riskM.getCompVal() != 0.0) {
                    this.label.setStyle("-fx-text-fill:-fx-global-red");
                } else if (riskM.getNowVal() > riskM.getDeptVal() && riskM.getDeptVal() != 0.0) {
                    this.label.setStyle("-fx-text-fill:#EEBB55");
                } else {
                    this.label.setStyle("-fx-text-fill:-fx-global-text-color");
                }
                this.setGraphic((Node)this.label);
                Tooltip tooltip = new Tooltip(value);
                tooltip.setMaxWidth(400.0);
                tooltip.setWrapText(true);
                this.setTooltip(tooltip);
            }
            catch (Exception e) {
                InstructionOtcFundBasePart.this.logger.error("SideCell update error : " + e.getMessage());
            }
        }
    }
}

