/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.viewers;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.instructions.http.viewers.InstructionOtcFundBasePart;
import cms.tmx.javafx.MxNode;
import cms.tmx.query.current.models.NewInstructionModel;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class InstructionOtcFundApprovePart
extends InstructionOtcFundBasePart {
    @Inject
    private NewInstructionModel insModel;
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObInstruction)) {
            return;
        }
        ObInstruction ins = (ObInstruction)ObInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };

    @PostConstruct
    public void init() {
        super.init();
        this.partType = "PART_TYPE_APPROVE";
        this.instruction = null;
        this.es.subscribe("instruction.set.on.panel", this.hSetCodeApp);
    }

    @Override
    public void initialize() {
        this.setConfirmSymbol("\u5ba1\u6279");
        this.hBoxOtcTradePart.getChildren().clear();
        this.hBoxOtcTradePart.getChildren().add((Object)this.vBoxInsPart);
        this.hBoxOtcTradePart.getChildren().add((Object)this.vBoxUploadPart);
        super.initialize();
        this.controlComponent();
        this.initFinished.set(true);
        this.doFill();
    }

    @Override
    protected void submitOrder() {
        WorkflowTask task = null;
        List workflowTasks = this.instruction.getWorkflowTasks();
        String operation = "";
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains("2")) {
                task = workflowTask;
                operation = "2";
            }
            if (!workflowTask.getPermissibleList().contains("6")) continue;
            task = workflowTask;
            operation = "6";
        }
        if (task == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25\uff0c\u672a\u53d6\u5230\u5ba1\u6279\u4efb\u52a1");
            return;
        }
        try {
            this.insModel.audit(this.instruction, operation, task, (List)this.attachmentList);
        }
        catch (MException | Exception e) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6307\u4ee4\u5ba1\u6279\u5931\u8d25:" + e.getMessage());
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u6307\u4ee4\u5ba1\u6279\u6210\u529f");
        this.clearInfo();
    }

    @Override
    protected void clearInfo() {
        super.clearInfo();
        this.instruction = null;
        this.btnOrder.setDisable(true);
        this.tradeDate.getEditor().setText("");
        this.tradeDate.setValue(null);
        this.bonusDate.getEditor().setText("");
        this.bonusDate.setValue(null);
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    private void controlComponent() {
        this.btnOrder.setText("\u5ba1\u6279\u901a\u8fc7");
        this.cmbPortfolio.setDisable(true);
        this.txtCode.setDisable(true);
        this.lbName.setDisable(true);
        this.confirmedBuyAmt.setDisable(true);
        this.appliedBuyAmt.setDisable(true);
        this.redeemQty.setDisable(true);
        this.bonusAmt.setDisable(true);
        this.bonusQty.setDisable(true);
        this.tradeDate.setDisable(true);
        this.redeemDate.setDisable(true);
        this.bonusDate.setDisable(true);
        this.cmbSide.setDisable(true);
        this.cmbBonusType.setDisable(true);
        this.cmbCounterParty.setDisable(true);
        this.lbBankAcc.setDisable(true);
        this.lbSetAcc.setDisable(true);
        this.cmbTradePlatform.setDisable(true);
        this.personCode.disableProperty().unbind();
        this.personCode.setDisable(true);
        this.txtTargetCode.setDisable(true);
    }

    private boolean validOrderFill(ObInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"FundDetail"}) && ins.isIsApproveStep();
    }

    @Override
    protected void reloadComponent() {
        if (this.cmbSide.getValue() == null) {
            return;
        }
        switch (((MxNode)this.cmbSide.getValue()).getRaw()) {
            case "1": {
                this.panelType = "SUBSCRIBE_BUY";
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "0": {
                this.panelType = "CREATION_BUY";
                this.canBuyCol.setVisible(true);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "2": {
                this.panelType = "REDEEM";
                this.lbQty.setText("\u8d4e\u56de\u4efd\u989d");
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                break;
            }
            case "3": {
                if (this.cmbBonusType.getValue() == null) {
                    this.cmbBonusType.getSelectionModel().select(0);
                }
                this.panelType = "0".equals(((MxNode)this.cmbBonusType.getValue()).getRaw()) ? "BONUS_CASH" : "BONUS_INVEST";
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                break;
            }
            case "4": {
                this.panelType = "TRANSFER";
                this.lbQty.setText("\u8f6c\u6362\u4efd\u989d");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(true);
                if (!this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().add(4, (Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) break;
                this.vBoxInsPart.getChildren().add(5, (Object)this.targetNameHbox);
                break;
            }
            case "5": {
                this.panelType = "PROVISTON";
                this.btnOrder.setText("\u4e1a\u7ee9\u8ba1\u63d0");
                this.canBuyCol.setVisible(false);
                this.canSellCol.setVisible(false);
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetCodeHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetCodeHbox);
                }
                if (this.vBoxInsPart.getChildren().contains((Object)this.targetNameHbox)) {
                    this.vBoxInsPart.getChildren().remove((Object)this.targetNameHbox);
                }
                if (!this.componentBox.getChildren().contains((Object)this.hBoxCounterParty)) break;
                this.componentBox.getChildren().remove((Object)this.hBoxCounterParty);
                break;
            }
        }
        this.componentBox.getChildren().setAll((Collection)this.panelMap.get(this.panelType));
        this.layout();
        this.changeTable();
        Platform.runLater(() -> {
            this.componentBox.requestFocus();
            if (this.cmbTradePlatform.getSelectionModel().getSelectedItem() != null) {
                this.reloadByTradeCouter((String)this.cmbTradePlatform.getSelectionModel().getSelectedItem());
            }
        });
    }
}

