/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.viewers;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.instructions.http.models.InstructionOtcFundAccSetModel;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionOtcAccSetDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(InstructionOtcAccSetDialog.class);
    @FXML
    protected TreeTableView<CcsAccountDistribution> otcAcctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @Inject
    private MxAlert alert;
    @Inject
    private InstructionOtcFundAccSetModel model;
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private TreeItem<CcsAccountDistribution> root = new TreeItem();
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    if (treeItem.isLeaf()) {
                        this.disableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                                treeItem.getParent().getChildren().forEach(each -> {
                                    if (!each.equals(treeItem) && each.getValue() != null && ((CcsAccountDistribution)each.getValue()).getSecAcc().getExchange().getRaw().equals(((CcsAccountDistribution)treeItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                        ((CcsAccountDistribution)each.getValue()).setSelected(false);
                                    }
                                });
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        this.getTreeTableRow().disableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).disableProperty());
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                InstructionOtcAccSetDialog.this.otcAcctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> InstructionOtcAccSetDialog.this.otcAcctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> {
                            boolean xshg = true;
                            boolean xshe = true;
                            boolean xotc = true;
                            treeItem.getChildren();
                            for (TreeItem cadItem : treeItem.getChildren()) {
                                ((CcsAccountDistribution)cadItem.getValue()).setSelected(false);
                                if (!((CcsAccountDistribution)treeItem.getValue()).isSelected()) continue;
                                if (xshg && "XSHG".equals(((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                    ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                    xshg = false;
                                }
                                if (xshe && "XSHE".equals(((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) {
                                    ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                    xshe = false;
                                }
                                if (!xotc || !"XOTC".equals(((CcsAccountDistribution)cadItem.getValue()).getSecAcc().getExchange().getRaw())) continue;
                                ((CcsAccountDistribution)cadItem.getValue()).setSelected(true);
                                xshe = false;
                            }
                        });
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };

    @FXML
    public void initialize() {
        this.createTree();
    }

    public void initCheck(String subFund, String subSec) {
        try {
            for (TreeItem fundItem : this.root.getChildren()) {
                if (((CcsAccountDistribution)fundItem.getValue()).getAcc() instanceof CcsSubFundAccount && ((CcsSubFundAccount)CcsSubFundAccount.class.cast(((CcsAccountDistribution)fundItem.getValue()).getAcc())).getSubAccntId().equals(subFund)) {
                    ((CcsAccountDistribution)fundItem.getValue()).setSelected(true);
                    for (TreeItem secItem : fundItem.getChildren()) {
                        if (((CcsAccountDistribution)secItem.getValue()).getSecAcc() instanceof CcsSubSecAccount && ((CcsSubSecAccount)CcsSubSecAccount.class.cast(((CcsAccountDistribution)secItem.getValue()).getSecAcc())).getSubSecAccntId().equals(subSec)) {
                            ((CcsAccountDistribution)secItem.getValue()).setSelected(true);
                            continue;
                        }
                        ((CcsAccountDistribution)secItem.getValue()).setSelected(false);
                    }
                    continue;
                }
                ((CcsAccountDistribution)fundItem.getValue()).setSelected(false);
                for (TreeItem secItem : fundItem.getChildren()) {
                    ((CcsAccountDistribution)secItem.getValue()).setSelected(false);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8d26\u53f7\u9009\u62e9\u6062\u590d\u51fa\u9519", (Throwable)e);
        }
    }

    private void createTree() {
        this.root = this.model.getRoot();
        this.root.setExpanded(true);
        this.otcAcctTreeTable.setRoot(this.root);
        this.otcAcctTreeTable.setShowRoot(false);
        this.otcAcctTreeTable.setPlaceholder((Node)new Label());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
    }

    protected boolean isOK(ButtonType bt) {
        int selectedSecNum = 0;
        CcsAccountDistribution selectedFund = null;
        CcsAccountDistribution selectedSec = null;
        for (TreeItem accItem : this.root.getChildren()) {
            if (!((CcsAccountDistribution)accItem.getValue()).isSelected()) continue;
            selectedFund = (CcsAccountDistribution)accItem.getValue();
            for (TreeItem secItem : accItem.getChildren()) {
                if (!((CcsAccountDistribution)secItem.getValue()).isSelected()) continue;
                ++selectedSecNum;
                selectedSec = (CcsAccountDistribution)secItem.getValue();
            }
        }
        if (selectedSecNum < 1) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u4e00\u4e2a\u8bc1\u5238\u8d26\u53f7\uff01");
            return false;
        }
        if (selectedSecNum > 1) {
            this.alert.alert(Alert.AlertType.ERROR, "\u6700\u591a\u9009\u62e9\u4e00\u4e2a\u8bc1\u5238\u8d26\u53f7\uff01");
            return false;
        }
        if (selectedFund.getAcc() instanceof CcsSubFundAccount) {
            this.model.setSubFund((CcsSubFundAccount)CcsSubFundAccount.class.cast(selectedFund.getAcc()));
        }
        if (selectedSec.getSecAcc() instanceof CcsSubSecAccount) {
            CcsSubSecAccount subSec = (CcsSubSecAccount)CcsSubSecAccount.class.cast(selectedSec.getSecAcc());
            this.model.setSubFundAcc(subSec.getSubAccntId());
            this.model.setSubSecAcc(subSec.getSubSecAccntId());
        }
        return true;
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }
}

