/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.models;

import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.PortfolioAccountDistribution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.portfolio.models.FilterAccountModel;
import cms.tmx.portfolio.uitls.PortfolioAccountDistTreeList;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.models.OtcFundPositionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionOtcFundDistributionModel
extends MxModel {
    @Inject
    private OtcPortfolioAccountModel otcModel;
    @Inject
    private FilterAccountModel filterModel;
    @Inject
    private OtcFundPositionModel posModel;
    @Inject
    private IFundAccountService ifa;
    @Inject
    private ExecutorService exe;
    private final int MAP_CAP = 100;
    private final int INIT_UNIT = 100;
    private BooleanProperty showCanBuy = new SimpleBooleanProperty(true);
    private LongProperty canBuy = new SimpleLongProperty();
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty percent = new SimpleDoubleProperty();
    private IntegerProperty unit = new SimpleIntegerProperty(100);
    private IntegerProperty unitConvert = new SimpleIntegerProperty(1);
    private ObjectProperty<RefItem> refItem = new SimpleObjectProperty();
    private BooleanProperty repo = new SimpleBooleanProperty(false);
    private boolean hkwolun = false;
    private ReentrantLock lock = new ReentrantLock();
    private BooleanProperty single = new SimpleBooleanProperty(false);
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private StringProperty searchSec = new SimpleStringProperty("");
    protected boolean hasChecked = false;
    private static final int RECAL_INTERVAL = 500;
    @Inject
    protected MScheduler sdReCalculate;
    protected TreeItem<PortfolioAccountDistribution> root = new TreeItem((Object)new PortfolioAccountDistribution());
    protected MxTreeList<PortfolioAccountDistribution> portfolioMxList;
    protected Map<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>> mapPortFolioAcc = new HashMap<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>>(100);
    protected Map<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>> mapAccSec = new HashMap<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>>(100);
    protected Map<String, Long> mapQuantiy = new HashMap<String, Long>();
    protected InvalidationListener lstPosition = ob -> Platform.runLater(() -> {
        this.filterAcc();
        this.showCanBuy();
    });
    protected InvalidationListener lstPotfolio = ob -> this.onFundChange();

    public TreeItem<PortfolioAccountDistribution> getRoot() {
        return this.root;
    }

    public synchronized TreeItem<PortfolioAccountDistribution> create() throws MException {
        this.sdReCalculate.setInterval(500);
        this.queryPostition();
        this.getPosModel().changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.getLstPosition()));
        this.createPortfolioTree();
        return this.root;
    }

    public TreeItem<PortfolioAccountDistribution> createPortfolioTree() throws MException {
        LinkedList<PortfolioAccountDistribution> portfolioDistList = new LinkedList<PortfolioAccountDistribution>();
        this.portfolioMxList = new PortfolioAccountDistTreeList(this.root, this.root.getChildren(), portfolioDistList);
        this.mapPortFolioAcc.clear();
        this.mapAccSec.clear();
        this.lock.lock();
        try {
            for (Portfolio pf : this.getPortfolios()) {
                PortfolioAccountDistribution dist = new PortfolioAccountDistribution();
                dist.setPortfolio(pf);
                dist.setPortDist(true);
                dist.setCount(this.mapQuantiy.get(pf.getId()) == null ? 0L : this.mapQuantiy.get(pf.getId()));
                dist.setSelected(this.isSelected());
                portfolioDistList.add(dist);
                this.portfolioMxList.update(portfolioDistList);
                if (this.root.getChildren().size() < portfolioDistList.size()) {
                    portfolioDistList.remove(portfolioDistList.size() - 1);
                    continue;
                }
                MxTreeList<PortfolioAccountDistribution> fundMxList = this.createFundAccTree((TreeItem<PortfolioAccountDistribution>)((TreeItem)this.root.getChildren().get(portfolioDistList.size() - 1)), this.getAccSecsMap(pf));
                this.mapPortFolioAcc.put(dist, fundMxList);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.root;
    }

    public MxTreeList<PortfolioAccountDistribution> createFundAccTree(TreeItem<PortfolioAccountDistribution> fundRoot, Map<CcsFundAccount, List<SecAccount>> map) {
        Portfolio port = ((PortfolioAccountDistribution)fundRoot.getValue()).getPortfolio();
        LinkedList<PortfolioAccountDistribution> accList = new LinkedList<PortfolioAccountDistribution>();
        PortfolioAccountDistTreeList accMxList = new PortfolioAccountDistTreeList(fundRoot, fundRoot.getChildren(), accList);
        if (map == null || map.isEmpty()) {
            return accMxList;
        }
        for (FundAccount fundAccount : map.keySet()) {
            boolean haveOtcSec;
            List<SecAccount> list = map.get(fundAccount);
            if (map.get(fundAccount).isEmpty() || !(haveOtcSec = list.stream().anyMatch(item -> "XOTC".equals(item.getExchange().getRaw())))) continue;
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            PortfolioAccountDistribution accDst = new PortfolioAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setPortfolio(port);
            accList.add(accDst);
            accMxList.update(accList);
            LinkedList<PortfolioAccountDistribution> secAccList = new LinkedList<PortfolioAccountDistribution>();
            for (SecAccount secAcc : map.get(fundAccount)) {
                PortfolioAccountDistribution secDst = new PortfolioAccountDistribution();
                secAccList.add(secDst);
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setPortfolio(port);
            }
            PortfolioAccountDistTreeList secMxList = new PortfolioAccountDistTreeList((TreeItem)fundRoot.getChildren().get(accList.size() - 1), ((TreeItem)fundRoot.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapAccSec.put(accDst, (MxTreeList<PortfolioAccountDistribution>)secMxList);
        }
        return accMxList;
    }

    protected List<Portfolio> getPortfolios() {
        ArrayList<Portfolio> portfolios = new ArrayList<Portfolio>();
        List portfolioList = this.otcModel.getPortfolios();
        portfolioList.removeIf(portfolio -> this.otcModel.getMap(portfolio) == null || this.otcModel.getMap(portfolio).isEmpty());
        portfolios.addAll(portfolioList);
        return portfolios;
    }

    protected Map<CcsFundAccount, List<SecAccount>> getAccSecsMap(Portfolio pf) {
        return this.otcModel.getMap(pf);
    }

    private void queryPostition() {
        this.exe.execute(() -> this.getPosModel().query());
    }

    public synchronized void filterAcc() {
        this.fundCanBuy();
        this.calCanBuySell();
        this.secCanSell();
        this.changed();
    }

    private void onFundChange() {
        this.changed();
    }

    private void onWeightChange() {
        this.changed();
    }

    private void onSelectChange() {
        this.changed();
    }

    public void changed() {
        this.sdReCalculate.schedule(event -> super.changed());
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    public void showCanBuy() {
        int accNum = 0;
        if (this.isRepo()) {
            this.setShowCanBuy(false);
        } else if (this.isBuy()) {
            for (PortfolioAccountDistribution dist : this.mapAccSec.keySet()) {
                if (!dist.isSelected() || !dist.isShow()) continue;
                this.setCanBuy(dist.getCanBuy());
                ++accNum;
            }
            this.setShowCanBuy(accNum == 1);
        } else {
            int secNum = 0;
            for (MxTreeList<PortfolioAccountDistribution> secList : this.mapAccSec.values()) {
                for (PortfolioAccountDistribution secDist : secList.getOrList()) {
                    if (!secDist.isSelected() || !secDist.isShow()) continue;
                    ++secNum;
                    this.setCanBuy(secDist.getCanSell());
                }
            }
            this.setShowCanBuy(secNum == 1);
        }
    }

    public void fundCanBuy() {
        LinkedList<MxTreeList<PortfolioAccountDistribution>> portFolioAccList = new LinkedList<MxTreeList<PortfolioAccountDistribution>>(this.mapPortFolioAcc.values());
        for (MxTreeList mxTreeList : portFolioAccList) {
            mxTreeList.getOrList().forEach(acc -> {
                long canBuy = 0L;
                acc.setCanBuy(0L);
                if (this.getRefItem() == null) {
                    this.getRefItem();
                }
                if (this.getRefItem() != null && this.getPrice() > 0.0 && this.getUnit() != 0) {
                    canBuy = (long)(this.getAvailable((CcsAccountDistribution)acc) / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                    acc.setCanBuy(canBuy);
                }
            });
        }
    }

    protected void secCanSell() {
        for (MxTreeList<PortfolioAccountDistribution> secList : this.mapAccSec.values()) {
            secList.getOrList().forEach(sec -> sec.setCanSell(0L));
        }
    }

    public void calCanBuySell() {
        this.clearCanBuySell(this.root);
        if (this.getRefItem() == null) {
            return;
        }
        this.calDistCanBuy();
        this.calDistCanSell();
    }

    private void calDistCanBuy() {
        this.portfolioMxList.getOrList().filtered(pd -> pd.isShow()).forEach(portfo -> {
            long canBuy = 0L;
            if (this.mapPortFolioAcc.get(portfo) == null) {
                return;
            }
            for (PortfolioAccountDistribution accDist : this.mapPortFolioAcc.get(portfo).getOrList().filtered(pd -> pd.isShow())) {
                canBuy += accDist.getCanBuy();
            }
            portfo.setCanBuy(canBuy);
        });
    }

    private void calDistCanSell() {
        this.secCanSell();
        this.portfolioMxList.getOrList().filtered(pd -> pd.isShow()).forEach(portfo -> {
            long portfoCanSell = 0L;
            if (this.mapPortFolioAcc.get(portfo) == null) {
                return;
            }
            for (PortfolioAccountDistribution accDist : this.mapPortFolioAcc.get(portfo).getOrList().filtered(pd -> pd.isShow())) {
                long accCanSell = 0L;
                for (PortfolioAccountDistribution secDist : this.mapAccSec.get(accDist).getOrList().filtered(pd -> pd.isShow())) {
                    accCanSell += secDist.getCanSell();
                }
                accDist.setCanSell(accCanSell);
                portfoCanSell += accCanSell;
            }
            portfo.setCanSell(portfoCanSell);
        });
    }

    public void clearCanBuySell(TreeItem<PortfolioAccountDistribution> parent) {
        this.portfolioMxList.getOrList().forEach(portfo -> {
            portfo.setCanBuy(0L);
            portfo.setCanSell(0L);
        });
        this.mapAccSec.keySet().forEach(acc -> acc.setCanSell(0L));
    }

    public void clearAll() {
        this.clearCanBuy(this.getRoot());
    }

    public void clearCount(TreeItem<PortfolioAccountDistribution> parent) {
    }

    public void clearCanBuy(TreeItem<PortfolioAccountDistribution> parent) {
    }

    public void clearSelect() {
        this.root.getChildren().forEach(portfolio -> {
            ((PortfolioAccountDistribution)portfolio.getValue()).setSelected(false);
            portfolio.getChildren().forEach(subFundAcc -> {
                ((PortfolioAccountDistribution)subFundAcc.getValue()).setSelected(false);
                subFundAcc.getChildren().forEach(subSecAcc -> ((PortfolioAccountDistribution)subSecAcc.getValue()).setSelected(false));
            });
        });
    }

    public void selectSecAcc(String portfId, String AccId, String secAcc, String mkt) {
        this.mapPortFolioAcc.keySet().forEach(port -> {
            if (!port.getPortfolio().getId().equals(portfId) || !port.isShow()) {
                return;
            }
            port.setSelected(true);
            this.mapPortFolioAcc.get(port).getOrList().filtered(pd -> pd.isShow()).forEach(acc -> {
                if (acc.getAcc().getExtAccntId().equals(AccId)) {
                    acc.setSelected(true);
                }
                this.mapAccSec.get(acc).getOrList().filtered(pd -> pd.getSecAcc().getExtSecAccntId().equals(secAcc) && pd.getSecAcc().getExchange().getRaw().equals(mkt)).forEach(sec -> sec.setSelected(true));
            });
        });
    }

    public void refresh() {
        this.exe.execute(() -> this.getPosModel().query());
    }

    public BooleanProperty showCanBuyProperty() {
        return this.showCanBuy;
    }

    public boolean isShowCanBuy() {
        return this.showCanBuyProperty().get();
    }

    public void setShowCanBuy(boolean showCanBuy) {
        this.showCanBuyProperty().set(showCanBuy);
    }

    public LongProperty canBuyProperty() {
        return this.canBuy;
    }

    public long getCanBuy() {
        return this.canBuyProperty().get();
    }

    public void setCanBuy(long canBuy) {
        this.canBuyProperty().set(canBuy);
    }

    public BooleanProperty buyProperty() {
        return this.buy;
    }

    public boolean isBuy() {
        return this.buyProperty().get();
    }

    public void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public StringProperty countStgProperty() {
        return this.countStg;
    }

    public String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public StringProperty distStgProperty() {
        return this.distStg;
    }

    public String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public DoubleProperty percentProperty() {
        return this.percent;
    }

    public double getPercent() {
        return this.percentProperty().get();
    }

    public void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public IntegerProperty unitProperty() {
        return this.unit;
    }

    public int getUnit() {
        return this.unitProperty().get();
    }

    public void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public IntegerProperty unitConvertProperty() {
        return this.unitConvert;
    }

    public int getUnitConvert() {
        return this.unitConvertProperty().get();
    }

    public void setUnitConvert(int unitConvert) {
        this.unitConvertProperty().set(unitConvert);
    }

    protected MxTreeList<PortfolioAccountDistribution> getPortfolioMxList() {
        return this.portfolioMxList;
    }

    protected Map<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>> getMapPortFolioAcc() {
        return this.mapPortFolioAcc;
    }

    protected Map<PortfolioAccountDistribution, MxTreeList<PortfolioAccountDistribution>> getMapAccSec() {
        return this.mapAccSec;
    }

    public ObjectProperty<RefItem> refItemProperty() {
        return this.refItem;
    }

    public RefItem getRefItem() {
        return (RefItem)this.refItemProperty().get();
    }

    public void setRefItem(RefItem refItem) {
        this.refItemProperty().set((Object)refItem);
    }

    public BooleanProperty repoProperty() {
        return this.repo;
    }

    public boolean isRepo() {
        return this.repoProperty().get();
    }

    public void setRepo(boolean repo) {
        this.repoProperty().set(repo);
    }

    public BooleanProperty singleProperty() {
        return this.single;
    }

    public boolean isSingle() {
        return this.singleProperty().get();
    }

    public void setSingle(boolean single) {
        this.singleProperty().set(single);
    }

    public InvalidationListener getLstPosition() {
        return this.lstPosition;
    }

    public void setLstPosition(InvalidationListener lstPosition) {
        this.lstPosition = lstPosition;
    }

    public InvalidationListener getLstPotfolio() {
        return this.lstPotfolio;
    }

    public void setLstPotfolio(InvalidationListener lstPotfolio) {
        this.lstPotfolio = lstPotfolio;
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public boolean isSelected() {
        return this.selectedProperty().get();
    }

    public void setSelected(boolean selected) {
        this.selectedProperty().set(selected);
    }

    public final StringProperty searchSecProperty() {
        return this.searchSec;
    }

    public final String getSearchSec() {
        return (String)this.searchSecProperty().get();
    }

    public final void setSearchSec(String searchSec) {
        this.searchSecProperty().set((Object)searchSec);
    }

    public boolean isHkwolun() {
        return this.hkwolun;
    }

    public void setHkwolun(boolean hkwolun) {
        this.hkwolun = hkwolun;
    }

    public OtcFundPositionModel getPosModel() {
        return this.posModel;
    }

    public double getAvailable(CcsAccountDistribution item) {
        return item.getAcc().getAvailable();
    }
}

