/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.instructions.http.models;

import cms.tmx.api.instruction.IInstructionApi;
import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.BlockTradeParam;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.OrderCancelRequest;
import cms.tmx.http.instruction.api.InstructionServiceApi;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.NewInstructionReq;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.SecAccountMngServiceImpl;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class InstructionOtcFundBaseModel {
    @Inject
    private IMarketDataMng mktMng;
    private static final Logger logger = LogManager.getLogger(InstructionOtcFundBaseModel.class);
    @Inject
    private HttpBaseApi httpBaseApi;
    protected MarketItem mktItem;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    protected IAccountService accountService;
    @Inject
    private IBaseApi baseApi;
    @Inject
    private TradeServiceApi tradeApi;
    @Inject
    private IInstructionApi<?> insApi;
    @Inject
    private InstructionServiceApi newInsApi;
    @Inject
    private MEventService es;
    private MEventHandler cancelOrderByInstruction = event -> {
        Object object = event.getObj();
        if (!(object instanceof ObInstruction)) {
            return;
        }
        ObInstruction ins = (ObInstruction)event.getObj();
        int countSuc = 0;
        int countFailed = 0;
        StringBuilder str = new StringBuilder();
        try {
            this.cancel(ins);
            ++countSuc;
        }
        catch (MException e) {
            ++countFailed;
            logger.error("\u6307\u4ee4\u64a4\u5355\u5931\u8d25", (Throwable)e);
            str.append(String.valueOf(ins.getId()) + e.getMessage() + "\n");
        }
        event.put((Object)"suc.count", (Object)countSuc);
        event.put((Object)"fail.count", (Object)countFailed);
        event.put((Object)"fail.message", (Object)str);
    };
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private SecAccountMngServiceImpl secService;
    @Inject
    private OtcPortfolioAccountModel otcAccModel;

    @PostConstruct
    private void init() {
        this.mktItem = this.mktMng.createItem(10);
        this.es.subscribe("cancel.order.by.instruction", this.cancelOrderByInstruction);
    }

    public void onSecChange() {
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public void submitAdvice(BlockTradeParam param) throws MException {
    }

    public Set<CcsFundAccount> getActiveAccMap(String instructionPanelType) {
        if (this.instrAccModel.getActiveAccMap(instructionPanelType) != null) {
            return this.instrAccModel.getActiveAccMap(instructionPanelType).keySet();
        }
        return new HashSet<CcsFundAccount>();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    public void newInstruction(NewInstructionReq req) throws MException {
        this.newInsApi.newInstruction(req);
    }

    public void doChange() {
        this.mktMng.dye(this.mktItem);
    }

    public MarketItem getMktItem() {
        return this.mktItem;
    }

    public void cancel(ObInstruction ins) throws MException {
        OrderCancelRequest order = new OrderCancelRequest();
        order.setOpUser(this.httpBaseApi.getHttpOpUser());
        order.setReference(ins.getId());
        if (ins.getOtcOrderDetail() != null) {
            Instrument instrument = ins.getOtcOrderDetail().getInstrument();
            String marketGroup = "";
            if (!ins.getJobs().isEmpty()) {
                marketGroup = ((ExecJob)ins.getJobs().get(0)).getMarketGroup();
            }
            instrument.setMarketGroup(marketGroup);
            order.setInstrument(instrument);
            CcsSubFundAccount fundAccount = this.otcAccModel.getFundAccount(((AccntSecInfo)ins.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getCashAccntId(), marketGroup);
            CcsSubSecAccount subSecAccount = this.otcAccModel.getSubSecAccountByIdAndMarket(((AccntSecInfo)ins.getOtcOrderDetail().getAccntSecInfo().get(0)).getAccountId().getSecAccntId(), "XOTC");
            if (fundAccount == null) {
                throw new MException(1, "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u8d44\u91d1\u8d26\u53f7 marketGroup:" + marketGroup);
            }
            if (subSecAccount == null) {
                throw new MException(1, "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u8bc1\u5238\u8d26\u53f7marketGroup:" + marketGroup);
            }
            String cashAccId = this.fundService.getNewFrameExtAccntId(fundAccount.getParentId(), marketGroup);
            String secAccId = this.secService.getNewFrameSecAccntId(fundAccount.getParentId(), marketGroup, subSecAccount.getInverstorSecId());
            if (StringUtils.isEmpty((String)cashAccId)) {
                throw new MException(1, "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u8bc1\u5238\u8d26\u53f7marketGroup:" + marketGroup);
            }
            if (StringUtils.isEmpty((String)secAccId)) {
                throw new MException(1, "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u8bc1\u5238\u8d26\u53f7marketGroup:" + marketGroup);
            }
            order.setExtCashAccntId(cashAccId);
            order.setExtSecAccntId(secAccId);
            this.tradeApi.orderCancel(order);
        }
    }

    public void approve(Instruction instruction) throws MException {
        this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, instruction.getPostil());
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, instruction.getPostil());
    }

    public void refreshResource(Instruction instruction) throws MException {
        this.instructionModel.refreshResource(instruction);
    }

    public void setMktItem(MarketItem mktItem) {
        this.mktItem = mktItem;
    }
}

