/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import com.sun.javafx.tk.TKStage;
import com.sun.jna.Callback;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.lang.reflect.Method;
import java.util.Map;
import javafx.stage.Stage;

public class StageUtils {
    public static void updateStageStyle(Stage stage) {
        Pointer pointer = StageUtils.getWindowPointer(stage);
        WinDef.HWND hwnd = new WinDef.HWND(pointer);
        User32 user32 = User32.INSTANCE;
        int oldStyle = user32.GetWindowLong(hwnd, -16);
        int newStyle = oldStyle | 0x20000;
        user32.SetWindowLong(hwnd, -16, newStyle);
    }

    private static Pointer getWindowPointer(Stage stage) {
        try {
            TKStage tkStage = stage.impl_getPeer();
            Method getPlatformWindow = tkStage.getClass().getDeclaredMethod("getPlatformWindow", new Class[0]);
            getPlatformWindow.setAccessible(true);
            Object platformWindow = getPlatformWindow.invoke((Object)tkStage, new Object[0]);
            Method getNativeHandle = platformWindow.getClass().getMethod("getNativeHandle", new Class[0]);
            getNativeHandle.setAccessible(true);
            Object nativeHandle = getNativeHandle.invoke(platformWindow, new Object[0]);
            return new Pointer(((Long)nativeHandle).longValue());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    static interface ExtUser32
    extends StdCallLibrary,
    User32 {
        public static final ExtUser32 INSTANCE = (ExtUser32)Native.loadLibrary((String)"user32", ExtUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinDef.LRESULT CallWindowProcW(Pointer var1, Pointer var2, int var3, WinDef.WPARAM var4, WinDef.LPARAM var5);

        public int SetWindowLong(WinDef.HWND var1, int var2, Callback var3) throws LastErrorException;
    }
}

