/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class SceneService {
    @Inject
    private MEventService es;
    private BorderPane root;
    private Node top;
    private Node bottom;
    private HBox topHbox;
    private HBox bottomHbox;
    private EventHandler<MouseEvent> handler = Event::consume;

    public void disableCursor(Stage stage) {
        stage.getScene().setCursor(Cursor.NONE);
        stage.addEventFilter(MouseEvent.ANY, this.handler);
        stage.addEventFilter(MouseEvent.MOUSE_MOVED, event -> event.consume());
    }

    public void enableCursor(Stage stage) {
        stage.getScene().setCursor(null);
        stage.removeEventFilter(MouseEvent.ANY, this.handler);
    }

    public void hideTopBottom(Stage stage) {
        this.check(stage);
        this.topHbox.setMaxHeight(0.0);
        this.topHbox.setMinHeight(0.0);
        this.topHbox.setPrefHeight(0.0);
        this.top.setOpacity(0.0);
        this.top.setVisible(false);
        this.bottomHbox.setMaxHeight(0.0);
        this.bottomHbox.setMinHeight(0.0);
        this.bottomHbox.setPrefHeight(0.0);
        this.bottom.setOpacity(0.0);
        this.bottom.setVisible(false);
        MEvent event = new MEvent();
        event.put((Object)"full_screen", (Object)true);
        this.es.sendEvent("full_screen", event);
    }

    private void check(Stage stage) {
        if (this.root == null) {
            this.root = (BorderPane)BorderPane.class.cast(stage.getScene().lookup("#cms-tm-app-trimbar-bottom").getParent().getParent());
        }
        if (this.top == null) {
            this.top = stage.getScene().lookup("#cms-tmx-trimbar-top").getParent();
        }
        if (this.bottom == null) {
            this.bottom = stage.getScene().lookup("#cms-tm-app-trimbar-bottom").getParent();
        }
        if (this.topHbox == null) {
            this.topHbox = (HBox)HBox.class.cast(stage.getScene().lookup("#cms-tmx-trimbar-top"));
        }
        if (this.bottomHbox == null) {
            this.bottomHbox = (HBox)HBox.class.cast(stage.getScene().lookup("#cms-tm-app-trimbar-bottom"));
        }
    }

    public void showTopBottom(Stage stage) {
        this.check(stage);
        this.topHbox.setMaxHeight(40.0);
        this.topHbox.setMinHeight(40.0);
        this.topHbox.setPrefHeight(40.0);
        this.top.setOpacity(1.0);
        this.top.setVisible(true);
        this.bottomHbox.setMaxHeight(36.0);
        this.bottomHbox.setMinHeight(36.0);
        this.bottomHbox.setPrefHeight(36.0);
        this.bottom.setOpacity(1.0);
        this.bottom.setVisible(true);
        MEvent event = new MEvent();
        event.put((Object)"full_screen", (Object)false);
        this.es.sendEvent("full_screen", event);
    }
}

