/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import cms.tmx.define.IDictMap;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MxNodeFactory {
    private static Map<String, MxNode> map = new HashMap<String, MxNode>();
    @Inject
    private static IDictMap dmap;

    @PostConstruct
    public void init() {
        MxNode.setDictMap(dmap);
    }

    public static MxNode create(String key) {
        return MxNodeFactory.create(key, "");
    }

    public static MxNode createNew(String key) {
        return MxNodeFactory.createNew(key, "");
    }

    public static MxNodePwf createPwf(String key) {
        return MxNodeFactory.createPwf(key, "");
    }

    public static MxNode create(String key, String raw) {
        MxNode node = map.get(key);
        if (node == null) {
            node = new MxNode().load(key, "");
            if (node == null) {
                return null;
            }
            map.put(key, node);
        }
        node = node.clone();
        node.setRaw(raw);
        return node;
    }

    public static MxNode createNew(String key, String raw) {
        MxNode node = new MxNode().load(key, "");
        if (node == null) {
            return null;
        }
        node.setRaw(raw);
        return node;
    }

    public static MxNodePwf createPwf(String key, String raw) {
        MxNodePwf node = new MxNodePwf().load(key, "");
        if (node == null) {
            return null;
        }
        node.setRaw(raw);
        return node;
    }
}

