/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import cms.tmx.utils.StringUtils;
import java.math.BigDecimal;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Control;
import javafx.util.StringConverter;

public class MxBindings {
    public static void bindVisible(Control ctrl, ObservableBooleanValue value) {
        ctrl.visibleProperty().unbind();
        ctrl.visibleProperty().bind((ObservableValue)value);
    }

    public static void bindSD(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Double fromString(String str) {
                if (str.isEmpty()) {
                    return 0.0;
                }
                if (!StringUtils.isDouble((String)str)) {
                    return 0.0;
                }
                return StringUtils.parseDouble((String)str);
            }

            public String toString(Number num) {
                return String.valueOf(num);
            }
        });
    }

    public static void bindSDFormat(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Double fromString(String str) {
                if (str.isEmpty()) {
                    return 0.0;
                }
                if (!StringUtils.isDouble((String)str)) {
                    return 0.0;
                }
                return StringUtils.parseDouble((String)str);
            }

            public String toString(Number num) {
                return String.format("%.3f", num);
            }
        });
    }

    public static void bindSDMinus(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Double fromString(String str) {
                if ((str = str.replaceAll(",", "")).isEmpty()) {
                    return 0.0;
                }
                if (!StringUtils.isMinusDouble((String)str)) {
                    return 0.0;
                }
                return Double.valueOf(str);
            }

            public String toString(Number num) {
                return String.valueOf(num);
            }
        });
    }

    public static void bindSI(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Integer fromString(String string) {
                if (string.isEmpty()) {
                    return 0;
                }
                if (!StringUtils.isInt((String)string)) {
                    return 0;
                }
                return StringUtils.parseInt((String)string);
            }

            public String toString(Number number) {
                return String.valueOf(number);
            }
        });
    }

    public static void bindSD(Property<String> text, ObservableNumberValue value, int scale) {
        text.unbind();
        StringBinding sb = Bindings.createStringBinding(() -> String.format("%1$,." + scale + "f", value.doubleValue()), (Observable[])new Observable[]{value});
        text.bind((ObservableValue)sb);
    }

    public static void bindSi(Property<String> text, ObservableNumberValue value) {
        text.unbind();
        StringBinding sb = Bindings.createStringBinding(() -> String.valueOf(value.longValue()), (Observable[])new Observable[]{value});
        text.bind((ObservableValue)sb);
    }

    public static void percentBinding(Property<String> text, ObservableNumberValue value, int scale) {
        text.unbind();
        StringBinding sb = Bindings.createStringBinding(() -> String.valueOf(String.format("%1$,." + scale + "f", value.doubleValue())) + "%", (Observable[])new Observable[]{value});
        text.bind((ObservableValue)sb);
    }

    public static void bindBidirectional(Property<String> pText, Property<String> old, Property<String> now) {
        pText.unbindBidirectional(old);
        pText.bindBidirectional(now);
    }

    public static void bindBidirectionalBoolean(Property<Boolean> pText, Property<Boolean> old, Property<Boolean> now) {
        pText.unbindBidirectional(old);
        pText.bindBidirectional(now);
    }

    public static void bindSDTwoScale(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Double fromString(String str) {
                if ((str = str.replaceAll(",", "")).isEmpty()) {
                    return 0.0;
                }
                if (!StringUtils.isDouble((String)str)) {
                    return 0.0;
                }
                return StringUtils.parseDouble((String)str);
            }

            public String toString(Number num) {
                BigDecimal bd2 = new BigDecimal(num.doubleValue()).setScale(2, 4);
                return StringUtils.toThousands((Number)bd2.doubleValue(), (int)2);
            }
        });
    }

    public static void bindSDThreeScale(Property<String> string, Property<Number> number) {
        Bindings.bindBidirectional(string, number, (StringConverter)new StringConverter<Number>(){

            public Double fromString(String str) {
                if ((str = str.replaceAll(",", "")).isEmpty()) {
                    return 0.0;
                }
                if (!StringUtils.isDouble((String)str)) {
                    return 0.0;
                }
                return StringUtils.parseDouble((String)str);
            }

            public String toString(Number num) {
                BigDecimal bd2 = new BigDecimal(num.doubleValue()).setScale(3, 4);
                return StringUtils.toThousands((Number)bd2.doubleValue(), (int)3);
            }
        });
    }
}

