/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;

public class FxUtils {
    public static <T> ObservableList<T> newList() {
        return FXCollections.observableList(new LinkedList());
    }

    public static <T> ObservableList<T> newArrayList() {
        return FXCollections.observableList(new ArrayList());
    }

    public static <K, V> ObservableMap<K, V> newMap() {
        return FXCollections.observableHashMap();
    }

    public static void makePC(Node node, String ps, boolean bFlag) {
        PseudoClass pc = PseudoClass.getPseudoClass((String)ps);
        node.pseudoClassStateChanged(pc, bFlag);
    }

    public static void focusBtnSure(Button btnSure, Node ... nodes) {
        List<Node> conts = Arrays.asList(nodes);
        conts.forEach(node -> node.setOnKeyPressed(event -> {
            if (KeyCode.ENTER.equals((Object)event.getCode())) {
                btnSure.requestFocus();
            }
        }));
    }

    public static <T> void initComboBox(ComboBox<T> comboBox) {
        comboBox.setOnShowing(event -> {
            if (comboBox.getScene().getWindow() instanceof Stage) {
                Stage stage = (Stage)Stage.class.cast(comboBox.getScene().getWindow());
                stage.setAlwaysOnTop(true);
                System.err.println("stage:" + stage + " onTop:" + stage.isAlwaysOnTop());
            }
        });
        comboBox.setOnHiding(event -> {
            if (comboBox.getScene().getWindow() instanceof Stage) {
                Stage stage = (Stage)Stage.class.cast(comboBox.getScene().getWindow());
                stage.setAlwaysOnTop(false);
                System.err.println("stage:" + stage + " onTop:" + stage.isAlwaysOnTop());
            }
        });
    }
}

