/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import java.util.Arrays;
import java.util.List;
import javafx.css.PseudoClass;
import javafx.scene.control.Control;

public class CssUtils {
    static PseudoClass pcRise = PseudoClass.getPseudoClass((String)"rise");
    static PseudoClass pcfall = PseudoClass.getPseudoClass((String)"fall");
    static PseudoClass pcBold = PseudoClass.getPseudoClass((String)"bold");
    static PseudoClass pcBlue = PseudoClass.getPseudoClass((String)"btnBlue");
    static PseudoClass pcYellow = PseudoClass.getPseudoClass((String)"yellow");
    static PseudoClass pcPink = PseudoClass.getPseudoClass((String)"pink");
    static final List<PseudoClass> listPc = Arrays.asList(pcRise, pcfall, pcBold, pcBlue, pcYellow, pcPink);
    private static final double PRICE_ZERO = 0.0;

    public static void priceTag(Control ctrl) {
        CssUtils.addStyleClass(ctrl, "priceTag");
    }

    public static void addStyleClass(Control ctrl, String sc) {
        ctrl.getStyleClass().remove((Object)sc);
        ctrl.getStyleClass().add((Object)sc);
    }

    public static void removeStyleClass(Control ctrl, String sc) {
        ctrl.getStyleClass().remove((Object)sc);
    }

    public static void checkPrice(Control ctrl, double base, double now) {
        if (base == 0.0 || now == 0.0 || base == now) {
            ctrl.pseudoClassStateChanged(pcRise, false);
            ctrl.pseudoClassStateChanged(pcfall, false);
            return;
        }
        if (now > base) {
            ctrl.pseudoClassStateChanged(pcRise, true);
            ctrl.pseudoClassStateChanged(pcfall, false);
        } else if (now < base) {
            ctrl.pseudoClassStateChanged(pcRise, false);
            ctrl.pseudoClassStateChanged(pcfall, true);
        }
    }

    public static void boldPrice(Control ctrl) {
        ctrl.pseudoClassStateChanged(pcBold, true);
    }

    public static void checkPct(Control ctrl, double base) {
        if (base == 0.0) {
            ctrl.pseudoClassStateChanged(pcRise, false);
            ctrl.pseudoClassStateChanged(pcfall, false);
        } else if (base > 0.0) {
            ctrl.pseudoClassStateChanged(pcRise, true);
            ctrl.pseudoClassStateChanged(pcfall, false);
        } else if (base < 0.0) {
            ctrl.pseudoClassStateChanged(pcRise, false);
            ctrl.pseudoClassStateChanged(pcfall, true);
        }
    }

    public static void checkSecMessage(Control ctrl, boolean warning) {
        if (warning) {
            ctrl.pseudoClassStateChanged(pcRise, true);
            ctrl.pseudoClassStateChanged(pcfall, false);
        } else {
            ctrl.pseudoClassStateChanged(pcRise, false);
            ctrl.pseudoClassStateChanged(pcfall, false);
        }
    }

    public static void makeRise(Control ctrl) {
        CssUtils.make(ctrl, pcRise);
    }

    public static void makeFall(Control ctrl) {
        CssUtils.make(ctrl, pcfall);
    }

    public static void makeEven(Control ctrl) {
        CssUtils.make(ctrl, null);
    }

    public static void makeBlue(Control ctrl) {
        CssUtils.make(ctrl, pcBlue);
    }

    public static void makeYellow(Control ctrl) {
        CssUtils.make(ctrl, pcYellow);
    }

    public static void makePink(Control ctrl) {
        CssUtils.make(ctrl, pcPink);
    }

    public static void make(Control ctrl, PseudoClass pc) {
        listPc.forEach(pClass -> ctrl.pseudoClassStateChanged(pClass, pClass.equals(pc)));
    }
}

