/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import com.sun.javafx.scene.control.skin.Utils;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.TableColumnBase;

public class ControlUtils {
    private ControlUtils() {
    }

    public static void scrollToIndex(Control control, int index) {
        Utils.executeOnceWhenPropertyIsNonNull((ObservableValue)control.skinProperty(), skin -> Event.fireEvent((EventTarget)control, (Event)new ScrollToEvent((Object)control, (EventTarget)control, ScrollToEvent.scrollToTopIndex(), (Object)index)));
    }

    public static void scrollToColumn(Control control, TableColumnBase<?, ?> column) {
        Utils.executeOnceWhenPropertyIsNonNull((ObservableValue)control.skinProperty(), skin -> control.fireEvent((Event)new ScrollToEvent((Object)control, (EventTarget)control, ScrollToEvent.scrollToColumn(), (Object)column)));
    }

    static void requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(Control c) {
        Node focusOwner;
        Scene scene = c.getScene();
        Node node = focusOwner = scene == null ? null : scene.getFocusOwner();
        if (focusOwner == null) {
            c.requestFocus();
        } else if (!c.equals(focusOwner)) {
            Parent p = focusOwner.getParent();
            while (p != null) {
                if (c.equals(p)) {
                    c.requestFocus();
                    break;
                }
                p = p.getParent();
            }
        }
    }

    public static <T> ListChangeListener.Change<T> buildClearAndSelectChange(ObservableList<T> list, List<T> removed, int retainedRow) {
        return new ListChangeListener.Change<T>(list, removed, retainedRow){
            private final int[] EMPTY_PERM = new int[0];
            private final int removedSize;
            private final List<T> firstRemovedRange;
            private final List<T> secondRemovedRange;
            private boolean invalid;
            private boolean atFirstRange;
            private int from;
            {
                this.removedSize = list.size();
                this.invalid = true;
                this.atFirstRange = true;
                this.from = -1;
                int midIndex = n >= this.removedSize ? this.removedSize : (n < 0 ? 0 : n);
                this.firstRemovedRange = list.subList(0, midIndex);
                this.secondRemovedRange = list.subList(midIndex, this.removedSize);
            }

            public int getFrom() {
                this.checkState();
                return this.from;
            }

            public int getTo() {
                return this.getFrom();
            }

            public List<T> getRemoved() {
                this.checkState();
                return this.atFirstRange ? this.firstRemovedRange : this.secondRemovedRange;
            }

            public int getRemovedSize() {
                return this.atFirstRange ? this.firstRemovedRange.size() : this.secondRemovedRange.size();
            }

            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            public boolean next() {
                if (this.invalid && this.atFirstRange) {
                    this.invalid = false;
                    this.from = 0;
                    return true;
                }
                if (this.atFirstRange && !this.secondRemovedRange.isEmpty()) {
                    this.atFirstRange = false;
                    this.from = 1;
                    return true;
                }
                return false;
            }

            public void reset() {
                this.invalid = true;
                this.atFirstRange = true;
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
    }
}

