/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx.utils;

import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

public class CellUtils {
    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    static <T> TextField createTextField(Cell<T> cell, StringConverter<T> converter) {
        TextField textField = new TextField(CellUtils.getItemText(cell, converter));
        textField.setOnAction(event -> {
            cell.commitEdit(converter.fromString(textField.getText()));
            event.consume();
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                cell.cancelEdit();
                t.consume();
            }
        });
        return textField;
    }

    static <T> void startEdit(Cell<T> cell, StringConverter<T> converter, HBox hbox, Node graphic, TextField textField) {
        if (textField != null) {
            textField.setText(CellUtils.getItemText(cell, converter));
        }
        cell.setText(null);
        if (graphic != null) {
            hbox.getChildren().setAll((Object[])new Node[]{graphic, textField});
            cell.setGraphic((Node)hbox);
        } else {
            cell.setGraphic((Node)textField);
        }
        textField.selectAll();
        textField.requestFocus();
    }
}

