/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.javafx.obj.MxObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;

public class MxTreeList<T extends MxObject> {
    protected TreeItem<T> parentItem;
    private ObservableList<TreeItem<T>> obList;
    private List<T> orList;
    private List<T> dirtyList;
    private Map<T, TreeItem<T>> obMap = new HashMap<T, TreeItem<T>>();
    private Map<T, TreeItem<T>> treeItemMap = new HashMap<T, TreeItem<T>>();

    public MxTreeList(ObservableList<TreeItem<T>> obList) {
        this.resetObList(obList);
    }

    private void resetObList(ObservableList<TreeItem<T>> obList) {
        this.obMap = this.setObMap(obList);
        this.obList = obList;
    }

    private Map<T, TreeItem<T>> setObMap(ObservableList<TreeItem<T>> obList) {
        HashMap obMap = new HashMap();
        obList.forEach(t -> obMap.put((MxObject)t.getValue(), t));
        return obMap;
    }

    public MxTreeList(ObservableList<TreeItem<T>> obList, List<T> orList) {
        this.resetObList(obList);
        this.update(orList);
    }

    public MxTreeList(TreeItem<T> parentItem, ObservableList<TreeItem<T>> obList, List<T> orList) {
        this.parentItem = parentItem;
        this.resetObList(obList);
        this.update(orList);
    }

    private void setOrList(List<T> listSrc) {
        this.orList = listSrc;
    }

    private void setDirtyList(List<T> listChange) {
        this.dirtyList = listChange;
    }

    public ObservableList<T> getOrList() {
        return FXCollections.observableList(this.orList);
    }

    public synchronized void filter(Predicate<T> pd) {
        if (this.orList == null) {
            return;
        }
        this.update(this.orList, pd);
    }

    public TreeItem<T> add(T obj) {
        TreeItem item = new TreeItem(obj);
        this.obListAdd(item);
        return item;
    }

    private void obListAdd(TreeItem<T> item) {
        this.obList.add(item);
        this.obMap.put((MxObject)item.getValue(), item);
    }

    public synchronized void updateDirty(List<T> listChange) {
        if (listChange == null || listChange.isEmpty()) {
            return;
        }
        this.setDirtyList(listChange);
        HashSet<Object> orSet = new HashSet<Object>();
        orSet.addAll(this.orList);
        orSet.addAll(listChange);
        this.setOrList(new ArrayList(orSet));
        HashMap changeMap = new HashMap();
        listChange.forEach(t -> changeMap.put(t, t));
        for (TreeItem old : this.obList) {
            this.treeItemMap.put((MxObject)old.getValue(), old);
        }
        for (MxObject item : this.dirtyList) {
            TreeItem<T> t2 = this.treeItemMap.get(item);
            if (t2 == null) {
                TreeItem treeItem = new TreeItem((Object)item);
                this.treeItemMap.put(item, treeItem);
                this.obListAdd(treeItem);
                continue;
            }
            ((MxObject)t2.getValue()).update(item);
        }
    }

    public void update(List<T> listSrc) {
        this.update(listSrc, p -> true);
    }

    public synchronized void update(List<T> listSrc, Predicate<T> pd) {
        this.setOrList(listSrc);
        HashMap orMap = new HashMap();
        listSrc.forEach(t -> orMap.put(t, t));
        LinkedList<TreeItem> removeList = new LinkedList<TreeItem>();
        LinkedList<TreeItem<T>> addList = new LinkedList<TreeItem<T>>();
        for (TreeItem item : this.obList) {
            if (!pd.test((MxObject)item.getValue())) {
                removeList.add(item);
                this.obMap.remove(item.getValue());
                continue;
            }
            if (orMap.containsKey(item.getValue())) continue;
            removeList.add(item);
            this.obMap.remove(item.getValue());
        }
        this.obList.removeAll(removeList);
        for (MxObject item : this.orList) {
            this.take(item, pd, addList);
        }
        this.obList.addAll(addList);
    }

    public ObservableList<TreeItem<T>> getObList() {
        return this.obList;
    }

    public TreeItem<T> getParent() {
        return this.parentItem;
    }

    protected void take(T item, Predicate<T> pd, LinkedList<TreeItem<T>> addList) {
        TreeItem<T> t = this.getItem(item);
        if (!pd.test(item)) {
            return;
        }
        if (t == null) {
            TreeItem<T> treeItem = new TreeItem<T>(item);
            if (this.treeItemMap.get(item) != null) {
                treeItem = this.treeItemMap.get(item);
            } else {
                this.treeItemMap.put(item, treeItem);
            }
            addList.add(treeItem);
            this.obMap.put((MxObject)treeItem.getValue(), treeItem);
        } else {
            ((MxObject)t.getValue()).update(item);
        }
    }

    public void take(T item) {
        TreeItem<T> t = this.getItem(item);
        if (t == null) {
            TreeItem<T> treeItem = new TreeItem<T>(item);
            if (this.treeItemMap.get(item) != null) {
                treeItem = this.treeItemMap.get(item);
            } else {
                this.treeItemMap.put(item, treeItem);
            }
            this.obList.add(treeItem);
            this.obMap.put((MxObject)treeItem.getValue(), treeItem);
        } else {
            ((MxObject)t.getValue()).update(item);
        }
    }

    public TreeItem<T> getItem(T item) {
        return this.obMap.get(item);
    }
}

