/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MProps;
import cms.tmx.javafx.LoggerInterface;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.StageUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;

public class MxPart
extends LoggerInterface {
    private ObservableList<TableView<?>> listViewer = FxUtils.newList();
    protected String path;
    @Inject
    @Optional
    protected BorderPane p;
    @Inject
    private MConfService cs;
    @Inject
    private ScheduledExecutorService esScheduled;
    @Inject
    protected Scene s;
    @Inject
    protected MEventService es;
    @Inject
    protected ExecutorService exe;
    @Inject
    protected Stage stage;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    protected volatile boolean fxmlDone = false;
    @Inject
    private EPartService eps;
    protected long startDate;
    protected Parent content;
    private static ConcurrentHashMap<Object, Boolean> partMap;
    public static ConcurrentHashMap<Object, String> partHKMap;
    public static String hkElement;
    private static volatile boolean lisFlag;
    private static final IPartListener PART_LIS;
    private String baseDir;
    private static final String VISIABLE = "visiable";
    private static final String SORT = "sort";
    private static final String DELAY = "delay";
    private static final String INDEX = "index";
    private static final String ASCENDING = "1";
    private static final String DESCENDING = "2";

    static {
        partHKMap = new ConcurrentHashMap();
        hkElement = "";
        lisFlag = false;
        PART_LIS = new IPartListener(){

            public void partVisible(MPart part) {
                if (partMap == null) {
                    return;
                }
                if (part.getObject() != null && part.getObject() instanceof MxPart) {
                    partMap.put(part.getObject(), true);
                    partHKMap.put(part.getObject().toString(), part.getElementId());
                    hkElement = part.getElementId();
                }
                System.err.println("visit " + part.getObject());
            }

            public void partHidden(MPart part) {
                if (partMap == null) {
                    return;
                }
                if (part.getObject() != null && part.getObject() instanceof MxPart) {
                    partMap.put(part.getObject(), false);
                    partHKMap.put(part.getObject(), part.getElementId());
                    MxPart.setHkElement(part.getElementId());
                }
                System.err.println("hidden " + part.getObject());
            }

            public void partDeactivated(MPart part) {
                System.err.println("deactive " + part.getObject());
            }

            public void partBroughtToTop(MPart part) {
                System.err.println("totop " + part.getObject());
            }

            public void partActivated(MPart part) {
                if (part.getObject() != null && part.getObject() instanceof MxPart) {
                    MxPart.setHkElement(part.getElementId());
                    partHKMap.put(part.getObject(), part.getElementId());
                    partMap.put(part.getObject(), true);
                    ((MxPart)MxPart.class.cast(part.getObject())).onVisit();
                }
                System.err.println("active " + part.getObject());
            }
        };
    }

    public MxPart(String path) {
        this.path = path;
    }

    public MxPart() {
        this.path = String.valueOf(this.getClass().getSimpleName()) + ".fxml";
    }

    @PostConstruct
    public void init() {
        this.logger.info("-------- Part init called " + this.getClass().getSimpleName());
        if (!lisFlag) {
            this.eps.addPartListener(PART_LIS);
        }
        if (partMap == null) {
            partMap = (ConcurrentHashMap)this.eCore.get((Object)"partMap");
        }
        this.exe.execute(() -> {
            try {
                this.loadFXML();
                this.resoreTable();
                this.startRecord();
                this.fxmlDone = true;
            }
            catch (IOException e) {
                this.logger.error("init part failed", (Throwable)e);
                return;
            }
            Platform.runLater(() -> {
                if (this.p != null) {
                    this.p.setCenter((Node)this.content);
                }
                this.layout();
            });
            this.logger.info("-------- Part init finish " + this.getClass().getSimpleName());
        });
    }

    @PreDestroy
    public void onPartClose() {
        if (this.p != null && this.content != null) {
            this.p.getChildren().remove((Object)this.content);
        }
        this.exe.execute(() -> this.saveTable());
        this.destroyRecord();
        this.logger.info("-------- MxPart: onPartClose called " + this.getClass().getSimpleName());
    }

    public void finalize() {
        this.logger.info("-------- MxPart: finalize called " + this.getClass().getSimpleName());
    }

    protected void startRecord() {
        this.startDate = System.currentTimeMillis();
        MEvent event = new MEvent();
        event.putStr("beginTime", (Object)this.startDate);
        event.putStr("moduleId", (Object)String.valueOf(this.getClass().getSimpleName()));
        this.es.sendEvent("module.begin", event);
    }

    private void destroyRecord() {
        if (0L == this.startDate) {
            return;
        }
        MEvent event = new MEvent();
        event.putStr("beginTime", (Object)String.valueOf(this.startDate));
        event.putStr("endTime", (Object)String.valueOf(System.currentTimeMillis()));
        event.putStr("moduleId", (Object)this.getClass().getSimpleName());
        this.es.sendEvent("module.end", event);
    }

    protected URL getFXMLLocation() {
        return this.getClass().getResource(this.path);
    }

    protected Parent loadFXML() throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(this.getFXMLLocation());
        loader.setController((Object)this);
        this.content = (Parent)loader.load();
        return this.content;
    }

    protected void initTransparent() {
        try {
            this.loadFXML();
            this.stage.initStyle(StageStyle.UNDECORATED);
            this.p.setCenter((Node)this.content);
            Platform.runLater(() -> StageUtils.updateStageStyle(this.stage));
        }
        catch (IOException e) {
            this.logger.error("init transparent part failed", (Throwable)e);
        }
    }

    protected void initSynchronized() {
        try {
            this.loadFXML();
            this.p.setCenter((Node)this.content);
            this.resoreTable();
            this.startRecord();
        }
        catch (IOException e) {
            this.logger.error("init part failed", (Throwable)e);
            return;
        }
    }

    public void addViwer(TableView<?> viewer) {
        this.listViewer.add(viewer);
    }

    @Focus
    private void onFocus() {
        for (TableView viewer : this.listViewer) {
            viewer.refresh();
        }
    }

    public void onVisit() {
        this.logger.info("part visit :" + this.getClass());
    }

    protected void saveTable() {
        try {
            MProps mProps = this.initProp();
            boolean flag = false;
            flag = this.recordAttribute(this.getClass(), flag, mProps);
            if (!flag) {
                this.recordAttribute(this.getClass().getSuperclass(), flag, mProps);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    protected void resoreTable() {
        try {
            MProps mProps = this.initProp();
            boolean flag = false;
            flag = this.readAttribute(this.getClass(), flag, mProps);
            if (!flag) {
                this.readAttribute(this.getClass().getSuperclass(), flag, mProps);
            }
            this.afterTableRestore();
            Class<?> cla = this.getClass();
            do {
                this.changeTextField(cla, flag, mProps);
            } while (!(cla = cla.getSuperclass()).getSimpleName().equals(Object.class.getSimpleName()));
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    protected void afterTableRestore() {
    }

    private MProps initProp() throws IOException {
        this.baseDir = Paths.get(System.getProperty("user.dir"), "data").toString();
        MProps mProps = new MProps();
        Path dataPath = Paths.get(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getSimpleName()) + ".properties");
        File file = dataPath.toFile();
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!file.exists()) {
            new File(String.valueOf(this.baseDir) + File.separator + this.eCore.getStr("user_id"), String.valueOf(this.getClass().getSimpleName()) + ".properties").createNewFile();
        }
        mProps.load(file);
        return mProps;
    }

    private <T> void changeTextField(Class<?> cla, boolean flag, MProps mProps) {
        try {
            Field[] fields;
            Field[] fieldArray = fields = cla.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Parent parent;
                TextField txtSearch;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                Object object = field.get(this);
                if (object instanceof TextField && ("txtSearch".equals((txtSearch = (TextField)TextField.class.cast(object)).getId()) || "searchText".equals(txtSearch.getId()) || "txtSearchNoWidth".equals(txtSearch.getId()) || txtSearch.getStyleClass().contains((Object)"search")) && (parent = txtSearch.getParent()) instanceof StackPane) {
                    ImageView mv = new ImageView(new Image("res/menuxx.png"));
                    mv.setFitWidth(12.0);
                    mv.setFitHeight(12.0);
                    mv.setStyle("-fx-cursor:hand;");
                    StackPane stackPane = (StackPane)StackPane.class.cast(parent);
                    stackPane.getChildren().add((Object)mv);
                    StackPane.setAlignment((Node)mv, (Pos)Pos.CENTER_RIGHT);
                    StackPane.setMargin((Node)mv, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                    mv.setOnMouseClicked(e -> txtSearch.clear());
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            this.logger.error((Object)e2, (Throwable)e2);
        }
    }

    private <T> boolean readAttribute(Class<?> cla, boolean flag, MProps mProps) {
        try {
            Field[] fields;
            Field[] fieldArray = fields = cla.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Parent parent;
                TextField txtSearch;
                String sortType;
                boolean isVisible;
                int position;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                Object object = field.get(this);
                if (object instanceof TableView) {
                    flag = true;
                    TableView tableView = (TableView)TableView.class.cast(object);
                    tableView.setOnMouseEntered(event -> {
                        Node menuButton = tableView.lookup(".show-hide-columns-button");
                        if (!"check".equals(menuButton.getId())) {
                            menuButton.setOnMousePressed(e -> {
                                MEvent mEvent = new MEvent();
                                mEvent.put((Object)"data", (Object)tableView);
                                this.es.sendEvent("change.table.column", mEvent);
                                event.consume();
                            });
                            menuButton.setOnMouseReleased(e -> event.consume());
                            menuButton.setId("check");
                        }
                    });
                    LinkedList<TableColumn> list = new LinkedList<TableColumn>();
                    int j = 0;
                    while (j < tableView.getColumns().size()) {
                        list.add(null);
                        ++j;
                    }
                    int i = 0;
                    while (i < tableView.getColumns().size()) {
                        TableColumn column = (TableColumn)tableView.getColumns().get(i);
                        if (column.getText().isEmpty()) {
                            list.set(0, column);
                        } else {
                            tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
                            position = mProps.getInt(String.valueOf(column.getText()) + column.getId() + INDEX, i);
                            if (position < list.size()) {
                                list.set(position, column);
                            }
                            column.setPrefWidth(mProps.getDouble(String.valueOf(column.getText()) + column.getId(), column.getPrefWidth()));
                            isVisible = mProps.getBool(String.valueOf(column.getText()) + column.getId() + VISIABLE, true);
                            if (!isVisible) {
                                column.setVisible(isVisible);
                            }
                            if (column.getColumns() != null && !column.getColumns().isEmpty()) {
                                ObservableList cTwos = column.getColumns();
                                ArrayList<TableColumn> listTwo = new ArrayList<TableColumn>();
                                int k = 0;
                                while (k < cTwos.size()) {
                                    listTwo.add(null);
                                    ++k;
                                }
                                int j2 = 0;
                                while (j2 < cTwos.size()) {
                                    TableColumn c = (TableColumn)cTwos.get(j2);
                                    c.setPrefWidth(mProps.getDouble(String.valueOf(column.getText()) + c.getText() + c.getId(), c.getPrefWidth()));
                                    isVisible = mProps.getBool(String.valueOf(column.getText()) + c.getText() + c.getId() + VISIABLE, true);
                                    if (!isVisible) {
                                        c.setVisible(isVisible);
                                    }
                                    position = mProps.getInt(String.valueOf(column.getText()) + c.getText() + c.getId() + INDEX, j2);
                                    listTwo.set(position, c);
                                    String sortTypeTwo = mProps.get(String.valueOf(c.getText()) + c.getId() + SORT);
                                    if (!sortTypeTwo.isEmpty()) {
                                        this.esScheduled.schedule(() -> Platform.runLater(() -> {
                                            tableView.getSortOrder().clear();
                                            c.setSortType(ASCENDING.equals(sortTypeTwo) ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                                            tableView.getSortOrder().add((Object)c);
                                            tableView.sort();
                                            this.afterTableRestore();
                                        }), (long)this.cs.getValueAsInt(DELAY, this.getDelayTime()), TimeUnit.MILLISECONDS);
                                    }
                                    ++j2;
                                }
                                List collect = listTwo.stream().filter(item -> item != null).collect(Collectors.toList());
                                column.getColumns().clear();
                                column.getColumns().addAll(collect);
                            }
                            if (!(sortType = mProps.get(String.valueOf(column.getText()) + column.getId() + SORT)).isEmpty()) {
                                this.esScheduled.schedule(() -> Platform.runLater(() -> {
                                    tableView.getSortOrder().clear();
                                    column.setSortType(ASCENDING.equals(sortType) ? TableColumn.SortType.ASCENDING : TableColumn.SortType.DESCENDING);
                                    tableView.getSortOrder().add((Object)column);
                                    tableView.sort();
                                    this.afterTableRestore();
                                }), (long)this.cs.getValueAsInt(DELAY, this.getDelayTime()), TimeUnit.MILLISECONDS);
                            }
                        }
                        ++i;
                    }
                    boolean all = true;
                    int i2 = 0;
                    while (i2 < tableView.getColumns().size()) {
                        if (!((TableColumn)tableView.getColumns().get(i2)).getText().isEmpty()) {
                            all = false;
                        }
                        ++i2;
                    }
                    if (all) {
                        return flag;
                    }
                    if (list.contains(null)) {
                        return flag;
                    }
                    tableView.getColumns().clear();
                    tableView.getColumns().addAll(list);
                } else if (object instanceof TreeTableView) {
                    flag = true;
                    TreeTableView treeTableView = (TreeTableView)TreeTableView.class.cast(object);
                    treeTableView.setOnMouseEntered(event -> {
                        Node menuButton = treeTableView.lookup(".show-hide-columns-button");
                        if (!"check".equals(menuButton.getId())) {
                            menuButton.setOnMousePressed(e -> {
                                MEvent mEvent = new MEvent();
                                mEvent.put((Object)"data", (Object)treeTableView);
                                this.es.sendEvent("change.tree.table.column", mEvent);
                                event.consume();
                            });
                            menuButton.setOnMouseReleased(e -> event.consume());
                            menuButton.setId("check");
                        }
                    });
                    LinkedList<TreeTableColumn> treeTableColumns = new LinkedList<TreeTableColumn>();
                    int j = 0;
                    while (j < treeTableView.getColumns().size()) {
                        treeTableColumns.add(null);
                        ++j;
                    }
                    treeTableView.setColumnResizePolicy(TreeTableView.UNCONSTRAINED_RESIZE_POLICY);
                    int k = 0;
                    while (k < treeTableView.getColumns().size()) {
                        TreeTableColumn column = (TreeTableColumn)treeTableView.getColumns().get(k);
                        position = mProps.getInt(String.valueOf(column.getText()) + INDEX, k);
                        if (position < treeTableColumns.size()) {
                            treeTableColumns.set(position, column);
                        }
                        column.setPrefWidth(mProps.getDouble(column.getText(), column.getPrefWidth()));
                        isVisible = mProps.getBool(String.valueOf(column.getText()) + VISIABLE, true);
                        if (!isVisible) {
                            column.setVisible(isVisible);
                        }
                        if (!(sortType = mProps.get(String.valueOf(column.getText()) + SORT)).isEmpty()) {
                            this.esScheduled.schedule(() -> Platform.runLater(() -> {
                                treeTableView.getSortOrder().clear();
                                column.setSortType(ASCENDING.equals(sortType) ? TreeTableColumn.SortType.ASCENDING : TreeTableColumn.SortType.DESCENDING);
                                treeTableView.getSortOrder().add((Object)column);
                                treeTableView.sort();
                            }), (long)this.cs.getValueAsInt(DELAY, this.getDelayTime()), TimeUnit.MILLISECONDS);
                        }
                        ++k;
                    }
                    if (treeTableColumns.contains(null)) {
                        return flag;
                    }
                    treeTableView.getColumns().clear();
                    treeTableView.getColumns().addAll(treeTableColumns);
                } else if (object instanceof TextField && ("txtSearch".equals((txtSearch = (TextField)TextField.class.cast(object)).getId()) || "searchText".equals(txtSearch.getId()) || txtSearch.getStyleClass().contains((Object)"search")) && (parent = txtSearch.getParent()) instanceof StackPane) {
                    ImageView mv = new ImageView(new Image("res/menuxx.png"));
                    mv.setFitWidth(12.0);
                    mv.setFitHeight(12.0);
                    mv.setStyle("-fx-cursor:hand;");
                    StackPane stackPane = (StackPane)StackPane.class.cast(parent);
                    stackPane.getChildren().add((Object)mv);
                    StackPane.setAlignment((Node)mv, (Pos)Pos.CENTER_RIGHT);
                    StackPane.setMargin((Node)mv, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
                    mv.setOnMouseClicked(e -> txtSearch.clear());
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            this.logger.error((Object)e2, (Throwable)e2);
        }
        return flag;
    }

    private <T> boolean recordAttribute(Class<?> cla, boolean flag, MProps mProps) {
        try {
            Field[] fields;
            mProps.clear();
            mProps.save();
            Field[] fieldArray = fields = cla.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String type;
                Field field = fieldArray[n2];
                field.setAccessible(true);
                Object object = field.get(this);
                if (object instanceof TableView) {
                    flag = true;
                    TableView tableView = (TableView)TableView.class.cast(object);
                    int i = 0;
                    while (i < tableView.getColumns().size()) {
                        TableColumn column = (TableColumn)tableView.getColumns().get(i);
                        if (!column.getText().isEmpty()) {
                            mProps.setValue(String.valueOf(column.getText()) + column.getId(), (Object)String.valueOf(column.getWidth()));
                            mProps.setValue(String.valueOf(column.getText()) + column.getId() + VISIABLE, (Object)column.isVisible());
                            mProps.setValue(String.valueOf(column.getText()) + column.getId() + INDEX, (Object)i);
                            if (column.getColumns() != null && !column.getColumns().isEmpty()) {
                                ObservableList cTwos = column.getColumns();
                                int j = 0;
                                while (j < cTwos.size()) {
                                    mProps.setValue(String.valueOf(column.getText()) + ((TableColumn)cTwos.get(j)).getText() + ((TableColumn)cTwos.get(j)).getId(), (Object)String.valueOf(((TableColumn)cTwos.get(j)).getWidth()));
                                    mProps.setValue(String.valueOf(column.getText()) + ((TableColumn)cTwos.get(j)).getText() + ((TableColumn)cTwos.get(j)).getId() + VISIABLE, (Object)((TableColumn)cTwos.get(j)).isVisible());
                                    mProps.setValue(String.valueOf(column.getText()) + ((TableColumn)cTwos.get(j)).getText() + ((TableColumn)cTwos.get(j)).getId() + INDEX, (Object)j);
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                    if (tableView.getSortOrder().size() != 0) {
                        String name = String.valueOf(((TableColumn)tableView.getSortOrder().get(0)).getText()) + ((TableColumn)tableView.getSortOrder().get(0)).getId() + SORT;
                        type = ((TableColumn)tableView.getSortOrder().get(0)).getSortType().equals((Object)TableColumn.SortType.ASCENDING) ? ASCENDING : DESCENDING;
                        mProps.setValue(name, (Object)type);
                    }
                } else if (object instanceof TreeTableView) {
                    flag = true;
                    TreeTableView treeTableView = (TreeTableView)TreeTableView.class.cast(object);
                    int j = 0;
                    while (j < treeTableView.getColumns().size()) {
                        TreeTableColumn treeTableColumn = (TreeTableColumn)treeTableView.getColumns().get(j);
                        mProps.setValue(treeTableColumn.getText(), (Object)String.valueOf(treeTableColumn.getWidth()));
                        mProps.setValue(String.valueOf(treeTableColumn.getText()) + VISIABLE, (Object)treeTableColumn.isVisible());
                        mProps.setValue(String.valueOf(treeTableColumn.getText()) + INDEX, (Object)j);
                        ++j;
                    }
                    if (treeTableView.getSortOrder().size() != 0) {
                        String name = String.valueOf(((TreeTableColumn)treeTableView.getSortOrder().get(0)).getText()) + SORT;
                        type = ((TreeTableColumn)treeTableView.getSortOrder().get(0)).getSortType().equals((Object)TableColumn.SortType.ASCENDING) ? ASCENDING : DESCENDING;
                        mProps.setValue(name, (Object)type);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        return flag;
    }

    public Parent getContent() {
        return this.content;
    }

    protected boolean isVisible() {
        if (!this.fxmlDone || partMap == null) {
            return false;
        }
        Boolean isVisit = partMap.get(this);
        return this.fxmlDone && (isVisit == null || isVisit != false);
    }

    protected void layout() {
        if (this.p != null) {
            Platform.runLater(() -> this.p.layout());
        }
    }

    public int getDelayTime() {
        return 1000;
    }

    public String getHkElement() {
        return hkElement;
    }

    public static void setHkElement(String hkElement1) {
        hkElement = hkElement1;
    }

    public static ConcurrentHashMap<Object, String> getPartHKMap() {
        return partHKMap;
    }

    public static void setPartHKMap(ConcurrentHashMap<Object, String> partHKMap) {
        MxPart.partHKMap = partHKMap;
    }
}

