/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.core.MEvent;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPageList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.SortPolicy;
import cms.tmx.javafx.obj.MxObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javax.annotation.PreDestroy;

public abstract class MxPagePart<E extends MxObject, T extends MxObject>
extends MxPart {
    protected static final Integer PAGE_SIZE = 50;
    protected MxPageList<E, T> mxList;
    @FXML
    protected Label lbCurrentCount;
    @FXML
    protected Label lbTotalCount;
    @FXML
    protected Label lbCountSeparator;
    @FXML
    protected Label lbPrevPage;
    @FXML
    protected Label lbNextPage;
    @FXML
    protected TableView<T> tableView;
    private ScrollBar bar;
    private double lastPosition = 0.0;
    private long lastLoadTime = 0L;
    protected boolean dragFlag = false;
    protected long lastDragTime = 0L;
    @FXML
    protected TextField searchText;
    private Type[] types;
    protected Predicate<E> pd = t -> this.predicate(t);
    protected InvalidationListener lstnModel = ob -> this.refreshList();
    protected InvalidationListener listenerSearch = ob -> {
        List<E> list = this.getList();
        synchronized (list) {
            this.mxList.filter(this.getList(), this.pd);
        }
        this.sort();
        this.mxList.updatePageList();
        this.tableView.refresh();
        this.mxList.setBeginIndex(0);
        this.lbCurrentCount.setText(String.valueOf(String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
        this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
    };
    public Callback<TableView<T>, Boolean> DEFAULT_SORT_POLICY = new SortPolicy<T>(){

        @Override
        public void afterSort() {
            MxPagePart.this.lstnModel.invalidated(null);
        }
    };

    public MxPagePart() {
        Type type = this.getClass().getSuperclass().getSimpleName().equals("MxPagePart") ? this.getClass().getGenericSuperclass() : this.getClass().getSuperclass().getGenericSuperclass();
        ParameterizedType ptype = (ParameterizedType)type;
        this.types = ptype.getActualTypeArguments();
        Class clazz = (Class)this.types[1];
        this.mxList = new MxPageList(PAGE_SIZE, clazz);
    }

    protected abstract boolean predicate(E var1);

    protected abstract List<E> getList();

    protected abstract MxModel getModel();

    protected abstract void createTableView();

    protected abstract void refresh();

    public abstract void exportExcel();

    public abstract void defaultSort();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<E> newList = new ArrayList<E>();
        List<E> list = this.getList();
        synchronized (list) {
            newList.addAll(this.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(newList, this.pd);
            this.sort();
            this.mxList.updatePageList();
            this.tableView.refresh();
            if (this.lbCurrentCount != null && this.lbTotalCount != null) {
                this.lbCurrentCount.setText(String.valueOf(this.mxList.getBeginIndex() == 0 && this.mxList.getList().size() == 0 ? "0" : String.valueOf(this.mxList.getBeginIndex() + 1)) + "-" + (this.mxList.getBeginIndex() + PAGE_SIZE > this.mxList.getList().size() ? String.valueOf(this.mxList.getList().size()) : String.valueOf(this.mxList.getBeginIndex() + PAGE_SIZE)));
                this.lbTotalCount.setText(String.valueOf(this.mxList.getList().size()));
            }
        });
    }

    protected void loadNextPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE >= this.mxList.getList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() + PAGE_SIZE < this.mxList.getList().size()) {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() + PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    protected void loadPrevPage() {
        if (this.mxList.getList().size() == this.mxList.getPageList().size()) {
            return;
        }
        if (this.mxList.getBeginIndex() == 0) {
            return;
        }
        if (this.mxList.getBeginIndex() - PAGE_SIZE < 0) {
            this.mxList.setBeginIndex(0);
        } else {
            this.mxList.setBeginIndex(this.mxList.getBeginIndex() - PAGE_SIZE);
        }
        this.lstnModel.invalidated(null);
        this.dragFlag = true;
    }

    @PreDestroy
    protected void preDestroy() {
        this.searchText.textProperty().removeListener(this.listenerSearch);
        this.getModel().changedProperty().removeListener(this.lstnModel);
    }

    @FXML
    protected void initialize() {
        this.tableView.setSortPolicy(this.DEFAULT_SORT_POLICY);
        this.searchText.textProperty().addListener(this.listenerSearch);
        this.getModel().changedProperty().addListener(this.lstnModel);
        this.createTableView();
        this.refresh();
        this.tableView.addEventFilter(MouseEvent.MOUSE_DRAGGED, event -> {
            if (event.getTarget().toString().contains("ScrollBarSkin")) {
                if (this.dragFlag) {
                    event.consume();
                }
                if (this.bar == null) {
                    this.bar = (ScrollBar)this.tableView.lookup(".scroll-bar:vertical");
                }
                if (this.bar.getValue() != this.lastPosition) {
                    long current = System.currentTimeMillis();
                    if (System.currentTimeMillis() - this.lastDragTime < 100L) {
                        return;
                    }
                    this.lastDragTime = current;
                    if (this.bar.getValue() < this.lastPosition) {
                        if (this.bar.getValue() <= this.bar.getMax() * 0.1) {
                            this.loadPrevPage();
                        }
                    } else if (this.bar.getValue() >= this.bar.getMax() * 0.9) {
                        this.loadNextPage();
                    }
                    this.lastPosition = this.bar.getValue();
                }
            }
        });
        this.tableView.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.dragFlag = false;
        });
        this.tableView.setOnScroll(ob -> {
            long now = System.currentTimeMillis();
            if (now - this.lastLoadTime < 1000L) {
                return;
            }
            this.lastLoadTime = now;
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableView.lookup(".scroll-bar:vertical");
            }
            if (ob.getDeltaY() > 0.0) {
                if (this.lbCurrentCount.getText().startsWith("1-")) {
                    return;
                }
                this.loadPrevPage();
                this.bar.setValue(1.0);
                return;
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
        this.lbPrevPage.setOnMouseClicked(event -> {
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableView.lookup(".scroll-bar:vertical");
            }
            if (this.lbCurrentCount.getText().startsWith("1-")) {
                return;
            }
            this.loadPrevPage();
            this.bar.setValue(0.0);
        });
        this.lbNextPage.setOnMouseClicked(event -> {
            if (this.bar == null) {
                this.bar = (ScrollBar)this.tableView.lookup(".scroll-bar:vertical");
            }
            if (this.lbCurrentCount.getText().endsWith("-" + this.lbTotalCount.getText())) {
                return;
            }
            this.loadNextPage();
            this.bar.setValue(0.0);
        });
        this.tableView.setOnMouseEntered(event -> {
            Node menuButton = this.tableView.lookup(".show-hide-columns-button");
            if (!"check".equals(menuButton.getId())) {
                menuButton.setOnMousePressed(e -> {
                    MEvent mEvent = new MEvent();
                    mEvent.put((Object)"data", this.tableView);
                    this.es.sendEvent("change.table.column", mEvent);
                    event.consume();
                });
                menuButton.setOnMouseReleased(e -> event.consume());
                menuButton.setId("check");
            }
        });
    }

    protected void sort() {
        try {
            this.defaultSort();
            ObservableList sortOrder = this.tableView.getSortOrder();
            for (TableColumn column : sortOrder) {
                this.mxList.getList().sort((o1, o2) -> {
                    try {
                        Class clazz = (Class)this.types[0];
                        Method method = clazz.getMethod("get" + MxPagePart.capitalize(column.getId()), new Class[0]);
                        Object s1 = method.invoke(o1, new Object[0]);
                        Object s2 = method.invoke(o2, new Object[0]);
                        if (s1 instanceof Number) {
                            return MxPagePart.compareNumber(column, s1, s2);
                        }
                        if (s1 instanceof MxNode) {
                            return MxPagePart.compareMxNode(column, s1, s2);
                        }
                        return MxPagePart.compareString(column, s1, s2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String capitalize(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static int compareString(TableColumn<?, ?> column, Object s1, Object s2) {
        String sort1 = (String)s1;
        String sort2 = (String)s2;
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            if (s1 == null && s2 != null) {
                return -1;
            }
            if (s2 == null && s1 != null) {
                return 1;
            }
            if (s2 == null && s1 == null) {
                return 0;
            }
            if (sort1.length() == sort2.length()) {
                return sort1.compareTo(sort2);
            }
            if (sort1.length() > sort2.length()) {
                return 1;
            }
            return -1;
        }
        if (s1 == null && s2 != null) {
            return 1;
        }
        if (s2 == null && s1 != null) {
            return -1;
        }
        if (s2 == null && s1 == null) {
            return 0;
        }
        if (sort1.length() == sort2.length()) {
            return sort2.compareTo(sort1);
        }
        if (sort2.length() > sort1.length()) {
            return 1;
        }
        return -1;
    }

    public static int compareMxNode(TableColumn<?, ?> column, Object s1, Object s2) {
        MxNode m1 = (MxNode)MxNode.class.cast(s1);
        MxNode m2 = (MxNode)MxNode.class.cast(s2);
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            return m1.getValue().compareTo(m2.getValue());
        }
        return m2.getValue().compareTo(m1.getValue());
    }

    public static int compareNumber(TableColumn<?, ?> column, Object s1, Object s2) {
        Number n1 = (Number)Number.class.cast(s1);
        Number n2 = (Number)Number.class.cast(s2);
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            return Double.compare(n1.doubleValue(), n2.doubleValue());
        }
        return Double.compare(n2.doubleValue(), n1.doubleValue());
    }
}

