/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MxPageList<E extends MxObject, T extends MxObject> {
    private ObservableList<E> list = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(MxPageList.class);
    private ObservableList<T> pageList = FxUtils.newArrayList();
    private ArrayList<T> objPool = new ArrayList(200);
    private Class<T> clazz;
    private ConcurrentHashMap<E, E> listMap = new ConcurrentHashMap();
    public int num = 200;
    private int beginIndex = 0;

    public MxPageList(int num, Class<T> clazz) {
        this.num = num;
        this.clazz = clazz;
        this.fillObjPool();
    }

    private void fillObjPool() {
        int i = 0;
        while (i < this.num) {
            try {
                Constructor<T> constructor = this.clazz.getConstructor(new Class[0]);
                this.objPool.add((MxObject)constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                logger.error("fill objPool failed :", (Throwable)e);
            }
            ++i;
        }
    }

    public ObservableList<E> getList() {
        return this.list;
    }

    public ObservableList<T> getPageList() {
        return this.pageList;
    }

    public ConcurrentHashMap<E, E> getListMap() {
        return this.listMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
        }
    }

    public void update(List<E> listSrc) {
        this.update(listSrc, (E p) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(List<E> listSrc, Predicate<E> pd) {
        LinkedList<MxObject> listSrcResult = new LinkedList<MxObject>();
        for (MxObject e : listSrc) {
            if (!pd.test(e)) continue;
            listSrcResult.add(e);
        }
        List listSrcDistinct = listSrcResult.stream().distinct().collect(Collectors.toList());
        Iterator<E> iterator = this.list;
        synchronized (iterator) {
            this.list.setAll(listSrcDistinct);
            this.listMap.clear();
            this.list.stream().forEach(item -> {
                MxObject mxObject = this.listMap.put(item, item);
            });
        }
    }

    public void update(Set<E> setSrc, Predicate<E> pd) {
        this.update(new LinkedList<E>(setSrc), pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<E> listSrc, Predicate<E> pd) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            ArrayList<MxObject> newList = new ArrayList<MxObject>(listSrc.size() * 2);
            for (MxObject now : listSrc) {
                if (!pd.test(now)) continue;
                newList.add(now);
            }
            this.list.setAll(newList);
            this.listMap.clear();
            for (MxObject e : newList) {
                this.listMap.put(e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePageList() {
        int size = this.list.size();
        ArrayList<E> dataList = new ArrayList<E>();
        Object object = this.list;
        synchronized (object) {
            if (size >= this.num) {
                if (this.beginIndex + this.num >= size) {
                    dataList.addAll(this.list.subList(this.beginIndex, size));
                } else {
                    dataList.addAll(this.list.subList(this.beginIndex, this.beginIndex + this.num));
                }
            } else {
                dataList.addAll((Collection<E>)this.list);
            }
        }
        object = this.pageList;
        synchronized (object) {
            if (size >= this.num) {
                if (this.beginIndex + this.num >= size) {
                    this.pageList.setAll(this.objPool.subList(0, size - this.beginIndex));
                } else {
                    this.pageList.setAll(this.objPool);
                }
            } else {
                this.pageList.setAll(this.objPool.subList(0, size));
            }
            int i = 0;
            for (MxObject e : dataList) {
                ((MxObject)this.pageList.get(i++)).update(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(List<E> newList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
            newList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<E> addList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            addList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            if (!this.listMap.containsKey(e)) {
                this.list.add(e);
                this.listMap.put(e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.remove(e);
            this.listMap.remove(e);
        }
    }

    public E get(E e) {
        return (E)((MxObject)this.listMap.get(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<E> toBeRemoved) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxObject e : toBeRemoved) {
                this.list.remove((Object)e);
                this.listMap.remove(e);
            }
        }
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }
}

