/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.define.IDictMap;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MxNode
extends MxObject
implements Comparator<MxNode> {
    private static final Logger logger = LogManager.getLogger(MxNode.class);
    private String raw = "";
    private String value = "";
    protected ObservableList<MxNode> listNodes = FxUtils.newList();
    @Inject
    protected static IDictMap dmap;
    protected Map<String, String> map;

    public MxNode getNode(String key) {
        for (MxNode node : this.listNodes) {
            if (!node.getRaw().equals(key)) continue;
            return node;
        }
        return null;
    }

    public void addNode(String key) {
        if (this.getNode(key) == null && this.map.get(key) != null) {
            MxNode node = this.clone();
            node.setRaw(key);
            this.listNodes.add((Object)node);
        }
    }

    public void removeNode(String key) {
        for (MxNode node : this.listNodes) {
            if (!node.getRaw().equals(key)) continue;
            this.listNodes.remove((Object)node);
            return;
        }
    }

    public MxNode clone() {
        MxNode node = new MxNode();
        node.map = this.map;
        node.listNodes = this.listNodes;
        return node;
    }

    public MxNode load(String key, String raw) {
        this.map = dmap.get(key);
        if (this.map == null) {
            logger.error("failed to load dict map for key: " + key);
            return null;
        }
        for (String item : this.map.keySet()) {
            if (item.equals(this.getRaw())) continue;
            MxNode node = this.clone();
            node.setRaw(item);
            this.listNodes.add((Object)node);
        }
        this.setRaw(raw);
        return this;
    }

    public boolean is(String raw) {
        return this.getRaw().equals(raw);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MxNode) {
            return ((MxNode)MxNode.class.cast(obj)).is(this.getRaw());
        }
        return false;
    }

    public ObservableList<MxNode> getNodes() {
        return this.listNodes;
    }

    public String toString() {
        return this.getValue();
    }

    public String getRaw() {
        return this.raw;
    }

    public void setRaw(String raw) {
        this.raw = raw;
        if (StringUtils.isEmpty((String)raw)) {
            this.value = "";
        } else if (this.map != null) {
            this.value = this.map.get(raw);
        }
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int compare(MxNode o1, MxNode o2) {
        String raw1 = o1.getRaw();
        String raw2 = o2.getRaw();
        if (StringUtils.isInt((String)raw1) && StringUtils.isInt((String)raw2)) {
            return Integer.parseInt(raw1) - Integer.parseInt(raw2);
        }
        return raw1.compareTo(raw2);
    }

    public static void setDictMap(IDictMap map) {
        dmap = map;
    }

    public void removeOthers(String raw) {
        Iterator it = this.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (raw.equals(node.getRaw())) continue;
            it.remove();
        }
    }

    public void removeOthersAndAddThis(String raw) {
        Iterator it = this.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (raw.equals(node.getRaw())) continue;
            it.remove();
        }
        if (this.getNodes().isEmpty()) {
            this.addNode(raw);
        }
    }

    public boolean constains(String raw) {
        for (MxNode node : this.getNodes()) {
            if (!raw.equals(node.getRaw())) continue;
            return true;
        }
        return false;
    }
}

