/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.javafx.obj.MxDirtyObj;
import cms.tmx.javafx.utils.FxUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;

public class MxListDirty<E extends MxDirtyObj> {
    private ObservableList<E> list = FxUtils.newList();
    private ConcurrentHashMap<E, E> listMap = new ConcurrentHashMap();

    public ObservableList<E> getList() {
        return this.list;
    }

    public ConcurrentHashMap<E, E> getListMap() {
        return this.listMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
        }
    }

    public void updateDirty(List<E> listChange) {
        this.updateDirty(listChange, true);
    }

    public void updateDirtyWithOutRm(List<E> listChange) {
        this.updateDirty(listChange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty(List<E> listChange, boolean canRm) {
        if (listChange == null) {
            return;
        }
        HashMap map = new HashMap(2 * (this.list.size() + 1));
        listChange.forEach(item -> {
            MxDirtyObj mxDirtyObj = map.put(item, item);
        });
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            if (canRm) {
                Iterator it = this.list.iterator();
                while (it.hasNext()) {
                    MxDirtyObj eNow;
                    MxDirtyObj eOld = (MxDirtyObj)it.next();
                    if (!eOld.isDirty() || (eNow = (MxDirtyObj)map.get(eOld)) != null) continue;
                    it.remove();
                    this.listMap.remove(eOld);
                }
            }
            for (MxDirtyObj e : listChange) {
                if (!this.listMap.containsKey(e)) {
                    this.list.add((Object)e);
                    this.listMap.put(e, e);
                    continue;
                }
                MxDirtyObj old = (MxDirtyObj)this.listMap.get(e);
                old.setDirty(false);
                if (old == e) continue;
                old.update(e);
            }
        }
    }

    public void update(List<E> listSrc) {
        this.update(listSrc, (E p) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(List<E> listSrc, Predicate<E> pd) {
        LinkedList<MxDirtyObj> listSrcResult = new LinkedList<MxDirtyObj>();
        for (MxDirtyObj e : listSrc) {
            if (!pd.test(e)) continue;
            listSrcResult.add(e);
        }
        List listSrcDistinct = listSrcResult.stream().distinct().collect(Collectors.toList());
        Iterator<E> iterator = this.list;
        synchronized (iterator) {
            this.list.setAll(listSrcDistinct);
            this.listMap.clear();
            this.list.stream().forEach(item -> {
                MxDirtyObj mxDirtyObj = this.listMap.put(item, item);
            });
        }
    }

    public void update(Set<E> setSrc, Predicate<E> pd) {
        this.update(new LinkedList<E>(setSrc), pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<E> listSrc, Predicate<E> pd) {
        HashMap<MxDirtyObj, MxDirtyObj> mapNow = new HashMap<MxDirtyObj, MxDirtyObj>(2 * (listSrc.size() + 1));
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxDirtyObj now : listSrc) {
                if (!pd.test(now)) continue;
                mapNow.put(now, now);
                MxDirtyObj old = (MxDirtyObj)this.listMap.get(now);
                if (old == null) {
                    this.list.add((Object)now);
                    this.listMap.put(now, now);
                    continue;
                }
                if (old == now) continue;
                old.update(now);
            }
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                MxDirtyObj old = (MxDirtyObj)it.next();
                if (mapNow.get(old) != null) continue;
                it.remove();
                this.listMap.remove(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(List<E> newList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
            newList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<E> addList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            addList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            if (!this.listMap.containsKey(e)) {
                this.list.add(e);
                this.listMap.put(e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.remove(e);
            this.listMap.remove(e);
        }
    }

    public E get(E e) {
        return (E)((MxDirtyObj)this.listMap.get(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<E> toBeRemoved) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxDirtyObj e : toBeRemoved) {
                this.list.remove((Object)e);
                this.listMap.remove(e);
            }
        }
    }
}

