/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.javafx;

import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;

public class MxList<E extends MxObject> {
    private ObservableList<E> list = FxUtils.newList();
    private ObservableList<E> pageList = FxUtils.newList();
    private ConcurrentHashMap<E, E> listMap = new ConcurrentHashMap();
    private boolean isPage = false;
    public int num = 200;

    public MxList() {
    }

    public MxList(int num) {
        this.isPage = true;
        this.num = num;
    }

    public ObservableList<E> getList() {
        return this.list;
    }

    public ObservableList<E> getPageList() {
        return this.pageList;
    }

    public ConcurrentHashMap<E, E> getListMap() {
        return this.listMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePart(List<E> listChange) {
        if (listChange == null) {
            return;
        }
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxObject e : listChange) {
                if (!this.listMap.containsKey(e)) {
                    this.list.add((Object)e);
                    this.listMap.put(e, e);
                    continue;
                }
                MxObject old = (MxObject)this.listMap.get(e);
                if (old == e) continue;
                old.update(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePart(E e) {
        if (e == null) {
            return;
        }
        MxObject old = (MxObject)this.listMap.get(e);
        if (old != null) {
            old.update(e);
            return;
        }
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            if (!this.listMap.containsKey(e)) {
                this.list.add(e);
                this.listMap.put(e, e);
            }
        }
    }

    public void update(List<E> listSrc) {
        this.update(listSrc, (E p) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(List<E> listSrc, Predicate<E> pd) {
        LinkedList<MxObject> listSrcResult = new LinkedList<MxObject>();
        for (MxObject e : listSrc) {
            if (!pd.test(e)) continue;
            listSrcResult.add(e);
        }
        List listSrcDistinct = listSrcResult.stream().distinct().collect(Collectors.toList());
        Iterator<E> iterator = this.list;
        synchronized (iterator) {
            this.list.setAll(listSrcDistinct);
            this.listMap.clear();
            this.list.stream().forEach(item -> {
                MxObject mxObject = this.listMap.put(item, item);
            });
        }
    }

    public void update(Set<E> setSrc, Predicate<E> pd) {
        this.update(new LinkedList<E>(setSrc), pd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<E> listSrc, Predicate<E> pd) {
        HashMap<MxObject, MxObject> mapNow = new HashMap<MxObject, MxObject>(2 * (listSrc.size() + 1));
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxObject now : listSrc) {
                if (!pd.test(now)) continue;
                mapNow.put(now, now);
                MxObject old = (MxObject)this.listMap.get(now);
                if (old == null) {
                    this.list.add((Object)now);
                    this.listMap.put(now, now);
                    continue;
                }
                if (old == now) continue;
                old.update(now);
            }
            List collect = this.list.stream().filter(item -> !mapNow.containsKey(item)).collect(Collectors.toList());
            this.list.removeAll(collect);
            collect.stream().forEach(item -> {
                E e = this.listMap.remove(item);
            });
        }
    }

    public void updatePageList() {
        if (this.isPage) {
            if (this.list.size() >= this.num) {
                this.pageList.setAll((Collection)this.list.subList(0, this.num));
            } else {
                this.pageList.setAll(this.list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAll(List<E> newList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.clear();
            this.listMap.clear();
            newList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<E> addList) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            addList.stream().forEach(item -> {
                if (!this.listMap.containsKey(item)) {
                    this.list.add(item);
                    this.listMap.put(item, item);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            if (!this.listMap.containsKey(e)) {
                this.list.add(e);
                this.listMap.put(e, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(E e) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            this.list.remove(e);
            if (e != null) {
                this.listMap.remove(e);
            }
        }
    }

    public E get(E e) {
        return (E)((MxObject)this.listMap.get(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<E> toBeRemoved) {
        ObservableList<E> observableList = this.list;
        synchronized (observableList) {
            for (MxObject e : toBeRemoved) {
                this.list.remove((Object)e);
                this.listMap.remove(e);
            }
        }
    }
}

