/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.websocket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.api.MarketDataApi;
import cms.tmx.http.api.marketdata.dto.InstrmtMDReq;
import cms.tmx.http.api.marketdata.dto.MarketDataRequest;
import cms.tmx.http.api.marketdata.dto.MarketDataResponse;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.javafx.MxModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class StdMarketDataModel
extends MxModel {
    @Inject
    private MEventService es;
    private Map<MarketItem, XSwapStrategy> mapInfo = new ConcurrentHashMap<MarketItem, XSwapStrategy>();
    @Inject
    private MarketDataApi api;

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.ficc.marketdata", event -> this.onMarketItemPush(event));
        this.es.subscribe("websocket.connected", event -> this.reSub());
    }

    public void dyeDepth(MarketItem item, XSwapStrategy strategy) {
        this.mapInfo.put(item, strategy);
        this.subMarketItem(strategy);
    }

    public void subMarketItem(XSwapStrategy strategy) {
        this.query(strategy);
        MarketDataRequest req = new MarketDataRequest();
        req.setInstrmtMdReq(this.packMdReq(strategy));
        Message message = new Message();
        message.setTopic("ficc.marketdata");
        message.setData((Object)req);
        MEvent event = new MEvent();
        event.setObj((Object)message);
        this.es.postEvent("subscribe.market.data", event);
    }

    private List<InstrmtMDReq> packMdReq(XSwapStrategy ... listStrategy) {
        ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
        XSwapStrategy[] xSwapStrategyArray = listStrategy;
        int n = listStrategy.length;
        int n2 = 0;
        while (n2 < n) {
            XSwapStrategy strategy = xSwapStrategyArray[n2];
            Instrument instHedge = new Instrument();
            instHedge.setMarket(strategy.getMarket());
            instHedge.setSecurityId("Hedge" + strategy.getContextId());
            InstrmtMDReq mdReqHedge = new InstrmtMDReq();
            mdReqHedge.setInstrument(instHedge);
            mdReqHedge.setMdType("pricing");
            Instrument instActive = new Instrument();
            instActive.setMarket(strategy.getMarket());
            instActive.setSecurityId("Active" + strategy.getContextId());
            InstrmtMDReq mdReqActive = new InstrmtMDReq();
            mdReqActive.setInstrument(instActive);
            mdReqActive.setMdType("pricing");
            list.add(mdReqHedge);
            list.add(mdReqActive);
            ++n2;
        }
        return list;
    }

    public void reSub() {
        if (this.mapInfo.values().isEmpty()) {
            return;
        }
        Message message = new Message();
        message.setTopic("ficc.marketdata");
        message.setData(this.packMdReq(this.mapInfo.values().toArray(new XSwapStrategy[this.mapInfo.values().size()])));
        MEvent event = new MEvent();
        event.setObj((Object)message);
        this.es.postEvent("subscribe.market.data", event);
    }

    public void query(XSwapStrategy strategy) {
        MarketDataRequest req = new MarketDataRequest();
        req.setInstrmtMdReq(this.packMdReq(strategy));
        try {
            MarketDataResponse resp = this.api.queryMarketData(req);
            if (resp.getSnapshot() == null) {
                return;
            }
            for (MarketDataSnapshot snap : resp.getSnapshot()) {
                this.updateMarketItems(snap);
            }
        }
        catch (MException e) {
            e.printStackTrace();
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void onMarketItemPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof MarketDataSnapshot)) {
            return;
        }
        MarketDataSnapshot snap = (MarketDataSnapshot)obj;
        if ("pricing".equals(snap.getMdType())) {
            this.updateMarketItems(snap);
        }
    }

    private void updateMarketItems(MarketDataSnapshot snap) {
        String securityId = snap.getInstrument().getSecurityId();
        String index = securityId.contains("Hedge") ? "Hedge" : "Active";
        String strategyId = securityId.substring(securityId.lastIndexOf(index) + index.length());
        for (Map.Entry<MarketItem, XSwapStrategy> entry : this.mapInfo.entrySet()) {
            String contextId = entry.getValue().getContextId();
            if (!contextId.equals(strategyId)) continue;
            Platform.runLater(() -> ((MarketItem)entry.getKey()).update((Object)snap));
        }
    }
}

