/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.websocket;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.impl.RefDataMngImpl;
import cms.tmx.data.websocket.StdMarketDataModel;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.XSwapStrategy;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.marketdata.api.MarketDataApi;
import cms.tmx.http.api.marketdata.dto.InstrmtMDReq;
import cms.tmx.http.api.marketdata.dto.MarketDataRequest;
import cms.tmx.http.api.marketdata.dto.MarketDataResponse;
import cms.tmx.http.api.marketdata.dto.MarketDataSnapshot;
import cms.tmx.http.api.marketdata.dto.Message;
import cms.tmx.http.api.strategy.dto.SettlType;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.ListUtils;
import cmx.tmx.data.INewRefMng;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarketDataModel
extends MxModel {
    @Inject
    private MEventService es;
    private Map<RefItem, Map<String, MarketItem>> mapInfo = new ConcurrentHashMap<RefItem, Map<String, MarketItem>>();
    private Map<RefItem, List<MarketItem>> listInfo = new HashMap<RefItem, List<MarketItem>>();
    private ObservableList<WeakReference<MarketItem>> listCreated = FxUtils.newList();
    private static final List<String> OTHER_TYPE = Arrays.asList("CBDeal", "BFDDeal", "xbond_pricing", "pricing");
    @Inject
    private RefDataMngImpl refMng;
    @Inject
    private INewRefMng newRefMng;
    @Inject
    private MarketDataApi api;
    @Inject
    private StdMarketDataModel stdMktModel;

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.ficc.marketdata", event -> this.onMarketItemPush(event));
        this.es.subscribe("websocket.connected", event -> this.reSub());
    }

    public synchronized MarketItem createItem(int gears) {
        MarketItem item = new MarketItem(gears);
        this.listCreated.add(new WeakReference<MarketItem>(item));
        return item;
    }

    private synchronized Map<String, MarketItem> createItem(RefItem item) {
        int gears;
        Map<String, MarketItem> map = this.mapInfo.get(item);
        List<MarketItem> list = this.listInfo.get(item);
        if (map != null) {
            return map;
        }
        if (list != null) {
            this.logger.error("map is null, but list is not null ???");
        }
        map = new HashMap<String, MarketItem>();
        list = new ArrayList<MarketItem>();
        int n = gears = item.getType().equals("FUT") ? 5 : 10;
        if (item.getType().equals("BOND") && "XcfeXBond".equals(item.getSubSecurityType())) {
            MarketItem mktItem = new MarketItem(SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE, 2, gears);
            mktItem.setRefItem(item);
            map.put(String.valueOf(item.getMarket()) + item.getCode() + mktItem.getSettlType().name() + mktItem.getMdBookType(), mktItem);
            list.add(mktItem);
            mktItem = new MarketItem(SettlType.CASH_OR_TOD_OR_T_PLUS_0_SETTLTYPE, 107, gears);
            mktItem.setRefItem(item);
            map.put(String.valueOf(item.getMarket()) + item.getCode() + mktItem.getSettlType().name() + mktItem.getMdBookType(), mktItem);
            list.add(mktItem);
            mktItem = new MarketItem(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1, 2, gears);
            mktItem.setRefItem(item);
            map.put(String.valueOf(item.getMarket()) + item.getCode() + mktItem.getSettlType().name() + mktItem.getMdBookType(), mktItem);
            list.add(mktItem);
            mktItem = new MarketItem(SettlType.NEXT_DAY_OR_TOM_OR_T_PLUS_1, 107, gears);
            mktItem.setRefItem(item);
            map.put(String.valueOf(item.getMarket()) + item.getCode() + mktItem.getSettlType().name() + mktItem.getMdBookType(), mktItem);
            list.add(mktItem);
        } else {
            MarketItem marketItem = new MarketItem(gears);
            marketItem.setRefItem(item);
            map.put(String.valueOf(item.getMarket()) + item.getCode(), marketItem);
        }
        this.mapInfo.put(item, map);
        this.listInfo.put(item, list);
        return map;
    }

    public void dye(MarketItem item) {
        if (!item.isValidRef()) {
            return;
        }
        this.createItem(item.getRefItem());
        this.query(item.getRefItem());
        item.update((Object)this.getItem(item.getRefItem()));
        this.subMarketItem(item.getRefItem());
    }

    public void dyeDepth(MarketItem item, XSwapStrategy strategy) {
        if (!item.isValidRef()) {
            return;
        }
        this.dye(item);
        this.stdMktModel.dyeDepth(item, strategy);
    }

    public void subMarketItem(RefItem item) {
        ArrayList<RefItem> items = new ArrayList<RefItem>();
        items.add(item);
        this.subMarketItems(items);
    }

    public void subMarketItems(List<RefItem> items) {
        this.subMarketItems(items, null);
    }

    /*
     * Unable to fully structure code
     */
    public void subMarketItems(List<RefItem> items, Object obj) {
        this.query(items, obj);
        splits = ListUtils.split(items, (int)30);
        for (List split : splits) {
            message = new Message();
            req = new MarketDataRequest();
            list = new ArrayList<InstrmtMDReq>();
            for (RefItem item : split) {
                block20: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block19: {
                                        ins = new InstrmtMDReq();
                                        inst = new Instrument();
                                        if (!"BOND".equals(item.getType())) break block19;
                                        inst.setMarket(item.getMarket());
                                        inst.setSecurityId(item.getCode());
                                        inst.setSecurityType(item.getType());
                                        inst.setSecuritySubType("XcfeXBond");
                                        break block20;
                                    }
                                    if (!"secTypeArbitrage".equals(item.getType())) break block21;
                                    ins.setMdStreamId(item.getConId());
                                    break block20;
                                }
                                if (!"STOCKXHKG".equals(item.getType())) break block22;
                                inst.setMarket("XHKG");
                                ins.setMdType("CCSL2");
                                break block20;
                            }
                            if (!"SBFWD".equals(item.getType()) && !"FORWARD".equals(item.getType())) break block23;
                            inst.setMarket(item.getMarket());
                            inst.setSecurityId(item.getCode());
                            inst.setSecurityType(item.getType());
                            inst.setSecuritySubType("XcfeXSwap");
                            break block20;
                        }
                        if (!"FUT".equals(item.getType())) break block24;
                        inst.setMarket(item.getMarket());
                        inst.setSecurityId(item.getCode());
                        inst.setSecurityType(item.getType());
                        inst.setSecuritySubType(item.getSubSecurityType());
                        if (!(item instanceof CtpRefItem)) break block20;
                        ctp = (CtpRefItem)CtpRefItem.class.cast(item);
                        var14_14 = ctp.getProductId();
                        tmp = -1;
                        switch (var14_14.hashCode()) {
                            case 84: {
                                if (var14_14.equals("T")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 2674: {
                                if (var14_14.equals("TF")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 2687: {
                                if (var14_14.equals("TS")) {
                                    tmp = 1;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                if (!(obj instanceof String) || !"FutureYtm".equals(obj)) break block20;
                                ins.setMdType("FutureYtm");
                            }
                            default: {
                                ** break;
                            }
                            {
lbl67:
                                // 1 sources

                                break block20;
                            }
                        }
                    }
                    if ("STOCKXHKG".equals(String.valueOf(item.getType()) + item.getMarket())) {
                        inst.setMarket(item.getMarket());
                        inst.setSecurityId(item.getCode());
                        ins.setMdType("CCSL2");
                    } else if ("REPOXCFE".equals(String.valueOf(item.getType()) + item.getMarket())) {
                        inst.setMarket(item.getMarket());
                        inst.setSecurityId(item.getCode());
                        inst.setSecurityType(item.getType());
                        inst.setSecuritySubType("XcfeXRepo");
                    } else {
                        inst.setMarket(item.getMarket());
                        inst.setSecurityId(item.getCode());
                        inst.setSecurityType(item.getType());
                    }
                }
                ins.setInstrument(inst);
                list.add(ins);
                this.createItem(item);
            }
            req.setInstrmtMdReq(list);
            message.setTopic("ficc.marketdata");
            message.setData((Object)req);
            event = new MEvent();
            event.setObj((Object)message);
            this.es.postEvent("subscribe.market.data", event);
        }
    }

    public void reSub() {
        Set<RefItem> items = this.listInfo.keySet();
        if (items.size() == 0) {
            return;
        }
        Message message = new Message();
        ArrayList<RefItem> itemList = new ArrayList<RefItem>(items);
        if (itemList.isEmpty()) {
            return;
        }
        List splits = ListUtils.split(itemList, (int)30);
        for (List split : splits) {
            MarketDataRequest req = new MarketDataRequest();
            ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
            for (RefItem item : split) {
                InstrmtMDReq ins = new InstrmtMDReq();
                Instrument inst = new Instrument();
                inst.setMarket(item.getMarket());
                inst.setSecurityType(item.getType());
                if ("SBFWD".equals(item.getType()) || "FORWARD".equals(item.getType())) {
                    inst.setSecuritySubType("XcfeXSwap");
                } else {
                    inst.setSecuritySubType("XcfeXBond");
                }
                inst.setSecurityId(item.getCode());
                if ("STOCKXHKG".equals(String.valueOf(item.getType()) + item.getMarket())) {
                    inst.setMarket(item.getMarket());
                    inst.setSecurityId(item.getCode());
                    ins.setMdType("CCSL2");
                }
                ins.setInstrument(inst);
                if ("secTypeArbitrage".equals(item.getType())) {
                    ins.setMdStreamId(item.getConId());
                }
                list.add(ins);
            }
            req.setInstrmtMdReq(list);
            message.setTopic("ficc.marketdata");
            message.setData((Object)req);
            MEvent event = new MEvent();
            event.setObj((Object)message);
            this.es.postEvent("subscribe.market.data", event);
        }
    }

    private void onMarketItemPush(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof MarketDataSnapshot)) {
            return;
        }
        MarketDataSnapshot snap = (MarketDataSnapshot)obj;
        if (!OTHER_TYPE.contains(snap.getMdType())) {
            this.updateMarketItems(snap);
        }
    }

    public void query(List<RefItem> items) {
        this.query(items, null);
    }

    /*
     * Unable to fully structure code
     */
    public void query(List<RefItem> items, Object obj) {
        block22: {
            if (items.isEmpty()) break block22;
            req = new MarketDataRequest();
            list = new ArrayList<InstrmtMDReq>();
            for (RefItem item : items) {
                block24: {
                    block25: {
                        block23: {
                            ins = new InstrmtMDReq();
                            inst = new Instrument();
                            inst.setMarket(item.getMarket());
                            inst.setSecurityType(item.getType());
                            inst.setSecuritySubType("XcfeXBond");
                            inst.setSecurityId(item.getCode());
                            if (!"SBFWD".equals(item.getType()) && !"FORWARD".equals(item.getType())) break block23;
                            inst.setSecuritySubType("XcfeXSwap");
                            break block24;
                        }
                        if (!"FUT".equals(item.getType())) break block25;
                        inst.setSecuritySubType(item.getSubSecurityType());
                        if (!(item instanceof CtpRefItem)) break block24;
                        ctp = (CtpRefItem)CtpRefItem.class.cast(item);
                        var10_11 = ctp.getProductId();
                        tmp = -1;
                        switch (var10_11.hashCode()) {
                            case 84: {
                                if (var10_11.equals("T")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 2674: {
                                if (var10_11.equals("TF")) {
                                    tmp = 1;
                                }
                                break;
                            }
                            case 2687: {
                                if (var10_11.equals("TS")) {
                                    tmp = 1;
                                }
                                break;
                            }
                        }
                        switch (tmp) {
                            case 1: {
                                if (!(obj instanceof String) || !"FutureYtm".equals(obj)) break block24;
                                ins.setMdType("FutureYtm");
                            }
                            default: {
                                ** break;
                            }
                            {
lbl46:
                                // 1 sources

                                break block24;
                            }
                        }
                    }
                    if ("STOCKXHKG".equals(String.valueOf(item.getType()) + item.getMarket())) {
                        inst.setMarket(item.getMarket());
                        inst.setSecurityId(item.getCode());
                        ins.setMdType("CCSL2");
                    } else if ("REPOXCFE".equals(String.valueOf(item.getType()) + item.getMarket())) {
                        inst.setSecuritySubType("XcfeXRepo");
                    }
                }
                if ("FUTSGEX".equals(String.valueOf(item.getType()) + item.getMarket())) {
                    ins.setMdType("CTPL1");
                }
                ins.setInstrument(inst);
                list.add(ins);
                this.createItem(item);
            }
            req.setInstrmtMdReq(list);
            try {
                resp = this.api.queryMarketData(req);
                if (resp.getSnapshot() == null) {
                    return;
                }
                for (MarketDataSnapshot snap : resp.getSnapshot()) {
                    this.updateMarketItems(snap);
                }
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public void query(RefItem item) {
        MarketDataRequest req = new MarketDataRequest();
        ArrayList<InstrmtMDReq> list = new ArrayList<InstrmtMDReq>();
        InstrmtMDReq ins = new InstrmtMDReq();
        Instrument inst = new Instrument();
        inst.setMarket(item.getMarket());
        inst.setSecurityType(item.getType());
        ins.setMdStreamId(item.getConId());
        if (item.getConId().contains("_")) {
            inst.setSecurityId(item.getConId());
        } else {
            inst.setSecurityId(item.getCode());
        }
        if ("STOCKXHKG".equals(String.valueOf(item.getType()) + item.getMarket())) {
            inst.setMarket(item.getMarket());
            inst.setSecurityId(item.getCode());
            ins.setMdType("CCSL2");
        }
        ins.setInstrument(inst);
        list.add(ins);
        this.createItem(item);
        req.setInstrmtMdReq(list);
        try {
            MarketDataResponse resp = this.api.queryMarketData(req);
            if (resp.getSnapshot() == null) {
                return;
            }
            for (MarketDataSnapshot snap : resp.getSnapshot()) {
                this.updateMarketItems(snap);
            }
        }
        catch (MException e) {
            e.printStackTrace();
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateMarketItems(MarketDataSnapshot snap) {
        String code;
        RefItem refItem;
        String market = snap.getInstrument().getMarket();
        if (market == null) {
            market = "";
        }
        if ((refItem = this.refMng.getItem(market, code = snap.getInstrument().getSecurityId())) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[market]: no ref item " + code);
            }
            String type = "STOCK";
            if ("XHKG".equals(snap.getInstrument().getMarket())) {
                // empty if block
            }
            if ((refItem = this.newRefMng.getItem(snap.getInstrument().getSecurityType() == null ? type : snap.getInstrument().getSecurityType(), market, code)) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[market]: newframe no ref item " + code);
                }
                for (RefItem item : this.mapInfo.keySet()) {
                    if (item.getCode().equals(code)) {
                        refItem = item;
                        continue;
                    }
                    if (!item.getConId().equals(code)) continue;
                    refItem = item;
                }
                if (refItem == null) {
                    return;
                }
            }
        }
        if (refItem.getType().equals("PLEDGE") && (refItem = this.refMng.getItem("BOND", market, code)) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("[market]: no ref item " + code);
            }
            return;
        }
        MarketItem item = null;
        if ("BOND".equals(snap.getInstrument().getSecurityType())) {
            item = this.mapInfo.get(refItem).get(String.valueOf(market) + code + snap.getSettlType().name() + snap.getMdBookType());
        } else if ("SBFWD".equals(snap.getInstrument().getSecurityType()) || "FORWARD".equals(snap.getInstrument().getSecurityType())) {
            item = this.mapInfo.get(refItem).get(String.valueOf(market) + snap.getInstrument().getSecurityId());
        } else if ("XcfeXRepo".equals(snap.getInstrument().getSecuritySubType())) {
            item = this.mapInfo.get(refItem).get(String.valueOf(market) + code);
        } else if (code.contains("_")) {
            String beforeId = code.substring(0, code.indexOf("_"));
            String codeId = code.substring(beforeId.length() + 1, code.length());
            item = this.mapInfo.get(refItem).get(String.valueOf(market) + codeId);
        } else {
            item = this.mapInfo.get(refItem).get(String.valueOf(market) + code);
        }
        if (item != null) {
            item.clear();
            item.update((Object)snap);
            this.updateCreatedItems(snap);
            item.setLastUpdateTime(System.currentTimeMillis());
        }
    }

    public MarketItem getItem(RefItem item) {
        return this.mapInfo.get(item) == null ? null : this.mapInfo.get(item).get(String.valueOf(item.getMarket()) + item.getCode());
    }

    public Map<RefItem, Map<String, MarketItem>> getMapInfo() {
        return this.mapInfo;
    }

    private void updateCreatedItems(MarketDataSnapshot snap) {
        for (WeakReference ref : this.listCreated) {
            MarketItem item = (MarketItem)ref.get();
            if (item == null) continue;
            this.updateCreateItem(snap, item);
        }
    }

    private void updateCreateItem(MarketDataSnapshot snap, MarketItem item) {
        RefItem refItem = item.getRefItem();
        if (!this.checkRefItem(refItem)) {
            return;
        }
        String market = snap.getInstrument().getMarket();
        if (market == null) {
            market = "";
        }
        String code = snap.getInstrument().getSecurityId();
        SettlType type = snap.getSettlType();
        int mdBookType = snap.getMdBookType();
        if (refItem.getType().equals("BOND") && "XcfeXBond".equals(refItem.getSubSecurityType())) {
            if (refItem.getMarket().equals(market) && refItem.getCode().equals(code) && type == item.getSettlType() && mdBookType == item.getMdBookType()) {
                item.clear();
                item.update((Object)snap);
            }
        } else if (refItem.getMarket().equals(market) && refItem.getCode().equals(code) || refItem.getMarket().equals(market) && refItem.getConId().equals(code)) {
            Platform.runLater(() -> {
                if (!"FutureYtm".equals(snap.getMdType())) {
                    item.clear();
                }
                item.update((Object)snap);
            });
        }
    }

    private boolean checkRefItem(RefItem item) {
        if (item != null && item.getType().equals("secTypeArbitrage")) {
            return !item.getCode().isEmpty();
        }
        return item != null && !item.getMarket().isEmpty() && !item.getCode().isEmpty();
    }
}

