/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.entity.data.RefItem;
import java.util.Comparator;

public class SgeSuggest
extends BaseSuggestion<RefItem> {
    private static final int ACRONYM_LENGTH = 30;
    private Comparator<RefItem> cp = new Comparator<RefItem>(){

        @Override
        public int compare(RefItem o1, RefItem o2) {
            return SgeSuggest.this.weightLet(o2) - SgeSuggest.this.weightLet(o1);
        }
    };

    public int weightLet(RefItem item) {
        String input = this.getRequest().toUpperCase();
        String code = item.getCode().toUpperCase();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        char[] chars = code.toCharArray();
        int letWeight = 0;
        int i = 0;
        while (i < chars.length) {
            letWeight += chars[i];
            ++i;
        }
        return weight - letWeight;
    }

    protected Comparator<RefItem> getComparator() {
        return this.cp;
    }

    protected boolean isMatch(RefItem item, BaseAutoCompletion.ISuggestionRequest req) {
        String code = item.getCode();
        return code.toUpperCase().contains(req.getUserText().toUpperCase());
    }

    public static StrSuggest getStrSuggest() {
        return new StrSuggest();
    }

    public static class StrSuggest
    extends BaseSuggestion<String> {
        private Comparator<String> cp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };

        protected Comparator<String> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(String str, BaseAutoCompletion.ISuggestionRequest req) {
            String userTextLower = req.getUserText().toLowerCase();
            String suggestionStr = str.toString().toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

