/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.entity.data.RefItem;
import java.util.Comparator;

public class SecSuggest
extends BaseSuggestion<RefItem> {
    private boolean containLetter = false;
    private Comparator<RefItem> cp = new Comparator<RefItem>(){

        @Override
        public int compare(RefItem o1, RefItem o2) {
            if (SecSuggest.this.isLetters()) {
                return SecSuggest.this.weightLet(o2) - SecSuggest.this.weightLet(o1);
            }
            return SecSuggest.this.weightNum(o2) - SecSuggest.this.weightNum(o1);
        }
    };
    private static final int CODE_LENGTH = 30;
    private static final int ACRONYM_LENGTH = 30;

    public SecSuggest() {
    }

    public SecSuggest(boolean containLetter) {
        this.setContainLetter(containLetter);
    }

    public int weightNum(RefItem item) {
        String input = this.getRequest();
        String code = item.getCode();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        return weight - Integer.parseInt(code.replaceAll("[A-Za-z\\/]*", ""));
    }

    public int weightLet(RefItem item) {
        String input = this.getRequest().toUpperCase();
        String code = "";
        code = this.containLetter ? item.getCode().toUpperCase() : item.getSpellCode().toUpperCase();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        char[] chars = code.toCharArray();
        int letWeight = 0;
        int i = 0;
        while (i < chars.length) {
            letWeight += chars[i];
            ++i;
        }
        return weight - letWeight;
    }

    protected Comparator<RefItem> getComparator() {
        return this.cp;
    }

    protected boolean isMatch(RefItem item, BaseAutoCompletion.ISuggestionRequest req) {
        String code = "";
        code = this.containLetter ? item.getCode() : (this.isLetters() ? item.getSpellCode() : item.getCode());
        return code.toUpperCase().contains(req.getUserText().toUpperCase());
    }

    public static StrSuggest getStrSuggest() {
        return new StrSuggest();
    }

    public boolean isContainLetter() {
        return this.containLetter;
    }

    public void setContainLetter(boolean containLetter) {
        this.containLetter = containLetter;
    }

    public static class StrSuggest
    extends BaseSuggestion<String> {
        private Comparator<String> cp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };

        protected Comparator<String> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(String str, BaseAutoCompletion.ISuggestionRequest req) {
            String userTextLower = req.getUserText().toLowerCase();
            String suggestionStr = str.toString().toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

