/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.javafx.utils.CssUtils;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;

public class PriceCell<E extends HandicapInfo>
extends TableCell<HandicapInfo, String> {
    private MarketItem info;
    private Boolean bs;

    public PriceCell(MarketItem info) {
        CssUtils.priceTag((Control)this);
        this.info = info;
    }

    public PriceCell(MarketItem info, Boolean bs) {
        this(info);
        this.bs = bs;
    }

    public void updateItem(String item, boolean empty) {
        HandicapInfo handiInfo;
        if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
            double price = Double.parseDouble(item);
            if (this.bs != null && this.bs.booleanValue()) {
                CssUtils.makeFall((Control)this);
            } else if (this.bs != null && !this.bs.booleanValue()) {
                CssUtils.makeRise((Control)this);
            } else {
                CssUtils.checkPrice((Control)this, (double)this.info.getClosePrice(), (double)price);
            }
            if (price > 0.0) {
                String txt = String.format("%." + this.info.getRefItem().getScale() + "f", price);
                if (this.info.getRefItem().getMarket().equals("XHKG")) {
                    txt = String.format("%.3f", price);
                }
                this.setText(txt);
                return;
            }
        }
        this.setText(null);
    }
}

