/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.http.data.IssueInfo;
import java.util.Comparator;

public class IssueSuggest
extends BaseSuggestion<IssueInfo> {
    private static final int CODE_LENGTH = 30;
    private Comparator<IssueInfo> cp = new Comparator<IssueInfo>(){

        @Override
        public int compare(IssueInfo o1, IssueInfo o2) {
            return IssueSuggest.this.weightNum(o2) - IssueSuggest.this.weightNum(o1);
        }
    };

    public int weightNum(IssueInfo item) {
        String input = this.getRequest();
        String code = item.getSecurity().getInstrument().getSecurityId();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        return weight - Integer.parseInt(code.replaceAll("[A-Za-z]*", ""));
    }

    protected Comparator<IssueInfo> getComparator() {
        return this.cp;
    }

    protected boolean isMatch(IssueInfo item, BaseAutoCompletion.ISuggestionRequest req) {
        String code = item.getSecurity().getInstrument().getSecurityId();
        return code.toUpperCase().contains(req.getUserText().toUpperCase());
    }

    public static StrSuggest getStrSuggest() {
        return new StrSuggest();
    }

    public static class StrSuggest
    extends BaseSuggestion<String> {
        private Comparator<String> cp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };

        protected Comparator<String> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(String str, BaseAutoCompletion.ISuggestionRequest req) {
            String userTextLower = req.getUserText().toLowerCase();
            String suggestionStr = str.toString().toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

